/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function.operator;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.fel.common.Null;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.fel.compile.FelMethod;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.exception.EvalException;
import kd.fi.bcm.fel.function.StableFunction;
import kd.fi.bcm.fel.function.TolerantFunction;
import kd.fi.bcm.fel.parser.FelNode;

public class And
extends StableFunction {
    public String toJavaOper() {
        return this.getName();
    }

    @Override
    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children != null && children.size() == 2) {
            return this.logic(context, children);
        }
        throw new EvalException(ResManager.loadKDString((String)"\u53c2\u6570\u6570\u7ec4\u4e3a\u7a7a\u6216\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e\u3002", (String)"And_0", (String)"fi-bcm-common", (Object[])new Object[0]));
    }

    Boolean logic(FelContext context, List<FelNode> children) {
        Boolean leftValue = this.toBoolean(context, children.get(0));
        if (!leftValue.booleanValue()) {
            return leftValue;
        }
        return this.toBoolean(context, children.get(1));
    }

    Boolean toBoolean(FelContext context, Object node) {
        node = TolerantFunction.eval(context, node);
        return NumberUtil.toBooleanObj(node);
    }

    @Override
    public String getName() {
        return "&&";
    }

    @Override
    public FelMethod toMethod(FelNode node, FelContext ctx) {
        String code = this.toBoolean(node, ctx, 0) + this.toJavaOper() + this.toBoolean(node, ctx, 1);
        return new FelMethod(Boolean.class, code);
    }

    public String toBoolean(FelNode node, FelContext ctx, int index) {
        List<FelNode> children = node.getChildren();
        FelNode child = children.get(index);
        SourceBuilder method = child.toMethod(ctx);
        Class<?> type = method.returnType(ctx, child);
        if (Boolean.class.isAssignableFrom(type)) {
            return "(" + method.source(ctx, child) + ")";
        }
        if (String.class.isAssignableFrom(type)) {
            return "Boolean.valueOf(" + method.source(ctx, child) + ")";
        }
        if (Null.class.isAssignableFrom(type)) {
            return "false";
        }
        return "false";
    }
}

