/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function.operator;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.fel.compile.FelMethod;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.exception.ParseException;
import kd.fi.bcm.fel.function.StableFunction;
import kd.fi.bcm.fel.parser.FelNode;

public class Cond
extends StableFunction {
    @Override
    public Object call(FelNode node, FelContext context) {
        Boolean b;
        List<FelNode> args = this.ensureValid(node);
        FelNode cond = args.get(0);
        FelNode result1 = args.get(1);
        FelNode result2 = args.get(2);
        Object eval = cond.eval(context);
        if (eval instanceof Boolean && (b = (Boolean)eval).booleanValue()) {
            return result1.eval(context);
        }
        return result2.eval(context);
    }

    @Override
    public String getName() {
        return "?";
    }

    @Override
    public SourceBuilder toMethod(FelNode node, FelContext ctx) {
        List<FelNode> args = this.ensureValid(node);
        FelNode cond = args.get(0);
        FelNode result1 = args.get(1);
        FelNode result2 = args.get(2);
        SourceBuilder source = cond.toMethod(ctx);
        Class<?> class1 = source.returnType(ctx, cond);
        StringBuilder sb = new StringBuilder();
        Class<?> type = null;
        SourceBuilder r2 = result2.toMethod(ctx);
        if (Boolean.class.isAssignableFrom(class1) || Boolean.TYPE.isAssignableFrom(class1)) {
            sb.append(source.source(ctx, node));
            sb.append('?');
            SourceBuilder r1 = result1.toMethod(ctx);
            type = r1.returnType(ctx, result1);
            sb.append(r1.source(ctx, result1));
            sb.append(':');
            sb.append(r2.source(ctx, result2));
        } else {
            sb.append(r2.source(ctx, result2));
            type = r2.returnType(ctx, result2);
        }
        return new FelMethod(type, sb.toString());
    }

    private List<FelNode> ensureValid(FelNode node) {
        List<FelNode> args = node.getChildren();
        if (args == null || args.size() != 3) {
            throw new ParseException(ResManager.loadKDString((String)"\u4e09\u5143\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\u3002", (String)"Cond_0", (String)"fi-bcm-common", (Object[])new Object[0]));
        }
        return args;
    }
}

