/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function.operator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.fel.Expression;
import kd.fi.bcm.fel.common.ArrayUtils;
import kd.fi.bcm.fel.common.Null;
import kd.fi.bcm.fel.common.ReflectUtil;
import kd.fi.bcm.fel.compile.FelMethod;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.function.CommonFunction;
import kd.fi.bcm.fel.function.Function;
import kd.fi.bcm.fel.parser.FelNode;
import kd.fi.bcm.fel.security.SecurityMgr;

public class Dot
implements Function {
    private SecurityMgr securityMgr;
    public static final String DOT = ".";

    public SecurityMgr getSecurityMgr() {
        return this.securityMgr;
    }

    public void setSecurityMgr(SecurityMgr securityMgr) {
        this.securityMgr = securityMgr;
    }

    @Override
    public String getName() {
        return DOT;
    }

    @Override
    public Object call(FelNode node, FelContext context) {
        String methodName;
        FelNode right;
        List<FelNode> children = node.getChildren();
        Object left = children.get(0);
        if (left instanceof Expression) {
            Expression exp = (Expression)left;
            left = exp.eval(context);
        }
        FelNode exp = right = children.get(1);
        Class[] argsType = new Class[]{};
        Object[] args = CommonFunction.evalArgs(right, context);
        if (!ArrayUtils.isEmpty(args)) {
            argsType = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                argsType[i] = args[i] == null ? Null.class : args[i].getClass();
            }
        }
        Method method = null;
        Class<?> cls = left instanceof Class ? (Class<?>)left : left.getClass();
        method = this.findMethod(cls, methodName = right.getText(), argsType);
        if (method == null) {
            String getMethod = "get";
            method = this.findMethod(cls, getMethod, new Class[]{String.class});
            args = new Object[]{exp.getText()};
        }
        if (method != null) {
            return Dot.invoke(left, method, args);
        }
        return null;
    }

    private Method findMethod(Class<?> cls, String methodName, Class<?>[] argsType) {
        Method method = ReflectUtil.findMethod(cls, methodName, argsType);
        return this.getCallableMethod(method);
    }

    private Method getMethod(Class<?> cls, String methodName, Class<?>[] argsType) {
        Method method = ReflectUtil.getMethod(cls, methodName, argsType);
        return this.getCallableMethod(method);
    }

    private Method getCallableMethod(Method m) {
        if (m == null || this.securityMgr.isCallable(m)) {
            return m;
        }
        throw new SecurityException(String.format(ResManager.loadKDString((String)"\u5b89\u5168\u7ba1\u7406\u5668\u201c%1$s\u201d\u7981\u6b62\u8c03\u7528\u65b9\u6cd5\u201c%2$\u201d\u3002", (String)"Dot_0", (String)"fi-bcm-common", (Object[])new Object[0]), this.securityMgr.getClass().getSimpleName(), m));
    }

    public static Object invoke(Object obj, Method method, Object[] args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public FelMethod toMethod(FelNode node, FelContext context) {
        StringBuilder sb = new StringBuilder();
        List<FelNode> children = node.getChildren();
        FelNode l = children.get(0);
        SourceBuilder leftMethod = l.toMethod(context);
        Class<?> cls = leftMethod.returnType(context, l);
        String leftSrc = leftMethod.source(context, l);
        if (cls.isPrimitive()) {
            Class<?> wrapperClass = ReflectUtil.toWrapperClass(cls);
            sb.append("((").append(wrapperClass.getSimpleName()).append(')').append(leftSrc).append(')');
        } else {
            sb.append(leftSrc);
        }
        sb.append('.');
        Method method = null;
        FelNode rightNode = children.get(1);
        List<FelNode> params = rightNode.getChildren();
        Class[] paramValueTypes = null;
        boolean hasParam = params != null && !params.isEmpty();
        String rightMethod = rightNode.getText();
        StringBuilder rightMethodParam = new StringBuilder();
        if (hasParam) {
            paramValueTypes = new Class[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                FelNode p = params.get(i);
                SourceBuilder paramMethod = p.toMethod(context);
                paramValueTypes[i] = paramMethod.returnType(context, p);
            }
            method = this.findMethod(cls, rightNode.getText(), paramValueTypes);
            if (method != null) {
                Class<?>[] paramTypes = method.getParameterTypes();
                for (int i = 0; i < paramTypes.length; ++i) {
                    Class<?> paramType = paramTypes[i];
                    FelNode p = params.get(i);
                    String paramCode = Dot.getParamCode(paramType, p, context);
                    rightMethodParam.append(paramCode).append(',');
                }
                rightMethod = method.getName();
            }
        } else {
            method = this.findMethod(cls, rightNode.getText(), new Class[0]);
            if (method == null) {
                method = this.getMethod(cls, "get", new Class[]{String.class});
                if (method != null) {
                    rightMethod = "get";
                    rightMethodParam = new StringBuilder();
                    rightMethodParam.append('\"');
                    rightMethodParam.append(rightNode.getText());
                    rightMethodParam.append('\"');
                }
            } else {
                rightMethod = method.getName();
            }
        }
        if (method != null) {
            // empty if block
        }
        if (rightMethodParam.toString().endsWith(",")) {
            rightMethodParam = new StringBuilder(rightMethodParam.substring(0, rightMethodParam.length() - 1));
        }
        rightMethod = rightMethod + "(" + rightMethodParam + ")";
        sb.append(rightMethod);
        FelMethod returnMe = new FelMethod(method == null ? null : method.getReturnType(), sb.toString());
        return returnMe;
    }

    public static String getParamCode(Class<?> paramType, FelNode node, FelContext ctx) {
        String paramCode = "";
        SourceBuilder paramMethod = node.toMethod(ctx);
        Class<?> paramValueType = paramMethod.returnType(ctx, node);
        if (ReflectUtil.isTypeMatch(paramType, paramValueType)) {
            paramCode = paramMethod.source(ctx, node);
        } else {
            String className = null;
            Class<?> wrapperClass = ReflectUtil.toWrapperClass(paramType);
            className = wrapperClass != null ? wrapperClass.getName() : paramType.getName();
            paramCode = "(" + className + ")" + paramMethod.source(ctx, node);
        }
        return paramCode;
    }
}

