/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function.operator;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.fel.common.ReflectUtil;
import kd.fi.bcm.fel.compile.FelMethod;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.function.StableFunction;
import kd.fi.bcm.fel.function.TolerantFunction;
import kd.fi.bcm.fel.function.operator.NotEqual;
import kd.fi.bcm.fel.parser.FelNode;

public class Equal
extends StableFunction {
    @Override
    public String getName() {
        return "==";
    }

    @Override
    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children != null && children.size() == 2) {
            Object left = TolerantFunction.eval(context, children.get(0));
            Object right = TolerantFunction.eval(context, children.get(1));
            if (left == null) {
                left = NumberUtil.convertNullObjectAsBase(right);
            }
            if (right == null) {
                right = NumberUtil.convertNullObjectAsBase(left);
            }
            return this.compare(left, right);
        }
        throw new NullPointerException(ResManager.loadKDString((String)"\u53c2\u6570\u6570\u7ec4\u4e3a\u7a7a\u6216\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e\u3002", (String)"Equal_0", (String)"fi-bcm-common", (Object[])new Object[0]));
    }

    boolean compare(Object left, Object right) {
        return this.equals(left, right);
    }

    public boolean equals(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof Number && right instanceof Number) {
            return this.compareNumber(left, right);
        }
        if (left.getClass().equals(right.getClass())) {
            return left.equals(right);
        }
        return left.equals(right);
    }

    protected boolean compareNumber(Object left, Object right) {
        if (left instanceof BigDecimal || right instanceof BigDecimal) {
            return NumberUtil.toBigDecimal(left).compareTo(NumberUtil.toBigDecimal(right)) == 0;
        }
        if (NumberUtil.isFloatingPointNumber(left) || NumberUtil.isFloatingPointNumber(right)) {
            return Equal.isEqual(NumberUtil.toDouble(left), NumberUtil.toDouble(right));
        }
        return Equal.isEqual(NumberUtil.toDouble(left), NumberUtil.toDouble(right));
    }

    @Override
    public SourceBuilder toMethod(FelNode node, FelContext ctx) {
        String operator = this.getName();
        return this.toMethod(node, ctx, operator);
    }

    private FelMethod toMethod(FelNode node, FelContext ctx, String operator) {
        StringBuilder sb = Equal.buildRelationExpr(node, ctx, operator);
        if (sb.length() == 0) {
            String left = Equal.getChildCode(node, ctx, 0);
            String right = Equal.getChildCode(node, ctx, 1);
            String toMethod = this.toMethod(left, right);
            sb.append(toMethod);
        }
        return new FelMethod(Boolean.class, sb.toString());
    }

    String toMethod(String left, String right) {
        return "ObjectUtils.equals(" + left + "," + right + ")";
    }

    public static String getChildCode(FelNode node, FelContext ctx, int index) {
        List<FelNode> children = node.getChildren();
        FelNode child = children.get(index);
        SourceBuilder leftM = child.toMethod(ctx);
        String code = "(" + leftM.source(ctx, child) + ")";
        return code;
    }

    private static StringBuilder buildRelationExpr(FelNode node, FelContext ctx, String operator) {
        List<FelNode> child = node.getChildren();
        FelNode leftNode = child.get(0);
        FelNode rightNode = child.get(1);
        SourceBuilder leftM = leftNode.toMethod(ctx);
        SourceBuilder rightM = rightNode.toMethod(ctx);
        Class<?> leftType = leftM.returnType(ctx, leftNode);
        Class<?> rightType = rightM.returnType(ctx, rightNode);
        String left = "(" + leftM.source(ctx, leftNode) + ")";
        String right = "(" + rightM.source(ctx, rightNode) + ")";
        StringBuilder sb = new StringBuilder();
        boolean isNotEqual = new NotEqual().getName().equals(operator);
        if (ReflectUtil.isPrimitiveOrWrapNumber(leftType) && ReflectUtil.isPrimitiveOrWrapNumber(rightType)) {
            if (isNotEqual) {
                sb.append('!');
            }
            return sb.append("NumberUtil.equals(").append(left).append(',').append(right).append(')');
        }
        if (isNotEqual) {
            sb.append('!');
        }
        return sb.append("ObjectUtils.equals(").append(left).append(',').append(right).append(')');
    }

    public static boolean isEqual(float a, float b) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isInfinite(a) || Double.isInfinite(b)) {
            return false;
        }
        double eps = 1.0E-8;
        return (double)Math.abs(a - b) < eps;
    }

    public static boolean isEqual(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isInfinite(a) || Double.isInfinite(b)) {
            return false;
        }
        double eps = 1.0E-8;
        return Math.abs(a - b) < eps;
    }

    protected Object formatResult(Object left, Object right) {
        if (left instanceof Number) {
            right = BigDecimal.ZERO;
        } else if (left instanceof String) {
            right = "";
        }
        return right;
    }
}

