/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function.operator;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.fel.common.ReflectUtil;
import kd.fi.bcm.fel.compile.FelMethod;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.function.Function;
import kd.fi.bcm.fel.function.TolerantFunction;
import kd.fi.bcm.fel.parser.FelNode;
import kd.fi.bcm.fel.parser.Stable;

public class LessThen
implements Stable,
Function {
    @Override
    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children != null && children.size() == 2) {
            Object left = TolerantFunction.eval(context, children.get(0));
            Object right = TolerantFunction.eval(context, children.get(1));
            if (left == null) {
                left = this.formatResult(right, left);
            }
            if (right == null) {
                right = this.formatResult(left, right);
            }
            return this.compare(left, right);
        }
        throw new NullPointerException(ResManager.loadKDString((String)"\u53c2\u6570\u6570\u7ec4\u4e3a\u7a7a\u6216\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e\u3002", (String)"LessThen_0", (String)"fi-bcm-common", (Object[])new Object[0]));
    }

    public boolean compare(Object left, Object right) {
        if (left == right) {
            return false;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof Number && right instanceof Number) {
            return NumberUtil.toDouble((Number)left) < NumberUtil.toDouble((Number)right);
        }
        if (left instanceof Comparable && right instanceof Comparable) {
            return ((Comparable)left).compareTo(right) < 0;
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201ctype:%1$s;value:%2$s\u201d\u548c\u53c2\u6570\u201ctype:%3$s;value:%4$s\u201d\u4e0d\u80fd\u8fdb\u884c\u6bd4\u8f83\u201c%5$s\u201d\u8fd0\u7b97\u3002", (String)"LessThen_1", (String)"fi-bcm-common", (Object[])new Object[0]), left.getClass(), left, right.getClass(), right, this.getName()));
    }

    public StringBuilder buildRelationExpr(FelNode node, FelContext ctx, String operator) {
        List<FelNode> child = node.getChildren();
        FelNode leftNode = child.get(0);
        FelNode rightNode = child.get(1);
        SourceBuilder leftM = leftNode.toMethod(ctx);
        SourceBuilder rightM = rightNode.toMethod(ctx);
        Class<?> leftType = leftM.returnType(ctx, leftNode);
        Class<?> rightType = rightM.returnType(ctx, rightNode);
        String left = "(" + leftM.source(ctx, leftNode) + ")";
        String right = "(" + rightM.source(ctx, rightNode) + ")";
        StringBuilder sb = new StringBuilder();
        if (ReflectUtil.isFloatType(leftType) && ReflectUtil.isDoubleType(rightType)) {
            sb.append("NumberUtil.toDouble(").append(left).append(')');
            sb.append(operator);
            sb.append(right);
        } else if (ReflectUtil.isFloatType(rightType) && ReflectUtil.isDoubleType(leftType)) {
            sb.append(left);
            sb.append(operator);
            sb.append("NumberUtil.toDouble(").append(right).append(')');
        } else if (ReflectUtil.isPrimitiveOrWrapNumber(leftType) && ReflectUtil.isPrimitiveOrWrapNumber(rightType)) {
            sb.append(left);
            sb.append(operator);
            sb.append(right);
        } else if (Comparable.class.isAssignableFrom(leftType) && Comparable.class.isAssignableFrom(rightType)) {
            sb.append("NumberUtil.compare(").append(left).append(',').append(right).append(')').append(operator).append('0');
        } else {
            throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7c7b\u578b\u548c\u201c%2$s\u201d\u7c7b\u578b\u4e0d\u652f\u6301\u6bd4\u8f83\u64cd\u4f5c\u3002", (String)"LessThen_5", (String)"fi-bcm-common", (Object[])new Object[0]), leftType, rightType));
        }
        return sb;
    }

    @Override
    public String getName() {
        return "<";
    }

    @Override
    public SourceBuilder toMethod(FelNode node, FelContext ctx) {
        StringBuilder code = this.buildRelationExpr(node, ctx, this.getName());
        return new FelMethod(Boolean.class, code.toString());
    }

    @Override
    public boolean stable() {
        return true;
    }

    protected Object formatResult(Object left, Object right) {
        if (left instanceof Number) {
            right = BigDecimal.ZERO;
        } else if (left instanceof String) {
            right = "";
        }
        return right;
    }
}

