/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function.operator;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.fel.common.ReflectUtil;
import kd.fi.bcm.fel.compile.FelMethod;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.exception.CompileException;
import kd.fi.bcm.fel.exception.EvalException;
import kd.fi.bcm.fel.function.StableFunction;
import kd.fi.bcm.fel.parser.FelNode;

public class Mul
extends StableFunction {
    @Override
    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children.size() == 2) {
            FelNode left = children.get(0);
            Object leftValue = left.eval(context);
            FelNode right = children.get(1);
            Object rightValue = right.eval(context);
            if (leftValue instanceof Number && rightValue instanceof Number) {
                double l = NumberUtil.toDouble(leftValue);
                double r = NumberUtil.toDouble(rightValue);
                return this.calc(l, r);
            }
            throw new EvalException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u201c%s\u201d\u51fa\u9519\uff0c\u53c2\u6570\u5fc5\u987b\u662f\u6570\u503c\u578b\u3002", (String)"Mul_0", (String)"fi-bcm-common", (Object[])new Object[0]), this.getName()));
        }
        throw new EvalException(String.format(ResManager.loadKDString((String)"\u6267\u884c%s\u51fa\u9519\uff0c\u53c2\u6570\u6570\u91cf\u5fc5\u987b\u4e3a2\u3002", (String)"Mul_2", (String)"fi-bcm-common", (Object[])new Object[0]), this.getName()));
    }

    Object calc(double l, double r) {
        return NumberUtil.parseNumber(l * r);
    }

    @Override
    public String getName() {
        return "*";
    }

    @Override
    public FelMethod toMethod(FelNode node, FelContext ctx) {
        String code = "";
        FelNode left = node.getChildren().get(0);
        FelNode right = node.getChildren().get(1);
        SourceBuilder lm = left.toMethod(ctx);
        Class<?> leftType = lm.returnType(ctx, left);
        SourceBuilder rm = right.toMethod(ctx);
        Class<?> rightType = lm.returnType(ctx, right);
        Class<?> type = null;
        if (!ReflectUtil.isPrimitiveOrWrapNumber(leftType) || !ReflectUtil.isPrimitiveOrWrapNumber(rightType)) {
            throw new CompileException(String.format(ResManager.loadKDString((String)"\u201c%3$s\u201d\u8fd0\u7b97\u4ec5\u652f\u6301\u6570\u503c\u7c7b\u578b\uff0c\u4e0d\u652f\u6301\u7c7b\u578b\u201c%1$s\u201d\u3001\u201c%2$s\u201d\u3002", (String)"Mul_3", (String)"fi-bcm-common", (Object[])new Object[0]), ReflectUtil.getClassName(leftType), ReflectUtil.getClassName(rightType), this.getName()));
        }
        type = NumberUtil.arithmeticClass(leftType, rightType);
        code = "(" + lm.source(ctx, left) + ")" + this.getName() + "(" + rm.source(ctx, right) + ")";
        FelMethod m = new FelMethod(type, code);
        return m;
    }

    @Override
    public boolean stable() {
        return true;
    }
}

