/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function.operator;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.fel.common.ReflectUtil;
import kd.fi.bcm.fel.compile.FelMethod;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.exception.CompileException;
import kd.fi.bcm.fel.exception.EvalException;
import kd.fi.bcm.fel.function.StableFunction;
import kd.fi.bcm.fel.parser.FelNode;

public class Sub
extends StableFunction {
    private void appendArg(StringBuilder sb, SourceBuilder argMethod, FelContext ctx, FelNode node) {
        Class<?> t = argMethod.returnType(ctx, node);
        sb.append('(');
        if (ReflectUtil.isPrimitiveOrWrapNumber(t)) {
            sb.append(argMethod.source(ctx, node));
        } else if (CharSequence.class.isAssignableFrom(t)) {
            // empty if block
        }
        sb.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FelMethod toMethod(FelNode node, FelContext ctx) {
        List<FelNode> children = node.getChildren();
        StringBuilder sb = new StringBuilder();
        Class<?> type = null;
        if (children.size() == 2) {
            FelNode left = children.get(0);
            SourceBuilder lm = left.toMethod(ctx);
            Class<?> leftType = lm.returnType(ctx, left);
            this.appendArg(sb, lm, ctx, left);
            FelNode right = children.get(1);
            SourceBuilder rm = right.toMethod(ctx);
            Class<?> rightType = rm.returnType(ctx, right);
            sb.append('-');
            this.appendArg(sb, rm, ctx, right);
            if (!ReflectUtil.isPrimitiveOrWrapNumber(leftType) || !ReflectUtil.isPrimitiveOrWrapNumber(rightType)) throw new CompileException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u201c%1$s\u201d\u3001\u201c%2$s\u201d\uff0c\u51cf\u6cd5\u8fd0\u7b97\u53ea\u652f\u6301\u6570\u503c\u7c7b\u578b\u3002", (String)"Sub_0", (String)"fi-bcm-common", (Object[])new Object[0]), ReflectUtil.getClassName(leftType), ReflectUtil.getClassName(rightType)));
            type = NumberUtil.arithmeticClass(leftType, rightType);
            return new FelMethod(type, sb.toString());
        } else {
            if (children.size() != 1) return new FelMethod(type, sb.toString());
            FelNode right = children.get(0);
            SourceBuilder rm = right.toMethod(ctx);
            Class<?> rightType = rm.returnType(ctx, right);
            sb.append('-');
            this.appendArg(sb, rm, ctx, right);
            if (!ReflectUtil.isPrimitiveOrWrapNumber(rightType)) return new FelMethod(type, sb.toString());
            type = rightType;
        }
        return new FelMethod(type, sb.toString());
    }

    @Override
    public String getName() {
        return "-";
    }

    @Override
    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children.size() == 2) {
            FelNode left = children.get(0);
            Object leftValue = left.eval(context);
            FelNode right = children.get(1);
            Object rightValue = right.eval(context);
            if (leftValue instanceof Number && rightValue instanceof Number) {
                double l = NumberUtil.toDouble(leftValue);
                double r = NumberUtil.toDouble(rightValue);
                return NumberUtil.parseNumber(l - r);
            }
            throw new EvalException(ResManager.loadKDString((String)"\u6267\u884c\u51cf\u6cd5\u51fa\u9519\uff0c\u53c2\u6570\u5fc5\u987b\u662f\u6570\u503c\u578b\u3002", (String)"Sub_2", (String)"fi-bcm-common", (Object[])new Object[0]));
        }
        if (children.size() == 1) {
            FelNode right = children.get(0);
            Object rightValue = right.eval(context);
            if (rightValue instanceof Number) {
                if (NumberUtil.isFloatingPoint(rightValue)) {
                    return NumberUtil.toDouble(rightValue) * -1.0;
                }
                return NumberUtil.parseNumber(((Number)rightValue).longValue() * -1L);
            }
            throw new EvalException(ResManager.loadKDString((String)"\u6267\u884c\u51cf\u6cd5\u51fa\u9519\uff0c\u53c2\u6570\u5fc5\u987b\u662f\u6570\u503c\u578b\u3002", (String)"Sub_2", (String)"fi-bcm-common", (Object[])new Object[0]));
        }
        throw new EvalException(ResManager.loadKDString((String)"\u6267\u884c\u51cf\u6cd5\u51fa\u9519\uff0c\u53c2\u6570\u957f\u5ea6\u5fc5\u987b\u662f1\u62162\u3002", (String)"Sub_3", (String)"fi-bcm-common", (Object[])new Object[0]));
    }
}

