/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function.operator.big;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.fel.common.ObjectUtils;
import kd.fi.bcm.fel.compile.InterpreterSourceBuilder;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.function.StableFunction;
import kd.fi.bcm.fel.function.TolerantFunction;
import kd.fi.bcm.fel.parser.FelNode;

public class BigAdd
extends StableFunction {
    @Override
    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        Object left = TolerantFunction.eval(context, children.get(0));
        if (children.size() == 1) {
            return left;
        }
        Object right = TolerantFunction.eval(context, children.get(1));
        if (left == null) {
            left = NumberUtil.convertNullObjectAsBase(right);
        }
        if (right == null) {
            right = NumberUtil.convertNullObjectAsBase(left);
        }
        if (left == null && right == null) {
            return null;
        }
        if (left instanceof String || right instanceof String) {
            if (left instanceof String && BCMConstant.Zero == right) {
                return ObjectUtils.toString(left);
            }
            if (right instanceof String && BCMConstant.Zero == left) {
                return ObjectUtils.toString(right);
            }
            return ObjectUtils.toString(left).concat(ObjectUtils.toString(right));
        }
        try {
            if (BigAdd.hasFloat(left, right)) {
                BigDecimal l = NumberUtil.toBigDecimal(left);
                BigDecimal r = NumberUtil.toBigDecimal(right);
                return l.add(r);
            }
            if (BigAdd.isInt(left) || BigAdd.isInt(right)) {
                BigInteger l = NumberUtil.toBigInteger(left);
                BigInteger r = NumberUtil.toBigInteger(right);
                return l.add(r);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ObjectUtils.toString(left).concat(ObjectUtils.toString(right));
    }

    public static boolean isInt(Object left, Object right) {
        return BigAdd.isInt(left) && BigAdd.isInt(right);
    }

    public static boolean hasFloat(Object left, Object right) {
        return BigAdd.isFloat(left) || BigAdd.isFloat(right);
    }

    @Override
    public String getName() {
        return "+";
    }

    public static boolean isFloat(Object o) {
        return NumberUtil.isFloatingPoint(o) || o instanceof BigDecimal;
    }

    public static boolean isInt(Object o) {
        return NumberUtil.isNumberable(o) || o instanceof BigInteger;
    }

    @Override
    public SourceBuilder toMethod(FelNode node, FelContext ctx) {
        return InterpreterSourceBuilder.getInstance();
    }
}

