/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function.operator.big;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.exception.EvalException;
import kd.fi.bcm.fel.function.TolerantFunction;
import kd.fi.bcm.fel.function.operator.big.BigMul;
import kd.fi.bcm.fel.parser.FelNode;

public class BigDiv
extends BigMul {
    private final MathContext mc;

    public BigDiv(int setPrecision) {
        this.mc = new MathContext(setPrecision, RoundingMode.HALF_DOWN);
    }

    public BigDiv() {
        this(100);
    }

    @Override
    public String getName() {
        return "/";
    }

    @Override
    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        Object left = TolerantFunction.eval(context, children.get(0));
        Object right = TolerantFunction.eval(context, children.get(1));
        if (left == null) {
            left = NumberUtil.convertNullObjectAsBase(right);
        }
        if (right == null) {
            right = NumberUtil.convertNullObjectAsBase(left);
        }
        try {
            if (left == null && right == null) {
                return null;
            }
            BigDecimal l = NumberUtil.toBigDecimal(left);
            BigDecimal r = NumberUtil.toBigDecimal(right);
            return this.calc(l, r);
        }
        catch (NumberFormatException e) {
            throw new EvalException(String.format(ResManager.loadKDString((String)"\u9664\u6cd5\u6267\u884c\u5931\u8d25\uff0c\u201c%1$s/%2$s\u201d\u3002", (String)"BigDiv_0", (String)"fi-bcm-common", (Object[])new Object[0]), NumberUtil.outputData(left), NumberUtil.outputData(right)), e);
        }
    }

    @Override
    public Object calc(BigDecimal left, BigDecimal right) {
        try {
            return left.divide(right, this.mc);
        }
        catch (ArithmeticException e) {
            throw new EvalException(String.format(ResManager.loadKDString((String)"\u9664\u6cd5\u6267\u884c\u5931\u8d25\uff0c\u201c%1$s/%2$s\u201d\u3002", (String)"BigDiv_0", (String)"fi-bcm-common", (Object[])new Object[0]), NumberUtil.outputData(left), NumberUtil.outputData(right)), e);
        }
    }
}

