/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.function.operator.big;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.fel.common.NumberUtil;
import kd.fi.bcm.fel.compile.InterpreterSourceBuilder;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.exception.EvalException;
import kd.fi.bcm.fel.function.StableFunction;
import kd.fi.bcm.fel.function.TolerantFunction;
import kd.fi.bcm.fel.function.operator.big.BigAdd;
import kd.fi.bcm.fel.parser.FelNode;

public class BigSub
extends StableFunction {
    @Override
    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        Object left = TolerantFunction.eval(context, children.get(0));
        Object right = null;
        if (children.size() == 1) {
            if (left == null) {
                return null;
            }
            right = left;
            left = 0;
        } else {
            right = TolerantFunction.eval(context, children.get(1));
            if (left == null) {
                left = NumberUtil.convertNullObjectAsBase(right);
            }
            if (right == null) {
                right = NumberUtil.convertNullObjectAsBase(left);
            }
            if (left == null && right == null) {
                return null;
            }
        }
        try {
            if (BigAdd.isFloat(left) || BigAdd.isFloat(right)) {
                BigDecimal l = NumberUtil.toBigDecimal(left);
                BigDecimal r = NumberUtil.toBigDecimal(right);
                return l.subtract(r);
            }
            if (BigAdd.isInt(left) || BigAdd.isInt(right)) {
                BigInteger l = NumberUtil.toBigInteger(left);
                BigInteger r = NumberUtil.toBigInteger(right);
                return l.subtract(r);
            }
        }
        catch (NumberFormatException e) {
            throw new EvalException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u51cf\u6cd5\u5931\u8d25[%1$s-%2$s]", (String)"BigSub_0", (String)"fi-bcm-common", (Object[])new Object[0]), NumberUtil.outputData(left), NumberUtil.outputData(right)), e);
        }
        throw new EvalException(String.format(ResManager.loadKDString((String)"\u6267\u884c\u51cf\u6cd5\u5931\u8d25[%1$s-%2$s]", (String)"BigSub_0", (String)"fi-bcm-common", (Object[])new Object[0]), NumberUtil.outputData(left), NumberUtil.outputData(right)));
    }

    @Override
    public String getName() {
        return "-";
    }

    @Override
    public SourceBuilder toMethod(FelNode node, FelContext ctx) {
        return InterpreterSourceBuilder.getInstance();
    }
}

