/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.optimizer;

import java.util.List;
import java.util.Map;
import kd.fi.bcm.fel.compile.InterpreterSourceBuilder;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.compile.SourceGeneratorImpl;
import kd.fi.bcm.fel.compile.VarBuffer;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.context.MapContext;
import kd.fi.bcm.fel.context.Var;
import kd.fi.bcm.fel.interpreter.Interpreter;
import kd.fi.bcm.fel.optimizer.Optimizer;
import kd.fi.bcm.fel.parser.AbstFelNode;
import kd.fi.bcm.fel.parser.FelNode;
import kd.fi.bcm.fel.parser.VarAstNode;

public class VarVisitOpti
implements Optimizer {
    private Map<String, Var> varMap;

    public VarVisitOpti(Var ... vars) {
        this.varMap = new MapContext();
        if (vars != null) {
            for (Var var : vars) {
                if (var == null) continue;
                this.varMap.put(var.getName(), var);
            }
        }
    }

    public VarVisitOpti() {
    }

    @Override
    public FelNode call(FelContext ctx, FelNode node) {
        List<FelNode> nodes = AbstFelNode.getNodes(node, SourceGeneratorImpl.varsFilter);
        for (FelNode varNode : nodes) {
            VarAstNode n;
            if (!(varNode instanceof VarAstNode) || !(n = (VarAstNode)varNode).isDefaultInterpreter()) continue;
            n.setInterpreter(this.createInterpreter());
            n.setSourcebuilder(this.createVarSourceBuilder(n));
        }
        return node;
    }

    private Interpreter createInterpreter() {
        return new Interpreter(){

            @Override
            public Object interpret(FelContext context, FelNode node) {
                Var var = VarVisitOpti.this.getVar(context, node);
                return var != null ? var.getValue() : null;
            }
        };
    }

    private SourceBuilder createVarSourceBuilder(VarAstNode n) {
        return new SourceBuilder(){
            private String src = null;
            private Class<?> returnType = null;

            @Override
            public String source(FelContext ctx, FelNode node) {
                if (this.src == null) {
                    Var var = VarVisitOpti.this.getVar(ctx, node);
                    String varFieldName = VarBuffer.push(var);
                    Class<?> type = this.returnType(ctx, node);
                    this.src = VarAstNode.getVarFullCode(type, varFieldName + ".getValue()");
                }
                return this.src;
            }

            @Override
            public Class<?> returnType(FelContext ctx, FelNode node) {
                if (this.returnType == null) {
                    this.returnType = InterpreterSourceBuilder.getInstance().returnType(ctx, node);
                }
                return this.returnType;
            }
        };
    }

    private Var getVar(FelContext context, FelNode node) {
        Var var = null;
        if (this.varMap != null) {
            var = this.varMap.get(node.getText());
        }
        if (var == null) {
            var = context.getVar(node.getText());
        }
        return var;
    }
}

