/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import kd.fi.bcm.fel.FelEngine;
import kd.fi.bcm.fel.common.Callable;
import kd.fi.bcm.fel.exception.ParseException;
import kd.fi.bcm.fel.function.Function;
import kd.fi.bcm.fel.function.operator.Dot;
import kd.fi.bcm.fel.parser.AbstFelNode;
import kd.fi.bcm.fel.parser.FelLexer;
import kd.fi.bcm.fel.parser.FelNode;
import kd.fi.bcm.fel.parser.FelParser;
import kd.fi.bcm.fel.parser.FunNode;
import kd.fi.bcm.fel.parser.NodeAdaptor;
import kd.fi.bcm.fel.parser.Parser;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.TreeAdaptor;

public class AntlrParser
implements Parser {
    public static final Callable<Boolean, FelNode> funFilter = new Callable<Boolean, FelNode>(){

        public Boolean call(FelNode ... node) {
            FelNode n = node[0];
            if (n == null) {
                return Boolean.FALSE;
            }
            boolean isFun = n instanceof FunNode;
            if (isFun && n instanceof CommonTree) {
                CommonTree treeNode = (CommonTree)n;
                CommonTree p = treeNode.parent;
                if (p != null && ".".equals(p.getText())) {
                    isFun = p.getChildren().get(0) == n;
                }
            }
            return isFun;
        }
    };
    private final FelEngine engine;
    private final NodeAdaptor adaptor;

    public AntlrParser(FelEngine engine) {
        this(engine, null);
    }

    public AntlrParser(FelEngine engine, NodeAdaptor adaptor) {
        this.engine = engine;
        if (adaptor == null) {
            adaptor = new NodeAdaptor();
        }
        this.adaptor = adaptor;
    }

    @Override
    public FelNode parse(String exp) {
        Object tree;
        if (exp == null || "".equals(exp)) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(exp.getBytes());
        ANTLRInputStream input = null;
        try {
            input = new ANTLRInputStream((InputStream)is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FelLexer lexer = new FelLexer((CharStream)input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        FelParser parser = new FelParser((TokenStream)tokens);
        parser.setTreeAdaptor((TreeAdaptor)this.adaptor);
        FelParser.program_return r = null;
        try {
            r = parser.program();
        }
        catch (RecognitionException e) {
            throw new ParseException(e.getMessage(), e);
        }
        if (r != null && (tree = r.getTree()) instanceof FelNode) {
            this.initFun((FelNode)tree);
            return (FelNode)tree;
        }
        return null;
    }

    public void initFun(FelNode node) {
        List<FelNode> nodes = AbstFelNode.getNodes(node, funFilter);
        if (nodes != null) {
            for (FelNode n : nodes) {
                FunNode funNode = (FunNode)n;
                funNode.initFun(this.engine.getFunMgr());
                Function fun = funNode.getFun();
                if (!(fun instanceof Dot)) continue;
                Dot dot = (Dot)fun;
                dot.setSecurityMgr(this.engine.getSecurityMgr());
            }
        }
    }

    @Override
    public boolean verify(String exp) {
        try {
            this.parse(exp);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

