/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.fel.parser;

import kd.fi.bcm.fel.common.ReflectUtil;
import kd.fi.bcm.fel.compile.InterpreterSourceBuilder;
import kd.fi.bcm.fel.compile.SourceBuilder;
import kd.fi.bcm.fel.context.AbstractContext;
import kd.fi.bcm.fel.context.ArrayCtx;
import kd.fi.bcm.fel.context.FelContext;
import kd.fi.bcm.fel.parser.AbstFelNode;
import kd.fi.bcm.fel.parser.FelNode;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;

public class VarAstNode
extends AbstFelNode {
    private final String text;

    public VarAstNode(Token token) {
        super(token);
        this.builder = new SourceBuilder(){

            @Override
            public String source(FelContext ctx, FelNode node) {
                if (!node.isDefaultInterpreter()) {
                    return InterpreterSourceBuilder.getInstance().source(ctx, node);
                }
                Class<?> type = this.returnType(ctx, node);
                String varName = node.getText();
                String getVarCode = "context.get(\"" + varName + "\")";
                if (ctx instanceof ArrayCtx) {
                    ArrayCtx c = (ArrayCtx)ctx;
                    getVarCode = "((context instanceof ArrayCtx)?((ArrayCtx)context).get(" + c.getIndex(varName) + "):context.get(\"" + varName + "\"))";
                }
                String code = VarAstNode.getVarFullCode(type, getVarCode);
                return code;
            }

            @Override
            public Class<?> returnType(FelContext ctx, FelNode node) {
                Class<?> type = AbstractContext.getVarType(node.getText(), ctx);
                if (type == null) {
                    type = InterpreterSourceBuilder.getInstance().returnType(ctx, node);
                }
                return type;
            }
        };
        this.text = token.getText();
    }

    public String getText() {
        return this.text;
    }

    @Override
    public Object interpret(FelContext context, FelNode node) {
        return context.get(this.text);
    }

    public static boolean isVar(FelNode n) {
        if (n == null) {
            return false;
        }
        boolean isVar = n instanceof VarAstNode;
        if (isVar && n instanceof CommonTree) {
            CommonTree treeNode = (CommonTree)n;
            CommonTree p = treeNode.parent;
            if (p != null && ".".equals(p.getText())) {
                isVar = p.getChildren().get(0) == n;
            }
        }
        return isVar;
    }

    public static String getVarFullCode(Class<?> type, String getVarCode) {
        String typeName = type.getCanonicalName();
        boolean isNumber = Number.class.isAssignableFrom(type);
        String code = "";
        code = ReflectUtil.isPrimitiveOrWrapNumber(type) ? "((" + typeName + ")" + getVarCode + ")" : (isNumber ? "((" + typeName + ")" + getVarCode + ").doubleValue()" : "((" + typeName + ")" + getVarCode + ")");
        return code;
    }
}

