/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.spread.common.util.exception.InvalidDateException;
import org.apache.poi.ss.usermodel.DateUtil;

public class DateTimeUtils {
    private static final Log logger = LogFactory.getLog(DateTimeUtils.class);
    private static TimeZone gmt = new SimpleTimeZone(0, "GMT");
    private static final String EX_GMT_TO_DATE = "gmtToDate: invalid gmt date string!";
    private static final String EX_GET_MONTH_NAME = "getMonthName : month value must be between 1 and 12!";
    private static final String EX_GET_ELAPSED_TIME = "getElapsedTime : begin date must be inferior to end date !";
    private static final String EX_GET_DAY_NAME = "getDayName: day value must be between 1 and 7!";
    private static final String EX_FORMAT_MONTH = "Invalid month name";
    private static final String EX_DATE_TO_GMT = "dateToGmt: unknown RFC format";

    public static String format(Date d, String fmt) {
        return DateTimeUtils.format(d, fmt, null);
    }

    public static String format(Date d, String fmt, TimeZone timezone) {
        return DateTimeUtils.format(d, fmt, timezone, null);
    }

    public static String format(Date d, String fmt, TimeZone timezone, Locale locale) {
        if (fmt == null) {
            fmt = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            df.setTimeZone(TimeZone.getDefault());
        } else {
            df.setTimeZone(timezone);
        }
        return df.format(d);
    }

    public static String format(Date d) {
        return DateTimeUtils.format(d, null, null);
    }

    public static String format(Date d, TimeZone timezone) {
        return DateTimeUtils.format(d, null, timezone);
    }

    public static String formatDate(Date d, TimeZone timezone) {
        return DateTimeUtils.format(d, "yyyy-MM-dd", timezone);
    }

    public static String formatDate(Date d) {
        return DateTimeUtils.formatDate(d, null);
    }

    public static String formatTime(Date d, TimeZone timezone) {
        return DateTimeUtils.format(d, "HH:mm:ss", timezone);
    }

    public static String formatTime(Date d) {
        return DateTimeUtils.formatTime(d, null);
    }

    public static String defaultDateString(Date d) {
        return DateTimeUtils.defaultDateString(d, null);
    }

    public static String defaultDateString(Date d, TimeZone timezone) {
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        long l = timezone.getRawOffset();
        StringBuilder temp = new StringBuilder(DateTimeUtils.format(d, timezone));
        if (l > 0L) {
            temp.append(" +");
        } else {
            temp.append(" -");
            l = -l;
        }
        temp.append(DateTimeUtils.format(new Date(l), "HH:mm", gmt));
        return temp.toString();
    }

    public static Date parseDate(String s) throws ParseException {
        if (StringUtils.isNotEmpty(s)) {
            int length = s.length();
            if (19 == length) {
                if (s.indexOf("-") > 0) {
                    return DateTimeUtils.parseDate(s, "yyyy-MM-dd HH:mm:ss");
                }
                return DateTimeUtils.parseDate(s, "MM/dd/yyyy HH:mm:ss");
            }
            if (8 == length) {
                return DateTimeUtils.parseDate(s, "HH:mm:ss");
            }
            if (10 == length) {
                if (s.indexOf("-") > 0) {
                    return DateTimeUtils.parseDate(s, "yyyy-MM-dd");
                }
                return DateTimeUtils.parseDate(s, "MM/dd/yyyy");
            }
        }
        return DateTimeUtils.parseDate(s, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parseDate(String s, String fmt) throws ParseException {
        return DateTimeUtils.parseDate(s, fmt, null);
    }

    public static Object trans2DateFilter4BizRule(Object value) {
        try {
            if (value instanceof Date) {
                return value;
            }
            return DateTimeUtils.parseStrDate(value.toString());
        }
        catch (ParseException e) {
            try {
                SimpleDateFormat sp = new SimpleDateFormat("yyyy/MM/dd");
                return sp.parse(value.toString());
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public static Date parseStrDate(String strDate) throws ParseException {
        if (strDate.contains("T")) {
            strDate = DateTimeUtils.parseUTC(strDate);
        }
        if (strDate.contains("OADate")) {
            return DateTimeUtils.parseOADate(strDate);
        }
        if (strDate.contains(ResManager.loadKDString((String)"\u5e74", (String)"DateTimeUtils_0", (String)"fi-bcm-common", (Object[])new Object[0])) || strDate.contains(ResManager.loadKDString((String)"\u6708", (String)"DateTimeUtils_1", (String)"fi-bcm-common", (Object[])new Object[0])) || strDate.contains(ResManager.loadKDString((String)"\u65e5", (String)"DateTimeUtils_2", (String)"fi-bcm-common", (Object[])new Object[0]))) {
            if (strDate.contains(ResManager.loadKDString((String)"\u65e5", (String)"DateTimeUtils_2", (String)"fi-bcm-common", (Object[])new Object[0]))) {
                return DateTimeUtils.parseDate(strDate, ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"DateTimeUtils_3", (String)"fi-bcm-common", (Object[])new Object[0]));
            }
            return DateTimeUtils.parseDate(strDate, ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"DateTimeUtils_4", (String)"fi-bcm-common", (Object[])new Object[0]));
        }
        if (strDate.contains("/")) {
            if (strDate.contains(":")) {
                return DateTimeUtils.parseDate(strDate, "MM/dd/yyyy HH:mm:ss");
            }
            return DateTimeUtils.parseDate(strDate, "MM/dd/yyyy");
        }
        if (strDate.contains("-")) {
            if (strDate.contains(":")) {
                return DateTimeUtils.parseDate(strDate, "yyyy-MM-dd HH:mm:ss");
            }
            return DateTimeUtils.parseDate(strDate, "yyyy-MM-dd");
        }
        if (strDate.contains(".")) {
            if (strDate.contains(":")) {
                return DateTimeUtils.parseDate(strDate, "yyyy.MM.dd HH:mm:ss");
            }
            return DateTimeUtils.parseDate(strDate, "yyyy.MM.dd");
        }
        if (8 == strDate.length()) {
            return DateTimeUtils.parseDate(strDate, "HH:mm:ss");
        }
        return DateTimeUtils.parseDate(strDate, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parseStrDate2(String strDate) throws ParseException {
        if (strDate.contains("/")) {
            if (strDate.contains(":")) {
                return DateTimeUtils.parseDate(strDate, "yyyy/MM/dd HH:mm:ss");
            }
            return DateTimeUtils.parseDate(strDate, "yyyy/MM/dd");
        }
        if (strDate.contains("-")) {
            if (strDate.contains(":")) {
                return DateTimeUtils.parseDate(strDate, "yyyy-MM-dd HH:mm:ss");
            }
            return DateTimeUtils.parseDate(strDate, "yyyy-MM");
        }
        if (strDate.contains(".")) {
            if (strDate.contains(":")) {
                return DateTimeUtils.parseDate(strDate, "yyyy.MM.dd HH:mm:ss");
            }
            return DateTimeUtils.parseDate(strDate, "yyyy.MM");
        }
        if (8 == strDate.length()) {
            return DateTimeUtils.parseDate(strDate, "HH:mm:ss");
        }
        return DateTimeUtils.parseDate(strDate, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parseStrDate3(String strDate) throws ParseException {
        if (strDate.contains("/")) {
            if (strDate.contains(":")) {
                return DateTimeUtils.parseDate(strDate, "yyyy/MM HH:mm:ss");
            }
            return DateTimeUtils.parseDate(strDate, "yyyy/MM");
        }
        return DateTimeUtils.parseDate(strDate, "yyyy-MM-dd HH:mm:ss");
    }

    public static String parseUTC(String utcDate) {
        SimpleDateFormat utcFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS Z");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        utcDate = utcDate.replace("Z", " UTC");
        try {
            Date date = utcFormat.parse(utcDate);
            return sdf.format(date);
        }
        catch (ParseException e) {
            logger.error((Throwable)e);
            return utcDate;
        }
    }

    public static Date parseDate(String s, String fmt, TimeZone timezone) throws ParseException {
        return DateTimeUtils.parseDate(s, fmt, timezone, null);
    }

    public static Date parseDate(String s, String fmt, TimeZone timezone, Locale locale) throws ParseException {
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        df.setTimeZone(timezone);
        df.setLenient(false);
        return df.parse(s);
    }

    public static String emailDate(Date d) {
        return DateTimeUtils.emailDate(d, null);
    }

    public static String emailDate(Date d, TimeZone timezone) {
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        long l = timezone.getRawOffset();
        StringBuilder temp = new StringBuilder(DateTimeUtils.format(d, "E, d MMM yyyy HH:mm:ss", timezone, Locale.UK));
        if (l > 0L) {
            temp.append(" +");
        } else {
            temp.append(" -");
            l = -l;
        }
        temp.append(DateTimeUtils.format(new Date(l), "HHmm", gmt));
        return temp.toString();
    }

    public static boolean dayBefore(Date dt, Date dt1) {
        Calendar c = Calendar.getInstance();
        c.setTime(dt);
        int year = c.get(1);
        int date = c.get(6);
        c.setTime(dt1);
        int year1 = c.get(1);
        int date1 = c.get(6);
        return year < year1 || year == year1 && date < date1;
    }

    public static boolean dayAfter(Date dt, Date dt1) {
        Calendar c = Calendar.getInstance();
        c.setTime(dt);
        int year = c.get(1);
        int date = c.get(6);
        c.setTime(dt1);
        int year1 = c.get(1);
        int date1 = c.get(6);
        return year > year1 || year == year1 && date > date1;
    }

    public static boolean dayEquals(Date dt, Date dt1) {
        Calendar c = Calendar.getInstance();
        c.setTime(dt);
        int year = c.get(1);
        int date = c.get(6);
        c.setTime(dt1);
        int year1 = c.get(1);
        int date1 = c.get(6);
        return year == year1 && date == date1;
    }

    public static int getQuarter(Date date) {
        int quarter = 0;
        int month = DateTimeUtils.getMonth(date);
        if (month >= 1 && month <= 3) {
            quarter = 1;
        } else if (month >= 4 && month <= 6) {
            quarter = 2;
        } else if (month >= 7 && month <= 9) {
            quarter = 3;
        } else if (month >= 10 && month <= 12) {
            quarter = 4;
        }
        return quarter;
    }

    public static int daysOfMonth(int year, int month) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                if (DateTimeUtils.isLeap(year)) {
                    return 29;
                }
                return 28;
            }
        }
        return 0;
    }

    public static Date addDate(Date dDate1, Date dDate2) {
        long date1Ms = dDate1.getTime();
        long date2Ms = dDate2.getTime();
        long add = date1Ms + date2Ms;
        return new Date(add);
    }

    public static Date addDay(Date dDate, long iNbDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        cal.add(5, (int)iNbDay);
        Date result = cal.getTime();
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth) {
        Date result = dDate;
        result = DateTimeUtils.addMonth(result, iNbMonth);
        result = DateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth, int iNbDay) {
        Date result = dDate;
        result = DateTimeUtils.addDay(result, iNbDay);
        result = DateTimeUtils.addMonth(result, iNbMonth);
        result = DateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth, int iNbDay, int iNbHour) {
        Date result = dDate;
        result = DateTimeUtils.addHour(result, iNbHour);
        result = DateTimeUtils.addDay(result, iNbDay);
        result = DateTimeUtils.addMonth(result, iNbMonth);
        result = DateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth, int iNbDay, int iNbHour, int iNbMinute) {
        Date result = dDate;
        result = DateTimeUtils.addMinute(result, iNbMinute);
        result = DateTimeUtils.addHour(result, iNbHour);
        result = DateTimeUtils.addDay(result, iNbDay);
        result = DateTimeUtils.addMonth(result, iNbMonth);
        result = DateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addDuration(Date dDate, int iNbYear, int iNbMonth, int iNbDay, int iNbHour, int iNbMinute, int iNbSecond) {
        Date result = dDate;
        result = DateTimeUtils.addSecond(result, iNbSecond);
        result = DateTimeUtils.addMinute(result, iNbMinute);
        result = DateTimeUtils.addHour(result, iNbHour);
        result = DateTimeUtils.addDay(result, iNbDay);
        result = DateTimeUtils.addMonth(result, iNbMonth);
        result = DateTimeUtils.addYear(result, iNbYear);
        return result;
    }

    public static Date addHour(Date dDate, long iNbHour) {
        long datems = dDate.getTime();
        long hourMs = iNbHour * 60L * 60L * 1000L;
        long newDateMs = datems + hourMs;
        Date result = new Date(newDateMs);
        return result;
    }

    public static Date addMinute(Date dDate, long iNbMinute) {
        long datems = dDate.getTime();
        long minuteMs = iNbMinute * 60L * 1000L;
        long newDateMs = datems + minuteMs;
        Date result = new Date(newDateMs);
        return result;
    }

    public static Date addMonth(Date dDate, int iNbMonth) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        int month = cal.get(2);
        int year = (month += iNbMonth) / 12;
        cal.set(2, month %= 12);
        if (year != 0) {
            int oldYear = cal.get(1);
            cal.set(1, year + oldYear);
        }
        return cal.getTime();
    }

    public static Date addSecond(Date dDate, long iNbSecond) {
        long datems = dDate.getTime();
        long secondms = iNbSecond * 1000L;
        long newDateMs = datems + secondms;
        Date result = new Date(newDateMs);
        return result;
    }

    public static Date addYear(Date dDate, int iNbYear) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        int oldYear = cal.get(1);
        cal.set(1, iNbYear + oldYear);
        return cal.getTime();
    }

    public static long dateDiff(String interval, Date dDate1, Date dDate2) {
        int field;
        Date date2;
        Date date1;
        int desiredField = 0;
        int coef = 1;
        if (dDate1.getTime() > dDate2.getTime()) {
            coef = -1;
            date1 = dDate2;
            date2 = dDate1;
        } else {
            date1 = dDate1;
            date2 = dDate2;
        }
        if (interval.equals("yyyy")) {
            field = 1;
        } else if (interval.equals("m")) {
            field = 2;
        } else if (interval.equals("d")) {
            field = 5;
        } else if (interval.equals("y")) {
            field = 5;
        } else if (interval.equals("w")) {
            field = 4;
        } else if (interval.equals("ww")) {
            field = 3;
        } else if (interval.equals("h")) {
            field = 5;
            desiredField = 11;
        } else if (interval.equals("n")) {
            field = 5;
            desiredField = 12;
        } else if (interval.equals("s")) {
            field = 5;
            desiredField = 13;
        } else {
            return -1L;
        }
        Calendar calTmp = Calendar.getInstance();
        calTmp.setTime(date1);
        long nbOccurence = 0L;
        calTmp.add(field, 1);
        Date dateTemp = calTmp.getTime();
        while (dateTemp.getTime() <= date2.getTime()) {
            calTmp.add(field, 1);
            dateTemp = calTmp.getTime();
            ++nbOccurence;
        }
        if (desiredField == 11 || desiredField == 12 || desiredField == 13) {
            calTmp.setTime(date1);
            calTmp.add(field, (int)nbOccurence);
            dateTemp = calTmp.getTime();
            switch (desiredField) {
                case 11: {
                    nbOccurence *= 24L;
                    break;
                }
                case 12: {
                    nbOccurence = nbOccurence * 24L * 60L;
                    break;
                }
                case 13: {
                    nbOccurence = nbOccurence * 24L * 60L * 60L;
                }
            }
            calTmp.add(desiredField, 1);
            dateTemp = calTmp.getTime();
            while (dateTemp.getTime() <= date2.getTime()) {
                calTmp.add(desiredField, 1);
                dateTemp = calTmp.getTime();
                ++nbOccurence;
            }
        }
        return nbOccurence * (long)coef;
    }

    public static long dateDiff(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        return date2ms - date1ms;
    }

    public static String dateToSQL(Date vDate) {
        String sqlDate = "#" + DateTimeUtils.format(vDate, "M/d/yyyy H:m:s") + "#";
        return sqlDate;
    }

    public static int getDay(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(5);
    }

    public static String getDayName(int iNDay) throws InvalidDateException {
        if (iNDay >= 1 && iNDay <= 7) {
            Calendar cal = Calendar.getInstance();
            cal.set(7, iNDay);
            return DateTimeUtils.format(cal.getTime(), "EEEE");
        }
        throw new InvalidDateException(EX_GET_DAY_NAME);
    }

    public static String getDayName(Date vDate) {
        return DateTimeUtils.format(vDate, "EEEE");
    }

    public static Date getGMTDate() {
        Date now = new Date();
        long nowMs = now.getTime();
        long gmtOffetsMs = DateTimeUtils.getServerGMTOffset() * 60 * 1000;
        Date nowGMT = new Date(nowMs - gmtOffetsMs);
        return nowGMT;
    }

    public static int getGMTHour() {
        Date nowGMT = DateTimeUtils.getGMTDate();
        int gmtHour = Integer.parseInt(DateTimeUtils.format(nowGMT, "H"));
        return gmtHour;
    }

    public static long getGMTOffset(Date vDate) {
        Date nowGMT = DateTimeUtils.getGMTDate();
        long nowGMTMs = nowGMT.getTime();
        long vDateMs = vDate.getTime();
        double diffMs = vDateMs - nowGMTMs;
        double diffSec = diffMs / 1000.0;
        double diffMinute = Math.round(diffSec) / 60L;
        return Math.round(diffMinute);
    }

    public static int getMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(2) + 1;
    }

    public static String getMonthName(int iMonth) throws InvalidDateException {
        if (--iMonth >= 0 && iMonth <= 11) {
            Calendar cal = Calendar.getInstance();
            cal.set(5, 1);
            cal.set(2, iMonth);
            return DateTimeUtils.format(cal.getTime(), "MMMM");
        }
        throw new InvalidDateException(EX_GET_MONTH_NAME);
    }

    public static String getMonthName(Date vDate) {
        return DateTimeUtils.format(vDate, "MMMM");
    }

    public static int getServerGMTOffset() {
        Calendar now = Calendar.getInstance();
        int era = now.get(0);
        int year = now.get(1);
        int month = now.get(2);
        int day = now.get(5);
        int dayofweek = now.get(7);
        int milliseconds = now.get(14);
        int resultMs = Calendar.getInstance().getTimeZone().getOffset(era, year, month, day, dayofweek, milliseconds);
        return resultMs / 1000 / 60;
    }

    public static String getServerTimeZone() {
        Calendar cal = Calendar.getInstance();
        TimeZone tz = cal.getTimeZone();
        return tz.getID();
    }

    public static int getWeek(Date vDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(vDate);
        int week = cal.get(3);
        return week;
    }

    public static int getWeekDay(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(7);
    }

    public static int getYear(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        int year = cal.get(1);
        int era = cal.get(0);
        if (era == 0) {
            return -1 * year;
        }
        return year;
    }

    public static boolean isLeap(int year) {
        boolean div4 = year % 4 == 0;
        boolean div100 = year % 100 == 0;
        boolean div400 = year % 400 == 0;
        return div4 && (!div100 || div400);
    }

    public static Date secondsTo(long lNbSeconds) {
        return new Date(lNbSeconds * 1000L);
    }

    public static Date subDate(Date dDate1, Date dDate2) {
        long date1Ms = dDate1.getTime();
        long date2Ms = dDate2.getTime();
        long diff = date1Ms - date2Ms;
        return new Date(diff);
    }

    public static Date truncateDate(Date dt) {
        if (dt == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        cal.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static Date getDayBefore(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day - 1);
        return c.getTime();
    }

    public static Date getDayAfter(Date date, int n) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day + n);
        return c.getTime();
    }

    public static Date getDayAround(Date date, int count) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int day = c.get(5);
        c.set(5, day + count);
        return c.getTime();
    }

    public static Date getOnlyDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date zero = calendar.getTime();
        return zero;
    }

    public static String convertToOADate(Date date) {
        double oaDate = DateUtil.getExcelDate((Date)date);
        return "/OADate(" + oaDate + ")/";
    }

    public static boolean isOADate(String oaDateStr) {
        return oaDateStr.contains("OADate");
    }

    public static Date parseOADate(String oadate) throws ParseException {
        int startIndex = oadate.indexOf(40);
        int endIndex = oadate.indexOf(41);
        String timeStr = oadate.substring(startIndex + 1, endIndex);
        double d = Double.parseDouble(timeStr);
        return DateUtil.getJavaDate((double)d);
    }

    public static String formatDateToUTC(String value) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = null;
        try {
            date = DateTimeUtils.parseStrDate(value);
            return dateFormat.format(date);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return value;
        }
    }

    public static String getOADateStr(String dateStr, String defaultValue) {
        try {
            Date date = DateTimeUtils.parseStrDate(dateStr);
            return DateTimeUtils.convertToOADate(date);
        }
        catch (ParseException ex) {
            try {
                Date date = DateTimeUtils.parseStrDate2(dateStr);
                return DateTimeUtils.convertToOADate(date);
            }
            catch (ParseException ex2) {
                try {
                    Date date = DateTimeUtils.parseStrDate3(dateStr);
                    return DateTimeUtils.convertToOADate(date);
                }
                catch (ParseException ex3) {
                    return defaultValue;
                }
            }
        }
    }
}

