/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.common.util;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Locale;
import kd.bos.dataentity.utils.StringUtils;

public class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String RETURN = "\r\n";

    public static final boolean isEmptyString(String str) {
        return str == null || str.length() == 0;
    }

    public static final boolean equals(String str, String str2) {
        if (null == str) {
            return null == str2;
        }
        return str.equals(str2);
    }

    public static final boolean equalsIgnoreCase(String str, String str2) {
        if (null == str) {
            return null == str2;
        }
        return str.equalsIgnoreCase(str2);
    }

    public static String replaceFirst(String source, String subStr, String replacement) {
        int sublen = subStr.length();
        int srclen = source.length();
        if (sublen == 0 || srclen < sublen) {
            return source;
        }
        int index = source.indexOf(subStr);
        if (index == -1) {
            return source;
        }
        return source.substring(0, index) + replacement + source.substring(index + sublen, srclen);
    }

    public static String replace(String source, String subStr, String replacement, boolean matchFull, boolean matchCase) {
        if (matchFull || StringUtil.isEmptyString(subStr)) {
            return replacement;
        }
        if (StringUtil.isEmptyString(source)) {
            return replacement;
        }
        String formulaForCompare = source;
        String valueForFind = subStr;
        if (!matchCase) {
            formulaForCompare = formulaForCompare.toLowerCase(Locale.ENGLISH);
            valueForFind = valueForFind.toLowerCase(Locale.ENGLISH);
        }
        int vLen = valueForFind.length();
        int index = formulaForCompare.lastIndexOf(valueForFind);
        if (index < 0) {
            return source;
        }
        StringBuilder sb = new StringBuilder(source);
        while (index != -1) {
            sb.replace(index, index + vLen, replacement);
            index = formulaForCompare.lastIndexOf(valueForFind, index - 1);
        }
        return sb.toString();
    }

    public static String replace(String source, String subStr, String replacement) {
        return StringUtil.replace(source, subStr, replacement, false, true);
    }

    public static boolean isWrapString(String str) {
        return !StringUtil.isEmptyString(str) && str.indexOf(10) != -1;
    }

    public static boolean indexOf(String filter, char source) {
        boolean b = false;
        if (filter != null && filter.indexOf(source) != -1) {
            b = true;
        }
        return b;
    }

    public static String removeAppropriateZero(String str) {
        if (str != null && str.length() > 0 && str.indexOf(46) != -1) {
            boolean hasPercent = false;
            String percent = "%";
            int percentIndex = str.lastIndexOf(percent);
            if (percentIndex == -1) {
                percent = "\u2030";
                percentIndex = str.lastIndexOf(percent);
            }
            if (percentIndex != -1) {
                hasPercent = true;
                str = str.substring(0, percentIndex);
            }
            int len = str.length() - 1;
            int zeroIndex = str.lastIndexOf(48);
            for (int count = 0; zeroIndex == len && count <= 12; ++count) {
                str = str.substring(0, zeroIndex);
                len = str.length() - 1;
                zeroIndex = str.lastIndexOf(48);
            }
            len = str.length() - 1;
            int dotIndex = str.lastIndexOf(46);
            if (dotIndex == len) {
                str = str.substring(0, dotIndex);
            }
            if (hasPercent) {
                str = str + percent;
            }
        }
        return str;
    }

    public static boolean isPercentStr(String str) {
        DecimalFormat format = new DecimalFormat();
        char percent = format.getDecimalFormatSymbols().getPercent();
        char perMill = format.getDecimalFormatSymbols().getPerMill();
        boolean b = false;
        if (str == null) {
            return b;
        }
        if (str.indexOf(String.valueOf(percent)) != -1) {
            b = true;
        } else if (str.indexOf(String.valueOf(perMill)) != -1) {
            b = true;
        }
        return b;
    }

    public static boolean isValidateStr(String source, boolean isDigit, boolean isLetter, String validChars, String invalidChars) {
        boolean b = true;
        if (!(isDigit || isLetter || validChars != null && validChars.length() != 0 || invalidChars != null)) {
            return b;
        }
        if (source != null && source.length() > 0) {
            int len = source.length();
            for (int i = 0; i < len; ++i) {
                char cha = source.charAt(i);
                if (StringUtil.indexOf(invalidChars, cha)) {
                    return false;
                }
                if (StringUtil.indexOf(validChars, cha)) {
                    b = true;
                    continue;
                }
                if (isDigit) {
                    if (Character.isDigit(cha)) {
                        b = true;
                        continue;
                    }
                    return false;
                }
                if (!isLetter) continue;
                if (Character.isLetter(cha)) {
                    b = true;
                    continue;
                }
                return false;
            }
        }
        return b;
    }

    public static boolean isValidateStr(String source, boolean isDigit, boolean isLetter, String validChars, String invalidChars, int validLength) {
        int length;
        if (source != null && source.length() > 0 && validLength != -1 && (length = source.length()) > validLength) {
            return false;
        }
        return StringUtil.isValidateStr(source, isDigit, isLetter, validChars, invalidChars);
    }

    public static final String makeTypeShortening(Class<?> type) {
        StringBuilder buffer = new StringBuilder();
        String name = StringUtil.getClassName(type, false);
        buffer.append(name.charAt(0));
        for (int i = 1; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch < 'A' || ch > 'Z') continue;
            buffer.append(ch);
        }
        return buffer.toString().toLowerCase(Locale.ENGLISH);
    }

    public static final String getClassName(Class<?> cls, boolean full) {
        String fullName = cls.getName();
        int index = fullName.lastIndexOf(46);
        if (index == -1) {
            return fullName;
        }
        return fullName.substring(index + 1);
    }

    public static final String getClassName(Object obj, boolean full) {
        return StringUtil.getClassName(obj.getClass(), full);
    }

    public static boolean getBooleanFromString(String s) {
        return s != null && (s.equalsIgnoreCase("true") || s.equals("1"));
    }

    public static int[] str2IntArray(String str, String split) {
        if (str != null && str.trim().length() > 0) {
            String[] ss = str.split(split);
            int[] vals = new int[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                vals[i] = Integer.parseInt(ss[i].trim());
            }
            return vals;
        }
        return new int[0];
    }

    public static float[] str2FloatArray(String str, String split) {
        if (str != null && str.trim().length() > 0) {
            String[] ss = str.split(split);
            float[] vals = new float[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                vals[i] = Float.parseFloat(ss[i].trim());
            }
            return vals;
        }
        return new float[0];
    }

    public static void cutLastChar(StringBuffer sb) {
        if (sb == null || sb.length() == 0) {
            return;
        }
        sb.setLength(sb.length() - 1);
    }

    public static String makeRepeatString(String unit, int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append(unit);
        }
        return sb.toString();
    }

    public static final String getDisplayName(String name, String alias) {
        if (alias == null || alias.length() == 0) {
            return name;
        }
        return alias + "(" + name + ")";
    }

    public static String array2String(int[] array, String delimiter) {
        if (array != null && array.length > 0) {
            StringBuilder sb = new StringBuilder();
            int size = array.length;
            for (int i = 0; i < size - 1; ++i) {
                sb.append(String.valueOf(array[i])).append(delimiter);
            }
            sb.append(String.valueOf(array[size - 1]));
            return sb.toString();
        }
        return null;
    }

    public static String[] splitString(String str, String sep) {
        return null;
    }

    public static String array2String(double[] array, String delimiter) {
        if (array != null && array.length > 0) {
            StringBuilder sb = new StringBuilder();
            int size = array.length;
            for (int i = 0; i < size - 1; ++i) {
                sb.append(String.valueOf(array[i])).append(delimiter);
            }
            sb.append(String.valueOf(array[size - 1]));
            return sb.toString();
        }
        return null;
    }

    public static String array2String(float[] array, String delimiter) {
        if (array != null && array.length > 0) {
            StringBuilder sb = new StringBuilder();
            int size = array.length;
            for (int i = 0; i < size - 1; ++i) {
                sb.append(String.valueOf(array[i])).append(delimiter);
            }
            sb.append(String.valueOf(array[size - 1]));
            return sb.toString();
        }
        return null;
    }

    public static boolean isEnglishString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public static byte[] getBytes(String s) throws UnsupportedEncodingException {
        return s.getBytes("UTF-8");
    }

    public static boolean checkNumber(String str) {
        int dotCount = 0;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            char c = str.charAt(i);
            if (i == 0 && c == '-') {
                return true;
            }
            if (!(c == '.' ? ++dotCount >= 2 : !Character.isDigit(c))) continue;
            return false;
        }
        return true;
    }
}

