/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.common.util;

import java.sql.Timestamp;
import java.util.Date;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.common.util.exception.IllegalConversionException;
import kd.fi.bcm.spread.common.util.exception.InvalidDataException;

public class TypeConversionUtils {
    public static Date objToDate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        try {
            if (obj instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)obj;
                return new Date(timestamp.getTime());
            }
            if (obj instanceof Date) {
                java.sql.Date date = (java.sql.Date)obj;
                return new Date(date.getTime());
            }
            return new Date(DateTimeUtils.parseDate(obj.toString()).getTime());
        }
        catch (RuntimeException ex) {
            InvalidDataException invalidDataException = new InvalidDataException("Illegal date value - Java Date Objects cannot be earlier than 1/1/70\uff1a" + ex.getMessage());
            invalidDataException.initCause(ex);
            throw invalidDataException;
        }
        catch (Exception ex) {
            IllegalConversionException illegalConversionException = new IllegalConversionException("Illegal conversion\uff1a" + ex.getMessage());
            illegalConversionException.initCause(ex);
            throw illegalConversionException;
        }
    }
}

