/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.common.variant;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.spread.common.variant.ExprErr;
import kd.fi.bcm.spread.common.variant.SyntaxErrorException;
import kd.fi.bcm.spread.common.variant.Util;
import kd.fi.bcm.spread.common.variant.VarBase;
import kd.fi.bcm.spread.common.variant.Variant;

class VarByte
extends VarBase {
    VarByte() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        byte leftval = (Byte)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.add((int)leftval, ((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.add((int)leftval, rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).add(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 10: {
                    result.setObject(((BigDecimal)right.getValue()).add(BigDecimal.valueOf(leftval)), 10);
                    break;
                }
                case 11: {
                    result.setObject(new BigDecimal((String)right.getValue()).add(BigDecimal.valueOf(leftval)), 10);
                    break;
                }
                case 12: {
                    Util.add((long)leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.add((long)leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.add((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u8fd0\u7b97\u3002", (String)"Variant_0", (String)"fi-bcm-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        byte leftval = (Byte)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.subtract((int)leftval, ((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.subtract((int)leftval, rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(BigInteger.valueOf(leftval).subtract((BigInteger)right.getValue()), 9);
                    break;
                }
                case 10: {
                    result.setObject(BigDecimal.valueOf(leftval).subtract((BigDecimal)right.getValue()), 10);
                    break;
                }
                case 11: {
                    result.setObject(BigDecimal.valueOf(leftval).subtract(new BigDecimal((String)right.getValue())), 10);
                    break;
                }
                case 12: {
                    Util.subtract((long)leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.subtract((long)leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.subtract((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u8fd0\u7b97\u3002", (String)"Variant_0", (String)"fi-bcm-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        byte leftval = (Byte)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.multiply((int)leftval, ((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.multiply((int)leftval, rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(BigInteger.valueOf(leftval).multiply((BigInteger)right.getValue()), 9);
                    break;
                }
                case 10: {
                    result.setObject(BigDecimal.valueOf(leftval).multiply((BigDecimal)right.getValue()), 10);
                    break;
                }
                case 11: {
                    result.setObject(BigDecimal.valueOf(leftval).multiply(new BigDecimal((String)right.getValue())), 10);
                    break;
                }
                case 12: {
                    Util.multiply((long)leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.multiply((long)leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.multiply((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u8fd0\u7b97\u3002", (String)"Variant_0", (String)"fi-bcm-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(128L, ResManager.loadKDString((String)"\u9519\u8bef\u8c03\u7528", (String)"Variant_1", (String)"fi-bcm-common", (Object[])new Object[0]));
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        byte leftval = (Byte)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.mod((int)leftval, ((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.mod((int)leftval, rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).mod(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 10: {
                    Util.mod((double)leftval, right.doubleValue(), result);
                    break;
                }
                case 11: {
                    Variant vright = new Variant();
                    if (right.isNumeric(vright)) {
                        this.mod(left, vright, result);
                        break;
                    }
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u8fd0\u7b97\u3002", (String)"Variant_0", (String)"fi-bcm-common", (Object[])new Object[0]));
                    break;
                }
                case 12: {
                    Util.mod((long)leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.mod((long)leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.mod((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u8fd0\u7b97\u3002", (String)"Variant_0", (String)"fi-bcm-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        byte leftval = (Byte)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.and((int)leftval, ((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.and((int)leftval, rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).and(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 10: {
                    result.setObject(((BigDecimal)right.getValue()).toBigInteger().and(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 11: {
                    result.setObject(new BigInteger((String)right.getValue()).and(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 12: {
                    Util.and((long)leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.and((long)leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.and((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u8fd0\u7b97\u3002", (String)"Variant_0", (String)"fi-bcm-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        byte leftval = (Byte)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.or((int)leftval, ((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.or((int)leftval, rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).or(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 10: {
                    result.setObject(((BigDecimal)right.getValue()).toBigInteger().or(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 11: {
                    result.setObject(new BigInteger((String)right.getValue()).or(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 12: {
                    Util.or((long)leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.or((long)leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.or((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u8fd0\u7b97\u3002", (String)"Variant_0", (String)"fi-bcm-common", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        byte leftval = (Byte)left.getValue();
        if (right.getVt() < 512) {
            switch (right.getVt()) {
                case 7: {
                    Util.xor((int)leftval, ((Character)right.getValue()).charValue(), result);
                    break;
                }
                case 8: {
                    int rightval = Util.booleanToInt((Boolean)right.getValue());
                    Util.xor((int)leftval, rightval, result);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)right.getValue()).xor(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 10: {
                    result.setObject(((BigDecimal)right.getValue()).toBigInteger().xor(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 11: {
                    result.setObject(new BigInteger((String)right.getValue()).xor(BigInteger.valueOf(leftval)), 9);
                    break;
                }
                case 12: {
                    Util.xor((long)leftval, ((Date)right.getValue()).getTime(), result);
                    break;
                }
                case 13: {
                    Util.xor((long)leftval, right.longValue(), result);
                    break;
                }
                case 15: {
                    left.xor((Variant)right.getValue(), result);
                    break;
                }
                default: {
                    ExprErr.goError(64L, ResManager.loadKDString((String)"\u8be5\u6570\u636e\u7c7b\u578b\u4e0d\u652f\u6301\u8fd0\u7b97\u3002", (String)"Variant_0", (String)"fi-bcm-common", (Object[])new Object[0]));
                }
            }
        }
    }
}

