/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.util.BCMStringUtil;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.spread.common.util.TypeConversionUtils;
import kd.fi.bcm.spread.common.variant.Variant;
import kd.fi.bcm.spread.domain.Domain;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.model.CellData;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.SpanInfo;
import kd.fi.bcm.spread.model.UserObject;

public class Cell
extends Domain {
    private static final long serialVersionUID = 1L;
    private CellData cellData;
    private String formula;
    private SpanInfo spanInfo;
    private UserObject userObject = new UserObject(0);
    private boolean isChangeVal = false;
    protected boolean isMdDataDomain = false;
    @JsonIgnore
    private transient int row = -1;
    @JsonIgnore
    private transient int col = -1;
    @JsonIgnore
    private transient DataTypeEnum cellDataType;
    @JsonIgnore
    private transient boolean isOnRowOrColSetting = true;
    @JsonIgnore
    private transient Object newValue;
    @JsonIgnore
    private transient int _cachedHashCode = -1;
    @JsonIgnore
    private transient Map<String, String> _cacheMemberFromUserObjectDimNumbers;

    public Cell() {
        this.cellData = new CellData();
    }

    public CellData getCellData() {
        return this.cellData;
    }

    public void setRowAndCol(int row, int col) {
        this.row = row;
        this.col = col;
    }

    @Deprecated
    public void setRow(int row) {
        this.row = row;
    }

    @Deprecated
    public void setCol(int col) {
        this.col = col;
    }

    public int hashCode() {
        if (this.row > Short.MAX_VALUE && this.col > Short.MAX_VALUE) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u5143\u683c\u7684\u884c\u3001\u5217\u7ec4\u5408\u6570\u91cf\u8d85\u8fc7\u4e86\u6700\u5927\u9650\u5236\u6570%s\u3002", (String)"Cell_0", (String)"fi-bcm-common", (Object[])new Object[0]), Integer.MAX_VALUE));
        }
        this._cachedHashCode = this.row << 16 ^ this.col;
        return this._cachedHashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof Cell && ((Cell)obj).row == this.row && ((Cell)obj).col == this.col;
    }

    public boolean setValue(Object val) {
        boolean oldValIsNull;
        Variant temp = this.convert2Variant(val);
        Variant oldCellData = this.cellData.getData();
        boolean bl = oldValIsNull = oldCellData == null || oldCellData.isNull() || oldCellData.isEmpty();
        if (oldValIsNull && val != null && StringUtils.isNotEmpty((String)val.toString()) || !oldValIsNull && val == null || !oldValIsNull && (this.cellData.getData().getVt() != temp.getVt() || !temp.equals(oldCellData))) {
            this.isChangeVal = true;
            this.cellData.setData(temp);
        }
        return this.isChangeVal;
    }

    public Map<String, String> getMemberFromUserObjectDimNumbers() {
        if (this._cacheMemberFromUserObjectDimNumbers == null) {
            this._cacheMemberFromUserObjectDimNumbers = new HashMap<String, String>();
            if (this.userObject.getMemberFromUserObject() != null) {
                for (IDimMember member : this.userObject.getMemberFromUserObject()) {
                    if (member.getDimension() == null) continue;
                    this._cacheMemberFromUserObjectDimNumbers.put(member.getDimension().getNumber(), member.getNumber());
                }
            }
        }
        return this._cacheMemberFromUserObjectDimNumbers;
    }

    private Variant convert2Variant(Object val) {
        if (val instanceof BigDecimal) {
            return new Variant((BigDecimal)val);
        }
        if (val instanceof Long) {
            return new Variant(new BigDecimal((Long)val));
        }
        if (val instanceof Number) {
            return new Variant(new BigDecimal(val.toString()));
        }
        if (val instanceof Variant && Variant.encryptVariant.equals(val)) {
            return (Variant)val;
        }
        return new Variant(val);
    }

    public Object getValue() {
        return this.cellData.getData().getValue();
    }

    public Variant getVariant() {
        return this.cellData.getData();
    }

    public boolean isChangeVal() {
        return this.isChangeVal;
    }

    public void setChangeVal(boolean isChange) {
        this.isChangeVal = isChange;
    }

    public void setCellData(CellData cellData) {
        this.cellData = cellData;
    }

    public Object getUserObject(String key) {
        return this.userObject.getUserObject(key);
    }

    public UserObject getUserObject() {
        return this.userObject;
    }

    public void setUserObject(String key, Object val) {
        this.userObject.setUserObject(key, val);
    }

    public void removeUserObject(String key) {
        this.userObject.remove(key);
    }

    public void clearAllUserObject() {
        this.userObject.clearAllUserObject();
    }

    public <T> T getUserObject(String key, T defaultValue) {
        Object v = this.getUserObject(key);
        return (T)(v == null ? defaultValue : v);
    }

    public void addDim2UserObject(IDimMember member) {
        this.userObject.addDim2UserObject(member);
    }

    public void addExt2UserObject(Object value) {
        this.userObject.addExt2UserObject(value);
    }

    public void addDims2UserObject(List<IDimMember> members) {
        for (IDimMember m : members) {
            this.addDim2UserObject(m);
        }
    }

    public void replaceDims2UserObject(List<IDimMember> members) {
        if (this.getMemberFromUserObject() == null) {
            return;
        }
        ArrayList<IDimMember> membs = new ArrayList<IDimMember>(4);
        Map<String, IDimMember> dim2Membs = members.stream().collect(Collectors.toMap(k -> k.getDimension().getNumber(), v -> v));
        for (int i = 0; i < this.getMemberFromUserObject().size(); ++i) {
            Dimension dimension = (Dimension)this.getMemberFromUserObject().get(i).getDimension();
            if (dim2Membs.containsKey(dimension.getNumber())) {
                membs.add(dim2Membs.get(dimension.getNumber()));
                continue;
            }
            membs.add(this.getMemberFromUserObject().get(i));
        }
        this.getMemberFromUserObject().clear();
        this.getMemberFromUserObject().addAll(membs);
    }

    public boolean isMembUserObjContainMember(List<IDimMember> members) {
        if (this.getMemberFromUserObject() == null) {
            return false;
        }
        for (IDimMember member : this.getMemberFromUserObject()) {
            Dimension dimension = (Dimension)member.getDimension();
            for (IDimMember dimMember : members) {
                if (!dimension.getNumber().equals(dimMember.getDimension().getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMembUserObjContainMember(IDimMember newMember) {
        if (this.getMemberFromUserObject() == null) {
            return false;
        }
        for (IDimMember member : this.getMemberFromUserObject()) {
            Dimension dimension = (Dimension)member.getDimension();
            if (!dimension.getNumber().equals(newMember.getDimension().getNumber())) continue;
            return true;
        }
        return false;
    }

    public void replaceDims2UserObject(IDimMember newMember) {
        if (this.getMemberFromUserObject() == null) {
            return;
        }
        ArrayList<IDimMember> membs = new ArrayList<IDimMember>(4);
        for (int i = 0; i < this.getMemberFromUserObject().size(); ++i) {
            Dimension dimension = (Dimension)this.getMemberFromUserObject().get(i).getDimension();
            if (newMember.getDimension().getNumber().equals(dimension.getNumber())) {
                membs.add(newMember);
                continue;
            }
            membs.add(this.getMemberFromUserObject().get(i));
        }
        this.getMemberFromUserObject().clear();
        this.getMemberFromUserObject().addAll(membs);
    }

    public DimMember getMemb4UserObject(String dimNum) {
        if (this.getMemberFromUserObject() == null) {
            return null;
        }
        for (int i = 0; i < this.getMemberFromUserObject().size(); ++i) {
            Dimension dimension = (Dimension)this.getMemberFromUserObject().get(i).getDimension();
            if (!dimNum.equals(dimension.getNumber())) continue;
            return (DimMember)this.getMemberFromUserObject().get(i);
        }
        return null;
    }

    public List<IDimMember> getMemberFromUserObject() {
        return this.userObject.getMemberFromUserObject();
    }

    public Object getCellFormatter() {
        return this.userObject.getUserObject("cellstyle");
    }

    public List<IDimMember> getNotNullMemberUserObject() {
        return this.userObject.getMemberFromUserObject() == null ? new ArrayList(16) : this.userObject.getMemberFromUserObject();
    }

    public List<IDimMember> getMemberFromUserObjectWithAssistDim() {
        ArrayList<IDimMember> allDim = new ArrayList<IDimMember>(4);
        List<IDimMember> defDim = this.getMemberFromUserObject();
        if (defDim != null) {
            allDim.addAll(defDim);
        }
        allDim.addAll(this.getAssistMembers());
        return allDim;
    }

    public void setAssistDim(List<IDimMember> dims) {
        this.userObject.setAssistDim(dims);
    }

    public void setHasReactMember(boolean hasRedirectMem) {
        this.userObject.setHasRedirectMem(hasRedirectMem);
    }

    public boolean hasReactMember() {
        return this.userObject.hasRedirectMem();
    }

    public List<IDimMember> getAssistMembers() {
        return this.userObject.getAssistDim();
    }

    public void copyDimMember2UserObject(Cell other) {
        this.userObject.copyDimMember2UserObject(other);
    }

    public SpanInfo getSpanInfo() {
        return this.spanInfo;
    }

    public void setSpanInfo(SpanInfo spanInfo) {
        this.spanInfo = spanInfo;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public boolean hasFormula() {
        return StringUtils.isNotEmpty((String)this.formula);
    }

    public boolean isMdDataDomain() {
        return this.isMdDataDomain;
    }

    public void setMdDataDomain(boolean isMdDataDomain) {
        this.isMdDataDomain = isMdDataDomain;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public String getExcelAxis() {
        return ExcelUtils.xy2Pos(this.col, this.row);
    }

    public String displayDimMsg() {
        return Cell.formatDimMsg(this.getMemberFromUserObject());
    }

    public static String formatDimMsg(List<IDimMember> members) {
        StringBuilder sb = new StringBuilder();
        if (members != null && !members.isEmpty()) {
            sb.append('[');
            for (IDimMember mem : members) {
                sb.append(mem.getDimension().getName()).append('!').append(mem.getName()).append('|').append(mem.getNumber()).append(';');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(']');
        }
        return sb.toString();
    }

    public String displayDimMsg(int pattern) {
        List<IDimMember> members = this.getMemberFromUserObject();
        StringBuilder sb = new StringBuilder();
        if (members != null && !members.isEmpty()) {
            if (members.size() == 1) {
                IDimMember member = members.get(0);
                switch (PositionInfo.FloatMemDisplayPattern.getPattern(pattern)) {
                    case NAME: {
                        sb.append(member.getName());
                        break;
                    }
                    case NAMEANDNUMBER: {
                        sb.append(member.getNumber()).append('|').append(member.getName());
                        break;
                    }
                    case NUMBER: {
                        sb.append(member.getNumber());
                        break;
                    }
                    case SIMPLENAME: {
                        sb.append(member.getSimpleName() == null || member.getSimpleName().isEmpty() ? member.getName() : member.getSimpleName());
                        break;
                    }
                    default: {
                        sb.append(member.getDimension().getName()).append('!').append(member.getName()).append('|').append(member.getNumber());
                        break;
                    }
                }
            } else {
                switch (PositionInfo.FloatMemDisplayPattern.getPattern(pattern)) {
                    case NAME: {
                        for (IDimMember mem : members) {
                            sb.append(mem.getName()).append(';');
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        break;
                    }
                    case NAMEANDNUMBER: {
                        for (IDimMember mem : members) {
                            sb.append(mem.getDimension().getName()).append('!').append(mem.getNumber()).append('|').append(mem.getName()).append(';');
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        break;
                    }
                    case NUMBER: {
                        for (IDimMember mem : members) {
                            sb.append(mem.getNumber()).append(';');
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        break;
                    }
                    case SIMPLENAME: {
                        for (IDimMember mem : members) {
                            sb.append(mem.getDimension().getName()).append('!').append(mem.getSimpleName() == null || mem.getSimpleName().isEmpty() ? mem.getName() : mem.getSimpleName()).append(';');
                        }
                        sb.deleteCharAt(sb.length() - 1);
                        break;
                    }
                    default: {
                        for (IDimMember mem : members) {
                            sb.append(mem.getDimension().getName()).append('!').append(mem.getName()).append('|').append(mem.getNumber()).append(';');
                        }
                        sb.deleteCharAt(sb.length() - 1);
                    }
                }
            }
            this.setUserObject("floatmember", Boolean.TRUE);
        }
        return sb.toString();
    }

    public void clearMembersOfUserObject() {
        if (this.userObject.containsKey("KEY_DIM_FLAG")) {
            this.getMemberFromUserObject().clear();
        }
        this._cacheMemberFromUserObjectDimNumbers = null;
    }

    public String[] toSaveFormat() {
        ArrayList<String> arrs = new ArrayList<String>();
        if (this.getMemberFromUserObject() != null) {
            for (IDimMember m : this.getMemberFromUserObject()) {
                arrs.add(m.getNumber());
            }
        }
        return arrs.toArray(new String[0]);
    }

    public String valueToString() {
        Variant val = this.cellData.getData();
        if (val == null) {
            return "";
        }
        if (val.isNumber()) {
            return val.toString();
        }
        if (val.isDate()) {
            return TypeConversionUtils.objToDate(val).toString();
        }
        return val.toString();
    }

    public String toJSon() {
        return this.cellData.toJSon();
    }

    @JsonIgnore
    public void overrideCellDataWithNewData() {
        this.setValue(this.newValue);
    }

    @JsonIgnore
    public Object getNewValue() {
        return this.newValue;
    }

    @JsonIgnore
    public void setNewValue(Object newValue) {
        this.newValue = newValue;
    }

    @JsonIgnore
    public DataTypeEnum getCellDataType() {
        return this.cellDataType;
    }

    @JsonIgnore
    public void setCellDataType(DataTypeEnum cellDataType) {
        this.cellDataType = cellDataType;
    }

    @JsonIgnore
    public boolean isOnRowOrColSetting() {
        return this.isOnRowOrColSetting;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("value", (Object)this.cellData.getData()).add("formula", (Object)this.formula).add("isChangeVal", this.isChangeVal).add("isMDData", this.isMdDataDomain).add("userObject", (Object)this.userObject).toString();
    }

    public boolean isNullValue() {
        return this.getValue() == null || BCMStringUtil.trim(this.getValue().toString()).isEmpty();
    }

    public boolean isFloatMember() {
        Object userObject = this.getUserObject("floatmember");
        return userObject != null ? (Boolean)userObject : false;
    }

    public String getEXTColNumber() {
        Object userObject = this.getUserObject("ext_col");
        return userObject != null ? userObject.toString() : "";
    }

    public Long getEXTROWPKID() {
        Object userObject = this.getUserObject("extrowpkid");
        if (userObject != null) {
            if (userObject instanceof Long) {
                return (Long)userObject;
            }
            return 0L;
        }
        return 0L;
    }

    public String getEXTUserObject() {
        Object userObject = this.getUserObject("ext_col");
        return userObject != null ? userObject.toString() : "";
    }

    public String[] getMemberKey(List<IDimension> rowColDims) {
        HashMap mem2dim = new HashMap(16);
        if (this.getMemberFromUserObject() != null) {
            this.getMemberFromUserObject().forEach(member -> mem2dim.put(member.getDimension().getNumber(), member.getNumber()));
            ArrayList newMems = new ArrayList(rowColDims.size());
            for (IDimension dim : rowColDims) {
                newMems.add(mem2dim.get(dim.getNumber()));
            }
            return newMems.toArray(new String[newMems.size()]);
        }
        return null;
    }

    public Integer getCellId() {
        return this.getUserObject("cid", -1);
    }

    public void setCellId(Integer cellId) {
        this.userObject.put("cid", cellId);
    }

    public boolean isLock() {
        return this.getUserObject("locked", false);
    }

    public void setLock(boolean isLock) {
        if (isLock) {
            this.userObject.put("locked", isLock);
        } else {
            this.userObject.remove("locked");
        }
    }
}

