/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.fi.bcm.spread.domain.view.Sheet;

public class Book
implements Iterable<Sheet>,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Sheet> book = new ArrayList<Sheet>();

    public Book() {
    }

    public Book(String ... sheetName) {
        this.buildBlankSheets(sheetName);
    }

    private void buildBlankSheets(String ... sheetName) {
        for (String name : sheetName) {
            this.addSheet(name);
        }
    }

    private void addSheet(String sheetName) {
        this.book.add(new Sheet(sheetName));
    }

    public Sheet getSheet(int idx) {
        if (idx > this.book.size()) {
            return null;
        }
        return this.book.get(idx);
    }

    public void addSheet(Sheet sheet) {
        this.book.add(sheet);
    }

    public Sheet getSheet(String sheetName) {
        for (Sheet sheet : this.book) {
            if (!sheetName.equals(sheet.getSheetName())) continue;
            return sheet;
        }
        return null;
    }

    public int getSheetCount() {
        return this.book.size();
    }

    public void removeSheet(int idx) {
        this.book.remove(idx);
    }

    public String toJSon() {
        StringBuilder json = new StringBuilder();
        json.append("{\"version\":\"10.0.1\",");
        json.append("\"sheetCount\":").append(this.book.size()).append(',');
        json.append("\"sheets\":{");
        for (Sheet sheet : this.book) {
            json.append(sheet.toJSon());
            json.append(',');
        }
        json.deleteCharAt(json.length() - 1);
        json.append("}}");
        return json.toString();
    }

    @Override
    public Iterator<Sheet> iterator() {
        return this.book.iterator();
    }
}

