/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.common.enums.dimension.SystemVarsEnum;
import kd.fi.bcm.spread.domain.FilterDimDomain;
import kd.fi.bcm.spread.domain.PageDimDomain;
import kd.fi.bcm.spread.domain.ViewPointDimDomain;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.IDimension;

public class FilterView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ViewPointDimDomain viewPointDomain;
    private PageDimDomain pageDomain;
    private FilterDimDomain filterDomain;
    private boolean isHasReactFixMember = false;

    public FilterView(ViewPointDimDomain viewPointDomain, PageDimDomain pageDomain) {
        this.viewPointDomain = viewPointDomain;
        this.pageDomain = pageDomain;
        this.filterDomain = new FilterDimDomain();
    }

    public FilterView(ViewPointDimDomain viewPointDomain, PageDimDomain pageDomain, FilterDimDomain filterDomain) {
        this.viewPointDomain = viewPointDomain;
        this.pageDomain = pageDomain;
        this.filterDomain = filterDomain;
    }

    public boolean changePageDim(IDimension newVal) {
        IDimension old = this.pageDomain.getDimension(newVal);
        if (old != null && old.equals(newVal) && old.getMembers().equals(newVal.getMembers())) {
            return false;
        }
        this.pageDomain.replaceDimension(old, newVal);
        return true;
    }

    public boolean changeFilterDim(IDimension newVal, SpreadManager sm) {
        IDimension old;
        if (sm != null && newVal.getMembers() != null && !newVal.getMembers().isEmpty()) {
            for (PositionInfo posInfo : sm.getAreaManager().getPostionInfoSet()) {
                for (BasePointInfo baseInfo : posInfo.getBasePoints()) {
                    for (BasePointInnerLineInfo lineInfo : baseInfo.getBasePointInnerLineInfo()) {
                        if (!lineInfo.isFloated()) continue;
                        for (DynaMembScopeInfo scope : lineInfo.getDynaMembScopes()) {
                            if (!newVal.getNumber().equals(lineInfo.getDimension().getNumber())) continue;
                            if (scope.getMember().getNumber().equals(SystemVarsEnum.CURRENT.getNumber()) && String.valueOf(scope.getMember().getId()).equals(SystemVarsEnum.CURRENT.getId())) {
                                if (newVal.getMembers().get(0).getId() == -1L) continue;
                                ((DimMember)scope.getMember()).setTemp_id(scope.getMember().getId());
                                ((DimMember)scope.getMember()).setTemp_number(scope.getMember().getNumber());
                                scope.getMember().setId(newVal.getMembers().get(0).getId());
                                scope.getMember().setNumber(newVal.getMembers().get(0).getNumber());
                                ((DimMember)scope.getMember()).setPar_SonNum(newVal.getMembers().get(0).getPar_SonNum());
                                continue;
                            }
                            DimMember member = (DimMember)scope.getMember();
                            if (member.getTemp_number() == null || !member.getTemp_number().equals(SystemVarsEnum.CURRENT.getNumber()) || !String.valueOf(member.getTemp_id()).equals(SystemVarsEnum.CURRENT.getId())) continue;
                            scope.getMember().setId(newVal.getMembers().get(0).getId());
                            scope.getMember().setNumber(newVal.getMembers().get(0).getNumber());
                            member.setPar_SonNum(newVal.getMembers().get(0).getPar_SonNum());
                        }
                    }
                }
            }
        }
        if ((old = this.filterDomain.getDimension(newVal)) != null && old.equals(newVal) && old.getMembers().equals(newVal.getMembers())) {
            return false;
        }
        this.filterDomain.removeDimension(old);
        this.filterDomain.addDimension(newVal);
        return true;
    }

    public boolean isDimInCommonFilter(String dimNum) {
        boolean isCommonFilterInPV = false;
        PageDimDomain pageDomain = this.getPageDomain();
        ViewPointDimDomain viewPointDomain = this.getViewPointDomain();
        if (pageDomain != null) {
            for (IDimension dimension : pageDomain.getDimensions()) {
                if (!dimNum.equals(dimension.getNumber())) continue;
                isCommonFilterInPV = true;
                break;
            }
        }
        if (!isCommonFilterInPV && viewPointDomain != null) {
            for (IDimension dimension : viewPointDomain.getDimensions()) {
                if (!dimNum.equals(dimension.getNumber())) continue;
                isCommonFilterInPV = true;
                break;
            }
        }
        return isCommonFilterInPV;
    }

    public String getDimMember(String dimNum) {
        PageDimDomain pageDomain = this.getPageDomain();
        ViewPointDimDomain viewPointDomain = this.getViewPointDomain();
        FilterDimDomain filterDimDomain = this.getFilterDomain();
        if (pageDomain != null) {
            for (IDimension dimension : pageDomain.getDimensions()) {
                if (!dimNum.equals(dimension.getNumber()) || dimension.getMembers().size() <= 0) continue;
                return dimension.getMembers().get(0).getNumber();
            }
        }
        if (viewPointDomain != null) {
            for (IDimension dimension : viewPointDomain.getDimensions()) {
                if (!dimNum.equals(dimension.getNumber()) || dimension.getMembers().size() <= 0) continue;
                return dimension.getMembers().get(0).getNumber();
            }
        }
        if (filterDimDomain != null) {
            for (IDimension dimension : filterDimDomain.getDimensions()) {
                if (!dimNum.equals(dimension.getNumber()) || dimension.getMembers().size() <= 0) continue;
                return dimension.getMembers().get(0).getNumber();
            }
        }
        return "";
    }

    public ViewPointDimDomain getViewPointDomain() {
        return this.viewPointDomain;
    }

    public boolean isInCommonFilter(String dimNum) {
        boolean isInFilter = false;
        for (IDimension dimension : this.getPageDomain().getDimensions()) {
            if (!dimension.getNumber().equals(dimNum)) continue;
            isInFilter = true;
        }
        for (IDimension dimension : this.getViewPointDomain().getDimensions()) {
            if (!dimension.getNumber().equals(dimNum)) continue;
            isInFilter = true;
        }
        return isInFilter;
    }

    public boolean isInFliterDomain(String dimNum) {
        boolean isInFilter = false;
        for (IDimension dimension : this.getFilterDomain().getDimensions()) {
            if (!dimension.getNumber().equals(dimNum)) continue;
            isInFilter = true;
        }
        return isInFilter;
    }

    public String getCommonFilterNum(String dimNum) {
        for (IDimension dimension : this.getPageDomain().getDimensions()) {
            if (!dimension.getNumber().equals(dimNum)) continue;
            return dimension.getMembers().get(0).getNumber();
        }
        for (IDimension dimension : this.getViewPointDomain().getDimensions()) {
            if (!dimension.getNumber().equals(dimNum)) continue;
            return dimension.getMembers().get(0).getNumber();
        }
        return "";
    }

    public long getCommonFilterId(String dimNum) {
        for (IDimension dimension : this.getPageDomain().getDimensions()) {
            if (!dimension.getNumber().equals(dimNum)) continue;
            return dimension.getMembers().get(0).getId();
        }
        for (IDimension dimension : this.getViewPointDomain().getDimensions()) {
            if (!dimension.getNumber().equals(dimNum)) continue;
            return dimension.getMembers().get(0).getId();
        }
        return 0L;
    }

    public List<String> getCommonFilterDimNums() {
        ArrayList<String> dims = new ArrayList<String>(16);
        for (IDimension dimension : this.getPageDomain().getDimensions()) {
            dims.add(dimension.getNumber());
        }
        for (IDimension dimension : this.getViewPointDomain().getDimensions()) {
            dims.add(dimension.getNumber());
        }
        return dims;
    }

    public List<String> getCommonFilterDimMembNums() {
        ArrayList<String> dimMembs = new ArrayList<String>(16);
        for (IDimension dimension : this.getPageDomain().getDimensions()) {
            dimMembs.add(dimension.getMembers().get(0).getNumber());
        }
        for (IDimension dimension : this.getViewPointDomain().getDimensions()) {
            dimMembs.add(dimension.getMembers().get(0).getNumber());
        }
        return dimMembs;
    }

    public Map<String, String> getCommonFilterDim2MembNums() {
        HashMap<String, String> dimMembs = new HashMap<String, String>(16);
        for (IDimension dimension : this.getPageDomain().getDimensions()) {
            dimMembs.put(dimension.getNumber(), dimension.getMembers().get(0).getNumber());
        }
        for (IDimension dimension : this.getViewPointDomain().getDimensions()) {
            dimMembs.put(dimension.getNumber(), dimension.getMembers().get(0).getNumber());
        }
        return dimMembs;
    }

    public Map<String, String> getPageFilterDim2MembNums() {
        HashMap<String, String> dimMembs = new HashMap<String, String>(16);
        for (IDimension dimension : this.getPageDomain().getDimensions()) {
            dimMembs.put(dimension.getNumber(), dimension.getMembers().get(0).getNumber());
        }
        return dimMembs;
    }

    public Map<String, String> getViewFilterDim2MembNums() {
        HashMap<String, String> dimMembs = new HashMap<String, String>(16);
        for (IDimension dimension : this.getViewPointDomain().getDimensions()) {
            dimMembs.put(dimension.getNumber(), dimension.getMembers().get(0).getNumber());
        }
        return dimMembs;
    }

    public FilterDimDomain getFilterDomain() {
        return this.filterDomain;
    }

    public void setFilterDomain(FilterDimDomain filterDomain) {
        this.filterDomain = filterDomain;
    }

    public void setViewPointDomain(ViewPointDimDomain viewPointDomain) {
        this.viewPointDomain = viewPointDomain;
    }

    public PageDimDomain getPageDomain() {
        return this.pageDomain;
    }

    public void setPageDomain(PageDimDomain pageDomain) {
        this.pageDomain = pageDomain;
    }

    public boolean isHasReactFixMember() {
        return this.isHasReactFixMember;
    }

    public void setHasReactFixMember(boolean hasReactFixMember) {
        this.isHasReactFixMember = hasReactFixMember;
    }
}

