/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view;

import java.util.List;
import java.util.function.Consumer;
import kd.fi.bcm.spread.model.HeadObject;

public interface IHeader {
    public List<HeadObject> getObjects();

    default public HeadObject get(int index, boolean isCreated) {
        HeadObject obj;
        if (this.getObjects().size() < index + 1) {
            if (isCreated) {
                int addnum = index - this.getObjects().size();
                for (int i = 0; i <= addnum; ++i) {
                    this.getObjects().add(null);
                }
            } else {
                return null;
            }
        }
        if ((obj = this.getObjects().get(index)) == null) {
            if (isCreated) {
                obj = new HeadObject();
                this.getObjects().set(index, obj);
            } else {
                return null;
            }
        }
        obj.setIndex(index);
        return obj;
    }

    default public void iteratorObjects(Consumer<HeadObject> consumer) {
        int index = 0;
        for (HeadObject head : this.getObjects()) {
            if (head != null) {
                head.setIndex(index);
                consumer.accept(head);
            }
            ++index;
        }
    }

    default public void iteratorObjects(int start, int end, Consumer<HeadObject> consumer) {
        List<HeadObject> objects = this.getObjects();
        int allSize = objects.size();
        if (allSize >= start && allSize >= end) {
            int endIndex = end >= allSize ? allSize : end + 1;
            for (int i = start; i < endIndex; ++i) {
                HeadObject headObject = objects.get(i);
                if (headObject == null) continue;
                headObject.setIndex(i);
                consumer.accept(headObject);
            }
        }
    }

    default public void insertHead(int i) {
        this.get(i, true);
        this.getObjects().add(i, null);
    }

    default public HeadObject remove(int i) {
        return this.getObjects().remove(i);
    }
}

