/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.SpreadAreaUtil;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.Tuple;

public class MultiAreaPositionsManager
implements Serializable,
Iterable<Map.Entry<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>>> {
    private static final long serialVersionUID = 1L;
    private Map<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>> dic = new HashMap<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>>(1);
    private SpreadManager sm;
    private Map<PositionInfo, Set<Tuple<String[], Object>>> dynaDelVal = new HashMap<PositionInfo, Set<Tuple<String[], Object>>>();

    public MultiAreaPositionsManager() {
    }

    public MultiAreaPositionsManager(SpreadManager sm) {
        this.sm = sm;
    }

    public void setSm(SpreadManager sm) {
        this.sm = sm;
    }

    public void addArea(PositionInfo p, RowDimDomain r, ColumnDimDomain c) {
        this.dic.put(p, Tuple.newOne(r, c));
    }

    public boolean containsKey(PositionInfo p) {
        PositionInfo pos = this.searchStorePositionInfo(p);
        return this.dic.containsKey(pos);
    }

    public PositionInfo searchStorePositionInfo(PositionInfo p) {
        for (PositionInfo e : this.dic.keySet()) {
            if (e != p) continue;
            return e;
        }
        for (PositionInfo e : this.dic.keySet()) {
            if (!e.equals(p) && !e.equalsByOriginal(p)) continue;
            return e;
        }
        return null;
    }

    public PositionInfo searchStorePositionInfodev(PositionInfo p) {
        for (PositionInfo e : this.dic.keySet()) {
            if (!e.equals(p)) continue;
            return e;
        }
        return null;
    }

    public PositionInfo findPositionInfo(String startPosition, String areaRange) {
        for (PositionInfo e : this.dic.keySet()) {
            if (!areaRange.equals(e.getAreaRange()) || !startPosition.equals(e.getStartPosition())) continue;
            return e;
        }
        return null;
    }

    public PositionInfo searchStorePositionInfoByOriginal(PositionInfo p) {
        for (PositionInfo e : this.dic.keySet()) {
            if (!e.equalsByOriginal(p)) continue;
            return e;
        }
        return null;
    }

    public PositionInfo searchStorePositionInfo(String area) {
        for (PositionInfo e : this.dic.keySet()) {
            if (!e.getAreaRange().equals(area)) continue;
            return e;
        }
        return null;
    }

    public Set<PositionInfo> getPostionInfoSet() {
        return this.dic.keySet();
    }

    public int getPositionSize() {
        return this.dic.size();
    }

    public Tuple<RowDimDomain, ColumnDimDomain> getRowAndColDomainByPosition(PositionInfo p) {
        PositionInfo pos = this.searchStorePositionInfo(p);
        return this.dic.get(pos);
    }

    public Tuple<RowDimDomain, ColumnDimDomain> removeArea(PositionInfo p) {
        PositionInfo pos = this.findPositionInfo(p.getStartPosition(), p.getAreaRange());
        return this.dic.remove(pos);
    }

    @Override
    public Iterator<Map.Entry<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>>> iterator() {
        return this.dic.entrySet().iterator();
    }

    public Iterator<Tuple<RowDimDomain, ColumnDimDomain>> iteratorValues() {
        return this.dic.values().iterator();
    }

    public RowDimDomain getFirstAreaRowDimDomain() {
        for (Map.Entry<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>> e : this) {
            if (((RowDimDomain)e.getValue().k).getAllMembers().size() <= 0) continue;
            return (RowDimDomain)e.getValue().k;
        }
        return null;
    }

    public ColumnDimDomain getFirstAreaColDimDomain() {
        for (Map.Entry<PositionInfo, Tuple<RowDimDomain, ColumnDimDomain>> e : this) {
            if (((ColumnDimDomain)e.getValue().v).getAllMembers().size() <= 0) continue;
            return (ColumnDimDomain)e.getValue().v;
        }
        return null;
    }

    public void reSetRowColDimDomain() {
        this.dic.entrySet().forEach(e -> e.setValue(Tuple.newOne(new RowDimDomain(), new ColumnDimDomain())));
    }

    public RowDimDomain getRowDimDoman(PositionInfo p) {
        Tuple<RowDimDomain, ColumnDimDomain> t = this.getRowAndColDomainByPosition(p);
        if (t != null) {
            return (RowDimDomain)t.k;
        }
        return null;
    }

    public ColumnDimDomain getColDimDomain(PositionInfo p) {
        Tuple<RowDimDomain, ColumnDimDomain> t = this.getRowAndColDomainByPosition(p);
        if (t != null) {
            return (ColumnDimDomain)t.v;
        }
        return null;
    }

    public Map<PositionInfo, Set<Tuple<String[], Object>>> getDynaDelVal() {
        return this.dynaDelVal;
    }

    public void putDynaDelVal(PositionInfo pos, String[] dimMembCross, Object val, boolean isUpdate) {
        ArrayList<IDimension> rowColDims = new ArrayList<IDimension>(16);
        ArrayList<IDimension> rowDims = new ArrayList<IDimension>(16);
        ArrayList<IDimension> colDims = new ArrayList<IDimension>(16);
        if (this.sm.getAreaManager() != null) {
            ColumnDimDomain colDimDomain;
            RowDimDomain rowDimDomain = this.sm.getAreaManager().getRowDimDoman(pos);
            if (rowDimDomain != null) {
                rowColDims.addAll(rowDimDomain.getDimensions());
                rowDims.addAll(rowDimDomain.getDimensions());
            }
            if ((colDimDomain = this.sm.getAreaManager().getColDimDomain(pos)) != null) {
                rowColDims.addAll(colDimDomain.getDimensions());
                colDims.addAll(colDimDomain.getDimensions());
            }
        }
        if (isUpdate) {
            try {
                Recorder<Integer> commonSum = this.hasRepeatFloatMembsCross(pos, rowDims, colDims, dimMembCross);
                if (commonSum.getRecord() < 1) {
                    if (!this.dynaDelVal.containsKey(pos)) {
                        this.dynaDelVal.put(pos, new HashSet());
                    }
                    this.dynaDelVal.get(pos).add(Tuple.newOne(dimMembCross, val));
                }
            }
            catch (Exception exception) {}
        } else {
            if (!this.dynaDelVal.containsKey(pos)) {
                this.dynaDelVal.put(pos, new HashSet());
            }
            this.dynaDelVal.get(pos).add(Tuple.newOne(dimMembCross, val));
        }
    }

    private Recorder<Integer> hasRepeatFloatMembsCross(PositionInfo pos, List<IDimension> rowDims, List<IDimension> colDims, String[] dimMembCross) {
        Object[] dimMembRowCross = Arrays.copyOfRange(dimMembCross, 0, rowDims.size());
        Object[] dimMembColCross = Arrays.copyOfRange(dimMembCross, rowDims.size(), rowDims.size() + colDims.size());
        Sheet sheet = this.sm.getBook().getSheet(0);
        Recorder<Integer> commonSum = new Recorder<Integer>(0);
        for (BasePointInfo basePoint : pos.getBasePoints()) {
            List<IDimMember> members;
            Object[] memsKey;
            RangeModel rangeModel = SpreadAreaUtil.getRangModel(basePoint.getDynaRange());
            if (basePoint.isDirectHoriz()) {
                for (int c = rangeModel.getX_start(); c <= rangeModel.getX_end(); ++c) {
                    if (commonSum.getRecord() >= 2) continue;
                    memsKey = new String[colDims.size()];
                    for (int r = rangeModel.getY_start(); r <= rangeModel.getY_end(); ++r) {
                        members = sheet.getCell(r, c).getMemberFromUserObject();
                        if (members == null) continue;
                        members.forEach(arg_0 -> MultiAreaPositionsManager.lambda$hasRepeatFloatMembsCross$1((String[])memsKey, colDims, arg_0));
                    }
                    if (!Lists.newArrayList((Object[])memsKey).toString().equals(Lists.newArrayList((Object[])dimMembColCross).toString())) continue;
                    commonSum.setRecord(commonSum.getRecord() + 1);
                }
                continue;
            }
            for (int r = rangeModel.getY_start(); r <= rangeModel.getY_end(); ++r) {
                if (commonSum.getRecord() >= 1) continue;
                memsKey = new String[rowDims.size()];
                for (int c = rangeModel.getX_start(); c <= rangeModel.getX_end(); ++c) {
                    members = sheet.getCell(r, c).getMemberFromUserObject();
                    if (members == null) continue;
                    members.forEach(arg_0 -> MultiAreaPositionsManager.lambda$hasRepeatFloatMembsCross$2((String[])memsKey, rowDims, arg_0));
                }
                if (!Lists.newArrayList((Object[])memsKey).toString().equals(Lists.newArrayList((Object[])dimMembRowCross).toString())) continue;
                commonSum.setRecord(commonSum.getRecord() + 1);
            }
        }
        return commonSum;
    }

    public Set<Tuple<String[], Object>> getDelDynaValsByPos(PositionInfo pos) {
        return this.dynaDelVal.get(pos);
    }

    public void clearDynaDelVals() {
        this.dynaDelVal.clear();
    }

    private Object readResolve() {
        if (this.dynaDelVal == null) {
            this.dynaDelVal = new HashMap<PositionInfo, Set<Tuple<String[], Object>>>();
        }
        return this;
    }

    private static /* synthetic */ void lambda$hasRepeatFloatMembsCross$2(String[] memsKey, List rowDims, IDimMember m) {
        memsKey[rowDims.indexOf((Object)m.getDimension())] = m.getNumber();
    }

    private static /* synthetic */ void lambda$hasRepeatFloatMembsCross$1(String[] memsKey, List colDims, IDimMember m) {
        memsKey[colDims.indexOf((Object)m.getDimension())] = m.getNumber();
    }
}

