/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.common.Recorder;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.spread.common.util.DateTimeUtils;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.Header;
import kd.fi.bcm.spread.domain.view.builder.PrintLogger;
import kd.fi.bcm.spread.model.HeadObject;
import kd.fi.bcm.spread.util.SpanMergeHandler;

public class Sheet
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAX_ROW = 2000;
    public static final int DEFAULT_MAX_COL = 52;
    private List<List<Cell>> table = new ArrayList<List<Cell>>();
    private String sheetName;
    private transient List<Integer> changedRows = new ArrayList<Integer>();
    private transient int maxCellSize = 0;
    private boolean unCheckSize;
    private Map<String, Object> userObject;
    private Header colHeader;
    private Header rowHeader;

    public Sheet() {
    }

    public Sheet(String sheetName) {
        this.sheetName = sheetName;
    }

    public boolean isUnCheckSize() {
        return this.unCheckSize;
    }

    @Deprecated
    public void setUnCheckSize(boolean unCheckSize) {
        this.unCheckSize = unCheckSize;
    }

    public void initMaxSize() {
        this.maxCellSize = (Integer)ThreadCache.get((Object)"Sheet.getMaxSize", () -> {
            try {
                Class<?> clazz = Class.forName("kd.fi.bcm.business.serviceHelper.ConfigServiceHelper");
                Method initRpt = clazz.getMethod("getStringParamNoModel", String.class);
                String size = (String)initRpt.invoke(null, "sheetCellMaxLimit");
                return Integer.parseInt(size);
            }
            catch (Exception e) {
                return 500000;
            }
        });
    }

    public void putUserObject(String key, Object val) {
        if (this.userObject == null) {
            this.userObject = new HashMap<String, Object>();
        }
        this.userObject.put(key, val);
    }

    public <T> T getUserObject(String key) {
        if (this.userObject == null) {
            return null;
        }
        return (T)this.userObject.get(key);
    }

    public void addRow() {
        this.table.add(this.extendSameColCountAtOneRow());
    }

    private List<Cell> extendSameColCountAtOneRow() {
        ArrayList<Cell> cols = new ArrayList<Cell>(this.getMaxColumnCount());
        if (this.getMaxColumnCount() > 0) {
            for (int i = 0; i < this.getMaxColumnCount(); ++i) {
                cols.add(this.createCell(false));
            }
        }
        return cols;
    }

    private Cell createCell(boolean isCreated) {
        return isCreated ? new Cell() : null;
    }

    public void addRows(int rowCount) {
        for (int i = 0; i < rowCount; ++i) {
            this.addRow();
        }
        this.checkSize();
    }

    public void addRange(int rowCount, int colCount) {
        this.addRows(rowCount);
        this.addColumns(colCount);
    }

    public Cell getCell(int row, int col) {
        return this.getCell(row, col, true);
    }

    public Cell getCell(int row, int col, boolean isCreated) {
        Cell cell = null;
        if (isCreated) {
            this.ensureCapacity(row, col);
            cell = this.table.get(row).get(col);
            if (cell == null) {
                if (isCreated) {
                    cell = this.createCell(true);
                    this.table.get(row).set(col, cell);
                    cell.setRowAndCol(row, col);
                }
            } else {
                cell.setRowAndCol(row, col);
            }
        } else if (row <= this.table.size() - 1) {
            List<Cell> cells = this.table.get(row);
            if (cells == null || cells.isEmpty()) {
                return cell;
            }
            if (col <= cells.size() - 1 && (cell = cells.get(col)) != null) {
                cell.setRowAndCol(row, col);
            }
        }
        return cell;
    }

    private void ensureCapacity(int row, int col) {
        int maxrow = this.getMaxRowCount();
        int maxcol = this.getMaxColumnCount();
        if (row > maxrow - 1) {
            this.autoGrowRows(row - maxrow + 1);
        }
        if (col > maxcol - 1) {
            this.autoGrowCols(col - maxcol + 1);
        }
    }

    public void checkSize() {
        int col;
        int row;
        if (this.isUnCheckSize()) {
            return;
        }
        if (this.maxCellSize == 0) {
            this.initMaxSize();
        }
        if (!this.table.isEmpty() && (row = this.table.size()) * (col = this.table.get(0).size()) > this.maxCellSize) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u5143\u683c\u6570\u91cf\u8d85\u8fc7\u4e0a\u9650\u503c\uff08%s\uff09\uff0c\u65e0\u6cd5\u52a0\u8f7d\uff0c\u8bf7\u786e\u8ba4\u573a\u666f\u662f\u5426\u5408\u7406\u3002", (String)"Sheet_1", (String)"fi-bcm-common", (Object[])new Object[0]), this.maxCellSize));
        }
    }

    private void autoGrowRows(int rowCount) {
        this.addRows(rowCount);
    }

    private void autoGrowCols(int colCount) {
        this.addColumns(colCount);
    }

    public void insertRow(int i) {
        if (!this.ensureMaxRow(i)) {
            return;
        }
        i = Math.min(i, this.table.size() - 1);
        this.doInsertRow(i);
    }

    public void insertRowToBottom(int i) {
        if (!this.ensureMaxRow(i)) {
            return;
        }
        i = Math.min(i, this.table.size() - 1);
        this.doInsertRow(i + 1);
    }

    private void doInsertRow(int i) {
        this.table.add(i, this.extendSameColCountAtOneRow());
        this.checkSize();
        if (this.getRowHeader().getObjects().size() > 0) {
            this.getRowHeader().insertHead(i);
        }
    }

    public void insertRangeRows(int fromColIdx, int toColIdx, int selcRowindex, int rowcount) {
        int r;
        for (r = 0; r < rowcount; ++r) {
            this.insertRow(r + selcRowindex);
        }
        this.ensureCapacity(selcRowindex, toColIdx + rowcount);
        for (r = rowcount - 1; r >= 0; --r) {
            this.moveRowUp(fromColIdx, toColIdx, selcRowindex + r, r);
        }
        PrintLogger.outputLogFile(this);
    }

    public void delRangeRows(int fromColIdx, int toColIdx, int selcRowindex, int rowcount) {
        this.moveRowUpInRangeField(fromColIdx, toColIdx, selcRowindex, rowcount);
    }

    private void moveRowUpInRangeField(int fromColIdx, int toColIdx, int selcRowindex, int rowcount) {
        int c;
        List<Cell> targ;
        int from;
        int maxRowCount = this.getMaxRowCount();
        for (from = selcRowindex + rowcount; from < maxRowCount; ++from) {
            List<Cell> source = this.table.get(from);
            targ = this.table.get(from - rowcount);
            for (c = fromColIdx; c <= toColIdx; ++c) {
                targ.set(c, source.get(c));
            }
        }
        for (from = maxRowCount - rowcount; from < maxRowCount; ++from) {
            targ = this.table.get(from);
            for (c = fromColIdx; c <= toColIdx; ++c) {
                targ.set(c, this.createCell(false));
            }
        }
    }

    public void delRangeCols(int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        this.moveColLeftInRangeField(fromRowIdx, toRowIdx, selcColindex, colCount);
    }

    private void moveColLeftInRangeField(int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        int maxColCount = this.getMaxColumnCount();
        for (int r = fromRowIdx; r <= toRowIdx; ++r) {
            List<Cell> targ = this.table.get(r);
            for (int c = selcColindex + colCount; c < maxColCount; ++c) {
                targ.set(c - colCount, targ.get(c));
            }
        }
        for (int from = maxColCount - colCount; from < maxColCount; ++from) {
            for (int r = fromRowIdx; r <= toRowIdx; ++r) {
                this.table.get(r).set(from, this.createCell(false));
            }
        }
    }

    public void insertRangeCols(int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        for (int c = 0; c < colCount; ++c) {
            this.insertColumn(c + selcColindex);
        }
        this.ensureCapacity(toRowIdx, selcColindex + colCount);
        this.moveColLeft(fromRowIdx, toRowIdx, selcColindex, colCount);
        PrintLogger.outputLogFile(this);
    }

    private void moveColLeft(int excludeFromRowIdx, int excludeToRowIdx, int selcColindex, int colCount) {
        List<Cell> currRow = null;
        int size = this.getMaxRowCount();
        for (int r = 0; r < size; ++r) {
            if (r >= excludeFromRowIdx && r <= excludeToRowIdx) continue;
            currRow = this.getRowInner(r);
            this.doMoveColLeft(currRow, selcColindex, colCount);
        }
    }

    private void doMoveColLeft(List<Cell> currRow, int selcColindex, int colCount) {
        Cell[] dataElements = currRow.toArray(new Cell[0]);
        int size = dataElements.length;
        System.arraycopy(dataElements, selcColindex + colCount, dataElements, selcColindex, this.getMaxColumnCount() - (selcColindex + colCount));
        for (int c = 0; c < colCount; ++c) {
            dataElements[--size] = this.createCell(false);
        }
        currRow.clear();
        currRow.addAll(Arrays.asList(dataElements));
    }

    public static void main(String[] args) {
        Sheet sheet = new Sheet("test");
        for (int r = 0; r < 10; ++r) {
            for (int c = 0; c < 8; ++c) {
                sheet.getCell(r, c).setValue(ExcelUtils.xy2Pos(c, r));
            }
        }
        PrintLogger.outputLogFile(sheet);
        sheet.insertRangeRows(1, 5, 1, 1);
        sheet.insertRangeCols(2, 5, 1, 1);
    }

    private void moveRowUp(int excludeFromColIdx, int excludeToColIdx, int startIndex, int offset) {
        List<Cell> nextRow = null;
        int columSize = this.getMaxColumnCount();
        int size = this.table.size();
        for (int idx = startIndex; idx < size && idx != size - 1 - offset; ++idx) {
            this.ensureCapacity(idx + 1, this.getMaxColumnCount() - 1);
            List<Cell> currRow = this.table.get(idx);
            nextRow = this.table.get(idx + 1);
            this.doReplace(currRow, nextRow, 0, excludeFromColIdx - 1);
            this.doReplace(currRow, nextRow, excludeToColIdx + 1, columSize - 1);
        }
        if (nextRow == null) {
            return;
        }
        size = nextRow.size();
        for (int i = 0; i < size; ++i) {
            if (i >= excludeFromColIdx && i <= excludeToColIdx) continue;
            nextRow.set(i, this.createCell(false));
        }
    }

    private void doReplace(List<Cell> targ, List<Cell> src, int start, int end) {
        if (start > end) {
            return;
        }
        for (int i = start; i <= end; ++i) {
            targ.set(i, src.get(i));
        }
    }

    private List<Cell> getRowInner(int i) {
        return this.table.get(i);
    }

    public void delRow(int i) {
        if (!this.ensureMaxRow(i)) {
            return;
        }
        this.table.remove(i);
        if (this.getRowHeader().getObjects().size() > i) {
            this.getRowHeader().remove(i);
        }
    }

    public void resetRow(int r) {
        if (!this.ensureMaxRow(r)) {
            return;
        }
        for (int c = 0; c < this.table.get(r).size(); ++c) {
            Cell newCell = new Cell();
            newCell.setRowAndCol(r, c);
            newCell.setChangeVal(true);
            this.table.get(r).set(c, newCell);
        }
    }

    public void delColumn(int i) {
        if (!this.ensureMaxCol(i)) {
            return;
        }
        for (List<Cell> column : this.table) {
            column.remove(i);
        }
        if (this.getColHeader().getObjects().size() > i) {
            this.getColHeader().remove(i);
        }
    }

    public void resetColumn(int c) {
        if (!this.ensureMaxCol(c)) {
            return;
        }
        for (int r = 0; r < this.table.size(); ++r) {
            List<Cell> row = this.table.get(r);
            if (row == null || row.isEmpty()) continue;
            Cell newCell = new Cell();
            newCell.setRowAndCol(r, c);
            newCell.setChangeVal(true);
            row.set(c, newCell);
        }
    }

    private boolean ensureMaxRow(int rowIndex) {
        return rowIndex < this.getMaxRowCount();
    }

    public boolean ensureMaxCol(int colIndex) {
        return colIndex < this.getMaxColumnCount();
    }

    @Deprecated
    public Iterator<Cell> iteratorCells() {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        int rowIdx = 0;
        int colIdx = 0;
        for (List<Cell> row : this.table) {
            colIdx = 0;
            for (Cell cell : row) {
                if (cell != null) {
                    cell.setRowAndCol(rowIdx, colIdx);
                    cells.add(cell);
                }
                ++colIdx;
            }
            ++rowIdx;
        }
        return cells.iterator();
    }

    public void iteratorCells(Consumer<Cell> consumer) {
        int rowIdx = 0;
        int colIdx = 0;
        for (List<Cell> row : this.table) {
            colIdx = 0;
            for (Cell cell : row) {
                if (cell != null) {
                    cell.setRowAndCol(rowIdx, colIdx);
                    consumer.accept(cell);
                }
                ++colIdx;
            }
            ++rowIdx;
        }
    }

    public void iteratorCellsByPredicateBreak(Predicate<Cell> predicate) {
        int rowIdx = 0;
        int colIdx = 0;
        block0: for (List<Cell> row : this.table) {
            colIdx = 0;
            for (Cell cell : row) {
                if (cell != null) {
                    cell.setRowAndCol(rowIdx, colIdx);
                    if (predicate.test(cell)) break block0;
                }
                ++colIdx;
            }
            ++rowIdx;
        }
    }

    public void iteratorRangeByPredicateBreak(int fromRow, int endRow, int fromCol, int endCol, Predicate<Cell> predicate) {
        endRow = Math.min(endRow, this.getMaxRowCount() - 1);
        endCol = Math.min(endCol, this.getMaxColumnCount() - 1);
        block0: for (int r = fromRow; r <= endRow; ++r) {
            for (int c = fromCol; c <= endCol; ++c) {
                Cell cell = this.table.get(r).get(c);
                if (cell == null) continue;
                cell.setRowAndCol(r, c);
                if (predicate.test(cell)) break block0;
            }
        }
    }

    public void iteratorRowRangeCells(int fromRow, int endRow, Consumer<Cell> consumer) {
        this.iteratorRowRangeCells(fromRow, endRow, false, consumer);
    }

    public void iteratorRowRangeCells(int fromRow, int endRow, boolean isCreateNew, Consumer<Cell> consumer) {
        endRow = Math.min(endRow, this.getMaxRowCount() - 1);
        int colIdx = 0;
        for (int r = fromRow; r <= endRow; ++r) {
            colIdx = 0;
            for (Cell cell : this.table.get(r)) {
                if (cell != null) {
                    cell.setRowAndCol(r, colIdx);
                    consumer.accept(cell);
                } else if (isCreateNew) {
                    cell = this.getCell(r, colIdx);
                    consumer.accept(cell);
                }
                ++colIdx;
            }
        }
    }

    public void iteratorColRangeCells(int fromCol, int endCol, Consumer<Cell> consumer) {
        this.iteratorColRangeCells(fromCol, endCol, false, consumer);
    }

    public void iteratorColRangeCells(int fromCol, int endCol, boolean isCreateNew, Consumer<Cell> consumer) {
        endCol = Math.min(endCol, this.getMaxColumnCount() - 1);
        int rowIdx = 0;
        for (List<Cell> row : this.table) {
            for (int c = fromCol; c <= endCol; ++c) {
                Cell cell = row.get(c);
                if (cell != null) {
                    cell.setRowAndCol(rowIdx, c);
                    consumer.accept(cell);
                    continue;
                }
                if (!isCreateNew) continue;
                cell = this.getCell(rowIdx, c);
                consumer.accept(cell);
            }
            ++rowIdx;
        }
    }

    public void iteratorRangeCells(int fromRow, int endRow, int fromCol, int endCol, Consumer<Cell> consumer) {
        this.iteratorRangeCells(fromRow, endRow, fromCol, endCol, false, false, consumer);
    }

    public void iteratorRangeCells(int fromRow, int endRow, int fromCol, int endCol, boolean isCreateNew, Consumer<Cell> consumer) {
        this.iteratorRangeCells(fromRow, endRow, fromCol, endCol, isCreateNew, false, consumer);
    }

    public void iteratorRangeCells(RangeModel rangeModel, Consumer<Cell> consumer) {
        this.iteratorRangeCells(rangeModel, false, consumer);
    }

    public void iteratorRangeCells(RangeModel rangeModel, boolean isCreatNew, Consumer<Cell> consumer) {
        if (rangeModel != null) {
            this.iteratorRangeCells(rangeModel.getY_start(), rangeModel.getY_end(), rangeModel.getX_start(), rangeModel.getX_end(), isCreatNew, consumer);
        } else {
            this.iteratorCells(consumer);
        }
    }

    public void iteratorRangeCells(int fromRow, int endRow, int fromCol, int endCol, boolean isCreateNew, boolean isReturnNull, Consumer<Cell> consumer) {
        if (!isCreateNew) {
            endRow = Math.min(endRow, this.getMaxRowCount() - 1);
            endCol = Math.min(endCol, this.getMaxColumnCount() - 1);
        }
        for (int r = fromRow; r <= endRow; ++r) {
            for (int c = fromCol; c <= endCol; ++c) {
                Cell cell;
                if (isCreateNew) {
                    cell = this.getCell(r, c);
                    consumer.accept(cell);
                    continue;
                }
                cell = this.table.get(r).get(c);
                if (cell != null) {
                    cell.setRowAndCol(r, c);
                    consumer.accept(cell);
                    continue;
                }
                if (!isReturnNull) continue;
                consumer.accept(cell);
            }
        }
    }

    public List<Cell> getRow(int rowIndex) {
        return this.getRow(rowIndex, false);
    }

    public List<Cell> getRow(int rowIndex, boolean isCreateNew) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        this.iteratorRowRangeCells(rowIndex, rowIndex, isCreateNew, cell -> cells.add((Cell)cell));
        return cells;
    }

    public List<Cell> getTableRow(int rowIndex) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        this.iteratorTableRowRangeCells(rowIndex, rowIndex, cell -> cells.add((Cell)cell));
        return cells;
    }

    public void iteratorTableRowRangeCells(int fromRow, int endRow, Consumer<Cell> consumer) {
        endRow = Math.min(endRow, this.getMaxRowCount() - 1);
        int colIdx = 0;
        for (int r = fromRow; r <= endRow; ++r) {
            colIdx = 0;
            for (Cell cell : this.table.get(r)) {
                if (cell != null) {
                    cell.setRowAndCol(r, colIdx);
                    consumer.accept(cell);
                } else {
                    consumer.accept(null);
                }
                ++colIdx;
            }
        }
    }

    public List<Cell> getCol(int colIndex) {
        return this.getCol(colIndex, false);
    }

    public List<Cell> getCol(int colIndex, boolean isCreateNew) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        this.iteratorColRangeCells(colIndex, colIndex, isCreateNew, cell -> cells.add((Cell)cell));
        return cells;
    }

    public void shrinkSheetModel(boolean isTemplate) {
        this.shrinkContent(isTemplate);
        this.shrinkRow();
        this.shrinkCol();
    }

    private void shrinkCol() {
        if (this.table.isEmpty()) {
            return;
        }
        int maxColCount = this.getMaxColumnCount();
        int delFromIndex = -1;
        Recorder<Integer> r = new Recorder<Integer>(-1);
        boolean canRemoveCol = false;
        int c = maxColCount - 1;
        while (c >= 1) {
            r.setRecord(c);
            canRemoveCol = this.table.parallelStream().allMatch(row -> row.get((Integer)r.getRecord()) == null);
            if (!canRemoveCol) break;
            delFromIndex = c--;
        }
        if (delFromIndex != -1) {
            for (List<Cell> row2 : this.table) {
                for (int c2 = row2.size() - 1; c2 >= delFromIndex; --c2) {
                    row2.remove(c2);
                }
            }
        }
    }

    private void shrinkRow() {
        boolean isAllNull;
        for (int i = this.table.size() - 1; i >= 1 && (isAllNull = this.table.get(i).stream().allMatch(cell -> cell == null)); --i) {
            this.table.remove(i);
        }
    }

    public void shrinkContent(boolean isTemplate) {
        int colIdx = 0;
        for (List<Cell> row : this.table) {
            colIdx = 0;
            for (Cell cell : row) {
                if (cell != null) {
                    if (cell.getMemberFromUserObject() != null && !cell.getMemberFromUserObject().isEmpty()) {
                        cell.getMemberFromUserObject().forEach(e -> {
                            if (e.getDimension() != null) {
                                e.getDimension().setName(null);
                            }
                            e.setName(null);
                        });
                        if (isTemplate && cell.isMdDataDomain()) {
                            cell.setValue(null);
                            cell.setChangeVal(false);
                        }
                    } else if (cell.getValue() != null || cell.getUserObject() != null && !cell.getUserObject().isEmpty()) {
                        if (!cell.getUserObject().isEmpty() && !cell.isLock()) {
                            cell.removeUserObject("locked");
                        }
                    } else if (!cell.hasFormula()) {
                        row.set(colIdx, null);
                    }
                }
                ++colIdx;
            }
        }
    }

    public void insertColumn(int i) {
        if (!this.ensureMaxCol(i)) {
            return;
        }
        this.doInsertColumn(i);
    }

    public void insertColumnToRight(int i) {
        if (!this.ensureMaxCol(i)) {
            return;
        }
        this.doInsertColumn(i + 1);
    }

    private void doInsertColumn(int i) {
        for (List<Cell> column : this.table) {
            column.add(i, this.createCell(false));
        }
        this.checkSize();
        if (this.getColHeader().getObjects().size() > 0) {
            this.getColHeader().insertHead(i);
        }
    }

    public void addColumn() {
        for (List<Cell> column : this.table) {
            column.add(this.createCell(false));
        }
    }

    public void addColumns(int colCount) {
        for (List<Cell> row : this.table) {
            for (int i = 0; i < colCount; ++i) {
                row.add(this.createCell(false));
            }
        }
        this.checkSize();
    }

    public void clear() {
        this.table.clear();
        this.getRowHeader().clear();
        this.getColHeader().clear();
    }

    public int getMaxRowCount() {
        return this.table.size() > 0 ? this.table.size() : 0;
    }

    public int getCountOnRow(int row) {
        return this.table.get(row).size();
    }

    public int getMaxColumnCount() {
        return this.table.size() > 0 ? this.table.get(0).size() : 0;
    }

    public int getMaxRowHeaderSize() {
        return this.rowHeader != null ? this.rowHeader.getObjects().size() : 0;
    }

    public int getMaxColHeaderSize() {
        return this.colHeader != null ? this.colHeader.getObjects().size() : 0;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public String toJSon() {
        StringBuilder json = new StringBuilder();
        json.append('\"').append(this.sheetName).append("\":{");
        json.append("\"name\":\"").append(this.sheetName).append("\",");
        json.append("\"rowCount\":\"").append(this.getMaxOrDefault(this.getMaxRowCount(), true)).append("\",");
        json.append("\"columnCount\":\"").append(this.getMaxOrDefault(this.getMaxColumnCount(), false)).append("\",");
        json.append(this.toTableJSon());
        json.append('}');
        return json.toString();
    }

    private int getMaxOrDefault(int max, boolean isRow) {
        return Math.max(max, isRow ? 2000 : 52);
    }

    public String toJson_dataDomain() {
        StringBuilder json = new StringBuilder();
        json.append("{\"data\":[");
        int maxRows = this.getMaxRowCount();
        int maxCols = this.getMaxColumnCount();
        boolean hasMoreOne = false;
        for (int r = 0; r < maxRows; ++r) {
            for (int c = 0; c < maxCols; ++c) {
                Cell cell = this.getCell(r, c);
                if (!cell.isMdDataDomain() || !cell.isChangeVal()) continue;
                if (hasMoreOne) {
                    json.append(',');
                }
                json.append("{\"r\":").append(r).append(',');
                json.append("\"c\":").append(c).append(',');
                json.append("\"v\":").append(cell.valueToString());
                json.append('}');
                cell.setChangeVal(false);
                hasMoreOne = true;
            }
        }
        json.append("]}");
        return json.toString();
    }

    public List<Map<String, Object>> createClientValuesConfig() {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        this.iteratorCells(cell -> {
            if (cell.isChangeVal() || cell.getUserObject("p") != null) {
                HashMap<String, Object> e = new HashMap<String, Object>(3);
                e.put("r", cell.getRow());
                e.put("c", cell.getCol());
                e.put("v", cell.getValue());
                cellValues.add(e);
                if (cell.getUserObject("csv") != null) {
                    cell.removeUserObject("csv");
                } else {
                    cell.setChangeVal(false);
                }
            }
        });
        return cellValues;
    }

    public List<Map<String, Object>> getCellValuesForWp() {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        this.iteratorCells(cell -> {
            Object value = cell.getValue();
            if (value != null || cell.isChangeVal()) {
                HashMap<String, Object> e = new HashMap<String, Object>(3);
                e.put("r", cell.getRow());
                e.put("c", cell.getCol());
                e.put("v", value);
                cellValues.add(e);
            }
        });
        return cellValues;
    }

    public List<Map<String, Object>> createClientValues_All(boolean isTransDate) {
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        this.iteratorCells(cell -> {
            HashMap<String, Object> e = new HashMap<String, Object>(3);
            e.put("r", cell.getRow());
            e.put("c", cell.getCol());
            if (!isTransDate && cell.getValue() instanceof String && ((String)cell.getValue()).contains("OADate")) {
                try {
                    e.put("v", DateTimeUtils.parseOADate((String)cell.getValue()));
                }
                catch (ParseException parseException) {
                    e.put("v", cell.getValue());
                }
            } else {
                e.put("v", cell.getValue());
            }
            cellValues.add(e);
        });
        return cellValues;
    }

    public boolean hasModified(boolean isOnlyMd) {
        for (List<Cell> row : this.table) {
            for (Cell cell : row) {
                if (cell == null || !cell.isChangeVal()) continue;
                if (cell.isMdDataDomain()) {
                    return true;
                }
                if (isOnlyMd) continue;
                return true;
            }
        }
        return false;
    }

    public List<List<Cell>> getTable() {
        return this.table;
    }

    public Map<String, Object> getUserObject() {
        if (this.userObject == null) {
            this.userObject = new HashMap<String, Object>();
        }
        return this.userObject;
    }

    public String toTableJSon() {
        StringBuilder json = new StringBuilder();
        SpanMergeHandler spanHandler = new SpanMergeHandler();
        json.append("\"data\": {").append("\"dataTable\": {");
        int r = -1;
        for (List<Cell> row : this.table) {
            json.append('\"').append(++r).append("\":{");
            int c = -1;
            int nullcount = 0;
            if (row == null) continue;
            for (Cell cell : row) {
                ++c;
                if (cell == null) {
                    ++nullcount;
                    continue;
                }
                json.append('\"').append(c).append("\":{");
                json.append(cell.toJSon());
                json.append("},");
                spanHandler.findAndMergeSpan(cell, r, c);
            }
            if (nullcount != row.size()) {
                json.deleteCharAt(json.length() - 1);
            }
            json.append("},");
        }
        if (!this.table.isEmpty()) {
            json.deleteCharAt(json.length() - 1);
        }
        json.append("}}");
        if (!spanHandler.isEmpty()) {
            json.insert(0, spanHandler.toJSon() + ",");
        }
        return json.toString();
    }

    public void setCellToNULL(int row, int col) {
        if (row < this.getMaxRowCount() && col < this.getMaxColumnCount()) {
            this.table.get(row).set(col, null);
        }
    }

    public void setCellToBlank(int row, int col) {
        if (row < this.getMaxRowCount() && col < this.getMaxColumnCount()) {
            Cell cell = new Cell();
            cell.setRowAndCol(row, col);
            cell.setChangeVal(true);
            this.table.get(row).set(col, cell);
        }
    }

    public List<Integer> getChangedRows() {
        return this.changedRows;
    }

    public void addChangeRow(Integer changedRow) {
        this.changedRows.add(changedRow);
    }

    public Integer getMaxCellId() {
        Object cellId = this.userObject.get("mcid");
        if (cellId == null) {
            cellId = -1;
        }
        return (Integer)cellId;
    }

    public void setMaxCellId(Integer maxCellId) {
        this.userObject.put("mcid", maxCellId);
    }

    public Header getRowHeader() {
        if (this.rowHeader == null) {
            this.rowHeader = new Header();
        }
        return this.rowHeader;
    }

    public Header getColHeader() {
        if (this.colHeader == null) {
            this.colHeader = new Header();
        }
        return this.colHeader;
    }

    public Header getHeader(boolean isRow) {
        return isRow ? this.getRowHeader() : this.getColHeader();
    }

    public HeadObject getRowHeader(int index, boolean isCreated) {
        return this.getRowHeader().get(index, isCreated);
    }

    public HeadObject getColHeader(int index, boolean isCreated) {
        return this.getColHeader().get(index, isCreated);
    }

    public void setColHeader(Header colHeader) {
        this.colHeader = colHeader;
    }

    public void setRowHeader(Header rowHeader) {
        this.rowHeader = rowHeader;
    }
}

