/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.ISupportGZip;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.Book;
import kd.fi.bcm.spread.domain.view.FilterView;
import kd.fi.bcm.spread.domain.view.MultiAreaPositionsManager;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManagerDeserializer;
import kd.fi.bcm.spread.domain.view.SpreadManagerSerializer;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.dao.Tuple;

@JsonSerialize(using=SpreadManagerSerializer.class)
@JsonDeserialize(using=SpreadManagerDeserializer.class)
public class SpreadManager
implements Serializable,
ISupportGZip {
    private static final long serialVersionUID = 1L;
    private Book book;
    private FilterView filter = null;
    private MultiAreaPositionsManager pm;
    private static final BasePointInnerLineInfo[] EmptyBasePointInnerLineInfo = new BasePointInnerLineInfo[0];
    @JsonIgnore
    private transient Map<String, String> cachedSpreadModelAllFilterDimNumbers;
    @JsonIgnore
    private transient NavigableMap<Integer, TreeMap<Integer, RangeModelWrap>> basePointRangeModelRowIndexMap;
    @JsonIgnore
    private transient TreeMap<Integer, RangeModelWrap> positionRangeModelRowIndexMap;
    @JsonIgnore
    private transient TreeMap<Integer, RangeModelWrap> positionRangeModelColumnIndexMap;
    @JsonIgnore
    private transient boolean isSheetOnlyRead = false;
    @JsonIgnore
    private transient String currentYear = "";
    @JsonIgnore
    private transient String lastYear = "";

    public void rebuildBasePointInfoLookupMap() {
        TreeMap<Integer, TreeMap<Integer, RangeModelWrap>> rowIndexMap = new TreeMap<Integer, TreeMap<Integer, RangeModelWrap>>();
        this.positionRangeModelRowIndexMap = new TreeMap();
        this.positionRangeModelColumnIndexMap = new TreeMap();
        for (PositionInfo positionInfo : this.getAreaManager().getPostionInfoSet()) {
            for (BasePointInfo basePointInfo : positionInfo.getBasePoints()) {
                RangeModelWrap rangeModelWrap = new RangeModelWrap(positionInfo, basePointInfo);
                int x = rangeModelWrap.basePointDirectionRange.getX_start();
                int y = rangeModelWrap.basePointDirectionRange.getY_start();
                TreeMap<Integer, RangeModelWrap> tempBufRangeModelMap = (TreeMap<Integer, RangeModelWrap>)rowIndexMap.get(y);
                if (tempBufRangeModelMap == null) {
                    tempBufRangeModelMap = new TreeMap<Integer, RangeModelWrap>();
                    rowIndexMap.put(y, tempBufRangeModelMap);
                }
                tempBufRangeModelMap.put(x, rangeModelWrap);
                if (!this.positionRangeModelRowIndexMap.containsKey(y)) {
                    this.positionRangeModelRowIndexMap.put(y, rangeModelWrap);
                }
                if (this.positionRangeModelColumnIndexMap.containsKey(x)) continue;
                this.positionRangeModelColumnIndexMap.put(x, rangeModelWrap);
            }
        }
        this.basePointRangeModelRowIndexMap = rowIndexMap.descendingMap();
    }

    public RangeModelWrap getInAreaRangeModelWrapByXY(int row, int column) {
        NavigableMap<Integer, TreeMap<Integer, RangeModelWrap>> matchRowMap;
        if (this.basePointRangeModelRowIndexMap == null) {
            this.rebuildBasePointInfoLookupMap();
        }
        if (!(matchRowMap = this.basePointRangeModelRowIndexMap.tailMap(row, true)).isEmpty()) {
            for (Map.Entry rowEn : matchRowMap.entrySet()) {
                RangeModelWrap result;
                RangeModel basePointInfoRange;
                Map.Entry matchRangeEntryBuf = ((TreeMap)rowEn.getValue()).floorEntry(column);
                if (matchRangeEntryBuf == null || (basePointInfoRange = (result = (RangeModelWrap)matchRangeEntryBuf.getValue()).getBasePointInfoRange()).getY_end() < row || basePointInfoRange.getX_end() < column) continue;
                return result;
            }
        }
        return null;
    }

    public BasePointInfo getInAreaBasePointInfoByXY(int row, int column) {
        RangeModelWrap wrap = this.getInAreaRangeModelWrapByXY(row, column);
        return wrap != null ? wrap.getBasePointInfo() : null;
    }

    public PositionInfo getInAreaPositionByRow(int row, int column) {
        for (PositionInfo posInfo : this.getAreaManager().getPostionInfoSet()) {
            int startRowIndex = posInfo.getOrInitIndexRange().getStartY();
            int startColIndex = posInfo.getOrInitIndexRange().getStartX();
            int endRowIndex = posInfo.getOrInitIndexRange().getEndY();
            int endColIndex = posInfo.getOrInitIndexRange().getEndX();
            if (startRowIndex > row || endRowIndex < row || startColIndex > column || endColIndex < column) continue;
            return posInfo;
        }
        return null;
    }

    public PositionInfo getInAreaExtPositionByXY(int r, int c) {
        if (r < 0 || c < 0) {
            return null;
        }
        for (PositionInfo posInfo : this.getAreaManager().getPostionInfoSet()) {
            RangeModel rangeModel;
            if (posInfo.getExtendInfo() == null || (rangeModel = new RangeModel(posInfo.getAreaRange())).getY_start() > r || rangeModel.getY_end() < r || rangeModel.getX_start() > c || rangeModel.getX_end() < c) continue;
            return posInfo;
        }
        return null;
    }

    public Map<Integer, PositionInfo> getInAreaPosition(Set<Integer> selIndex) {
        HashMap<Integer, PositionInfo> row2Pos = new HashMap<Integer, PositionInfo>(16);
        if (selIndex == null || selIndex.isEmpty()) {
            return row2Pos;
        }
        for (Integer selrow : selIndex) {
            for (PositionInfo posInfo : this.getAreaManager().getPostionInfoSet()) {
                int endRowIndex;
                int startRowIndex = this.isHorizon() == 1 ? posInfo.getOrInitIndexRange().getStartX() : posInfo.getOrInitIndexRange().getStartY();
                int n = endRowIndex = this.isHorizon() == 1 ? posInfo.getOrInitIndexRange().getEndX() : posInfo.getOrInitIndexRange().getEndY();
                if (startRowIndex > selrow || endRowIndex < selrow) continue;
                row2Pos.put(selrow, posInfo);
            }
        }
        return row2Pos;
    }

    public BasePointInfo getInAreaBasePosInfo(int index) {
        Map<Integer, PositionInfo> index2Pos = this.getInAreaPosition(Sets.newHashSet((Object[])new Integer[]{index}));
        PositionInfo pos = index2Pos.get(index);
        if (pos == null) {
            return null;
        }
        BasePointInfo baseInfo = pos.getBasePoint(index);
        return baseInfo;
    }

    public PositionInfo getInAreaPositionInfoByXY(int row, int column) {
        RangeModelWrap wrap = this.getInAreaRangeModelWrapByXY(row, column);
        return wrap != null ? wrap.getPositionInfo() : null;
    }

    public PositionInfo.FloatMemDisplayPattern getInAreaFloatMemDisplayPatternByXY(int row, int column) {
        PositionInfo position = this.getInAreaPositionInfoByXY(row, column);
        return position != null ? position.getFloatMemDisplayPattern() : null;
    }

    public RangeModelWrap getInDirectionBasePointInfoAndPositionInfobyXY(boolean horizontalMode, int row, int column) {
        RangeModel basePointDirectionRange;
        Map.Entry<Integer, RangeModelWrap> matchMapEntry;
        if (this.positionRangeModelRowIndexMap == null || this.positionRangeModelColumnIndexMap == null) {
            this.rebuildBasePointInfoLookupMap();
        }
        if ((matchMapEntry = horizontalMode ? this.positionRangeModelRowIndexMap.floorEntry(row) : this.positionRangeModelColumnIndexMap.floorEntry(column)) != null && (basePointDirectionRange = matchMapEntry.getValue().basePointDirectionRange).getY_end() >= row && basePointDirectionRange.getX_end() >= column) {
            return matchMapEntry.getValue();
        }
        return null;
    }

    public BasePointInnerLineInfo[] getBasePointInnerLineInfos(int row, int column) {
        RangeModelWrap basePointInfo = this.getInAreaRangeModelWrapByXY(row, column);
        if (basePointInfo != null) {
            int comparePos;
            int basePos;
            if (basePointInfo.getBasePointInfo().getDirect() == 2) {
                basePos = basePointInfo.getBasePointInfoRange().getY_start();
                comparePos = column;
            } else {
                basePos = basePointInfo.getBasePointInfoRange().getX_start();
                comparePos = row;
            }
            ArrayList<BasePointInnerLineInfo> items = new ArrayList<BasePointInnerLineInfo>();
            for (BasePointInnerLineInfo innerInfo : basePointInfo.getBasePointInfo().getBasePointInnerLineInfo()) {
                if (basePos + innerInfo.getOffset() != comparePos) continue;
                items.add(innerInfo);
            }
            return items.toArray(EmptyBasePointInnerLineInfo);
        }
        return EmptyBasePointInnerLineInfo;
    }

    public SpreadManager(String sheetName, FilterView filter) {
        this.filter = filter;
        this.book = new Book();
        this.book.addSheet(new Sheet(sheetName));
        this.pm = new MultiAreaPositionsManager(this);
    }

    public MultiAreaPositionsManager getAreaManager() {
        return this.pm;
    }

    public void setAreaManager(MultiAreaPositionsManager pm) {
        this.pm = pm;
    }

    public FilterView getFilter() {
        return this.filter;
    }

    public int isHorizon() {
        for (PositionInfo positionInfo : this.getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().size() <= 0) continue;
            return positionInfo.getBasePoints().get(0).getDirect();
        }
        return 2;
    }

    public int isFloatType() {
        for (PositionInfo positionInfo : this.getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().size() <= 0) continue;
            return positionInfo.getBasePoints().get(0).getDirect();
        }
        return 0;
    }

    public boolean hasFloat() {
        for (PositionInfo positionInfo : this.getAreaManager().getPostionInfoSet()) {
            if (positionInfo.getBasePoints() == null || positionInfo.getBasePoints().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasExtArea() {
        for (PositionInfo info : this.getAreaManager().getPostionInfoSet()) {
            if (info.getExtendInfo() == null) continue;
            return true;
        }
        return false;
    }

    public void setFilter(FilterView filter) {
        this.filter = filter;
    }

    public Book getBook() {
        return this.book;
    }

    public void setBook(Book book) {
        this.book = book;
    }

    public boolean hasModified(boolean isOnlyMd) {
        for (int i = 0; i < this.book.getSheetCount(); ++i) {
            if (!this.book.getSheet(i).hasModified(isOnlyMd)) continue;
            return true;
        }
        return false;
    }

    public void resetAllCachedMemberList() {
        this.getFilter().getPageDomain().resetCachedMemberList();
        this.getFilter().getViewPointDomain().resetCachedMemberList();
        this.cachedSpreadModelAllFilterDimNumbers = null;
    }

    public Map<Integer, String> getExtHeadInfo(PositionInfo posinfo) {
        LinkedHashMap<Integer, String> index2DimNums = new LinkedHashMap<Integer, String>(16);
        if (posinfo != null && posinfo.getExtendInfo() != null) {
            int startRowIndex = posinfo.getOrInitIndexRange().getStartY();
            int headerCol = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
            for (Cell cell : this.getBook().getSheet(0).getRow(headerCol)) {
                if (cell.getEXTColNumber().isEmpty()) continue;
                index2DimNums.put(cell.getCol(), cell.getEXTColNumber());
            }
        }
        return index2DimNums;
    }

    public Map<String, Integer> getExtHeadInfoColNum2Indexs(PositionInfo posinfo) {
        LinkedHashMap<String, Integer> dimNum2Indexs = new LinkedHashMap<String, Integer>(16);
        if (posinfo != null && posinfo.getExtendInfo() != null) {
            int startRowIndex = posinfo.getOrInitIndexRange().getStartY();
            int headerCol = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
            for (Cell cell : this.getBook().getSheet(0).getRow(headerCol)) {
                if (cell.getEXTColNumber().isEmpty()) continue;
                dimNum2Indexs.put(cell.getEXTColNumber(), cell.getCol());
            }
        }
        return dimNum2Indexs;
    }

    public PositionInfo getCommonPositionInfo() {
        for (PositionInfo ps : this.pm.getPostionInfoSet()) {
            Tuple<RowDimDomain, ColumnDimDomain> rowAndColDomainByPosition;
            if (ps.getExtendInfo() != null || (rowAndColDomainByPosition = this.pm.getRowAndColDomainByPosition(ps)) == null) continue;
            RowDimDomain rowDimDomain = (RowDimDomain)rowAndColDomainByPosition.k;
            ColumnDimDomain columnDimDomain = (ColumnDimDomain)rowAndColDomainByPosition.v;
            if (rowDimDomain == null || rowDimDomain.isEmpty() || columnDimDomain == null || columnDimDomain.isEmpty()) continue;
            return ps;
        }
        return null;
    }

    public PositionInfo getFirstUnExtendInfo() {
        for (PositionInfo ps : this.pm.getPostionInfoSet()) {
            if (ps.getExtendInfo() != null) continue;
            return ps;
        }
        return null;
    }

    public PositionInfo getFirstExtendInfo() {
        for (PositionInfo ps : this.pm.getPostionInfoSet()) {
            if (ps.getExtendInfo() == null) continue;
            return ps;
        }
        return null;
    }

    public boolean isExtReport() {
        return this.getFirstExtendInfo() != null;
    }

    public Map<Integer, String> getExtFloatDimInfo(PositionInfo posinfo) {
        LinkedHashMap<Integer, String> index2DimNums = new LinkedHashMap<Integer, String>(16);
        if (posinfo != null) {
            for (PositionInfo positionInfo : this.pm.getPostionInfoSet()) {
                if (positionInfo.getExtendInfo() == null || !posinfo.getAreaRange().equals(positionInfo.getAreaRange())) continue;
                RangeModel rangeModel = new RangeModel(positionInfo.getAreaRange());
                int startRowIndex = rangeModel.getY_start();
                int headerRow = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
                List<String> floatDims = positionInfo.getExtendInfo().getFloatDimNums();
                for (Cell cell : this.getBook().getSheet(0).getRow(headerRow)) {
                    if (cell.getEXTColNumber().isEmpty() || !floatDims.contains(cell.getEXTColNumber())) continue;
                    index2DimNums.put(cell.getCol(), cell.getEXTColNumber());
                }
            }
        }
        return index2DimNums;
    }

    public Map<Integer, String> getExtFloatDimInfoIncludeOrg(PositionInfo posinfo) {
        Map<Integer, String> index2DimNums = this.getExtFloatDimInfo(posinfo);
        index2DimNums.putAll(this.getExtOrgFloatDimInfo(posinfo));
        return index2DimNums;
    }

    public Map<Integer, String> getExtOrgFloatDimInfo(PositionInfo posinfo) {
        LinkedHashMap<Integer, String> index2DimNums = new LinkedHashMap<Integer, String>(16);
        if (posinfo != null) {
            for (PositionInfo positionInfo : this.pm.getPostionInfoSet()) {
                if (positionInfo.getExtendInfo() == null || !posinfo.getAreaRange().equals(positionInfo.getAreaRange())) continue;
                RangeModel rangeModel = new RangeModel(positionInfo.getAreaRange());
                int startRowIndex = rangeModel.getY_start();
                int headerRow = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
                for (Cell cell : this.getBook().getSheet(0).getRow(headerRow)) {
                    if (cell.getEXTColNumber().isEmpty() || !cell.getEXTColNumber().equals(DimTypesEnum.ENTITY.getNumber())) continue;
                    index2DimNums.put(cell.getCol(), cell.getEXTColNumber());
                }
            }
        }
        return index2DimNums;
    }

    public String getExtHeadCol(int row, int col) {
        PositionInfo posInfo = this.getInAreaPositionByRow(row, col);
        if (posInfo != null && posInfo.getExtendInfo() != null) {
            Map<Integer, String> index2DimNums = this.getExtFloatDimInfo(posInfo);
            if (!index2DimNums.containsKey(col)) {
                return "";
            }
            return index2DimNums.get(col);
        }
        return "";
    }

    public String getExtHeadCol2(int row, int col) {
        PositionInfo posInfo = this.getInAreaPositionByRow(row, col);
        Map<Integer, String> extHeadInfo = this.getExtHeadInfo(posInfo);
        if (posInfo != null && posInfo.getExtendInfo() != null) {
            if (!extHeadInfo.containsKey(col)) {
                return "";
            }
            return extHeadInfo.get(col);
        }
        return "";
    }

    public Integer getExtEntityHeadCol(PositionInfo info) {
        int sourceOrgIndex = -1;
        if (info != null && info.getExtendInfo() != null) {
            Sheet sheet = this.getBook().getSheet(0);
            int startRowIndex = ExcelUtils.pos2Y(info.getAreaRange().split(":")[0]);
            int headerCol = startRowIndex >= 1 ? startRowIndex - 1 : startRowIndex;
            for (Cell cell : sheet.getRow(headerCol)) {
                if (cell.getEXTColNumber().isEmpty() || !"Entity".equals(cell.getEXTColNumber())) continue;
                sourceOrgIndex = cell.getCol();
            }
        }
        return sourceOrgIndex;
    }

    public String getExtModelNumber(int row, int col) {
        PositionInfo posInfo = this.getInAreaPositionByRow(row, col);
        if (posInfo != null && posInfo.getExtendInfo() != null) {
            return posInfo.getExtendInfo().getExtModelNumber();
        }
        return "";
    }

    public boolean isShowOnce(Cell cell) {
        BasePointInfo baseInfo = this.getInAreaBasePointInfoByXY(cell.getRow(), cell.getCol());
        RangeModel rangeModel = new RangeModel(baseInfo.getDynaRange());
        int index = baseInfo.isDirectHoriz() ? rangeModel.getX_start() : rangeModel.getY_start();
        for (BasePointInnerLineInfo lineInfo : baseInfo.getBasePointInnerLineInfo()) {
            int fIndex = index + lineInfo.getOffset();
            if (fIndex != (baseInfo.isDirectHoriz() ? cell.getRow() : cell.getCol())) continue;
            boolean isShowOnce = baseInfo.isTopSettingOrder_memShowOne(lineInfo.getOffset());
            return isShowOnce;
        }
        return false;
    }

    public List<Integer> getAreaShowOnceRCIndex(int index) {
        ArrayList<Integer> rcIndex = new ArrayList<Integer>(16);
        BasePointInfo baseInfo = this.getInAreaBasePosInfo(index);
        if (baseInfo == null) {
            return rcIndex;
        }
        RangeModel rangeModel = new RangeModel(baseInfo.getDynaRange());
        int startIndex = baseInfo.isDirectHoriz() ? rangeModel.getY_start() : rangeModel.getX_start();
        List<Integer> indexs = baseInfo.getTopSettingOrder_memShowOnce();
        for (Integer offset : indexs) {
            int fIndex = startIndex + offset;
            rcIndex.add(fIndex);
        }
        return rcIndex;
    }

    @JsonIgnore
    public Map<String, String> getCachedSpreadModelAllFilterDimNumbers() {
        if (this.cachedSpreadModelAllFilterDimNumbers == null) {
            this.cachedSpreadModelAllFilterDimNumbers = new HashMap<String, String>();
            if (this.filter != null) {
                List<IDimMember> listMemmber;
                if (this.filter.getPageDomain() != null && (listMemmber = this.filter.getPageDomain().getAllMembers()) != null) {
                    for (IDimMember member : listMemmber) {
                        this.cachedSpreadModelAllFilterDimNumbers.put(member.getDimension().getNumber(), member.getNumber());
                    }
                }
                if (this.filter.getViewPointDomain() != null && (listMemmber = this.filter.getViewPointDomain().getAllMembers()) != null) {
                    for (IDimMember member : listMemmber) {
                        this.cachedSpreadModelAllFilterDimNumbers.put(member.getDimension().getNumber(), member.getNumber());
                    }
                }
            }
        }
        return this.cachedSpreadModelAllFilterDimNumbers;
    }

    public boolean isSheetOnlyRead() {
        return this.isSheetOnlyRead;
    }

    public void setSheetOnlyRead(boolean sheetOnlyRead) {
        this.isSheetOnlyRead = sheetOnlyRead;
    }

    public String getCurrentYear() {
        return this.currentYear;
    }

    public void setCurrentYear(String currentYear) {
        this.currentYear = currentYear;
    }

    public String getLastYear() {
        return this.lastYear;
    }

    public void setLastYear(String lastYear) {
        this.lastYear = lastYear;
    }

    public static class RangeModelWrap {
        private PositionInfo positionInfo;
        private BasePointInfo basePointInfo;
        private RangeModel positionInfoRange;
        private RangeModel basePointInfoRange;
        private RangeModel basePointDirectionRange;
        private int _cachedHashCode = -1;

        public PositionInfo getPositionInfo() {
            return this.positionInfo;
        }

        public BasePointInfo getBasePointInfo() {
            return this.basePointInfo;
        }

        public RangeModel getPositionInfoRange() {
            return this.positionInfoRange;
        }

        public RangeModel getBasePointInfoRange() {
            return this.basePointInfoRange;
        }

        public RangeModel getBasePointDirectionRange() {
            return this.basePointDirectionRange;
        }

        public RangeModelWrap(PositionInfo positionInfo, BasePointInfo basePointInfo) {
            this.positionInfo = positionInfo;
            this.basePointInfo = basePointInfo;
            this.basePointInfoRange = new RangeModel(basePointInfo.getDynaRange());
            this.positionInfoRange = new RangeModel(positionInfo.getAreaRange());
            this.basePointDirectionRange = basePointInfo.getDirect() == 1 ? new RangeModel(this.basePointInfoRange.getX_start(), this.positionInfoRange.getX_end(), this.basePointInfoRange.getY_start(), this.basePointInfoRange.getY_end()) : new RangeModel(this.basePointInfoRange.getX_start(), this.basePointInfoRange.getX_end(), this.basePointInfoRange.getY_start(), this.positionInfoRange.getY_end());
            this._cachedHashCode = basePointInfo.getDynaRange().hashCode();
        }

        public int hashCode() {
            return this._cachedHashCode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RangeModelWrap) {
                return this._cachedHashCode == ((RangeModelWrap)obj).hashCode();
            }
            return false;
        }
    }
}

