/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.spread.common.variant.Variant;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.ColumnDimDomain;
import kd.fi.bcm.spread.domain.RowDimDomain;
import kd.fi.bcm.spread.domain.view.Book;
import kd.fi.bcm.spread.domain.view.Header;
import kd.fi.bcm.spread.domain.view.MultiAreaPositionsManager;
import kd.fi.bcm.spread.domain.view.Sheet;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.model.CellData;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;
import kd.fi.bcm.spread.model.IDimension;
import kd.fi.bcm.spread.model.dao.Tuple;

public class SpreadManagerDeserializer
extends JsonDeserializer<SpreadManager> {
    public SpreadManager deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String smStr = node.get("ma").asText();
        SpreadManager sm = (SpreadManager)ObjectSerialUtil.deSerializedBytes(smStr);
        MultiAreaPositionsManager pm = sm.getAreaManager();
        Map<Long, IDimMember> dmMap = this.toDimMemberMap(pm);
        Book book = this.readBook(ctx, node, dmMap);
        sm.setBook(book);
        return sm;
    }

    private Book readBook(DeserializationContext ctx, JsonNode node, Map<Long, IDimMember> dmMap) {
        Book book = new Book();
        Iterator bookNodeIt = node.get("book").elements();
        while (bookNodeIt.hasNext()) {
            JsonNode sheetNode = (JsonNode)bookNodeIt.next();
            Sheet sheet = this.readSheet(ctx, dmMap, sheetNode);
            book.addSheet(sheet);
        }
        return book;
    }

    private Sheet readSheet(DeserializationContext ctx, Map<Long, IDimMember> dmMap, JsonNode sheetNode) {
        Sheet sheet = new Sheet(sheetNode.get("name").asText());
        if (sheetNode.get("uc") != null) {
            sheet.setUnCheckSize(sheetNode.get("uc").asBoolean());
        }
        Iterator tableNodeIt = sheetNode.get("table").elements();
        List<List<Cell>> rows = sheet.getTable();
        while (tableNodeIt.hasNext()) {
            HashMap<String, Dimension> dimMap = new HashMap<String, Dimension>();
            Iterator rowNodeIt = ((JsonNode)tableNodeIt.next()).elements();
            ArrayList<Cell> row = new ArrayList<Cell>();
            rows.add(row);
            while (rowNodeIt.hasNext()) {
                JsonNode cellNode = (JsonNode)rowNodeIt.next();
                row.add(this.readCell(cellNode, dmMap, dimMap, ctx));
            }
        }
        JsonNode userObjNode = sheetNode.get("o");
        if (userObjNode != null) {
            Iterator objIt = userObjNode.fields();
            while (objIt.hasNext()) {
                Map.Entry entry = (Map.Entry)objIt.next();
                sheet.putUserObject((String)entry.getKey(), this.readDefaultObject((JsonNode)entry.getValue()));
            }
        }
        this.readHead(sheetNode, sheet);
        return sheet;
    }

    private Cell readCell(JsonNode node, Map<Long, IDimMember> dmMap, Map<String, Dimension> dimMap, DeserializationContext ctx) {
        Cell cell = new Cell();
        if (node != null) {
            IntNode isChangeVal;
            this.readCellData(node, cell, ctx);
            TextNode formula = (TextNode)node.get("f");
            if (formula != null) {
                cell.setFormula(formula.textValue());
            }
            cell.setChangeVal((isChangeVal = (IntNode)node.get("c")) != null && isChangeVal.intValue() == 1);
            IntNode isMdDataDomain = (IntNode)node.get("m");
            if (node.size() > 0) {
                cell.setMdDataDomain(isMdDataDomain == null || isMdDataDomain.intValue() != 1);
            }
            this.readCellUserObject(node, cell, dmMap);
            this.readCellDimMember(node, cell, dmMap, dimMap);
        }
        return cell;
    }

    private void readCellDimMember(JsonNode node, Cell cell, Map<Long, IDimMember> mems, Map<String, Dimension> dimMap) {
        ArrayNode dms = (ArrayNode)node.get("d");
        if (dms == null) {
            return;
        }
        Iterator dmIt = dms.elements();
        while (dmIt.hasNext()) {
            JsonNode dm = (JsonNode)dmIt.next();
            if (dm.isInt()) {
                long dmId = ((IntNode)dm).longValue();
                cell.addDim2UserObject(mems.get(dmId));
                continue;
            }
            if (!dm.isObject()) continue;
            String dimNum = dm.get("di").asText();
            Dimension dim = dimMap.computeIfAbsent(dimNum, key -> {
                String dimNam = null;
                if (dm.get("din") != null) {
                    dimNam = dm.get("din").asText();
                }
                return new Dimension(dimNam, (String)key, null);
            });
            String dmNum = dm.get("dm").asText();
            String dmNam = null;
            String p_cNum = null;
            if (dm.get("dmn") != null) {
                dmNam = dm.get("dmn").asText();
            }
            if (dm.get("dmp") != null) {
                p_cNum = dm.get("dmp").asText();
            }
            DimMember mem = new DimMember(dmNam, dmNum, null, dim);
            mem.setPar_SonNum(p_cNum);
            if (dm.get("dmt") != null) {
                mem.setTemp(dm.get("dmt").asBoolean());
            }
            if (dm.get("dmo") != null) {
                mem.setOriNumber(dm.get("dmo").asText());
            }
            dim.addMember(mem);
            cell.addDim2UserObject(mem);
        }
    }

    private void readCellData(JsonNode node, Cell cell, DeserializationContext ctx) {
        JsonNode jsonVal = node.get("v");
        if (jsonVal == null) {
            return;
        }
        Variant v = null;
        CellData cellData = null;
        if (jsonVal.isArray()) {
            ArrayNode val = (ArrayNode)jsonVal;
            Iterator vals = val.elements();
            if (vals.hasNext()) {
                cellData = new CellData();
                int vt = ((IntNode)vals.next()).intValue();
                JsonNode valNode = (JsonNode)vals.next();
                switch (vt) {
                    case 12: {
                        v = new Variant(new Date(((LongNode)valNode).longValue()), vt);
                        break;
                    }
                    case 10: {
                        v = new Variant(new BigDecimal(valNode.textValue()), vt);
                        break;
                    }
                    case 9: {
                        v = new Variant(((LongNode)valNode).longValue(), vt);
                        break;
                    }
                    case 8: {
                        v = new Variant(((BooleanNode)valNode).booleanValue(), vt);
                        break;
                    }
                    case 13: {
                        v = new Variant(ctx.constructCalendar(new Date(((LongNode)valNode).longValue())), vt);
                        break;
                    }
                    case 7: {
                        v = new Variant(valNode.textValue(), vt);
                        break;
                    }
                    case 3: {
                        v = new Variant(((IntNode)valNode).intValue(), vt);
                        break;
                    }
                    default: {
                        v = new Variant(valNode.textValue(), vt);
                    }
                }
                cellData.setData(v);
            }
        } else {
            cellData = new CellData();
            cellData.setData(new Variant(new BigDecimal(jsonVal.decimalValue().toPlainString()), 10));
        }
        cell.setCellData(cellData);
    }

    private void readCellUserObject(JsonNode node, Cell cell, Map<Long, IDimMember> mems) {
        JsonNode userObject = node.get("o");
        if (userObject == null) {
            return;
        }
        Iterator objIt = userObject.fields();
        while (objIt.hasNext()) {
            Map.Entry entry = (Map.Entry)objIt.next();
            if (((String)entry.getKey()).equals("seqobject")) {
                long dmId = ((IntNode)entry.getValue()).longValue();
                cell.setUserObject((String)entry.getKey(), mems.get(dmId));
                continue;
            }
            cell.setUserObject((String)entry.getKey(), this.readDefaultObject((JsonNode)entry.getValue()));
        }
    }

    private Object readDefaultObject(JsonNode jsonNode) {
        if (jsonNode.isInt()) {
            return jsonNode.asInt();
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        if (jsonNode.isLong()) {
            return jsonNode.asLong();
        }
        return jsonNode.asText();
    }

    private Map<Long, IDimMember> toDimMemberMap(MultiAreaPositionsManager pm) {
        HashMap<Long, IDimMember> dms = new HashMap<Long, IDimMember>();
        Iterator<Tuple<RowDimDomain, ColumnDimDomain>> it = pm.iteratorValues();
        while (it.hasNext()) {
            Tuple<RowDimDomain, ColumnDimDomain> val = it.next();
            if (val.k == null) continue;
            for (IDimension dim : ((RowDimDomain)val.k).getDimensions()) {
                for (IDimMember dm : dim.getMembers()) {
                    dms.put(((DimMember)dm).getId(), dm);
                }
            }
            for (IDimension dim : ((ColumnDimDomain)val.v).getDimensions()) {
                for (IDimMember dm : dim.getMembers()) {
                    dms.put(((DimMember)dm).getId(), dm);
                }
            }
        }
        return dms;
    }

    private void readHead(JsonNode sheetNode, Sheet sheet) {
        String smStr;
        JsonNode jn = sheetNode.get("rh");
        if (jn != null) {
            smStr = sheetNode.get("rh").asText();
            Header rh = (Header)ObjectSerialUtil.deSerializedBytes(smStr);
            sheet.setRowHeader(rh);
        }
        if ((jn = sheetNode.get("ch")) != null) {
            smStr = jn.asText();
            Header ch = (Header)ObjectSerialUtil.deSerializedBytes(smStr);
            sheet.setColHeader(ch);
        }
    }
}

