/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view.builder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.RangeModel;
import kd.fi.bcm.common.util.ToStringHelper;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.domain.view.builder.CircularInfo;
import kd.fi.bcm.spread.domain.view.builder.SequenceInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.BasePointInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.event.AdjustRangeEvent;
import kd.fi.bcm.spread.domain.view.builder.dynamic.event.IAdjustRange;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import kd.fi.bcm.spread.model.IDimension;
import org.apache.commons.lang3.builder.EqualsBuilder;

public class PositionInfo
implements Serializable,
IAdjustRange {
    private static final long serialVersionUID = 1L;
    public static final transient PositionInfo EMPTY = new PositionInfo("NULL", "NULL");
    private String startPosition;
    private String areaRange;
    private String originalStartPosition;
    private String originalAreaRange;
    private boolean isSplit = false;
    private List<BasePointInfo> basePoints = new ArrayList<BasePointInfo>(3);
    private List<CircularInfo> circularInfos = new ArrayList<CircularInfo>();
    private ExtendInfo extendInfo;
    private SequenceInfo sequenceInfo;
    private IDimension varDimension;
    private FloatSummaryWay floatSummaryWay;
    private int orgMemColIndex;
    private FloatOrgRange floatOrgRange;
    private FloatMemDisplayPattern floatMemDisplayPattern;
    private List<Integer> offsetIndex;
    private Boolean isShowFolatText = Boolean.TRUE;
    private transient IndexRange indexRange;
    private Boolean isShowFolatNullOrZero = Boolean.FALSE;
    private Boolean isShowFloatMember = Boolean.FALSE;
    private FloatConfigSetting floatConfigSetting;
    private MyCompanyAutoConvent myCompanyAutoConvent;

    public Boolean getShowFolatText() {
        if (this.isShowFolatText == null) {
            this.isShowFolatText = Boolean.TRUE;
        }
        return this.isShowFolatText;
    }

    public void setShowFolatText(Boolean showFolatText) {
        this.isShowFolatText = showFolatText;
    }

    public Boolean getShowFolatNullOrZero() {
        if (this.isShowFolatNullOrZero == null) {
            this.isShowFolatNullOrZero = Boolean.FALSE;
        }
        return this.isShowFolatNullOrZero;
    }

    public void setShowFolatNullOrZero(Boolean showFolatNullOrZero) {
        this.isShowFolatNullOrZero = showFolatNullOrZero;
    }

    public Boolean getShowFloatMember() {
        if (this.isShowFloatMember == null) {
            this.isShowFloatMember = Boolean.FALSE;
        }
        return this.isShowFloatMember;
    }

    public void setShowFloatMember(Boolean showFloatMember) {
        this.isShowFloatMember = showFloatMember;
    }

    public FloatConfigSetting getFloatConfigSetting() {
        if (this.floatConfigSetting == null) {
            this.floatConfigSetting = FloatConfigSetting.TOTAL;
        }
        return this.floatConfigSetting;
    }

    public void setFloatConfigSetting(FloatConfigSetting floatConfigSetting) {
        this.floatConfigSetting = floatConfigSetting;
    }

    public MyCompanyAutoConvent getMyCompanyAutoConvent() {
        if (this.myCompanyAutoConvent == null) {
            this.myCompanyAutoConvent = MyCompanyAutoConvent.NO;
        }
        return this.myCompanyAutoConvent;
    }

    public void setMyCompanyAutoConvent(MyCompanyAutoConvent myCompanyAutoConvent) {
        this.myCompanyAutoConvent = myCompanyAutoConvent;
    }

    public PositionInfo(String startPosition, String areaRange) {
        this.startPosition = startPosition;
        this.areaRange = areaRange;
        this.originalAreaRange = areaRange;
        this.originalStartPosition = startPosition;
    }

    public int getRowSize() {
        int startRowIndex = ExcelUtils.pos2Y(this.getAreaRange().split(":")[0]);
        int endRowIndex = ExcelUtils.pos2Y(this.getAreaRange().split(":")[1]);
        return endRowIndex - startRowIndex + 1;
    }

    public int getColSize() {
        int startColIndex = ExcelUtils.pos2X(this.getAreaRange().split(":")[0]);
        int endColIndex = ExcelUtils.pos2X(this.getAreaRange().split(":")[1]);
        return endColIndex - startColIndex + 1;
    }

    public int getFirstRow() {
        return ExcelUtils.pos2Y(this.getAreaRange().split(":")[0]);
    }

    public int getFirstCol() {
        return ExcelUtils.pos2X(this.getAreaRange().split(":")[0]);
    }

    public FloatSummaryWay getFloatSummaryWay() {
        return this.floatSummaryWay;
    }

    public boolean isFloatPosition() {
        return !this.basePoints.isEmpty();
    }

    public void setFloatSummaryWay(FloatSummaryWay floatSummaryWay) {
        this.floatSummaryWay = floatSummaryWay;
    }

    public int getOrgMemColIndex() {
        return this.orgMemColIndex;
    }

    public void setOrgMemColIndex(int orgMemColIndex) {
        this.orgMemColIndex = orgMemColIndex;
    }

    public FloatOrgRange getFloatOrgRange() {
        return this.floatOrgRange;
    }

    public void setFloatOrgRange(FloatOrgRange floatOrgRange) {
        this.floatOrgRange = floatOrgRange;
    }

    public FloatMemDisplayPattern getFloatMemDisplayPattern() {
        if (this.floatMemDisplayPattern == null) {
            this.floatMemDisplayPattern = FloatMemDisplayPattern.NAME;
        }
        return this.floatMemDisplayPattern;
    }

    public void setFloatMemDisplayPattern(FloatMemDisplayPattern floatMemDisplayPattern) {
        this.floatMemDisplayPattern = floatMemDisplayPattern;
    }

    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        String oldStartPos = this.startPosition;
        if (StringUtils.isNotEmpty((String)oldStartPos)) {
            this.setOriginalStartPosition(oldStartPos);
        }
        this.startPosition = startPosition;
    }

    public String getAreaRange() {
        return this.areaRange;
    }

    public void setAreaRange(String areaRange) {
        String oldAreaRange = this.areaRange;
        if (StringUtils.isNotEmpty((String)oldAreaRange)) {
            this.setOriginalAreaRange(oldAreaRange);
            RangeModel rangeModel = new RangeModel(oldAreaRange);
            this.setOriginalStartPosition(rangeModel.getStartPoint().toString());
        }
        this.areaRange = areaRange;
    }

    public boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean isSplit) {
        this.isSplit = isSplit;
    }

    public String getOriginalStartPosition() {
        if (this.originalStartPosition == null) {
            this.originalStartPosition = this.startPosition;
        }
        return this.originalStartPosition;
    }

    public void setOriginalStartPosition(String originalStartPosition) {
        this.originalStartPosition = originalStartPosition;
    }

    public String getOriginalAreaRange() {
        if (this.originalAreaRange == null) {
            this.originalAreaRange = this.areaRange;
        }
        return this.originalAreaRange;
    }

    public void setOriginalAreaRange(String originalAreaRange) {
        this.originalAreaRange = originalAreaRange;
    }

    public ExtendInfo getExtendInfo() {
        return this.extendInfo;
    }

    public void setExtendInfos(ExtendInfo extendInfo) {
        this.extendInfo = extendInfo;
    }

    public SequenceInfo getSequenceInfo() {
        return this.sequenceInfo;
    }

    public void setSequenceInfo(SequenceInfo sequenceInfo) {
        this.sequenceInfo = sequenceInfo;
    }

    public boolean isRightAtCurrPosition(PositionInfo oth) {
        int[] currStartPos = ExcelUtils.pos2XY(this.getAreaRange().split(":")[0]);
        int[] currEndPos = ExcelUtils.pos2XY(this.getAreaRange().split(":")[1]);
        int[] othStartPos = ExcelUtils.pos2XY(oth.getAreaRange().split(":")[0]);
        int[] othEndPos = ExcelUtils.pos2XY(oth.getAreaRange().split(":")[1]);
        return othStartPos[0] > currEndPos[0] && Math.max(currStartPos[1], othStartPos[1]) <= Math.min(currEndPos[1], othEndPos[1]);
    }

    public boolean isBottomAtCurrPosition(PositionInfo oth) {
        int[] currStartPos = ExcelUtils.pos2XY(this.getAreaRange().split(":")[0]);
        int[] currEndPos = ExcelUtils.pos2XY(this.getAreaRange().split(":")[1]);
        int[] othStartPos = ExcelUtils.pos2XY(oth.getAreaRange().split(":")[0]);
        int[] othEndPos = ExcelUtils.pos2XY(oth.getAreaRange().split(":")[1]);
        return othStartPos[1] > currEndPos[1] && Math.max(currStartPos[0], othStartPos[0]) <= Math.min(currEndPos[0], othEndPos[0]);
    }

    public boolean isBiggerTo(PositionInfo oth) {
        int[] othEndPos;
        int[] currStartPos = ExcelUtils.pos2XY(this.getAreaRange().split(":")[0]);
        return currStartPos[0] > (othEndPos = ExcelUtils.pos2XY(oth.getAreaRange().split(":")[1]))[0] || currStartPos[1] > othEndPos[1];
    }

    public boolean equalsByOriginal(PositionInfo other) {
        return new EqualsBuilder().append((Object)this.getOriginalAreaRange(), (Object)other.getOriginalAreaRange()).append((Object)this.getOriginalStartPosition(), (Object)other.getOriginalStartPosition()).isEquals();
    }

    public List<BasePointInfo> getBasePoints() {
        return this.basePoints;
    }

    public void setBasePoints(List<BasePointInfo> basePoints) {
        this.basePoints = basePoints;
    }

    public List<CircularInfo> getCircularInfos() {
        return this.circularInfos;
    }

    public void addCircularInfo(CircularInfo circularInfo) {
        this.circularInfos.add(circularInfo);
    }

    public IDimension getVarDimension() {
        return this.varDimension;
    }

    public void setVarDimension(IDimension varDimension) {
        this.varDimension = varDimension;
    }

    public List<Integer> getOffsetIndex() {
        return this.offsetIndex;
    }

    public void setOffsetIndex(List<Integer> offsetIndex) {
        this.offsetIndex = offsetIndex;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (obj instanceof PositionInfo) {
            PositionInfo o = (PositionInfo)obj;
            isEquals = new EqualsBuilder().append((Object)this.areaRange, (Object)o.getAreaRange()).append((Object)this.startPosition, (Object)o.getStartPosition()).isEquals();
        }
        return isEquals;
    }

    public String toString() {
        return ToStringHelper.reflectionToString(this);
    }

    @Override
    public void adjustRange(AdjustRangeEvent event) {
        String[] splitArr = this.areaRange.split(":");
        int startcol = ExcelUtils.pos2X(splitArr[0]);
        int startrow = ExcelUtils.pos2Y(splitArr[0]);
        int endcol = ExcelUtils.pos2X(splitArr[1]);
        int endrow = ExcelUtils.pos2Y(splitArr[1]);
        if (startrow > endrow || startcol > endcol || !this.getStartPosition().equals(splitArr[0])) {
            return;
        }
        String startPos = this.doAdjustRange(event, splitArr[0], false, splitArr[1]);
        if (this.dealSpecialRange(startPos)) {
            return;
        }
        String endPos = this.doAdjustRange(event, splitArr[1], true, splitArr[1]);
        if (this.dealSpecialRange(endPos)) {
            return;
        }
        this.areaRange = startPos + ":" + endPos;
        this.startPosition = this.doAdjustRange(event, this.startPosition, false, splitArr[1]);
        if (this.dealSpecialRange(this.startPosition)) {
            return;
        }
        this.basePoints.forEach(bp -> bp.adjustRange(event));
        if (this.sequenceInfo != null) {
            this.sequenceInfo.adjustRange(event);
            this.sequenceInfo.setDataArea(this.areaRange);
            RangeModel rangeModel = new RangeModel(this.sequenceInfo.getSeqArea());
            if (rangeModel.getX_start() > rangeModel.getX_end() || rangeModel.getY_start() > rangeModel.getY_end() || rangeModel.checkIsInArea(new RangeModel(this.areaRange))) {
                this.sequenceInfo = null;
            }
        }
        this.indexRange = null;
    }

    private boolean dealSpecialRange(String pos) {
        if ("#".equals(pos)) {
            this.areaRange = "B1:A1";
            this.startPosition = "B1:A1".split(":")[0];
            return true;
        }
        return false;
    }

    private Object readResolve() {
        if (this.basePoints == null) {
            this.basePoints = new ArrayList<BasePointInfo>(3);
        }
        return this;
    }

    public IndexRange getOrInitIndexRange() {
        if (this.indexRange != null) {
            return this.indexRange;
        }
        RangeModel rangeModel = new RangeModel(this.getAreaRange());
        int startRowIndex = rangeModel.getY_start();
        int startColIndex = rangeModel.getX_start();
        int endRowIndex = rangeModel.getY_end();
        int endColIndex = rangeModel.getX_end();
        this.indexRange = new IndexRange(startRowIndex, startColIndex, endRowIndex, endColIndex);
        return this.indexRange;
    }

    public static boolean isInArea(List<RangeModel> rangeModels, Cell cell) {
        for (RangeModel rangeModel : rangeModels) {
            if (cell.getRow() < rangeModel.getY_start() || cell.getRow() > rangeModel.getY_end() || cell.getCol() < rangeModel.getX_start() || cell.getCol() > rangeModel.getX_end()) continue;
            return true;
        }
        return false;
    }

    public BasePointInfo getBasePoint(Cell cell) {
        for (BasePointInfo basePointInfo : this.getBasePoints()) {
            RangeModel floatDataRange = this.getFloatdataArea(basePointInfo);
            if (cell.getRow() < floatDataRange.getY_start() || cell.getRow() > floatDataRange.getY_end() || cell.getCol() < floatDataRange.getX_start() || cell.getCol() > floatDataRange.getX_end()) continue;
            return basePointInfo;
        }
        return null;
    }

    public BasePointInfo getBasePoint(int index) {
        for (BasePointInfo basePointInfo : this.getBasePoints()) {
            int endIndex;
            RangeModel floatDataRange = this.getFloatdataArea(basePointInfo);
            int startIndex = basePointInfo.isDirectHoriz() ? floatDataRange.getX_start() : floatDataRange.getY_start();
            int n = endIndex = basePointInfo.isDirectHoriz() ? floatDataRange.getX_end() : floatDataRange.getY_end();
            if (index < startIndex || index > endIndex) continue;
            return basePointInfo;
        }
        return null;
    }

    public List<RangeModel> getFloatDataArea() {
        ArrayList<RangeModel> floatDataRanges = new ArrayList<RangeModel>(16);
        for (BasePointInfo basePointInfo : this.getBasePoints()) {
            RangeModel floatDataRange = this.getFloatdataArea(basePointInfo);
            floatDataRanges.add(floatDataRange);
        }
        return floatDataRanges;
    }

    public Map<String, RangeModel> getFloatArea2DataArea() {
        LinkedHashMap<String, RangeModel> floatArea2DataRanges = new LinkedHashMap<String, RangeModel>(16);
        for (BasePointInfo basePointInfo : this.getBasePoints()) {
            RangeModel floatDataRange = this.getFloatdataArea(basePointInfo);
            floatArea2DataRanges.put(basePointInfo.getOriginalDynaRange(), floatDataRange);
        }
        return floatArea2DataRanges;
    }

    public RangeModel getFloatdataArea(BasePointInfo basePointInfo) {
        RangeModel floatDataRange;
        RangeModel floatRange = new RangeModel(basePointInfo.getDynaRange());
        RangeModel datarange = new RangeModel(this.getAreaRange());
        if (!basePointInfo.isDirectHoriz()) {
            int startFloatRow = floatRange.getY_start();
            int endFloatRow = floatRange.getY_end();
            int startDataRangeCol = datarange.getX_start();
            int endDataRangeCol = datarange.getX_end();
            floatDataRange = new RangeModel(startDataRangeCol, endDataRangeCol, startFloatRow, endFloatRow);
        } else {
            int startFloatCol = floatRange.getX_start();
            int endFloatCol = floatRange.getX_end();
            int startDataRangeRow = datarange.getY_start();
            int endDataRangeRow = datarange.getY_end();
            floatDataRange = new RangeModel(startFloatCol, endFloatCol, startDataRangeRow, endDataRangeRow);
        }
        return floatDataRange;
    }

    public Map<String, RangeModel> getOriginFloatArea2DataArea() {
        LinkedHashMap<String, RangeModel> originFloatArea2DataRanges = new LinkedHashMap<String, RangeModel>(16);
        for (BasePointInfo basePointInfo : this.getBasePoints()) {
            RangeModel originFloatDataArea = this.getOriginFloatDataArea(basePointInfo);
            originFloatArea2DataRanges.put(basePointInfo.getOriginalDynaRange(), originFloatDataArea);
        }
        return originFloatArea2DataRanges;
    }

    public RangeModel getOriginFloatDataArea(BasePointInfo basePointInfo) {
        RangeModel floatDataRange;
        RangeModel floatRange = new RangeModel(basePointInfo.getOriginalDynaRange());
        RangeModel datarange = new RangeModel(this.getOriginalAreaRange());
        if (!basePointInfo.isDirectHoriz()) {
            int startFloatRow = floatRange.getY_start();
            int endFloatRow = floatRange.getY_end();
            int startDataRangeCol = datarange.getX_start();
            int endDataRangeCol = datarange.getX_end();
            floatDataRange = new RangeModel(startDataRangeCol, endDataRangeCol, startFloatRow, endFloatRow);
        } else {
            int startFloatCol = floatRange.getX_start();
            int endFloatCol = floatRange.getX_end();
            int startDataRangeRow = datarange.getY_start();
            int endDataRangeRow = datarange.getY_end();
            floatDataRange = new RangeModel(startFloatCol, endFloatCol, startDataRangeRow, endDataRangeRow);
        }
        return floatDataRange;
    }

    public static enum MyCompanyAutoConvent {
        NO(0),
        MCNONE(1),
        ECUR(2);

        private int index;

        private MyCompanyAutoConvent(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }

        public static MyCompanyAutoConvent getPattern(int idx) {
            for (MyCompanyAutoConvent pattern : MyCompanyAutoConvent.values()) {
                if (idx != pattern.getIndex()) continue;
                return pattern;
            }
            throw new KDBizException("error report MyCompanyAutoConvEnum: " + idx);
        }
    }

    public static enum FloatConfigSetting {
        TOTAL(1),
        PART(2);

        private int index;

        private FloatConfigSetting(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }

        public static FloatConfigSetting getPattern(int idx) {
            for (FloatConfigSetting pattern : FloatConfigSetting.values()) {
                if (idx != pattern.getIndex()) continue;
                return pattern;
            }
            throw new KDBizException("error report FloatConfigSetting: " + idx);
        }
    }

    public static enum FloatMemDisplayPattern {
        NAME(1),
        NAMEANDNUMBER(2),
        NUMBER(3),
        SIMPLENAME(4),
        NUMANDSIMPLENAME(5),
        NO(6);

        private int index;

        private FloatMemDisplayPattern(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }

        public static FloatMemDisplayPattern getPattern(int idx) {
            for (FloatMemDisplayPattern pattern : FloatMemDisplayPattern.values()) {
                if (idx != pattern.getIndex()) continue;
                return pattern;
            }
            throw new KDBizException("error report displayPattern: " + idx);
        }
    }

    public static enum FloatOrgRange {
        LEAF(1),
        DIRECT(2);

        private int index;

        private FloatOrgRange(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static enum FloatSummaryWay {
        SUPPORT(1),
        NONSUPPORT(2);

        private int index;

        private FloatSummaryWay(int idx) {
            this.index = idx;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static class IndexRange {
        int startY;
        int startX;
        int endY;
        int endX;

        public IndexRange(int startY, int startX, int endY, int endX) {
            this.startY = startY;
            this.startX = startX;
            this.endY = endY;
            this.endX = endX;
        }

        public int getStartY() {
            return this.startY;
        }

        public int getStartX() {
            return this.startX;
        }

        public int getEndY() {
            return this.endY;
        }

        public int getEndX() {
            return this.endX;
        }
    }
}

