/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.domain.view.builder.extend;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.CalculateInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.FloatDimInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.SortInfo;

public class ExtendInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String extModelNumber;
    private String extGroup;
    private boolean isRepAutoAgg;
    private boolean isNumShowSum;
    private boolean isCheckUnique;
    private boolean isShowDataSourceOrg;
    private PositionInfo.FloatMemDisplayPattern orgDisplayPattern;
    private Boolean isShowWholeRowZero = Boolean.TRUE;
    private boolean isShowFolatZeroRow = false;
    private int direct = 2;
    private String topField;
    private int topCount;
    private Map<String, List<Pair<Long, String>>> enumValueRangeMap = new HashMap<String, List<Pair<Long, String>>>(16);
    private Map<String, String> fixValueMap = new HashMap<String, String>(16);
    private Map<String, String> customColName = new HashMap<String, String>(16);
    private List<String> cols = new ArrayList<String>(10);
    private List<String> zeroNotShowCols = new ArrayList<String>(16);
    private boolean isColChange;
    private Map<String, String> colNumberToName = new HashMap<String, String>(16);
    private List<FloatDimInfo> floatdims = new ArrayList<FloatDimInfo>(3);
    private List<SortInfo> sortInfos = new ArrayList<SortInfo>(3);
    private List<CalculateInfo> calculateInfos = new ArrayList<CalculateInfo>();
    private Map<String, PositionInfo.FloatMemDisplayPattern> ext2DisplayPattern = new HashMap<String, PositionInfo.FloatMemDisplayPattern>(16);

    public ExtendInfo(String extModelNumber, String extGroup) {
        this.extModelNumber = extModelNumber;
        this.extGroup = extGroup;
        this.isColChange = true;
    }

    public boolean hasTopSetting() {
        return StringUtils.isNotEmpty((String)this.topField);
    }

    public void clearTopSetting() {
        this.setTopField(null);
        this.setTopCount(0);
        this.setCustomColName(new HashMap<String, String>(16));
    }

    public Boolean getShowWholeRowZero() {
        return this.isShowWholeRowZero;
    }

    public void setShowWholeRowZero(Boolean showWholeRowZero) {
        this.isShowWholeRowZero = showWholeRowZero;
    }

    public List<String> getZeroNotShowCols() {
        if (this.zeroNotShowCols == null) {
            this.zeroNotShowCols = new ArrayList<String>(16);
        }
        return this.zeroNotShowCols;
    }

    public void setZeroNotShowCols(List<String> zeroNotShowCols) {
        this.zeroNotShowCols = zeroNotShowCols;
    }

    public String getTopField() {
        return this.topField;
    }

    public void setTopField(String topField) {
        this.topField = topField;
    }

    public int getTopCount() {
        return this.topCount;
    }

    public void setTopCount(int topCount) {
        this.topCount = topCount;
    }

    public Map<String, String> getCustomColName() {
        if (this.customColName == null) {
            this.customColName = new HashMap<String, String>(16);
        }
        return this.customColName;
    }

    public void setCustomColName(Map<String, String> customColName) {
        this.customColName = customColName;
    }

    public boolean isDirectHoriz() {
        return 1 == this.direct;
    }

    public int getDirect() {
        return this.direct;
    }

    public void setDirect(int direct) {
        this.direct = direct;
    }

    public boolean isShowFolatZeroRow() {
        return this.isShowFolatZeroRow;
    }

    public void setShowFolatZeroRow(boolean isShowFolatZeroRow) {
        this.isShowFolatZeroRow = isShowFolatZeroRow;
    }

    public boolean isShowWholeRowZero() {
        return this.isShowWholeRowZero == null ? Boolean.TRUE : this.isShowWholeRowZero;
    }

    public void setShowWholeRowZero(boolean showWholeRowZero) {
        this.isShowWholeRowZero = showWholeRowZero;
    }

    public PositionInfo.FloatMemDisplayPattern getOrgDisplayPattern() {
        if (this.orgDisplayPattern == null) {
            this.orgDisplayPattern = PositionInfo.FloatMemDisplayPattern.NAMEANDNUMBER;
        }
        return this.orgDisplayPattern;
    }

    public boolean isColChange() {
        return this.isColChange;
    }

    public void setColChange(boolean isColChange) {
        this.isColChange = isColChange;
    }

    public void setOrgDisplayPattern(PositionInfo.FloatMemDisplayPattern orgDisplayPattern) {
        this.orgDisplayPattern = orgDisplayPattern;
    }

    public String getExtModelNumber() {
        return this.extModelNumber;
    }

    public void setExtModelNumber(String extModelNumber) {
        this.extModelNumber = extModelNumber;
    }

    public boolean isRepAutoAgg() {
        return this.isRepAutoAgg;
    }

    public void setRepAutoAgg(boolean repAutoAgg) {
        this.isRepAutoAgg = repAutoAgg;
    }

    public boolean isNumShowSum() {
        return this.isNumShowSum;
    }

    public void setNumShowSum(boolean numShowSum) {
        this.isNumShowSum = numShowSum;
    }

    public boolean isCheckUnique() {
        return this.isCheckUnique;
    }

    public void setCheckUnique(boolean checkUnique) {
        this.isCheckUnique = checkUnique;
    }

    public boolean addCol(String col) {
        this.setColChange(true);
        return this.cols.add(col);
    }

    public List<String> getCols() {
        return this.getCols(false);
    }

    public List<String> getCols(boolean isIncludeOrg) {
        ArrayList<String> list = new ArrayList<String>(this.cols);
        if (isIncludeOrg) {
            if (this.isShowDataSourceOrg && !this.cols.contains(DimTypesEnum.ENTITY.getNumber())) {
                list.add(0, DimTypesEnum.ENTITY.getNumber());
            }
        } else {
            list.remove(DimTypesEnum.ENTITY.getNumber());
        }
        return list;
    }

    public List<String> getFloatDimNums() {
        List<String> fDimNums = this.floatdims.stream().map(c -> c.getDimension().getNumber()).collect(Collectors.toList());
        return fDimNums;
    }

    public void setCols(List<String> cols) {
        if (this.colNumberToName != null) {
            this.colNumberToName.clear();
        }
        this.cols = cols;
    }

    public List<DynaMembScopeInfo> getFloatMemberScope(String dimNum) {
        for (FloatDimInfo floatdim : this.getFloatdims()) {
            if (!floatdim.getDimension().getNumber().equals(dimNum)) continue;
            return floatdim.getDynaMembScopes();
        }
        return null;
    }

    public PositionInfo.FloatMemDisplayPattern getFloatMemberDisplay(String dimNum) {
        for (FloatDimInfo floatdim : this.getFloatdims()) {
            if (!floatdim.getDimension().getNumber().equals(dimNum)) continue;
            return floatdim.getFloatMemDisplayPattern();
        }
        return null;
    }

    public void removeColField(String colNumber) {
        this.cols.remove(colNumber);
        this.floatdims.removeIf(p -> p.getDimension().getNumber().equals(colNumber));
        this.calculateInfos = this.calculateInfos.stream().filter(calculateInfo -> !calculateInfo.getCalcol().equals(colNumber)).collect(Collectors.toList());
        this.sortInfos = this.sortInfos.stream().filter(sortInfo -> !sortInfo.getSortField().equals(colNumber)).collect(Collectors.toList());
        if (this.colNumberToName != null) {
            this.colNumberToName.remove(colNumber);
        }
        if (colNumber.equals(this.topField)) {
            this.clearTopSetting();
            return;
        }
        if (this.customColName != null) {
            this.customColName.remove(colNumber);
        }
    }

    public boolean addFloatdim(FloatDimInfo fd) {
        return this.floatdims.add(fd);
    }

    public List<FloatDimInfo> getFloatdims() {
        return new ArrayList<FloatDimInfo>(this.floatdims);
    }

    public void setFloatdims(List<FloatDimInfo> floatdims) {
        this.floatdims = floatdims;
    }

    public boolean addSortInfo(SortInfo si) {
        return this.sortInfos.add(si);
    }

    public List<SortInfo> getSortInfos() {
        return new ArrayList<SortInfo>(this.sortInfos);
    }

    public List<SortInfo> getSortInfos(boolean isSort) {
        if (this.sortInfos.isEmpty() || !isSort) {
            return new ArrayList<SortInfo>(this.sortInfos);
        }
        ArrayList<SortInfo> orderSortInfos = new ArrayList<SortInfo>(this.sortInfos.size());
        this.sortInfos.stream().sorted(Comparator.comparingInt(e -> e.getSortpriority())).forEach(s -> orderSortInfos.add((SortInfo)s));
        return orderSortInfos;
    }

    public void setSortInfos(List<SortInfo> sortInfos) {
        this.sortInfos = sortInfos;
    }

    public void setCalculateInfos(List<CalculateInfo> calculateInfos) {
        this.calculateInfos = calculateInfos;
    }

    public List<CalculateInfo> getCalculateInfos() {
        return new ArrayList<CalculateInfo>(this.calculateInfos);
    }

    public String getExtGroup() {
        return this.extGroup;
    }

    public void setExtGroup(String extGroup) {
        this.extGroup = extGroup;
    }

    public boolean isShowDataSourceOrg() {
        return this.isShowDataSourceOrg;
    }

    public void setShowDataSourceOrg(boolean showDataSourceOrg) {
        this.isShowDataSourceOrg = showDataSourceOrg;
        if (!showDataSourceOrg) {
            this.orgDisplayPattern = PositionInfo.FloatMemDisplayPattern.NO;
            this.removeColField(DimTypesEnum.ENTITY.getNumber());
        }
    }

    public Map<String, String> getColNumberToName() {
        if (this.colNumberToName == null) {
            this.colNumberToName = new HashMap<String, String>(16);
        }
        return new HashMap<String, String>(this.colNumberToName);
    }

    public void setColNumberToName(Map<String, String> colNumberToName) {
        this.colNumberToName = colNumberToName;
    }

    public List<String> getColsWithoutUnflooatMember() {
        List<String> list = this.getCols(false);
        this.getFloatdims().forEach(e -> {
            if (e.isFixMember()) {
                list.remove(e.getDimension().getNumber());
            }
        });
        return list;
    }

    public Map<String, List<Pair<Long, String>>> getEnumValueRangeMap() {
        if (this.enumValueRangeMap == null) {
            this.enumValueRangeMap = new HashMap<String, List<Pair<Long, String>>>(16);
        }
        return new HashMap<String, List<Pair<Long, String>>>(this.enumValueRangeMap);
    }

    public void setEnumValueRangeMap(Map<String, List<Pair<Long, String>>> enumValueRangeMap) {
        this.enumValueRangeMap = enumValueRangeMap;
    }

    public List<Long> getEnumValueRange(String number) {
        List<Pair<Long, String>> values = this.getEnumValueRangeMap().get(number);
        ArrayList<Long> ids = new ArrayList<Long>(16);
        if (values instanceof List && !values.isEmpty()) {
            values.forEach(p -> ids.add((Long)p.p1));
        }
        return ids;
    }

    public Map<String, String> getFixValueMap() {
        if (this.fixValueMap == null) {
            this.fixValueMap = new HashMap<String, String>(16);
        }
        return new HashMap<String, String>(this.fixValueMap);
    }

    public void setFixValueMap(Map<String, String> fixValueMap) {
        this.fixValueMap = fixValueMap;
    }

    public PositionInfo.FloatMemDisplayPattern getExt2DisplayPattern(String extNum) {
        if (this.ext2DisplayPattern == null) {
            this.ext2DisplayPattern = new HashMap<String, PositionInfo.FloatMemDisplayPattern>(16);
        }
        return this.ext2DisplayPattern.getOrDefault(extNum, PositionInfo.FloatMemDisplayPattern.NAMEANDNUMBER);
    }

    public void setExt2DisplayPattern(String extNum, PositionInfo.FloatMemDisplayPattern pattern) {
        if (this.ext2DisplayPattern == null) {
            this.ext2DisplayPattern = new HashMap<String, PositionInfo.FloatMemDisplayPattern>(16);
        }
        this.ext2DisplayPattern.put(extNum, pattern);
    }
}

