/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.formula;

import java.util.List;
import java.util.Stack;
import kd.fi.bcm.spread.formula.expr.Area3DExpr;
import kd.fi.bcm.spread.formula.expr.AreaExpr;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.BoolExpr;
import kd.fi.bcm.spread.formula.expr.EmptyArgExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.IntExpr;
import kd.fi.bcm.spread.formula.expr.NameExpr;
import kd.fi.bcm.spread.formula.expr.NumberExpr;
import kd.fi.bcm.spread.formula.expr.Ref3DExpr;
import kd.fi.bcm.spread.formula.expr.ReferenceExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;
import kd.fi.bcm.spread.formula.expr.UnaryOperationExpr;
import kd.fi.bcm.spread.formula.ptg.AddPtg;
import kd.fi.bcm.spread.formula.ptg.Area3DPtg;
import kd.fi.bcm.spread.formula.ptg.AreaPtg;
import kd.fi.bcm.spread.formula.ptg.BoolPtg;
import kd.fi.bcm.spread.formula.ptg.ConcatPtg;
import kd.fi.bcm.spread.formula.ptg.DividePtg;
import kd.fi.bcm.spread.formula.ptg.EmptyArgPtg;
import kd.fi.bcm.spread.formula.ptg.EqualPtg;
import kd.fi.bcm.spread.formula.ptg.FuncVarPtg;
import kd.fi.bcm.spread.formula.ptg.GreaterEqualPtg;
import kd.fi.bcm.spread.formula.ptg.GreaterThanPtg;
import kd.fi.bcm.spread.formula.ptg.IntPtg;
import kd.fi.bcm.spread.formula.ptg.LessEqualPtg;
import kd.fi.bcm.spread.formula.ptg.LessThanPtg;
import kd.fi.bcm.spread.formula.ptg.MultiplyPtg;
import kd.fi.bcm.spread.formula.ptg.NamePtg;
import kd.fi.bcm.spread.formula.ptg.NotEqualPtg;
import kd.fi.bcm.spread.formula.ptg.NumberPtg;
import kd.fi.bcm.spread.formula.ptg.OperationPtg;
import kd.fi.bcm.spread.formula.ptg.PercentPtg;
import kd.fi.bcm.spread.formula.ptg.PowerPtg;
import kd.fi.bcm.spread.formula.ptg.Ptg;
import kd.fi.bcm.spread.formula.ptg.Ref3DPtg;
import kd.fi.bcm.spread.formula.ptg.ReferencePtg;
import kd.fi.bcm.spread.formula.ptg.StringPtg;
import kd.fi.bcm.spread.formula.ptg.SubtractPtg;
import kd.fi.bcm.spread.formula.ptg.UnaryMinusPtg;
import kd.fi.bcm.spread.formula.ptg.UnaryPlusPtg;

public class ExcelFormulaParser {
    private final List<Object> tokens;

    public ExcelFormulaParser(List<Object> tokens) {
        this.tokens = tokens;
    }

    public Expression parse() throws Exception {
        if (this.tokens == null || 0 == this.tokens.size()) {
            return null;
        }
        Stack<Expression> stack = new Stack<Expression>();
        int numPtgs = this.tokens.size();
        for (int i = 0; i < numPtgs; ++i) {
            Ptg p;
            Expression e;
            Object object = this.tokens.get(i);
            if (object instanceof OperationPtg) {
                if (object instanceof AddPtg) {
                    this.buildBinaryOp(stack, 7);
                    continue;
                }
                if (object instanceof SubtractPtg) {
                    this.buildBinaryOp(stack, 8);
                    continue;
                }
                if (object instanceof MultiplyPtg) {
                    this.buildBinaryOp(stack, 5);
                    continue;
                }
                if (object instanceof DividePtg) {
                    this.buildBinaryOp(stack, 6);
                    continue;
                }
                if (object instanceof PowerPtg) {
                    this.buildBinaryOp(stack, 4);
                    continue;
                }
                if (object instanceof LessEqualPtg) {
                    this.buildBinaryOp(stack, 13);
                    continue;
                }
                if (object instanceof EqualPtg) {
                    this.buildBinaryOp(stack, 10);
                    continue;
                }
                if (object instanceof LessThanPtg) {
                    this.buildBinaryOp(stack, 14);
                    continue;
                }
                if (object instanceof NotEqualPtg) {
                    this.buildBinaryOp(stack, 15);
                    continue;
                }
                if (object instanceof GreaterEqualPtg) {
                    this.buildBinaryOp(stack, 11);
                    continue;
                }
                if (object instanceof GreaterThanPtg) {
                    this.buildBinaryOp(stack, 12);
                    continue;
                }
                if (object instanceof ConcatPtg) {
                    this.buildBinaryOp(stack, 9);
                    continue;
                }
                if (object instanceof FuncVarPtg) {
                    FunctionExpr bop = new FunctionExpr(((FuncVarPtg)object).getName());
                    int numOperands = ((FuncVarPtg)object).getNumberOfOperands();
                    for (int j = 0; j < numOperands; ++j) {
                        bop.getParameters().add(0, stack.pop());
                    }
                    stack.push(bop);
                    continue;
                }
                if (!(object instanceof UnaryMinusPtg) && !(object instanceof UnaryPlusPtg) && !(object instanceof PercentPtg)) continue;
                Expression expr = stack.pop();
                int type = 3;
                if (object instanceof UnaryPlusPtg) {
                    type = 1;
                } else if (object instanceof UnaryMinusPtg) {
                    type = 2;
                } else if (object instanceof PercentPtg) {
                    type = 3;
                }
                UnaryOperationExpr e2 = new UnaryOperationExpr(type);
                e2.setOperand(expr);
                stack.push(e2);
                continue;
            }
            if (object instanceof IntPtg) {
                e = new IntExpr();
                e.setValue(((IntPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof NumberPtg) {
                e = new NumberExpr(((NumberPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof StringPtg) {
                e = new StringExpr(((StringPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof BoolPtg) {
                e = new BoolExpr(((BoolPtg)object).getValue());
                stack.push(e);
                continue;
            }
            if (object instanceof AreaPtg) {
                p = (AreaPtg)object;
                AreaExpr exp = new AreaExpr(((AreaPtg)p).getFirstRow(), ((AreaPtg)p).getFirstColumn(), ((AreaPtg)p).getLastRow(), ((AreaPtg)p).getLastColumn());
                exp.setFirstColRel(((AreaPtg)p).isFirstColRelative());
                exp.setLastColRel(((AreaPtg)p).isLastColRelative());
                exp.setFirstRowRel(((AreaPtg)p).isFirstRowRelative());
                exp.setLastRowRel(((AreaPtg)p).isLastRowRelative());
                stack.push(exp);
                continue;
            }
            if (object instanceof ReferencePtg) {
                p = (ReferencePtg)object;
                ReferenceExpr exp = new ReferenceExpr();
                exp.col = ((ReferencePtg)p).getColumn();
                exp.row = ((ReferencePtg)p).getRow();
                exp.setColRel(((ReferencePtg)p).isColRelative());
                exp.setRowRel(((ReferencePtg)p).isRowRelative());
                stack.push(exp);
                continue;
            }
            if (object instanceof Area3DPtg) {
                p = (Area3DPtg)object;
                Area3DExpr exp = new Area3DExpr();
                exp.setSheetName(((Area3DPtg)p).getSheetName());
                AreaExpr area = new AreaExpr(((Area3DPtg)p).getFirstRow(), ((Area3DPtg)p).getFirstColumn(), ((Area3DPtg)p).getLastRow(), ((Area3DPtg)p).getLastColumn());
                area.setFirstColRel(((Area3DPtg)p).isFirstColRelative());
                area.setLastColRel(((Area3DPtg)p).isLastColRelative());
                area.setFirstRowRel(((Area3DPtg)p).isFirstRowRelative());
                area.setLastRowRel(((Area3DPtg)p).isLastRowRelative());
                exp.setArea(area);
                stack.push(exp);
                continue;
            }
            if (object instanceof Ref3DPtg) {
                p = (Ref3DPtg)object;
                Ref3DExpr expr = new Ref3DExpr();
                expr.setSheetName(((Ref3DPtg)p).getSheetName());
                ReferenceExpr ref = new ReferenceExpr();
                ref.row = ((Ref3DPtg)p).getRow();
                ref.col = ((Ref3DPtg)p).getColumn();
                ref.setColRel(((Ref3DPtg)p).isColRelative());
                ref.setRowRel(((Ref3DPtg)p).isRowRelative());
                expr.setRef(ref);
                stack.push(expr);
                continue;
            }
            if (object instanceof NamePtg) {
                stack.push(new NameExpr(((NamePtg)object).getText()));
                continue;
            }
            if (!(object instanceof EmptyArgPtg)) continue;
            stack.push(new EmptyArgExpr());
        }
        return (Expression)stack.pop();
    }

    public void buildBinaryOp(Stack<Expression> stack, int type) {
        BinaryOperationExpr bop = new BinaryOperationExpr(type);
        bop.setRight(stack.pop());
        bop.setLeft(stack.pop());
        stack.push(bop);
    }
}

