/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.formula;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import kd.fi.bcm.spread.formula.ParseException;
import kd.fi.bcm.spread.formula.ptg.AbstractFunctionPtg;
import kd.fi.bcm.spread.formula.ptg.AddPtg;
import kd.fi.bcm.spread.formula.ptg.Area3DPtg;
import kd.fi.bcm.spread.formula.ptg.AreaPtg;
import kd.fi.bcm.spread.formula.ptg.BoolPtg;
import kd.fi.bcm.spread.formula.ptg.ConcatPtg;
import kd.fi.bcm.spread.formula.ptg.DividePtg;
import kd.fi.bcm.spread.formula.ptg.EmptyArgPtg;
import kd.fi.bcm.spread.formula.ptg.EqualPtg;
import kd.fi.bcm.spread.formula.ptg.FuncVarPtg;
import kd.fi.bcm.spread.formula.ptg.GreaterEqualPtg;
import kd.fi.bcm.spread.formula.ptg.GreaterThanPtg;
import kd.fi.bcm.spread.formula.ptg.IntPtg;
import kd.fi.bcm.spread.formula.ptg.LessEqualPtg;
import kd.fi.bcm.spread.formula.ptg.LessThanPtg;
import kd.fi.bcm.spread.formula.ptg.MultiplyPtg;
import kd.fi.bcm.spread.formula.ptg.NamePtg;
import kd.fi.bcm.spread.formula.ptg.NotEqualPtg;
import kd.fi.bcm.spread.formula.ptg.NumberPtg;
import kd.fi.bcm.spread.formula.ptg.ParenthesisPtg;
import kd.fi.bcm.spread.formula.ptg.PercentPtg;
import kd.fi.bcm.spread.formula.ptg.PowerPtg;
import kd.fi.bcm.spread.formula.ptg.Ref3DPtg;
import kd.fi.bcm.spread.formula.ptg.ReferencePtg;
import kd.fi.bcm.spread.formula.ptg.StringPtg;
import kd.fi.bcm.spread.formula.ptg.SubtractPtg;
import kd.fi.bcm.spread.formula.ptg.UnaryMinusPtg;
import kd.fi.bcm.spread.formula.ptg.UnaryPlusPtg;

public class Parse2RPN {
    public static final char DONE = '\u0000';
    private String formulaString;
    private int pointer = 0;
    private int formulaLength;
    private List<Object> tokens = new Stack<Object>();
    private List<List<Object>> functionTokens = new LinkedList<List<Object>>();
    private static char TAB = (char)9;
    private char look;

    public Parse2RPN(String formula) {
        this.formulaString = formula;
        this.pointer = 0;
        this.formulaLength = this.formulaString.length();
    }

    private void GetChar() {
        if (this.pointer == this.formulaLength) {
            this.look = '\u0000';
            return;
        }
        this.look = this.formulaString.charAt(this.pointer++);
    }

    private void Error(String s) {
    }

    private void Abort(String s) throws ParseException {
        this.Error(s);
        throw new ParseException("Cannot Parse, sorry : " + s);
    }

    private void Expected(String s) throws ParseException {
        this.Abort(s + " Expected");
    }

    private boolean IsAlpha(char c) {
        return Character.isLetter(c) || c == '$';
    }

    private boolean IsDigit(char c) {
        return Character.isDigit(c);
    }

    private boolean IsAlNum(char c) {
        return this.IsAlpha(c) || this.IsDigit(c) || c == '_';
    }

    private boolean IsAddop(char c) {
        return c == '+' || c == '-';
    }

    private boolean IsWhite(char c) {
        return c == ' ' || c == TAB;
    }

    private void SkipWhite() {
        while (this.IsWhite(this.look)) {
            this.GetChar();
        }
    }

    private void Match(char x) throws ParseException {
        if (this.look != x) {
            this.Expected("" + x + "");
        } else {
            this.GetChar();
            this.SkipWhite();
        }
    }

    private String GetName() throws ParseException {
        StringBuilder Token = new StringBuilder();
        if (!this.IsAlpha(this.look) && this.look != '\'') {
            this.Expected("Name");
        }
        if (this.look == '\'') {
            boolean done;
            this.Match('\'');
            boolean bl = done = this.look == '\'';
            while (!done) {
                Token.append(Character.toUpperCase(this.look));
                this.GetChar();
                if (this.look != '\'') continue;
                this.Match('\'');
                done = this.look != '\'';
            }
        } else {
            while (this.IsAlNum(this.look) || this.isSBC_Case_Symbol(this.look)) {
                Token.append(Character.toUpperCase(this.look));
                this.GetChar();
            }
        }
        this.SkipWhite();
        return Token.toString();
    }

    private boolean isSBC_Case_Symbol(char c) {
        switch (c) {
            case '\u201c': 
            case '\u3001': 
            case '\uff03': 
            case '\uff04': 
            case '\uff05': 
            case '\uff06': 
            case '\uff07': 
            case '\uff08': 
            case '\uff09': 
            case '\uff0a': 
            case '\uff0b': 
            case '\uff0c': 
            case '\uff0d': 
            case '\uff0e': 
            case '\uff0f': 
            case '\uff1a': 
            case '\uff1b': 
            case '\uff1c': 
            case '\uff1d': 
            case '\uff1e': 
            case '\uff1f': 
            case '\uff20': 
            case '\uff3b': 
            case '\uff3d': 
            case '\uff3f': 
            case '\uff40': 
            case '\uff5b': 
            case '\uff5c': 
            case '\uff5d': 
            case '\uff5e': {
                return true;
            }
        }
        return false;
    }

    private String GetNum() throws ParseException {
        StringBuilder sb = new StringBuilder();
        if (!this.IsDigit(this.look)) {
            this.Expected("Integer");
        }
        while (this.IsDigit(this.look)) {
            sb.append(this.look);
            this.GetChar();
        }
        this.SkipWhite();
        return sb.toString();
    }

    private void Ident() throws ParseException {
        String name = this.GetName();
        if (this.look == '(') {
            this.function(name);
        } else if (this.look == ':') {
            String first = name;
            this.Match(':');
            String second = this.GetName();
            this.tokens.add(new AreaPtg(first + ":" + second));
        } else if (this.look == '!') {
            this.Match('!');
            String sheetName = name;
            String first = null;
            boolean isDigit = false;
            if (this.IsDigit(this.look)) {
                first = this.GetNum();
                isDigit = true;
            } else {
                first = this.GetName();
            }
            if (this.look == ':') {
                this.Match(':');
                String second = null;
                second = isDigit ? this.GetNum() : this.GetName();
                this.tokens.add(new Area3DPtg(first + ":" + second, sheetName));
            } else if (isDigit) {
                this.Abort("Error Reference");
            } else {
                this.tokens.add(new Ref3DPtg(first, sheetName));
            }
        } else {
            boolean boolLit;
            boolean bl = boolLit = name.equals("TRUE") || name.equals("FALSE");
            if (boolLit) {
                this.tokens.add(new BoolPtg(name));
            } else {
                boolean cellRef = this.isReference(name);
                if (cellRef) {
                    this.tokens.add(new ReferencePtg(name));
                } else if ("NULL".equals(name)) {
                    this.tokens.add(new NamePtg("null"));
                } else {
                    this.tokens.add(new NamePtg(name));
                }
            }
        }
    }

    private boolean isReference(String reference) {
        int loc;
        int start = reference.indexOf(33);
        char[] chars = reference.toCharArray();
        if (chars[loc = ++start] == '$') {
            ++loc;
        }
        boolean beNum = false;
        boolean isRef = true;
        boolean hasDigit = false;
        while (loc < chars.length) {
            if (!beNum && (Character.isDigit(chars[loc]) || chars[loc] == '$')) {
                beNum = true;
                hasDigit = true;
            } else {
                if (!(beNum || chars[loc] >= 'a' && chars[loc] <= 'z' || chars[loc] >= 'A' && chars[loc] <= 'Z')) {
                    isRef = false;
                    break;
                }
                if (beNum) {
                    if (!this.IsDigit(chars[loc])) {
                        isRef = false;
                        break;
                    }
                    hasDigit = true;
                }
            }
            ++loc;
        }
        if (!hasDigit && isRef) {
            isRef = false;
        }
        return isRef;
    }

    private void addArgumentPointer() {
        if (this.functionTokens.size() > 0) {
            List<Object> arguments = this.functionTokens.get(0);
            arguments.add(this.tokens.get(this.tokens.size() - 1));
        }
    }

    private void function(String name) throws ParseException {
        this.functionTokens.add(0, new ArrayList(2));
        this.Match('(');
        int numArgs = this.Arguments();
        this.Match(')');
        AbstractFunctionPtg functionPtg = this.getFunction(name, (byte)numArgs);
        this.tokens.add(functionPtg);
        if (functionPtg.getName().equals("externalflag")) {
            this.tokens.add(new NamePtg(name));
        }
        this.functionTokens.remove(0);
    }

    private AbstractFunctionPtg getFunction(String name, byte numArgs) {
        FuncVarPtg retval = null;
        retval = new FuncVarPtg(name, numArgs);
        return retval;
    }

    private int Arguments() throws ParseException {
        int numArgs = 0;
        if (this.look == ',') {
            this.tokens.add(new EmptyArgPtg());
            this.addArgumentPointer();
            ++numArgs;
        } else if (this.look != ')') {
            ++numArgs;
            this.Expression();
            this.addArgumentPointer();
        }
        while (this.look == ',' || this.look == ';') {
            if (this.look == ',') {
                this.Match(',');
                if (this.look == ',' || this.look == ')') {
                    this.tokens.add(new EmptyArgPtg());
                    this.addArgumentPointer();
                    ++numArgs;
                    continue;
                }
            } else {
                this.Match(';');
            }
            this.Expression();
            this.addArgumentPointer();
            ++numArgs;
        }
        return numArgs;
    }

    private void Factor() throws ParseException {
        if (this.look == '-') {
            this.Match('-');
            this.Factor();
            this.tokens.add(new UnaryMinusPtg());
        } else if (this.look == '+') {
            this.Match('+');
            this.Factor();
            this.tokens.add(new UnaryPlusPtg());
        } else if (this.look == '(') {
            this.Match('(');
            this.Expression();
            this.Match(')');
            this.tokens.add(new ParenthesisPtg());
        } else if (this.IsAlpha(this.look) || this.look == '\'') {
            this.Ident();
        } else if (this.look == '\"') {
            this.StringLiteral();
        } else if ('\u0000' != this.look) {
            String number = this.GetNum();
            if (this.look == '.') {
                this.Match('.');
                if (this.IsDigit(this.look)) {
                    number = number + "." + this.GetNum();
                }
                this.tokens.add(new NumberPtg(number));
            } else if (this.look == ':') {
                this.Match(':');
                String number2 = this.GetNum();
                this.tokens.add(new AreaPtg(number + ':' + number2));
            } else {
                this.tokens.add(new IntPtg(number));
            }
        }
    }

    private void StringLiteral() throws ParseException {
        if (this.look != '\"') {
            this.Expected("\"");
        } else {
            this.GetChar();
            StringBuilder Token = new StringBuilder();
            while (true) {
                if (this.look == '\"') {
                    this.GetChar();
                    this.SkipWhite();
                    if (this.look != '\"') break;
                    Token.append('\"');
                    this.GetChar();
                    continue;
                }
                if (this.look == '\u0000') {
                    this.Expected("\"");
                    break;
                }
                Token.append(this.look);
                this.GetChar();
            }
            this.tokens.add(new StringPtg(Token.toString()));
        }
    }

    private void Multiply() throws ParseException {
        this.Match('*');
        this.PowerTerm();
        this.tokens.add(new MultiplyPtg());
    }

    private void Divide() throws ParseException {
        this.Match('/');
        this.PowerTerm();
        this.tokens.add(new DividePtg());
    }

    private void PowerTerm() throws ParseException {
        this.PercentTerm();
        if (this.look == '^') {
            this.Power();
        }
    }

    private void Term() throws ParseException {
        this.PowerTerm();
        while (this.look == '*' || this.look == '/') {
            if (this.look == '*') {
                this.Multiply();
                continue;
            }
            if (this.look != '/') continue;
            this.Divide();
        }
    }

    private void Add() throws ParseException {
        this.Match('+');
        this.Term();
        this.tokens.add(new AddPtg());
    }

    private void Concat() throws ParseException {
        this.Match('&');
        this.AddopTerm();
        this.tokens.add(new ConcatPtg());
    }

    private void Equal() throws ParseException {
        this.Match('=');
        this.Expression();
        this.tokens.add(new EqualPtg());
    }

    private void Subtract() throws ParseException {
        this.Match('-');
        this.Term();
        this.tokens.add(new SubtractPtg());
    }

    private void Power() throws ParseException {
        this.Match('^');
        this.PercentTerm();
        this.tokens.add(new PowerPtg());
    }

    private void PercentTerm() throws ParseException {
        this.Factor();
        if (this.look == '%') {
            this.Percent();
        }
    }

    private void Percent() throws ParseException {
        this.Match('%');
        this.tokens.add(new PercentPtg());
    }

    private void AddopTerm() throws ParseException {
        this.Term();
        while (this.IsAddop(this.look)) {
            if (this.look == '+') {
                this.Add();
                continue;
            }
            if (this.look != '-') continue;
            this.Subtract();
        }
    }

    private void ContactTerm() throws ParseException {
        this.AddopTerm();
        while (this.look == '&') {
            this.Concat();
        }
    }

    private void Expression() throws ParseException {
        this.ContactTerm();
        if (this.look == '=' || this.look == '>' || this.look == '<') {
            if (this.look == '=') {
                this.Equal();
            } else if (this.look == '>') {
                this.GreaterThan();
            } else if (this.look == '<') {
                this.LessThan();
            }
        }
    }

    private void GreaterThan() throws ParseException {
        this.Match('>');
        if (this.look == '=') {
            this.GreaterEqual();
        } else {
            this.Expression();
            this.tokens.add(new GreaterThanPtg());
        }
    }

    private void LessThan() throws ParseException {
        this.Match('<');
        if (this.look == '=') {
            this.LessEqual();
        } else if (this.look == '>') {
            this.NotEqual();
        } else {
            this.Expression();
            this.tokens.add(new LessThanPtg());
        }
    }

    private void GreaterEqual() throws ParseException {
        this.Match('=');
        this.Expression();
        this.tokens.add(new GreaterEqualPtg());
    }

    private void LessEqual() throws ParseException {
        this.Match('=');
        this.Expression();
        this.tokens.add(new LessEqualPtg());
    }

    private void NotEqual() throws ParseException {
        this.Match('>');
        this.Expression();
        this.tokens.add(new NotEqualPtg());
    }

    private void init() {
        this.GetChar();
        this.SkipWhite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws ParseException {
        List<Object> list = this.tokens;
        synchronized (list) {
            this.init();
            this.Expression();
            if (this.look != '\u0000') {
                this.Abort("Error of end");
            }
        }
    }

    public List<Object> getTokens() {
        return this.tokens;
    }
}

