/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.formula.expr;

import kd.fi.bcm.spread.formula.ICustomerFormat;
import kd.fi.bcm.spread.formula.expr.Expression;

public class StringExpr
extends Expression {
    private String value;

    public StringExpr(String value) {
        this.value = value;
    }

    @Override
    public void output(StringBuffer buffer, ICustomerFormat cc) {
        if (cc != null) {
            cc.beforeOutput(this, buffer);
        }
        if (cc == null) {
            buffer.append('\"');
            for (int i = 0; i < this.value.length(); ++i) {
                char c = this.value.charAt(i);
                buffer.append(this.value.charAt(i));
                if (c != '\"') continue;
                buffer.append('\"');
            }
            buffer.append('\"');
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            for (int i = 0; i < this.value.length(); ++i) {
                char c = this.value.charAt(i);
                sb.append(this.value.charAt(i));
                if (c != '\"') continue;
                sb.append('\"');
            }
            sb.append('\"');
            buffer.append(cc.formatOP(sb.toString()));
        }
        if (cc != null) {
            cc.afterOutput(this, buffer);
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

