/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.formula.expr;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.fi.bcm.spread.formula.ICodeSupplier;
import kd.fi.bcm.spread.formula.ICustomerFormat;
import kd.fi.bcm.spread.formula.IValueSupplier;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.IntExpr;
import kd.fi.bcm.spread.formula.expr.NumberExpr;
import kd.fi.bcm.spread.formula.expr.OperationExpr;

public class UnaryOperationExpr
extends OperationExpr {
    private Expression operand;

    public UnaryOperationExpr(int type) {
        if (type != 1 && type != 2 && type != 3) {
            throw new RuntimeException("Unsupported unary operation type :" + type);
        }
        this.setOperationType(type);
    }

    @Override
    public void output(StringBuffer buffer, ICustomerFormat c) {
        if (c != null) {
            c.beforeOutput(this, buffer);
        }
        if (this.getOperationType() == 1) {
            buffer.append('+');
        } else if (this.getOperationType() == 2) {
            buffer.append('-');
        }
        if (this.operand instanceof OperationExpr) {
            buffer.append('(');
        }
        this.operand.output(buffer, c);
        if (this.operand instanceof OperationExpr) {
            buffer.append(')');
        }
        if (this.getOperationType() == 3) {
            buffer.append('%');
        }
        if (c != null) {
            c.afterOutput(this, buffer);
        }
    }

    @Override
    public void outputCalcuteExpr(StringBuffer buffer, IValueSupplier<String, ?> s) {
        if (this.getOperationType() == 1) {
            buffer.append('+');
        } else if (this.getOperationType() == 2) {
            buffer.append('-');
        }
        if (this.operand instanceof OperationExpr) {
            buffer.append('(');
        }
        this.operand.outputCalcuteExpr(buffer, s);
        if (this.operand instanceof OperationExpr) {
            buffer.append(')');
        }
        if (this.getOperationType() == 3) {
            buffer.append('%');
        }
    }

    @Override
    public void outputEncodeExpr(StringBuffer buffer, ICodeSupplier s) {
        if (this.getOperationType() == 3) {
            if (this.operand instanceof NumberExpr) {
                buffer.append(new BigDecimal(this.operand.toString()).divide(new BigDecimal("100"), this.operand.toString().length() + 2, RoundingMode.HALF_UP));
            }
            if (this.operand instanceof IntExpr) {
                buffer.append(new BigDecimal(((IntExpr)IntExpr.class.cast(this.operand)).getValue().toString()).divide(new BigDecimal("100"), ((IntExpr)IntExpr.class.cast(this.operand)).getValue().toString().length() + 2, RoundingMode.HALF_UP));
            }
            return;
        }
        if (this.getOperationType() == 1) {
            buffer.append('+');
        } else if (this.getOperationType() == 2) {
            buffer.append('-');
        }
        if (this.operand instanceof OperationExpr) {
            buffer.append('(');
        }
        this.operand.outputEncodeExpr(buffer, s);
        if (this.operand instanceof OperationExpr) {
            buffer.append(')');
        }
        if (this.getOperationType() == 3) {
            buffer.append('%');
        }
    }

    public Expression getOperand() {
        return this.operand;
    }

    public void setOperand(Expression operand) {
        this.operand = operand;
    }
}

