/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.workpaper.DimensionMemberDisplayTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class HeadObject
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private transient int index;
    private Map<String, Map<String, Object>> allMemberMap;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int size() {
        return this.getAllMemberMap().size();
    }

    public Map<String, Map<String, Object>> getAllMemberMap() {
        if (this.allMemberMap == null) {
            this.allMemberMap = new HashMap<String, Map<String, Object>>(16);
        }
        return this.allMemberMap;
    }

    public Map<String, Object> getSingleDimMember(String dimNum) {
        HashMap map = this.getAllMemberMap().get(dimNum);
        return map == null ? new HashMap(16) : map;
    }

    public void addMember(String dimNum, Map<String, Object> member) {
        this.getAllMemberMap().put(dimNum, member);
    }

    public String getMemberName(String dimNum) {
        return (String)this.getSingleDimMember(dimNum).getOrDefault("memName", "");
    }

    public String getMemberNum(String dimNum) {
        return this.getMemberNum(dimNum, this.getSingleDimMember(dimNum), true);
    }

    public String getMemberNum(String dimNum, Map<String, Object> map, boolean isParSon) {
        if (map.get("number") != null) {
            if (DimTypesEnum.ENTITY.getNumber().equals(dimNum) && map.get("parentNum") != null && isParSon) {
                return map.get("parentNum") + "_" + map.get("number");
            }
            return (String)map.get("number");
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u7f3a\u5931\u884c\u5217\u5934\u6210\u5458", (String)"HeadObject_0", (String)"fi-bcm-common", (Object[])new Object[0]), dimNum));
    }

    public boolean isLeaf(String dimNum) {
        return (Boolean)this.getSingleDimMember(dimNum).getOrDefault("isleaf", true);
    }

    public long getMemberId(String dimNum) {
        return (Long)this.getSingleDimMember(dimNum).getOrDefault("id", 0L);
    }

    public String getShowValue(String showType, String dimNum) {
        return this.getShowValue(DimensionMemberDisplayTypeEnum.getEnumByItemKey(showType), dimNum, true, true);
    }

    public String getShowValue(DimensionMemberDisplayTypeEnum typeEnum, String dimNum, boolean isMDQA, boolean isParSon) {
        String displayContent;
        Map<String, Object> map = this.getSingleDimMember(dimNum);
        if (map.isEmpty()) {
            return null;
        }
        String showType = (String)map.getOrDefault("showType", "");
        if (map.get("msv") != null && showType.equals(typeEnum.getIndex() + "")) {
            return (String)map.get("msv");
        }
        map.put("showType", typeEnum.getIndex() + "");
        switch (typeEnum) {
            case NUMBER: {
                displayContent = this.getMemberNum(dimNum, map, isParSon);
                break;
            }
            case NAME: {
                displayContent = (String)map.getOrDefault("memName", "");
                break;
            }
            case SIMPLE: {
                displayContent = this.getSimpleName(map);
                break;
            }
            case NUMBERANDSIMPLE: {
                displayContent = this.getMemberNum(dimNum, map, isParSon) + " " + this.getSimpleName(map);
                break;
            }
            default: {
                displayContent = this.getMemberNum(dimNum, map, isParSon) + " " + map.getOrDefault("memName", "");
            }
        }
        if (isMDQA && !((Boolean)map.getOrDefault("isleaf", true)).booleanValue()) {
            displayContent = "+  " + displayContent;
        }
        map.put("msv", displayContent);
        return displayContent;
    }

    private String getSimpleName(Map<String, Object> map) {
        String simpleName = (String)map.getOrDefault("simplename", "");
        if (StringUtils.isEmpty((CharSequence)simpleName)) {
            simpleName = (String)map.getOrDefault("memName", "");
        }
        return simpleName;
    }

    public List<String> getCombineList(List<String> dims) {
        ArrayList<String> list = new ArrayList<String>(16);
        dims.forEach((? super T e) -> list.add(this.getMemberNum((String)e)));
        return list;
    }

    public Map<String, String> getCombineMap(List<String> dims) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
        dims.forEach((? super T s) -> map.put((String)s, this.getMemberNum((String)s)));
        return map;
    }

    public Map<String, Pair<String, String>> getNumberNameMap(List<String> dims) {
        LinkedHashMap<String, Pair<String, String>> map = new LinkedHashMap<String, Pair<String, String>>(16);
        dims.forEach((? super T s) -> map.put((String)s, Pair.onePair(this.getMemberNum((String)s), this.getMemberName((String)s))));
        return map;
    }
}

