/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.spread.model;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.util.StringUtils;
import kd.fi.bcm.common.util.ToStringHelper;
import kd.fi.bcm.spread.domain.Cell;
import kd.fi.bcm.spread.model.DimMember;
import kd.fi.bcm.spread.model.Dimension;
import kd.fi.bcm.spread.model.IDimMember;

public class UserObject
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;

    public UserObject(int size) {
        super(size);
    }

    public UserObject() {
        this(0);
    }

    public Object getUserObject(String key) {
        return this.get(key);
    }

    public void setUserObject(String key, Object val) {
        this.put(key, val);
    }

    public void clearAllUserObject() {
        this.clear();
    }

    public void addDim2UserObject(IDimMember dim) {
        if (!this.containsKey("KEY_DIM_FLAG")) {
            this.put("KEY_DIM_FLAG", new ArrayList());
        }
        ((List)this.get("KEY_DIM_FLAG")).add(dim);
    }

    public void addExt2UserObject(Object dim) {
        this.put("KEY_EXT_FLAG", dim);
    }

    public List<IDimMember> getMemberFromUserObject() {
        return (List)this.get("KEY_DIM_FLAG");
    }

    public void copyDimMember2UserObject(Cell other) {
        if (other != null && other.getUserObject("KEY_DIM_FLAG") != null) {
            List<IDimMember> members = other.getMemberFromUserObject();
            if (!this.containsKey("KEY_DIM_FLAG")) {
                ArrayList dims = new ArrayList();
                this.put("KEY_DIM_FLAG", dims);
            }
            this.getMemberFromUserObject().addAll(members);
        }
    }

    public void setAssistDim(List<IDimMember> dims) {
        this.put("DIM_ASSIST", UserObject.formatDimMember(dims));
    }

    public void setHasRedirectMem(boolean hasRedirectMem) {
        if (hasRedirectMem) {
            this.put("MEMB_HASREDIRECT", hasRedirectMem);
        } else {
            this.remove("MEMB_HASREDIRECT", hasRedirectMem);
        }
    }

    public boolean hasRedirectMem() {
        return this.get("MEMB_HASREDIRECT") != null;
    }

    public List<IDimMember> getAssistDim() {
        String serial = (String)this.get("DIM_ASSIST");
        ArrayList<IDimMember> members = new ArrayList<IDimMember>(2);
        if (StringUtils.isNotEmpty((String)serial)) {
            String[] dimSplits;
            for (String s : dimSplits = serial.split(";")) {
                String[] membSplits = s.split("\\|");
                Dimension d = new Dimension(null, membSplits[0], "");
                DimMember m = new DimMember(null, membSplits[1], null, d);
                members.add(m);
            }
        }
        return members;
    }

    public static String formatDimMember(List<IDimMember> dims) {
        Objects.requireNonNull(dims);
        return Joiner.on((char)';').join((Iterable)Lists.transform(dims, d -> UserObject.formatDimMember(d)));
    }

    public static String formatDimMember(IDimMember d) {
        return d.getDimension().getNumber() + '|' + d.getNumber();
    }

    @Override
    public String toString() {
        return ToStringHelper.deepToString(this);
    }
}

