/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.Metric;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.google.common.util.concurrent.RateLimiter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.proxy.Interceptor;
import net.sf.cglib.proxy.MethodProxy;

public class ServiceProxyHelper {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ServiceProxyHelper.class);
    private static final Map<String, Metric> metrics = new MemoryUsageGaugeSet().getMetrics();
    private static RateLimiter limiter = RateLimiter.create((double)50.0);

    public static <T> T proxyService(final Object target) {
        Interceptor proxy = new Interceptor(target, null){

            public Object intercept(Object targetObj, Method method, Object[] args, MethodProxy arg3) throws Throwable {
                Object result;
                Pair<Integer, Float> config = ServiceProxyHelper.getServiceLimit();
                if ((Integer)config.p1 <= 0 || !Modifier.isPublic(method.getModifiers())) {
                    return method.invoke(target, args);
                }
                long start = System.currentTimeMillis();
                ServiceProxyHelper.checkLimiter((Integer)config.p1);
                limiter.acquire();
                try (TraceSpan span = Tracer.create((String)"mservice", (String)"bcm.mservice");){
                    int retry = 0;
                    String serviceName = targetObj.getClass().getSuperclass().getName();
                    while (retry++ < 5 && ServiceProxyHelper.jvmLimit(((Float)config.p2).floatValue())) {
                        log.warn(String.format("mservice\uff1a[%s] the %s times retry.", serviceName, retry));
                        TimeUnit.SECONDS.sleep(2L);
                    }
                    result = method.invoke(target, args);
                    long costTime = System.currentTimeMillis() - start - (long)((retry - 1) * 2000);
                    if (costTime >= 5000L) {
                        log.warn(String.format("mservice: %s invoke end,cost time: %s ms.", serviceName, costTime));
                    }
                }
                return result;
            }
        };
        return (T)proxy.createProxy();
    }

    private static boolean jvmLimit(float percent) {
        return ((RatioGauge)metrics.get("heap.usage")).getValue() > (double)percent;
    }

    public static Pair<Integer, Float> getServiceLimit() {
        try {
            JSONObject param = ConfigServiceHelper.getJsonParamNoModel((String)"PermitServiceLimit");
            if (param == null) {
                return Pair.onePair((Object)0, (Object)Float.valueOf(0.9f));
            }
            return Pair.onePair((Object)Integer.parseInt(param.getString("limit")), (Object)Float.valueOf(Float.parseFloat(param.getString("percent"))));
        }
        catch (Exception ex) {
            return Pair.onePair((Object)0, (Object)Float.valueOf(0.9f));
        }
    }

    private static void checkLimiter(int permitsPerSecond) {
        if (permitsPerSecond > 0 && limiter.getRate() != (double)permitsPerSecond) {
            limiter.setRate((double)permitsPerSecond);
        }
    }
}

