/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.integration.util.IntergrationUtil;
import kd.fi.bcm.business.model.formula.AcctFormulaModel;
import kd.fi.bcm.service.AcctGetDataService;

public class AcctGetDataServiceImpl
implements AcctGetDataService {
    public Map<String, Object> SearchData(Map<String, Object> parameters) {
        List queryData;
        QFilter periodTypeFilter;
        QFilter periodFilter;
        HashMap<String, Object> backData = new HashMap<String, Object>();
        int year = (Integer)parameters.get("year");
        int period = (Integer)parameters.get("period");
        String orgId = String.valueOf(parameters.get("entity"));
        String orgNum = String.valueOf(parameters.get("orgNum"));
        String orgName = String.valueOf(parameters.get("orgName"));
        String accountNum = String.valueOf(parameters.get("datasource"));
        String fetchType = this.matchFetchType(String.valueOf(parameters.get("datatype")));
        QFilter f1 = new QFilter("org.id", "=", (Object)orgId);
        QFilter f2 = new QFilter("bookstype.accounttype", "=", (Object)"1");
        DynamicObject book = QueryServiceHelper.queryOne((String)IntergrationUtil.getAccountBookMetadataNumber(), (String)"basecurrency.number,basecurrency.name,periodType,bookstype.number,accounttable.id,accounttable.masterid", (QFilter[])new QFilter[]{f1, f2});
        if (book == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"AIFS\u7684\u201c%s\u201d\u7ec4\u7ec7\u6ca1\u6709\u8bbe\u7f6e\u542f\u52a8\u671f\u95f4\u3002", (String)"AcctGetDataServiceImpl_0", (String)"fi-bcm-mservice", (Object[])new Object[0]), orgName));
        }
        String bookTypeNum = book.getString("bookstype.number");
        String currencyNum = book.getString("basecurrency.number");
        String currencyName = book.getString("basecurrency.name");
        QFilter fyFilter = new QFilter("periodyear", "=", (Object)year);
        DynamicObject periodGL = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fyFilter, periodFilter = new QFilter("periodnumber", "=", (Object)period), periodTypeFilter = new QFilter("periodtype", "=", (Object)book.getLong("periodType"))});
        if (periodGL == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"AIFS\u7684\u201c%s\u201d\u7ec4\u7ec7\u6ca1\u6709\u8bbe\u7f6e\u542f\u52a8\u671f\u95f4\u3002", (String)"AcctGetDataServiceImpl_0", (String)"fi-bcm-mservice", (Object[])new Object[0]), orgName));
        }
        Object[] searchParam = new Object[]{orgNum, bookTypeNum, accountNum, fetchType, year, period, currencyNum};
        String param = "";
        try {
            String str1 = JSONUtils.toString((Object)searchParam);
            param = "acct(" + str1.substring(1, str1.length() - 1) + ")";
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        AcctFormulaModel acctFormula = new AcctFormulaModel(param);
        acctFormula.setPeriodId(periodGL.getLong("id"));
        acctFormula.setAccountNumber(accountNum);
        acctFormula.getAccountItem(book.getLong("accounttable.masterid"), Long.parseLong(orgId));
        if (!acctFormula.check(false) && !(queryData = acctFormula.query()).isEmpty()) {
            String fetchField = acctFormula.getFetchField();
            Double data = (Double)((Map)queryData.get(0)).get(fetchField);
            BigDecimal value = BigDecimal.valueOf(data);
            if (value.compareTo(BigDecimal.ZERO) == 0) {
                backData.put("data", value);
                backData.put("currency", currencyName);
            }
        }
        return backData;
    }

    public String matchFetchType(String value) {
        String fetchType = null;
        switch (value) {
            case "1": {
                fetchType = "JF";
                break;
            }
            case "2": {
                fetchType = "DF";
                break;
            }
            case "3": {
                fetchType = "JL";
                break;
            }
            case "4": {
                fetchType = "DL";
                break;
            }
            case "5": {
                fetchType = "JF";
                break;
            }
            case "6": {
                fetchType = "DF";
                break;
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"AIFS\u4e0d\u5b58\u5728\u8be5\u53d6\u6570\u7c7b\u578b\u3002", (String)"AcctGetDataServiceImpl_1", (String)"fi-bcm-mservice", (Object[])new Object[0]));
            }
        }
        return fetchType;
    }
}

