/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.adjust.check.AdjustClearServiceHelper;
import kd.fi.bcm.business.adjust.model.AdjustBatchCreateParam;
import kd.fi.bcm.business.adjust.operation.AdjRecordLog;
import kd.fi.bcm.business.adjust.operation.AdjustAutoAuditOperation;
import kd.fi.bcm.business.adjust.operation.AdjustBatchOrgTreeNodeThreadExcute;
import kd.fi.bcm.business.adjust.operation.AdjustCopyOperation;
import kd.fi.bcm.business.adjust.operation.AdjustOperationContext;
import kd.fi.bcm.business.adjust.operation.AdjustOperationThreadHelper;
import kd.fi.bcm.business.adjust.task.batchOperationTask.AdjustOperTaskSchedulePlan;
import kd.fi.bcm.business.adjust.util.AdjustOperationHelper;
import kd.fi.bcm.business.dimension.datalock.LockScopeServiceHelper;
import kd.fi.bcm.business.dimension.helper.CslSchemeServiceHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.dimension.OrgTreeNode;
import kd.fi.bcm.common.adjust.AdjustModelParser;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.adjust.AdjustOperTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.service.AdjustMsService;
import kd.fi.bcm.service.UserParam;
import org.apache.commons.lang3.tuple.Pair;

public class AdjustMsServiceImpl
implements AdjustMsService {
    public static WatchLogger log = BcmLogFactory.getWatchLogInstance(AdjustMsServiceImpl.class);
    public static final String SUCCESSCOUNT = "successCount";
    public static final String BILLCOUNT = "billCount";
    public static final String ERRORMSG = "errorMsg";
    public static final String DETAILMSG = "detailMsg";

    private Map<String, Object> createReturnMap(OperationResult op) {
        if (op == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        returnMap.put(SUCCESSCOUNT, op.getSuccessPkIds().size());
        returnMap.put(BILLCOUNT, op.getBillCount());
        returnMap.put(ERRORMSG, op.getMessage());
        returnMap.put(DETAILMSG, JSON.toJSONString((Object)op));
        return returnMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> continueEntry(Map<String, Object> parameters) {
        OperationResult op = new OperationResult();
        UserParam userParam = new UserParam(parameters);
        AdjRecordLog log = null;
        AdjustmentServiceHelper.checkPermission((long)userParam.getModel(), (String)"bcm_rptadjust_list", (String)"13X65LZQ=RM/");
        Set continueOrgScope = (Set)userParam.getProperty("continueOrgScope");
        AdjustOperationContext _ctx = new AdjustOperationContext(userParam.getModel().longValue(), userParam.getScenario().longValue(), userParam.getYear().longValue(), userParam.getPeriod().longValue());
        try {
            Map userDefineParam = MapInitHelper.ofMap((Object)"specialFirstPeriod", (Object)userParam.getProperty("specialFirstPeriod"), (Object)"specialLastPeriod", (Object)userParam.getProperty("specialLastPeriod"));
            log = AdjustOperTaskSchedulePlan.dispatchContinueTaskSync((AdjustOperationContext)_ctx, (AdjustOperTypeEnum)AdjustOperTypeEnum.PERIODCONTINUEOPERATION, (Set)continueOrgScope, (Map)userDefineParam);
        }
        catch (Throwable t) {
            op.setMessage("" + AdjustmentServiceHelper.toString_Adj((Throwable)t));
            op.setSuccess(false);
        }
        finally {
            if (log != null) {
                log.endLog();
                op.mergeOperateResult(log.toOperationResult());
            }
        }
        AdjRecordLog adjLog = null;
        try {
            adjLog = AdjustOperTaskSchedulePlan.dispatchContinueTaskSync((AdjustOperationContext)_ctx, (AdjustOperTypeEnum)AdjustOperTypeEnum.YEARCONTINUEOPERATION, (Set)continueOrgScope, (Map)Maps.newHashMap());
        }
        catch (Throwable t) {
            op.setMessage(AdjustmentServiceHelper.toString_Adj((Throwable)t));
            op.setSuccess(false);
        }
        finally {
            if (adjLog != null) {
                adjLog.endLog();
                op.mergeOperateResult(adjLog.toOperationResult());
            }
        }
        return this.createReturnMap(op);
    }

    public Map<String, Object> audit(Map<String, Object> parameters) {
        OperationResult op = null;
        UserParam userParam = new UserParam(parameters);
        try {
            AdjustmentServiceHelper.checkPermission((long)userParam.getModel(), (String)"bcm_rptadjust_list", (String)"47162f66000000ac");
            String sceneNum = MemberReader.findScenaMemberById((Long)userParam.getModel(), (Long)userParam.getScenario()).getNumber();
            String yearNum = MemberReader.findScenaMemberById((Long)userParam.getModel(), (Long)userParam.getYear()).getNumber();
            String periodNum = MemberReader.findScenaMemberById((Long)userParam.getModel(), (Long)userParam.getPeriod()).getNumber();
            if (LockScopeServiceHelper.isExistArchiving((long)userParam.getModel(), (String)sceneNum, (String)yearNum, (String)periodNum)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u8d22\u5e74\u671f\u95f4%1$s_%2$s_%3$s\u7684\u5206\u9636\u6bb5\u9501\u5b9a\u5df2\u5728\u667a\u80fd\u5408\u5e76\u5f52\u6863\uff0c\u8bf7\u53cd\u5f52\u6863\u540e\u518d\u64cd\u4f5c\u3002", (String)"AdjustMsServiceImpl_2", (String)"fi-bcm-mservice", (Object[])new Object[0]), sceneNum, yearNum, periodNum));
            }
            DynamicObject record = AdjustOperationThreadHelper.createAdjustOperRecord((AdjustOperTypeEnum)AdjustOperTypeEnum.COPYOPERATION, (long)userParam.getModel(), (long)userParam.getScenario(), (long)userParam.getYear(), (long)userParam.getPeriod(), (int)userParam.getPkList().size());
            AdjustOperationContext ctx = new AdjustOperationContext(userParam.getModel().longValue(), userParam.getScenario().longValue(), userParam.getYear().longValue(), userParam.getPeriod().longValue());
            AdjustAutoAuditOperation flowOperation = new AdjustAutoAuditOperation(ctx, userParam.getPkList());
            flowOperation.getAdjLog().loadRecord(record, this.getClass().getName());
            flowOperation.excute();
            flowOperation.getAdjLog().endLog();
            op = flowOperation.getOperationResult();
        }
        catch (Throwable t) {
            op = new OperationResult();
            op.setBillCount(userParam.getPkList().size());
            op.setMessage(AdjustmentServiceHelper.toString_Adj((Throwable)t));
            op.setSuccess(false);
        }
        return this.createReturnMap(op);
    }

    public Map<String, Object> copy(Map<String, Object> parameters) {
        OperationResult op = null;
        UserParam userParam = new UserParam(parameters);
        try {
            AdjustmentServiceHelper.checkPermission((long)userParam.getModel(), (String)"bcm_rptadjust_list", (String)"4730fc9f000020ae");
            DynamicObject record = AdjustOperationThreadHelper.createAdjustOperRecord((AdjustOperTypeEnum)AdjustOperTypeEnum.COPYOPERATION, (long)userParam.getModel(), (long)userParam.getScenario(), (long)userParam.getYear(), (long)userParam.getPeriod(), (int)userParam.getPkList().size());
            AdjustCopyOperation copyOperation = new AdjustCopyOperation(userParam.getModel(), userParam.getScenario(), userParam.getYear(), userParam.getPeriod(), userParam.getPkList(), false);
            copyOperation.getAdjLog().loadRecord(record, this.getClass().getName());
            copyOperation.excute();
            copyOperation.getAdjLog().endLog();
            op = copyOperation.getOperationResult();
        }
        catch (Throwable t) {
            op = new OperationResult();
            op.setBillCount(userParam.getPkList().size());
            op.setMessage(AdjustmentServiceHelper.toString_Adj((Throwable)t));
            op.setSuccess(false);
        }
        return this.createReturnMap(op);
    }

    public Map<String, Object> deleteAutoEntry(Map<String, Object> parameters) {
        OperationResult op = null;
        UserParam userParam = new UserParam(parameters);
        try {
            String sceneNum = MemberReader.findScenaMemberById((Long)userParam.getModel(), (Long)userParam.getScenario()).getNumber();
            String yearNum = MemberReader.findScenaMemberById((Long)userParam.getModel(), (Long)userParam.getYear()).getNumber();
            String periodNum = MemberReader.findScenaMemberById((Long)userParam.getModel(), (Long)userParam.getPeriod()).getNumber();
            if (LockScopeServiceHelper.isExistArchiving((long)userParam.getModel(), (String)sceneNum, (String)yearNum, (String)periodNum)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u8d22\u5e74\u671f\u95f4%1$s_%2$s_%3$s\u7684\u5206\u9636\u6bb5\u9501\u5b9a\u5df2\u5728\u667a\u80fd\u5408\u5e76\u5f52\u6863\uff0c\u8bf7\u53cd\u5f52\u6863\u540e\u518d\u64cd\u4f5c\u3002", (String)"AdjustMsServiceImpl_2", (String)"fi-bcm-mservice", (Object[])new Object[0]), sceneNum, yearNum, periodNum));
            }
            AdjustmentServiceHelper.checkPermission((long)userParam.getModel(), (String)"bcm_rptadjust_list", (String)"4715e1f1000000ac");
            op = AdjustClearServiceHelper.batchDeleteAutoAdjust((String)this.getClass().getName(), (long)userParam.getModel(), (long)userParam.getScenario(), (long)userParam.getYear(), (long)userParam.getPeriod(), userParam.getPkList());
        }
        catch (Throwable t) {
            op = new OperationResult();
            op.setBillCount(userParam.getPkList().size());
            op.setMessage(AdjustmentServiceHelper.toString_Adj((Throwable)t));
            op.setSuccess(false);
        }
        return this.createReturnMap(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> createAutoAdjust(Map<String, Object> parameters) {
        OperationResult op = null;
        DynamicObject record = null;
        HashSet orgNumSet = new HashSet(16);
        AdjRecordLog log = new AdjRecordLog();
        UserParam userParam = new UserParam(parameters);
        try {
            String sceneNum = MemberReader.findScenaMemberById((Long)userParam.getModel(), (Long)userParam.getScenario()).getNumber();
            String yearNum = MemberReader.findScenaMemberById((Long)userParam.getModel(), (Long)userParam.getYear()).getNumber();
            String periodNum = MemberReader.findScenaMemberById((Long)userParam.getModel(), (Long)userParam.getPeriod()).getNumber();
            if (LockScopeServiceHelper.isExistArchiving((long)userParam.getModel(), (String)sceneNum, (String)yearNum, (String)periodNum)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u8d22\u5e74\u671f\u95f4%1$s_%2$s_%3$s\u7684\u5206\u9636\u6bb5\u9501\u5b9a\u5df2\u5728\u667a\u80fd\u5408\u5e76\u5f52\u6863\uff0c\u8bf7\u53cd\u5f52\u6863\u540e\u518d\u64cd\u4f5c\u3002", (String)"AdjustMsServiceImpl_2", (String)"fi-bcm-mservice", (Object[])new Object[0]), sceneNum, yearNum, periodNum));
            }
            int scope = Integer.parseInt(userParam.getProperty("scope").toString());
            boolean isCreateAdjust = Boolean.parseBoolean(String.valueOf(userParam.getProperty("isCreateAdjust")));
            boolean isCreateElim = Boolean.parseBoolean(String.valueOf(userParam.getProperty("isCreateElim")));
            boolean isCommonPaperSelected = Boolean.parseBoolean(String.valueOf(parameters.get("isCommonPaperSelected")));
            Set commonPaperIds = (Set)parameters.get("commonpapers");
            boolean isInvestTempSelected = Boolean.parseBoolean(String.valueOf(parameters.get("isInvestTempSelected")));
            Set investedTemplateIds = (Set)parameters.get("investedtemplates");
            boolean isInvSheetPaperSelected = Boolean.parseBoolean(String.valueOf(userParam.getProperty("isInvSheetPaperSelected")));
            AdjustmentServiceHelper.checkPermission((long)userParam.getModel(), (String)"bcm_rptadjust_list", (String)"13X65LZQ=RM/");
            IDNumberTreeNode checkNode = MemberReader.findEntityMemberById((Long)userParam.getModel(), (Long)userParam.getOrg());
            if (checkNode == IDNumberTreeNode.NotFoundTreeNode) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"AdjustMsServiceImpl_1", (String)"fi-bcm-mservice", (Object[])new Object[0]));
            }
            Long cslId = (Long)checkNode.getProperty("cslscheme.id");
            AdjustBatchCreateParam param = new AdjustBatchCreateParam();
            param.setScope(scope);
            param.setCreateAdjust(isCreateAdjust);
            param.setCreateElim(isCreateElim);
            param.setCommonPaperSelected(isCommonPaperSelected);
            param.setCommonPaperIds(this.toLongSet(commonPaperIds));
            param.setInvestTempSelected(isInvestTempSelected);
            param.setInvestedTemplateIds(this.toLongSet(investedTemplateIds));
            param.setInvSheetPaperSelected(isInvSheetPaperSelected);
            AdjustOperationContext actx = new AdjustOperationContext(userParam.getModel().longValue(), userParam.getScenario().longValue(), userParam.getYear().longValue(), userParam.getPeriod().longValue());
            actx.setCslId(cslId);
            OrgTreeNode node = this.buildTreeNode(userParam.getModel(), cslId, userParam.getScenario(), MemberReader.findFyMemberById((Long)userParam.getModel(), (Long)userParam.getYear()).getNumber(), userParam.getPeriod(), userParam.getOrg());
            if (node == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u751f\u6210\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2\u3002", (String)"AdjustCreateAutoEntryServiceImpl_1", (String)"fi-bcm-mservice", (Object[])new Object[0]));
            }
            HashSet orgSet = new HashSet(16);
            node.iterate(10, tree -> {
                orgSet.add(LongUtil.toLong((Object)tree.getId()));
                orgNumSet.add(MemberReader.findEntityMemberById((Long)userParam.getModel(), (Long)LongUtil.toLong((Object)tree.getId())).getNumber());
            });
            record = AdjustOperationThreadHelper.createAdjustOperRecord((AdjustOperTypeEnum)AdjustOperTypeEnum.CREATEAUTOOPERATION, (long)userParam.getModel(), (long)userParam.getScenario(), (long)userParam.getYear(), (long)userParam.getPeriod(), (int)orgSet.size());
            log.loadRecord(record, this.getClass().getName());
            AdjustBatchOrgTreeNodeThreadExcute excutor = new AdjustBatchOrgTreeNodeThreadExcute(actx, userParam.getOrg(), param, log);
            excutor.setOrgTreeNode(node);
            excutor.excute();
        }
        catch (Throwable t) {
            op = new OperationResult();
            op.setMessage(AdjustmentServiceHelper.toString_Adj((Throwable)t));
            op.setSuccess(false);
        }
        finally {
            log.endLog();
        }
        if (op != null) {
            return this.createReturnMap(op);
        }
        record = AdjustOperationThreadHelper.getAdjLogFromCache((Long)record.getLong("id"));
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put(SUCCESSCOUNT, log.getSuccessConut().get());
        result.put(BILLCOUNT, log.getCount());
        result.put(ERRORMSG, record.getString("failedlog"));
        result.put(DETAILMSG, record.getString("failedlog"));
        result.put("InvSheetPaperResult", InvestServiceHelper.queryInvSheetPaperResult((Long)userParam.getModel(), (Long)userParam.getScenario(), (Long)userParam.getYear(), (Long)userParam.getPeriod(), orgNumSet, null));
        return result;
    }

    private Set<Long> toLongSet(Set<?> set) {
        if (set == null) {
            return null;
        }
        return set.stream().filter(id -> id instanceof Long).map(Long.class::cast).collect(Collectors.toSet());
    }

    private OrgTreeNode buildTreeNode(Long modelId, Long cslShemeId, Long sceneId, String yearNum, Long periodId, Long selectedNodeId) {
        HashMap<String, List> need2RemoveNodes = new HashMap<String, List>();
        CslSchemeServiceHelper.QueryOrgParam param = CslSchemeServiceHelper.QueryOrgParam.of((String)"model", (Object)modelId);
        param.setNeedSchemeFilter(true);
        param.setNeedSchemeModelFilter(true);
        param.setCslScheme(Pair.of((Object)cslShemeId, (Object)""));
        param.setSceneId(sceneId.toString());
        param.setYearNum(yearNum);
        param.setPeriodId(periodId.toString());
        Map orgNodesFromCache = CslSchemeServiceHelper.getOrgNodesFromCache((CslSchemeServiceHelper.QueryOrgParam)param);
        ArrayList noMergeOrgNodes = new ArrayList();
        List filterVersionNodes = EntityVersioningUtil.filterVersionOrgTreeNodes((Map)orgNodesFromCache, (long)modelId, (Long)sceneId, (String)yearNum, (long)periodId);
        need2RemoveNodes.put("filterVersionNodeIds", filterVersionNodes);
        need2RemoveNodes.put("noMergeNodeIds", noMergeOrgNodes);
        if (!filterVersionNodes.contains(selectedNodeId)) {
            boolean showNoMergeOrg = ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM030");
            return TreeBuilder.createOrgTreeNode((long)modelId, (boolean)showNoMergeOrg, need2RemoveNodes, (IDNumberTreeNode)MemberReader.findEntityMemberById((Long)modelId, (Long)selectedNodeId), (String)"2", (Long)cslShemeId, (boolean)false, (boolean)false);
        }
        return null;
    }

    public Map<String, Object> buildAdjustWithMap(Map<String, Object> ctx, List<Map<String, Object>> ajusts) {
        HashMap<String, Object> res = new HashMap<String, Object>(16);
        res.put("success", true);
        try {
            kd.fi.bcm.common.Pair pars = AdjustModelParser.convertMapForDynamic(ajusts);
            res = this.buildAdjustWithDynamic(ctx, (List)pars.p1, (Map)pars.p2);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            res.put("success", false);
            res.put(ERRORMSG, Collections.singletonList(e.getMessage()));
            return res;
        }
        return res;
    }

    public Map<String, Object> buildAdjustWithDynamic(Map<String, Object> ctx, List<DynamicObject> adjustHeads, Map<Long, List<DynamicObject>> adjustDatas) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("success", true);
        res.put(BILLCOUNT, adjustHeads.size());
        try {
            AdjustOperationContext _ctx = new AdjustOperationContext(((Long)ctx.getOrDefault("model", 0L)).longValue(), ((Long)ctx.getOrDefault("scenario", 0L)).longValue(), ((Long)ctx.getOrDefault("year", 0L)).longValue(), ((Long)ctx.getOrDefault("period", 0L)).longValue());
            _ctx.addUserObject("isSysToMDD", ctx.getOrDefault("isSysToMDD", true));
            if (LockScopeServiceHelper.isExistArchiving((long)_ctx.getModelId(), (String)_ctx.getScenariodNum(), (String)_ctx.getFyNum(), (String)_ctx.getPeriodNum())) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u60c5\u666f\u8d22\u5e74\u671f\u95f4%1$s_%2$s_%3$s\u7684\u5206\u9636\u6bb5\u9501\u5b9a\u5df2\u5728\u667a\u80fd\u5408\u5e76\u5f52\u6863\uff0c\u8bf7\u53cd\u5f52\u6863\u540e\u518d\u64cd\u4f5c\u3002", (String)"AdjustMsServiceImpl_2", (String)"fi-bcm-mservice", (Object[])new Object[0]), _ctx.getScenariodNum(), _ctx.getFyNum(), _ctx.getPeriodNum()));
            }
            Map<Long, DynamicObject> pk2DyMap = adjustHeads.parallelStream().peek(p -> {
                if (p.getLong("id") == 0L) {
                    p.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                }
            }).collect(Collectors.toMap(p -> p.getLong("id"), p -> p));
            OperationResult op = AdjustOperationHelper.saveDataWithCheck((AdjustOperationContext)_ctx, adjustHeads, adjustDatas);
            res.put(SUCCESSCOUNT, op.getSuccessPkIds().size());
            res.put("billList", op.getSuccessPkIds().stream().map(pkId -> MapInitHelper.ofMap((Object)"id", (Object)pkId, (Object)"number", pk2DyMap.get(pkId) == null ? null : ((DynamicObject)pk2DyMap.get(LongUtil.toLong((Object)pkId))).getString("number"))).collect(Collectors.toList()));
            if (StringUtils.isEmpty((String)op.getMessage())) {
                res.put(ERRORMSG, op.getAllErrorInfo().stream().map(errorInfo -> MapInitHelper.ofMap((Object)"msg", (Object)errorInfo.getMessage(), (Object)"number", pk2DyMap.get(LongUtil.toLong((Object)errorInfo.getPkValue())) == null ? null : ((DynamicObject)pk2DyMap.get(errorInfo.getPkValue())).getString("number"))).collect(Collectors.toList()));
            } else {
                res.put("success", false);
                res.put(ERRORMSG, Collections.singletonList(op.getMessage()));
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            res.put("success", false);
            res.put(ERRORMSG, Collections.singletonList(e.getMessage()));
        }
        return res;
    }
}

