/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.common.util.EncryptUtils;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.business.serviceHelper.QueryMemberDetailsHelper;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.OlapConstant;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DetailTypeEnum;
import kd.fi.bcm.common.enums.TemplateCatalogTypeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.service.BCMToFSAMsService;

public class BCMToFSAMsServiceImpl
implements BCMToFSAMsService {
    private static final Log logger = LogFactory.getLog(BCMToFSAMsServiceImpl.class);
    private static final String CSLSCHEME = "cslscheme";
    private static final String QFX = "qfx";
    private static final String QS = "qs";
    private static final String F7 = "f7";
    private static final String[] priority = new String[]{"2", "3", "5"};
    private static final String OLAP_USER_NAME = "username";
    private static final String OLAP_PASSWORD = "password";
    private static final String OLAP_CONNECT_SERIAL = "connectSerial";

    public Map<String, String> loadModuleAllDimensionMetas(long moduleId) {
        try {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(16);
            Map<String, OlapServerDimemsionMetaInfo> stringOlapServerDimemsionMetaInfoMap = this.loadModuleDimensionMetas(moduleId, new String[0]);
            for (Map.Entry<String, OlapServerDimemsionMetaInfo> entrie : stringOlapServerDimemsionMetaInfoMap.entrySet()) {
                map.put(entrie.getKey(), this.jsonToString(entrie.getValue()));
            }
            return map;
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call loadModuleAllDimensionMetas error, params: moduleId=%s", moduleId));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public List<String> loadCslscheme(QFilter filter) {
        try {
            List<OlapCslSchemeInfo> olapCslSchemeInfos = this.loadModuleCslschemes(filter);
            return this.changeT2String(olapCslSchemeInfos);
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call loadCslscheme error, params: filter=%s", filter));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public List<String> loadModules(QFilter filter) {
        ArrayList olapCslSchemeInfos = new ArrayList(16);
        try {
            this.queryEntityInfo("bcm_model", "id,shownumber,name", filter.toArray(), null, null, null, row -> olapCslSchemeInfos.add(new OlapServerBaseMetaInfo(row.getLong("id"), row.getString("shownumber"), row.getString("name"))));
            return this.changeT2String(olapCslSchemeInfos);
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call bcm_model error, params: filter=%s", filter));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public List<String> loadDefaultCslscheme(long moduleId) {
        try {
            List<OlapCslSchemeInfo> olapCslSchemeInfos = this.loadModuleCslschemes(moduleId, "DefaultScheme", 1);
            if (CollectionUtils.isEmpty(olapCslSchemeInfos)) {
                olapCslSchemeInfos = this.loadModuleCslschemes(moduleId, null, 1);
            }
            return this.changeT2String(olapCslSchemeInfos);
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call loadDefaultCslscheme error, params: moduleId=%s", moduleId));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private <T> List<String> changeT2String(Collection<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        List<String> collect = list.stream().map(p -> this.jsonToString(p)).collect(Collectors.toList());
        return collect;
    }

    private List<OlapCslSchemeInfo> loadModuleCslschemes(QFilter qFilter) {
        ArrayList<OlapCslSchemeInfo> list = new ArrayList<OlapCslSchemeInfo>(1);
        this.queryEntityInfo("bcm_cslscheme", "id, number, name, longnumber", qFilter.toArray(), null, null, null, dataRow -> {
            OlapCslSchemeInfo dimMetaInfo = new OlapCslSchemeInfo(dataRow.getLong(0), dataRow.getString(1), dataRow.getString(2), dataRow.getString(3));
            list.add(dimMetaInfo);
        });
        return list;
    }

    private List<OlapCslSchemeInfo> loadModuleCslschemes(long moduleId, String number, Integer length) {
        QFilter qFilter = new QFilter("model", "=", (Object)moduleId).and(new QFilter("isenable", "=", (Object)"1")).and(new QFilter("nodetype", "=", (Object)"1"));
        if (number != null) {
            qFilter.and(new QFilter("number", "=", (Object)number));
        }
        ArrayList<OlapCslSchemeInfo> list = new ArrayList<OlapCslSchemeInfo>(1);
        this.queryEntityInfo("bcm_cslscheme", "id, number, name, longnumber", qFilter.toArray(), null, null, length, dataRow -> {
            OlapCslSchemeInfo dimMetaInfo = new OlapCslSchemeInfo(dataRow.getLong(0), dataRow.getString(1), dataRow.getString(2), dataRow.getString(3));
            list.add(dimMetaInfo);
        });
        return list;
    }

    private Map<String, OlapServerDimemsionMetaInfo> loadModuleDimensionMetas(long moduleId, String ... dimNumbers) {
        Object[] upperDimNumbers = null;
        if (ArrayUtils.isNotEmpty((Object[])dimNumbers)) {
            int length = dimNumbers.length;
            upperDimNumbers = new String[length];
            for (int i = 0; i < length; ++i) {
                upperDimNumbers[i] = dimNumbers[i].toUpperCase(Locale.ENGLISH);
            }
        }
        LinkedHashMap<String, OlapServerDimemsionMetaInfo> dimemsionMetaMap = new LinkedHashMap<String, OlapServerDimemsionMetaInfo>(10);
        QFilter[] qFilters = new QFilter("model", "=", (Object)moduleId).toArray();
        Object[] finalUpperDimNumbers = upperDimNumbers;
        this.queryDimension(qFilters, (arg_0, arg_1) -> BCMToFSAMsServiceImpl.lambda$loadModuleDimensionMetas$4((String[])finalUpperDimNumbers, dimemsionMetaMap, arg_0, arg_1));
        LinkedHashMap<String, OlapServerDimemsionMetaInfo> resultMap = dimemsionMetaMap;
        if (ArrayUtils.isNotEmpty((Object[])finalUpperDimNumbers)) {
            resultMap = new LinkedHashMap(10);
            block1: for (Object dimNumber : finalUpperDimNumbers) {
                for (Map.Entry next : dimemsionMetaMap.entrySet()) {
                    String number = (String)next.getKey();
                    if (!((String)dimNumber).equalsIgnoreCase(number)) continue;
                    resultMap.put(number, (OlapServerDimemsionMetaInfo)next.getValue());
                    continue block1;
                }
            }
        }
        return resultMap;
    }

    private void queryDimension(QFilter[] qFilters, BiConsumer<String, OlapServerDimemsionMetaInfo> biConsumer) {
        this.queryEntityInfo("bcm_dimension", "id, number, name, memberModel, fieldmapped", qFilters, "dseq", null, null, dataRow -> {
            OlapServerDimemsionMetaInfo dimMetaInfo = new OlapServerDimemsionMetaInfo(dataRow.getLong(0), dataRow.getString(1), dataRow.getString(2), dataRow.getString(3), dataRow.getString(4));
            biConsumer.accept(dataRow.getString(1), dimMetaInfo);
        });
    }

    public String loadModuleDimensionMeta(long moduleId, String dimNumber) {
        try {
            Iterator<Map.Entry<String, OlapServerDimemsionMetaInfo>> iterator;
            OlapServerDimemsionMetaInfo olapServerDimemsionMetaInfo;
            Map<String, OlapServerDimemsionMetaInfo> stringOlapServerDimemsionMetaInfoMap = this.loadModuleDimensionMetas(moduleId, dimNumber);
            if (stringOlapServerDimemsionMetaInfoMap.size() > 0 && (olapServerDimemsionMetaInfo = (iterator = stringOlapServerDimemsionMetaInfoMap.entrySet().iterator()).next().getValue()) != null) {
                return this.jsonToString(olapServerDimemsionMetaInfo);
            }
            return null;
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call loadModuleDimensionMeta error, params: moduleId=%s,dimNumber=%s", moduleId, dimNumber));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private String jsonToString(Object object) {
        return JSON.toJSONString((Object)object);
    }

    public String loadModuleOlapDimensionLookupMetaInfo(long moduleId, Long viewId, String[] hierarchyNumbers, String[] commonNumber, Map<String, Set<Long>> dimNumberAndMemberIdsMap) {
        try {
            String[] bothDimNumber = (String[])ArrayUtils.addAll((Object[])hierarchyNumbers, (Object[])commonNumber);
            Map<String, OlapServerDimemsionMetaInfo> olapServerDimemsionMetaInfoMap = this.loadModuleDimensionMetas(moduleId, bothDimNumber);
            OlapDimensionLookupMetaInfo olapDimensionLookupMetaInfo = new OlapDimensionLookupMetaInfo();
            olapDimensionLookupMetaInfo.initializeLookupIndex(this.loadDimensionMembers(moduleId, viewId, olapServerDimemsionMetaInfoMap.values(), dimNumberAndMemberIdsMap, QFX, null), hierarchyNumbers);
            return this.jsonToString(olapDimensionLookupMetaInfo);
        }
        catch (Exception e) {
            String hierarchyNumbersLog = hierarchyNumbers != null ? StringUtils.join((Object[])hierarchyNumbers, (String)"!") : null;
            String commonNumberLog = commonNumber != null ? StringUtils.join((Object[])commonNumber, (String)"!") : null;
            logger.error(String.format("[FSA] call loadModuleOlapDimensionLookupMetaInfo error, params: moduleId=%s,viewId=%s,hierarchyNumbers=%s,commonNumber=%s", moduleId, viewId, hierarchyNumbersLog, commonNumberLog));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public Map<String, String> loadDimensionMembers(Long moduleId, Long viewId, String dimensionEntityName, Long dimId, String filterColumnName, Collection<?> filterParamList, Boolean includeMode, Long userId) {
        try {
            LinkedHashMap<String, String> resultMap = new LinkedHashMap<String, String>(10);
            this.loadDimensionMembers(moduleId, viewId, dimensionEntityName, dimId, filterColumnName, filterParamList, includeMode, (number, olapServerDimMemberMetaInfo) -> resultMap.put((String)number, this.jsonToString(olapServerDimMemberMetaInfo)), F7, userId);
            return resultMap;
        }
        catch (Exception e) {
            String filterParamListLog = filterParamList != null ? StringUtils.join(filterParamList, (String)"!") : null;
            logger.error(String.format("[FSA] call loadDimensionMembers error, params: moduleId=%s,viewId=%s,dimensionEntityName=%s,dimId=%s,filterColumnName=%s,filterParamList=%s,includeMode=%s", moduleId, viewId, dimensionEntityName, dimId, filterColumnName, filterParamListLog, includeMode));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public Map<String, String> loadDimensionMembers(Long moduleId, Long viewId, String dimNumber, String filterColumnName, Collection<?> filterParamList, Boolean includeMode, Long userId) {
        Map<String, OlapServerDimemsionMetaInfo> stringOlapServerDimemsionMetaInfoMap = this.loadModuleDimensionMetas(moduleId, dimNumber);
        if (stringOlapServerDimemsionMetaInfoMap.size() > 0) {
            OlapServerDimemsionMetaInfo olapServerDimemsionMetaInfo = stringOlapServerDimemsionMetaInfoMap.entrySet().iterator().next().getValue();
            return this.loadDimensionMembers(moduleId, viewId, olapServerDimemsionMetaInfo.getDimEntityName(), olapServerDimemsionMetaInfo.getId(), filterColumnName, filterParamList, includeMode, userId);
        }
        return null;
    }

    private void loadDimensionEntityMembers(Long moduleid, Long viewId, Long dimId, String filterColumnName, Collection<?> filterParamList, boolean includeMode, BiConsumer<String, OlapServerDimMemberMetaInfo> handleAction, String purpose, Long userId) {
        try {
            QFilter cslschemeQFilter = null;
            cslschemeQFilter = viewId == null ? this.getCslschemeQFilter(moduleid) : new QFilter(CSLSCHEME, "=", (Object)viewId);
            String extraSelectFields = "";
            Class<OlapServerDimMemberMetaInfo> clazz = OlapServerDimMemberMetaInfo.class;
            if (QFX.equals(purpose)) {
                extraSelectFields = "bizchangerds.changetype,bizchangerds.bizeffdate";
                clazz = OlapServerDimMemberMetaInfoEntity.class;
            }
            this.loadDimensionMembers(moduleid, cslschemeQFilter, "bcm_entitymembertree", dimId, extraSelectFields, filterColumnName, filterParamList, includeMode, clazz, (olapServerDimMemberMetaInfo, dataRow) -> {
                if (olapServerDimMemberMetaInfo instanceof OlapServerDimMemberMetaInfoEntity) {
                    ((OlapServerDimMemberMetaInfoEntity)olapServerDimMemberMetaInfo).setChangeType(dataRow.getString(10));
                    ((OlapServerDimMemberMetaInfoEntity)olapServerDimMemberMetaInfo).setBizeffdate(dataRow.getDate(11));
                }
            }, (number, olapServerDimMemberMetaInfo) -> handleAction.accept((String)number, (OlapServerDimMemberMetaInfo)olapServerDimMemberMetaInfo), purpose, userId);
        }
        catch (Exception e) {
            String filterParamListLog = filterParamList != null ? StringUtils.join(filterParamList, (String)"!") : null;
            logger.error(String.format("[FSA] call loadDimensionEntityMembers error, params: moduleId=%s,dimId=%s,filterColumnName=%s,filterParamList=%s,includeMode=%s", moduleid, dimId, filterColumnName, filterParamListLog, includeMode));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private void loadDimensionPeriodMembers(long moduleId, Long dimId, String filterColumnName, Collection<?> filterParamList, boolean includeMode, BiConsumer<String, OlapServerDimMemberMetaInfo> handleAction, String purpose, Long userId) {
        try {
            String extraSelectFields = "effmonth,expmonth";
            this.loadDimensionMembers(moduleId, null, "bcm_periodmembertree", dimId, extraSelectFields, filterColumnName, filterParamList, includeMode, OlapServerDimMemberMetaInfoPeriod.class, (olapServerDimMemberMetaInfoPeriod, dataRow) -> {
                String effmonth = dataRow.getString(10);
                String expmonth = dataRow.getString(11);
                String date = "";
                String month = expmonth.equals(effmonth) ? effmonth : expmonth;
                if (month != null) {
                    date = month.length() == 1 ? "0" + month : month;
                }
                olapServerDimMemberMetaInfoPeriod.setDate(date);
            }, (number, olapServerDimMemberMetaInfo) -> handleAction.accept((String)number, (OlapServerDimMemberMetaInfo)olapServerDimMemberMetaInfo), purpose, userId);
        }
        catch (Exception e) {
            String filterParamListLog = filterParamList != null ? StringUtils.join(filterParamList, (String)"!") : null;
            logger.error(String.format("[FSA] call loadDimensionEntityMembers error, params: dimId=%s,filterColumnName=%s,filterParamList=%s,includeMode=%s", dimId, filterColumnName, filterParamListLog, includeMode));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private void loadDimensionMembers(Long moduleId, Long viewId, String dimensionEntityName, Long dimId, String filterColumnName, Collection<?> filterParamList, boolean includeMode, BiConsumer<String, OlapServerDimMemberMetaInfo> handleAction, String purpose, Long userId) {
        if ("bcm_entitymembertree".equals(dimensionEntityName)) {
            this.loadDimensionEntityMembers(moduleId, viewId, dimId, filterColumnName, filterParamList, includeMode, handleAction, purpose, userId);
        } else if ("bcm_periodmembertree".equals(dimensionEntityName) && QFX.equals(purpose)) {
            this.loadDimensionPeriodMembers(moduleId, dimId, filterColumnName, filterParamList, includeMode, handleAction, purpose, userId);
        } else {
            this.loadDimensionMembers(moduleId, null, dimensionEntityName, dimId, "", filterColumnName, filterParamList, includeMode, OlapServerDimMemberMetaInfo.class, null, handleAction, purpose, userId);
        }
    }

    private <T extends OlapServerDimMemberMetaInfo> void loadDimensionMembers(long moduleId, QFilter paramFilter, String dimensionEntityName, Long dimId, String extraSelectFields, String filterColumnName, Collection<?> filterParamList, boolean includeMode, Class<T> memberClass, BiConsumer<T, Row> biConsumer, BiConsumer<String, T> handleAction, String purpose, Long userId) {
        QFilter filter = new QFilter("dimension", "=", (Object)dimId).and(new QFilter("model", "=", (Object)moduleId)).and(new QFilter("status", "=", (Object)"C")).and(new QFilter("enable", "=", (Object)"1"));
        if (filterColumnName != null && filterParamList != null && filterParamList.size() > 0) {
            filter.and(new QFilter(filterColumnName, includeMode ? "in" : "not in", filterParamList));
        }
        if (paramFilter != null) {
            filter.and(paramFilter);
        }
        String selectFields = "id, number, name, level, isleaf, dseq, parent, longnumber, storagetype,aggoprt";
        if (kd.bos.util.StringUtils.isNotEmpty((String)extraSelectFields)) {
            selectFields = selectFields + "," + extraSelectFields;
        }
        Set noPermissionIds = Sets.newHashSet();
        if (userId != null) {
            noPermissionIds = MemberPermHelper.getNoPermissionIds((String)dimensionEntityName, (long)dimId, (Object)moduleId);
        }
        HashSet noPermIds = noPermissionIds;
        HashSet notshow = new HashSet(16);
        this.queryEntityInfo(dimensionEntityName, selectFields, filter.toArray(), "level, dseq", null, null, dataRow -> {
            Long id = dataRow.getLong(0);
            Long parentId = dataRow.getLong(6);
            if (noPermIds.contains(id)) {
                notshow.add(id);
            } else if (notshow.contains(parentId)) {
                notshow.add(id);
            } else {
                OlapServerDimMemberMetaInfo t = null;
                try {
                    Constructor constructor = memberClass.getConstructor(Long.class, String.class, String.class, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Long.class, String.class, String.class, String.class);
                    t = (OlapServerDimMemberMetaInfo)constructor.newInstance(id, dataRow.getString(1), dataRow.getString(2), dataRow.getInteger(3), dataRow.getBoolean(4), dataRow.getInteger(5), parentId, dataRow.getString(7), dataRow.getString(8), dataRow.getString(9));
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
                }
                if (biConsumer != null) {
                    biConsumer.accept((Object)t, (Row)dataRow);
                }
                if (QFX.equals(purpose) || QS.equals(purpose)) {
                    handleAction.accept(t.getNumber(), t);
                } else if (F7.equals(purpose)) {
                    handleAction.accept(t.getLongNumber(), t);
                }
            }
        });
    }

    private QFilter getCslschemeQFilter(Long moduleId) {
        if (moduleId == null) {
            throw new KDBizException("get Default Cslscheme,moduleId can not be null");
        }
        List<OlapCslSchemeInfo> olapCslSchemeInfos = this.loadModuleCslschemes(moduleId, "DefaultScheme", 1);
        if (CollectionUtils.isEmpty(olapCslSchemeInfos) && CollectionUtils.isEmpty(olapCslSchemeInfos = this.loadModuleCslschemes(moduleId, null, 1))) {
            throw new KDBizException(String.format("this moduleId=%s has not CslScheme", moduleId));
        }
        OlapCslSchemeInfo olapCslSchemeInfo = olapCslSchemeInfos.get(0);
        return new QFilter(CSLSCHEME, "=", (Object)olapCslSchemeInfo.id);
    }

    private Collection<OlapServerDimemsionMetaInfo> loadDimensionMembers(Long moduleId, Long viewId, Collection<OlapServerDimemsionMetaInfo> list, Map<String, Set<Long>> dimNumberAndMemberIdsMap, String purpose, Long userId) {
        for (OlapServerDimemsionMetaInfo olapServerDimemsionMetaInfo : list) {
            String dimEntityName = olapServerDimemsionMetaInfo.getDimEntityName();
            Long id = olapServerDimemsionMetaInfo.getId();
            String dimnumber = olapServerDimemsionMetaInfo.getNumber();
            LinkedHashMap<String, List<OlapServerDimMemberMetaInfo>> map = new LinkedHashMap<String, List<OlapServerDimMemberMetaInfo>>(16);
            String filterColumnName = "id";
            Collection filterParamList = dimNumberAndMemberIdsMap != null ? (Collection)dimNumberAndMemberIdsMap.get(dimnumber) : null;
            this.loadDimensionMembers(moduleId, viewId, dimEntityName, id, filterColumnName, filterParamList, true, (number, olapServerDimMemberMetaInfo) -> map.merge((String)number, (List<OlapServerDimMemberMetaInfo>)new ArrayList<OlapServerDimMemberMetaInfo>(Collections.singletonList(olapServerDimMemberMetaInfo)), (oldv, newv) -> {
                oldv.add(olapServerDimMemberMetaInfo);
                return oldv;
            }), purpose, userId);
            olapServerDimemsionMetaInfo.setDimMembers(map);
        }
        return list;
    }

    public Map<String, String> loadCurrentUserVisiableEntities(long moduleId, Long dimId) {
        try {
            Map entityMemberMap = MemberPermHelper.getMemberPermission((String)"bcm_entitymembertree", (long)dimId, (Object)moduleId);
            if (entityMemberMap != null && !entityMemberMap.isEmpty()) {
                return this.loadDimensionMemberNumberNames("bcm_entitymembertree", dimId, entityMemberMap.keySet(), false);
            }
            return new HashMap<String, String>(0);
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call loadCurrentUserVisiableEntities error, params: moduleId=%s,dimId=%s", String.valueOf(moduleId), dimId));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public Map<String, String> loadDimensionMemberNumberId(String srcEntityName, long dimensionId, Collection<Long> filterIds, boolean sort) {
        try {
            return this.loadDimensionMember(srcEntityName, "number, id", dimensionId, filterIds, sort);
        }
        catch (Exception e) {
            String filterIdsLog = filterIds != null ? StringUtils.join(filterIds, (String)"!") : null;
            logger.error(String.format("[FSA] call loadDimensionMemberNumberId error, params: srcEntityName=%s,dimensionId=%s,filterIds=%s,sort=%s", srcEntityName, dimensionId, filterIdsLog, sort));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public Map<String, String> loadDimensionMemberNumberNames(String srcEntityName, long dimensionId, Collection<Long> filterIds, boolean sort) {
        try {
            return this.loadDimensionMember(srcEntityName, "number, name", dimensionId, filterIds, sort);
        }
        catch (Exception e) {
            String filterIdsLog = filterIds != null ? StringUtils.join(filterIds, (String)"!") : null;
            logger.error(String.format("[FSA] call loadDimensionMemberNumberNames error, params: srcEntityName=%s,dimensionId=%s,filterIds=%s,sort=%s", srcEntityName, dimensionId, filterIdsLog, sort));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private Map<String, String> loadDimensionMember(String srcEntityName, String selectFields, long dimensionId, Collection<Long> filterIds, boolean sort) {
        LinkedHashMap<String, String> resultMap = sort ? new LinkedHashMap() : new HashMap();
        QFilter filter = new QFilter("dimension", "=", (Object)dimensionId).and(new QFilter("status", "=", (Object)"C")).and(new QFilter("enable", "=", (Object)"1"));
        if (filterIds != null) {
            filter.and(new QFilter("id", "in", filterIds));
        }
        this.queryEntityInfo(srcEntityName, selectFields, filter.toArray(), sort ? "dseq" : null, null, null, dataRow -> resultMap.put(dataRow.getString(0), dataRow.getString(1)));
        return resultMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void queryEntityInfo(String srcEntityName, String selectFields, QFilter[] filters, String orderBy, Integer startPos, Integer length, Consumer<Row> handleAction) {
        ORM orm = ORM.create();
        if (startPos == null || length == null || startPos < 0 || length < 0) {
            try (DataSet ds = orm.queryDataSet(String.format("%s/queryEntityInfo/%s", BCMToFSAMsServiceImpl.class.getName(), srcEntityName), srcEntityName, selectFields, filters, orderBy);){
                if (ds == null || ds.isEmpty()) return;
                while (ds.hasNext()) {
                    handleAction.accept(ds.next());
                }
                return;
            }
        }
        try (DataSet ds = orm.queryDataSet(String.format("%s/queryEntityInfo/%s", BCMToFSAMsServiceImpl.class.getName(), srcEntityName), srcEntityName, selectFields, filters, orderBy, startPos.intValue(), length.intValue());){
            if (ds == null || ds.isEmpty()) return;
            while (ds.hasNext()) {
                handleAction.accept(ds.next());
            }
            return;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public String getModelNumber(Long moduleId) {
        try {
            return MemberReader.findModelNumberById((Object)moduleId);
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call getModelNumber error, params: moduleId=%s", moduleId));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    public Map<String, String> getOlapConnectionInformation(String cube, String olapServerAddress) {
        try {
            HashMap<String, String> connectionInfoMap = new HashMap<String, String>(3);
            connectionInfoMap.put(OLAP_CONNECT_SERIAL, OlapConstant.getConnectSerial((String)cube));
            connectionInfoMap.put(OLAP_USER_NAME, OlapConstant.getConnectMsg((String)cube).getUsername());
            connectionInfoMap.put(OLAP_PASSWORD, EncryptUtils.aesDecrypt((String)OlapConstant.getConnectMsg((String)cube).getPassword()));
            return connectionInfoMap;
        }
        catch (Exception e) {
            logger.error(String.format("[FSA] call getOlapConnectionInformation error, params: cube=%s,olapServerAddress=%s", cube, olapServerAddress));
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private List<Template> loadTemplateList(long moduleId, Set<Long> templateCatalogIds, int[] filterValues, Object[][] params) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        qFilters.add(new QFilter("model", "=", (Object)moduleId));
        qFilters.add(new QFilter("status", "=", (Object)"1"));
        qFilters.add(new QFilter("isfintemplate", "=", (Object)"1"));
        qFilters.add(new QFilter("isOldTemplate", "=", (Object)"0"));
        if (!CollectionUtils.isEmpty(templateCatalogIds)) {
            qFilters.add(new QFilter("templatecatalog", "in", templateCatalogIds));
        }
        qFilters.add(new QFilter("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType()));
        qFilters.add(new QFilter("issavebydim", "=", (Object)"1"));
        Map templates = BusinessDataServiceHelper.loadFromCache((String)"bcm_templateentity", (String)"id, number,name, versionnumber,templatecatalog.id", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        if (CollectionUtils.isEmpty((Map)templates)) {
            return Collections.emptyList();
        }
        Collection values = templates.values();
        TemplateUtil.filterVersionTemplateTree(values);
        List<Template> templateList = new ArrayList<Template>(values.size());
        for (DynamicObject p : values) {
            Template template = new Template(p.getLong("id"), p.getString("number"), p.getString("name"));
            template.setTemplateCatalogId(p.getLong("templatecatalog.id"));
            template.setModelId(moduleId);
            templateList.add(template);
        }
        List<Filter> filters = FilterUtil.changeListAndValidParam(filterValues, params, Template.class);
        for (int i = 0; i < filters.size(); ++i) {
            templateList = filters.get(i).doFilte(templateList, params[i]);
        }
        return templateList;
    }

    public List<String> loadTemplates(long moduleId, Set<Long> templateCatalogIds, int[] filterValues, Object[][] params) {
        return this.changeT2String(this.loadTemplateList(moduleId, templateCatalogIds, filterValues, params));
    }

    public List<String> loadTemplateCatalogs(long moduleId, int[] filterValues, Object[][] params) {
        ArrayList templateCatalogs = new ArrayList(16);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("model", "=", (Object)moduleId));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        qFilters.add(TemplateCatalogTypeEnum.getTemplateCalcog());
        this.queryEntityInfo("bcm_templatecatalog", "id,number,name,parent", qFilters.toArray(new QFilter[qFilters.size()]), "level,sequence", null, null, row -> templateCatalogs.add(new TemplateCatalog(row.getLong(0), row.getString(1), row.getString(2), row.getLong(3))));
        if (FilterUtil.allMatchclazz(filterValues, TemplateCatalog.class)) {
            List<Filter> filters = FilterUtil.changeListAndValidParam(filterValues, params, TemplateCatalog.class);
            List filtertemplateCatalogs = templateCatalogs;
            for (int i = 0; i < filters.size(); ++i) {
                filtertemplateCatalogs = filters.get(i).doFilte(filtertemplateCatalogs, params[i]);
            }
        } else if (FilterUtil.allMatchclazz(filterValues, Template.class)) {
            List<Template> templateList = this.loadTemplateList(moduleId, null, filterValues, params);
            List templateCatalogIds = templateList.stream().map(p -> p.templateCatalogId).collect(Collectors.toList());
            HashMap<Long, TemplateCatalog> idMapTempl = new HashMap<Long, TemplateCatalog>(templateCatalogs.size());
            for (TemplateCatalog templateCatalog : templateCatalogs) {
                idMapTempl.put(templateCatalog.getId(), templateCatalog);
            }
            List<TemplateCatalog> initFilterTemplateCatalogs = templateCatalogs.stream().filter(p -> templateCatalogIds.contains(p.id)).collect(Collectors.toList());
            List<TemplateCatalog> returntemplCatalogs = this.getAllParentTemplCatalog(idMapTempl, new HashSet<Long>(16), initFilterTemplateCatalogs);
            return this.changeT2String(returntemplCatalogs);
        }
        return this.changeT2String(templateCatalogs);
    }

    public String loadDimMemberFromTemplate(long templateId) {
        StringBuilder sb = new StringBuilder();
        sb.append("name,number,model,").append("viewpointmembentry.viewmembid,").append("viewpointmembentry.viewdimension,").append("pagemembentry.pagemembid,").append("pagemembentry.pagedimension,").append("pagemembentry.membbound,").append("pagepropentry.pagepropdim,").append("pagepropentry.membprop,").append("pagepropentry.propbound,").append("areapositionentry");
        Map templateDynamicObjects = BusinessDataServiceHelper.loadFromCache((String)"bcm_templateentity", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)templateId)});
        Collection templateDynamicObjectcs = templateDynamicObjects.values();
        Template template = null;
        if (!CollectionUtils.isEmpty(templateDynamicObjectcs)) {
            DynamicObject templateDynamicObject = (DynamicObject)templateDynamicObjectcs.iterator().next();
            template = new Template();
            template.setId(templateId);
            long model = templateDynamicObject.getLong("model_id");
            template.setId(templateDynamicObject.getLong("id"));
            template.setNumber(templateDynamicObject.getString("number"));
            template.setName(templateDynamicObject.getString("name"));
            DynamicObjectCollection viewpointmembentry = templateDynamicObject.getDynamicObjectCollection("viewpointmembentry");
            HashMap<String, Long> viewmembMap = new HashMap<String, Long>(viewpointmembentry.size());
            for (DynamicObject dynamicObject : viewpointmembentry) {
                long viewmembId = dynamicObject.getLong("viewmembid");
                String viewdimNum = dynamicObject.getString("viewdimension.number");
                viewmembMap.put(viewdimNum, viewmembId);
            }
            template.setViewpoint(viewmembMap);
            DynamicObjectCollection pagemembentry = templateDynamicObject.getDynamicObjectCollection("pagemembentry");
            HashMap<String, Set<Long>> pagemembentryMap = new HashMap<String, Set<Long>>(pagemembentry.size());
            for (Object dynamicObject : pagemembentry) {
                long membId = dynamicObject.getLong("pagemembid");
                String dimNumber = dynamicObject.getString("pagedimension.number");
                String dimensionEntity = dynamicObject.getString("pagedimension.membermodel");
                int membbound = dynamicObject.getInt("membbound");
                Set memids = QueryMemberDetailsHelper.queryMemberIdsByRange((String)dimensionEntity, (Long)membId, (int)membbound, (String)String.valueOf(model), (DetailTypeEnum)DetailTypeEnum.OTHERS);
                pagemembentryMap.merge(dimNumber, memids, (oldvalue, newvalue) -> {
                    oldvalue.addAll(newvalue);
                    return oldvalue;
                });
            }
            DynamicObjectCollection pagepropentry = templateDynamicObject.getDynamicObjectCollection("pagepropentry");
            for (DynamicObject dynamicObject : pagepropentry) {
                String dimNumber = dynamicObject.getString("pagepropdim.number");
                String dimensionEntity = dynamicObject.getString("pagepropdim.membermodel");
                long membpropId = dynamicObject.getLong("membprop.id");
                String membpropNumber = dynamicObject.getString("membprop.number");
                int propbound = dynamicObject.getInt("propbound");
                Set memids = QueryMemberDetailsHelper.getMemberIdsByDefinedRange((String)dimensionEntity, (Long)membpropId, (String)membpropNumber, (int)propbound, (String)String.valueOf(model), (DetailTypeEnum)DetailTypeEnum.OTHERS);
                pagemembentryMap.merge(dimNumber, memids, (oldvalue, newvalue) -> {
                    oldvalue.addAll(newvalue);
                    return oldvalue;
                });
            }
            template.setPageDim(pagemembentryMap);
            DynamicObjectCollection areapositionentry = templateDynamicObject.getDynamicObjectCollection("areapositionentry");
            ArrayList<TmplDimPosition> tmplDimPositions = new ArrayList<TmplDimPosition>(areapositionentry.size());
            for (DynamicObject dynamicObject : areapositionentry) {
                TmplDimPosition tmplDimPosition = new TmplDimPosition();
                String arearange = dynamicObject.getString("arearange");
                tmplDimPosition.setArearange(arearange);
                DynamicObjectCollection colmembdetail = dynamicObject.getDynamicObjectCollection("colmembdetail");
                tmplDimPosition.setColDim(colmembdetail.stream().collect(Collectors.groupingBy(p -> p.getString("coldimension.number"), Collectors.mapping(p -> p.getLong("colmembid"), Collectors.toList()))));
                DynamicObjectCollection rowmembdetail = dynamicObject.getDynamicObjectCollection("rowmembdetail");
                tmplDimPosition.setRowDim(rowmembdetail.stream().collect(Collectors.groupingBy(p -> p.getString("rowdimension.number"), Collectors.mapping(p -> p.getLong("rowmembid"), Collectors.toList()))));
                tmplDimPositions.add(tmplDimPosition);
            }
            template.setTmplDimPositions(tmplDimPositions);
        }
        return this.jsonToString(template);
    }

    private List<TemplateCatalog> getAllParentTemplCatalog(Map<Long, TemplateCatalog> idMapTempl, Set<Long> parentIdset, List<TemplateCatalog> initFilterTemplateCatalogs) {
        if (CollectionUtils.isEmpty(initFilterTemplateCatalogs)) {
            return Collections.emptyList();
        }
        List<TemplateCatalog> templateCatalogList = initFilterTemplateCatalogs.stream().filter(p -> !parentIdset.contains(p.getParentId()) && idMapTempl.containsKey(p.getParentId())).map(p -> (TemplateCatalog)idMapTempl.get(p.getParentId())).distinct().collect(Collectors.toList());
        for (TemplateCatalog templateCatalog : templateCatalogList) {
            parentIdset.add(templateCatalog.getId());
        }
        initFilterTemplateCatalogs.addAll(this.getAllParentTemplCatalog(idMapTempl, parentIdset, templateCatalogList));
        return initFilterTemplateCatalogs;
    }

    private static /* synthetic */ void lambda$loadModuleDimensionMetas$4(String[] finalUpperDimNumbers, Map dimemsionMetaMap, String number, OlapServerDimemsionMetaInfo olapServerDimemsionMetaInfo) {
        if (ArrayUtils.isNotEmpty((Object[])finalUpperDimNumbers)) {
            if (ArrayUtils.contains((Object[])finalUpperDimNumbers, (Object)number.toUpperCase(Locale.ENGLISH))) {
                dimemsionMetaMap.put(number, olapServerDimemsionMetaInfo);
            }
        } else {
            dimemsionMetaMap.put(number, olapServerDimemsionMetaInfo);
        }
    }

    protected static class ColDimOrRowDimExitDimFilterImpl
    implements Filter<Template> {
        protected ColDimOrRowDimExitDimFilterImpl() {
        }

        @Override
        public List<Template> doFilte(List<Template> srcList, Object ... objects) {
            if (objects == null || objects.length < 3) {
                throw new KDBizException("ColDimExitDimFilterImpl : error param");
            }
            Object[] array = new Object[objects.length - 2];
            System.arraycopy(objects, 2, array, 0, array.length);
            Object firstParam = objects[0];
            Object sedParam = objects[1];
            if (firstParam instanceof Integer && ((Integer)firstParam == 1 || (Integer)firstParam == 2) && sedParam instanceof Boolean && Arrays.stream(array).anyMatch(p -> !(p instanceof String))) {
                throw new KDBizException("ColDimOrRowDimExitDimFilterImpl : error param");
            }
            if (srcList == null || srcList.size() == 0) {
                return srcList;
            }
            boolean contain = (Boolean)sedParam;
            String detailEntity = (Integer)firstParam == 1 ? "rowmembdetail" : "colmembdetail";
            String detailDimMember = (Integer)firstParam == 1 ? "rowdimension.number" : "coldimension.number";
            Template template = srcList.get(0);
            Long modelId = template.getModelId();
            HashSet<String> dimIds = new HashSet<String>(array.length);
            Set templateIdset = srcList.stream().map(p -> p.id).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("id", "in", templateIdset);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < array.length; ++i) {
                dimIds.add((String)array[i]);
            }
            sb.append("id,").append("areapositionentry,").append("areapositionentry.rowmembdetail,").append("areapositionentry.coldimension");
            Map pagemembentry = BusinessDataServiceHelper.loadFromCache((String)"bcm_templateentity", (String)sb.toString(), (QFilter[])new QFilter[]{qFilter});
            Iterator iterator = pagemembentry.entrySet().iterator();
            HashSet<Long> willReturnTemplateIds = new HashSet<Long>(16);
            while (iterator.hasNext()) {
                DynamicObject value = (DynamicObject)iterator.next().getValue();
                long fid = value.getLong("id");
                DynamicObjectCollection areapositionentry = value.getDynamicObjectCollection("areapositionentry");
                boolean exist = areapositionentry.stream().anyMatch(p -> p.getDynamicObjectCollection(detailEntity).stream().anyMatch(x -> dimIds.contains(x.getString(detailDimMember))));
                if (contain ^ exist) continue;
                willReturnTemplateIds.add(fid);
            }
            return srcList.stream().filter(p -> willReturnTemplateIds.contains(p.getId())).collect(Collectors.toList());
        }
    }

    protected static class PageDimExitDimFilterImpl
    implements Filter<Template> {
        protected PageDimExitDimFilterImpl() {
        }

        @Override
        public List<Template> doFilte(List<Template> srcList, Object ... objects) {
            if (objects == null || objects.length < 1 || Arrays.stream(objects).anyMatch(p -> !(p instanceof Long))) {
                throw new KDBizException("PageDimExitDimFilterImpl : error param");
            }
            if (srcList == null || srcList.size() == 0) {
                return srcList;
            }
            Template template = srcList.get(0);
            Long modelId = template.getModelId();
            HashSet<Long> dimIds = new HashSet<Long>(objects.length);
            Set templateIdset = srcList.stream().map(p -> p.id).collect(Collectors.toSet());
            QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("id", "in", templateIdset);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < objects.length; ++i) {
                dimIds.add(LongUtil.toLong((Object)objects[i]));
            }
            sb.append("id,").append("pagemembentry.pagedimension,").append("pagemembentry.membbound,").append("pagepropentry.pagepropdim");
            Map pagemembentry = BusinessDataServiceHelper.loadFromCache((String)"bcm_templateentity", (String)sb.toString(), (QFilter[])new QFilter[]{qFilter});
            Iterator iterator = pagemembentry.entrySet().iterator();
            HashSet<Long> willReturnTemplateIds = new HashSet<Long>(16);
            while (iterator.hasNext()) {
                DynamicObject value = (DynamicObject)iterator.next().getValue();
                long fid = value.getLong("id");
                DynamicObjectCollection pagemembentrys = value.getDynamicObjectCollection("pagemembentry");
                boolean exist = pagemembentrys.stream().anyMatch(p -> dimIds.contains(p.getLong("pagedimension_id")));
                if (exist) {
                    willReturnTemplateIds.add(fid);
                    continue;
                }
                DynamicObjectCollection pagepropentrys = value.getDynamicObjectCollection("pagepropentry");
                exist = pagepropentrys.stream().anyMatch(p -> dimIds.contains(p.getLong("pagepropdim_id")));
                if (!exist) continue;
                willReturnTemplateIds.add(fid);
            }
            return srcList.stream().filter(p -> willReturnTemplateIds.contains(p.getId())).collect(Collectors.toList());
        }
    }

    protected static class DistributionFilterImpl
    implements Filter<Template> {
        protected DistributionFilterImpl() {
        }

        @Override
        public List<Template> doFilte(List<Template> srcList, Object ... objects) {
            if (objects == null || objects.length < 1 || Arrays.stream(objects).anyMatch(p -> !(p instanceof Long))) {
                throw new KDBizException("DistributionFilterImpl : error param");
            }
            if (srcList == null || srcList.size() == 0) {
                return srcList;
            }
            Template template = srcList.get(0);
            Long modelId = template.getModelId();
            Set<Object> entityMemIds = new HashSet<Object>(Arrays.asList(objects));
            entityMemIds = MemberReader.change2BaseMember((long)modelId, (String)"bcm_entitymembertree", entityMemIds);
            Set srcIdList = srcList.stream().map(p -> p.getId()).collect(Collectors.toSet());
            Map template2OrgMapOfDispense = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense((Long)modelId, srcIdList, entityMemIds);
            HashSet values = new HashSet(16);
            template2OrgMapOfDispense.forEach((k, v) -> {
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)v)) {
                    values.add(k);
                }
            });
            return srcList.stream().filter(template1 -> values.contains(template1.getId())).collect(Collectors.toList());
        }
    }

    protected static class PageDimMemberFilterImpl
    implements Filter<Template> {
        protected PageDimMemberFilterImpl() {
        }

        @Override
        public List<Template> doFilte(List<Template> srcList, Object ... objects) {
            if (objects == null || objects.length < 2 || Arrays.stream(objects).anyMatch(p -> !(p instanceof Long))) {
                throw new KDBizException("PageDimMemberFilterImpl : error param");
            }
            if (srcList == null || srcList.size() == 0) {
                return srcList;
            }
            Template template = srcList.get(0);
            Long modelId = template.getModelId();
            HashSet<Long> memIds = new HashSet<Long>(objects.length - 1);
            long dimId = (Long)objects[0];
            for (int i = 1; i < objects.length; ++i) {
                memIds.add(LongUtil.toLong((Object)objects[i]));
            }
            Set templateIdset = srcList.stream().map(p -> p.id).collect(Collectors.toSet());
            Map dimensions = BusinessDataServiceHelper.loadFromCache((String)"bcm_dimension", (String)"memberModel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimId)});
            DynamicObject dimensionDynamicObject = (DynamicObject)dimensions.get(dimId);
            String dimensionEntity = dimensionDynamicObject.getString("memberModel");
            QFilter qFilter = new QFilter("model", "=", (Object)modelId).and("id", "in", templateIdset);
            StringBuilder sb = new StringBuilder();
            sb.append("id,").append("pagemembentry.pagemembid,").append("pagemembentry.pagedimension,").append("pagemembentry.membbound,").append("pagepropentry.pagepropdim,").append("pagepropentry.membprop,").append("pagepropentry.propbound");
            Map pagemembentry = BusinessDataServiceHelper.loadFromCache((String)"bcm_templateentity", (String)sb.toString(), (QFilter[])new QFilter[]{qFilter});
            Iterator iterator = pagemembentry.entrySet().iterator();
            HashSet<Long> willReturnTemplateIds = new HashSet<Long>(16);
            while (iterator.hasNext()) {
                DynamicObject value = (DynamicObject)iterator.next().getValue();
                long fid = value.getLong("id");
                DynamicObjectCollection pagemembentrys = value.getDynamicObjectCollection("pagemembentry");
                boolean exist = pagemembentrys.stream().filter(p -> p.getLong("pagedimension_id") == dimId).anyMatch(p -> {
                    long pagemembid = p.getLong("pagemembid");
                    int membbound = p.getInt("membbound");
                    Set longs = QueryMemberDetailsHelper.queryMemberIdsByRange((String)dimensionEntity, (Long)pagemembid, (int)membbound, (String)String.valueOf(modelId), (DetailTypeEnum)DetailTypeEnum.OTHERS);
                    return memIds.stream().map(ma -> longs.contains(ma)).filter(ma -> ma).count() > 0L;
                });
                if (exist) {
                    willReturnTemplateIds.add(fid);
                    continue;
                }
                DynamicObjectCollection pagepropentrys = value.getDynamicObjectCollection("pagepropentry");
                exist = pagepropentrys.stream().filter(p -> p.getLong("pagepropdim_id") == dimId).anyMatch(p -> {
                    long membpropId = p.getLong("membprop.id");
                    String membpropNumber = p.getString("membprop.number");
                    int propbound = p.getInt("propbound");
                    Set ids = QueryMemberDetailsHelper.getMemberIdsByDefinedRange((String)dimensionEntity, (Long)membpropId, (String)membpropNumber, (int)propbound, (String)String.valueOf(modelId), (DetailTypeEnum)DetailTypeEnum.OTHERS);
                    return memIds.stream().map(ma -> ids.contains(ma)).filter(ma -> ma).count() > 0L;
                });
                if (!exist) continue;
                willReturnTemplateIds.add(fid);
            }
            return srcList.stream().filter(p -> willReturnTemplateIds.contains(p.getId())).collect(Collectors.toList());
        }
    }

    public static interface Filter<T> {
        public List<T> doFilte(List<T> var1, Object ... var2);
    }

    public static class TmplDimPosition
    extends BaseMServiceJsonModel {
        @JSONField(serialize=false)
        String arearange;
        @JSONField(serialize=false)
        Map<String, List<Long>> colDim;
        @JSONField(serialize=false)
        Map<String, List<Long>> rowDim;

        public String getArearange() {
            return this.arearange;
        }

        public void setArearange(String arearange) {
            this.arearange = arearange;
        }

        public Map<String, List<Long>> getColDim() {
            return this.colDim;
        }

        public void setColDim(Map<String, List<Long>> colDim) {
            this.colDim = colDim;
        }

        public Map<String, List<Long>> getRowDim() {
            return this.rowDim;
        }

        public void setRowDim(Map<String, List<Long>> rowDim) {
            this.rowDim = rowDim;
        }

        @Override
        protected int getArraySize() {
            return 3;
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            targetArray[0] = this.arearange;
            targetArray[1] = this.colDim;
            targetArray[2] = this.rowDim;
            return targetArray;
        }
    }

    public static class Template
    extends OlapServerBaseMetaInfo {
        @JSONField(serialize=false)
        Map<String, Long> viewpoint;
        @JSONField(serialize=false)
        Map<String, Set<Long>> pageDim;
        @JSONField(serialize=false)
        Long templateCatalogId;
        @JSONField(serialize=false)
        Long modelId;
        @JSONField(serialize=false)
        List<TmplDimPosition> tmplDimPositions;

        public Template(Long id, String number, String name) {
            super(id, number, name);
        }

        public Template() {
        }

        @Override
        protected int getArraySize() {
            return super.getArraySize() + 3;
        }

        public Map<String, Long> getViewpoint() {
            return this.viewpoint;
        }

        public void setViewpoint(Map<String, Long> viewpoint) {
            this.viewpoint = viewpoint;
        }

        public Map<String, Set<Long>> getPageDim() {
            return this.pageDim;
        }

        public void setPageDim(Map<String, Set<Long>> pageDim) {
            this.pageDim = pageDim;
        }

        public List<TmplDimPosition> getTmplDimPositions() {
            return this.tmplDimPositions;
        }

        public void setTmplDimPositions(List<TmplDimPosition> tmplDimPositions) {
            this.tmplDimPositions = tmplDimPositions;
        }

        public Long getTemplateCatalogId() {
            return this.templateCatalogId;
        }

        public void setTemplateCatalogId(Long templateCatalogId) {
            this.templateCatalogId = templateCatalogId;
        }

        public Long getModelId() {
            return this.modelId;
        }

        public void setModelId(Long modelId) {
            this.modelId = modelId;
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            super.appendSerializedArray(targetArray);
            int index = super.getArraySize();
            targetArray[index++] = this.viewpoint;
            targetArray[index++] = this.pageDim;
            targetArray[index++] = this.tmplDimPositions;
            return targetArray;
        }
    }

    public static class TemplateCatalog
    extends OlapServerBaseMetaInfo {
        @JSONField(serialize=false)
        long parentId;

        public long getParentId() {
            return this.parentId;
        }

        public void setParentId(long parentId) {
            this.parentId = parentId;
        }

        @Override
        protected int getArraySize() {
            return super.getArraySize() + 1;
        }

        public TemplateCatalog(Long id, String number, String name, long parentId) {
            super(id, number, name);
            this.parentId = parentId;
        }

        public TemplateCatalog() {
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            super.appendSerializedArray(targetArray);
            int index = super.getArraySize();
            targetArray[index++] = this.parentId;
            return targetArray;
        }
    }

    public static class OlapDimensionLookupMetaInfo
    extends BaseMServiceJsonModel
    implements IColumnValueConverter<String, Object[]> {
        private static final long serialVersionUID = 7173886848678268717L;
        protected int[] dimLookupType;
        protected Map<String, Object[][]>[] dimMemberLookupMaps;

        @Override
        public Object[][] convert(int dimIndex, String dimMemberNumber, Object ... controlParam) {
            Object[][] objects = this.dimMemberLookupMaps[dimIndex].get(dimMemberNumber);
            return objects;
        }

        public void initializeLookupIndex(Collection<OlapServerDimemsionMetaInfo> srcDimMetas, String[] hierarchyNumbers) {
            this.dimMemberLookupMaps = new Map[srcDimMetas.size()];
            Iterator<OlapServerDimemsionMetaInfo> iterator = srcDimMetas.iterator();
            int index = 0;
            HashSet<String> hierarchyDims = hierarchyNumbers != null ? new HashSet<String>(Arrays.asList(hierarchyNumbers)) : Collections.emptySet();
            this.dimLookupType = new int[srcDimMetas.size()];
            while (iterator.hasNext()) {
                OlapServerDimemsionMetaInfo dimInfo = iterator.next();
                String dimNumber = dimInfo.getNumber();
                String dimEntityName = dimInfo.getDimEntityName();
                LinkedHashMap<String, Object[][]> map = new LinkedHashMap<String, Object[][]>(16);
                Map<String, List<OlapServerDimMemberMetaInfo>> dimMembers = dimInfo.getDimMembers();
                boolean ishiberarchyDim = hierarchyDims.contains(dimNumber);
                for (Map.Entry<String, List<OlapServerDimMemberMetaInfo>> next : dimMembers.entrySet()) {
                    String key = next.getKey();
                    List<OlapServerDimMemberMetaInfo> value = next.getValue();
                    if (!ishiberarchyDim) {
                        if (CollectionUtils.isEmpty(value)) continue;
                        OlapServerDimMemberMetaInfo olapServerDimMemberMetaInfo = value.get(0);
                        if ("bcm_periodmembertree".equals(dimEntityName)) {
                            this.setDict(index, MODELTYPE.PeriodDimMemLookupValueItem);
                            map.put(key, new Object[][]{{olapServerDimMemberMetaInfo.getName(), ((OlapServerDimMemberMetaInfoPeriod)olapServerDimMemberMetaInfo).getDate()}});
                            continue;
                        }
                        this.setDict(index, MODELTYPE.SingleNameDimMemLookupValueItem);
                        map.put(key, new Object[][]{{olapServerDimMemberMetaInfo.getName()}});
                        continue;
                    }
                    if ("bcm_entitymembertree".equals(dimEntityName)) {
                        this.setDict(index, MODELTYPE.EntityHierarchyDimMemLookupValueItem);
                        map.put(key, this.setObjectArraySpecial(value));
                        continue;
                    }
                    map.put(key, this.setObjectArray(value, index));
                }
                this.dimMemberLookupMaps[index++] = map;
            }
        }

        private void setDict(int index, MODELTYPE modeltype) {
            if (this.dimLookupType != null && this.dimLookupType[index] == 0) {
                this.dimLookupType[index] = modeltype.getValue();
            }
        }

        private Object[][] setObjectArray(List<OlapServerDimMemberMetaInfo> dimMembers, int index) {
            Object[][] outputResult = new Object[dimMembers.size()][];
            int i = 0;
            for (OlapServerDimMemberMetaInfo dimMember : dimMembers) {
                if (dimMember instanceof OlapServerDimMemberMetaInfoPeriod) {
                    outputResult[i] = new Object[]{String.valueOf(dimMember.getId()), String.valueOf(dimMember.getParent()), dimMember.getName(), ((OlapServerDimMemberMetaInfoPeriod)dimMember).getDate()};
                    this.setDict(index, MODELTYPE.PeriodHierarchyDimMemLookupValueItem);
                } else {
                    outputResult[i] = new Object[]{String.valueOf(dimMember.getId()), String.valueOf(dimMember.getParent()), dimMember.getName()};
                    this.setDict(index, MODELTYPE.SingleHierarchyDimMemLookupValueItem);
                }
                ++i;
            }
            return outputResult;
        }

        private Object[][] setObjectArraySpecial(List<OlapServerDimMemberMetaInfo> dimMembers) {
            Object[][] outputResult = new Object[1][];
            if (!CollectionUtils.isEmpty(dimMembers)) {
                OlapServerDimMemberMetaInfo olapServerDimMemberMetaInfo = dimMembers.get(0);
                String name = olapServerDimMemberMetaInfo.getName();
                if (olapServerDimMemberMetaInfo instanceof OlapServerDimMemberMetaInfoEntity) {
                    String strDateFormat = "yyyyMM";
                    SimpleDateFormat sdf = new SimpleDateFormat(strDateFormat);
                    Map collect = dimMembers.stream().map(p -> (OlapServerDimMemberMetaInfoEntity)p).collect(Collectors.groupingBy(p -> sdf.format(p.getBizeffdate()), Collectors.reducing((a, b) -> {
                        if (a.getBizeffdate().before(b.getBizeffdate())) {
                            return b;
                        }
                        if (a.getBizeffdate().equals(b.getBizeffdate()) && ArrayUtils.contains((Object[])priority, (Object)b.getChangeType())) {
                            return b;
                        }
                        return a;
                    })));
                    TreeMap treeMap = new TreeMap();
                    collect.forEach((k, v) -> treeMap.put(k, new Object[]{String.valueOf(((OlapServerDimMemberMetaInfoEntity)v.get()).getId()), String.valueOf(((OlapServerDimMemberMetaInfoEntity)v.get()).getParent()), ((OlapServerDimMemberMetaInfoEntity)v.get()).getChangeType()}));
                    outputResult[0] = new Object[]{treeMap, name};
                }
            }
            return outputResult;
        }

        @Override
        protected int getArraySize() {
            return 2;
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            targetArray[0] = JSON.toJSONString(this.dimMemberLookupMaps);
            targetArray[1] = JSON.toJSONString((Object)this.dimLookupType);
            return targetArray;
        }

        @Override
        protected void updateValueArray(Object[] v) {
        }

        @Override
        public int getCategoryCnt(int index) {
            return this.dimMemberLookupMaps[index].entrySet().iterator().next().getValue().length;
        }

        private static enum MODELTYPE {
            SingleNameDimMemLookupValueItem(1),
            SingleHierarchyDimMemLookupValueItem(2),
            PeriodDimMemLookupValueItem(3),
            PeriodHierarchyDimMemLookupValueItem(4),
            EntityHierarchyDimMemLookupValueItem(5);

            int value;

            private MODELTYPE(int value) {
                this.value = value;
            }

            public int getValue() {
                return this.value;
            }
        }
    }

    public static interface IColumnValueConverter<T, R>
    extends Serializable {
        public R convert(int var1, T var2, Object ... var3);

        public int getCategoryCnt(int var1);
    }

    public static class OlapServerMeasureMetaInfo
    extends BaseMServiceJsonModel {
        private static final long serialVersionUID = 5390849236474468734L;
        @JSONField(serialize=false)
        protected Integer measureTypeFieldIndex;
        @JSONField(serialize=false)
        protected String measureTypeField;
        @JSONField(serialize=false)
        protected Integer measureFieldIndex;

        public String toString() {
            return "OlapServerMeasureMetaInfo [measureTypeFieldIndex=" + this.measureTypeFieldIndex + ", measureTypeField=" + this.measureTypeField + ", measureFieldIndex=" + this.measureFieldIndex + "]";
        }

        @JSONField(serialize=false)
        public int getMeasureTypeFieldIndex() {
            return this.measureTypeFieldIndex;
        }

        public void setMeasureTypeFieldIndex(Integer measureTypeFieldIndex) {
            this.measureTypeFieldIndex = measureTypeFieldIndex;
        }

        @JSONField(serialize=false)
        public String getMeasureTypeField() {
            return this.measureTypeField;
        }

        public void setMeasureTypeField(String measureTypeField) {
            this.measureTypeField = measureTypeField;
        }

        @JSONField(serialize=false)
        public int getMeasureFieldIndex() {
            return this.measureFieldIndex;
        }

        public void setMeasureFieldIndex(Integer measureFieldIndex) {
            this.measureFieldIndex = measureFieldIndex;
        }

        @Override
        @JSONField(serialize=false)
        protected int getArraySize() {
            return 3;
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            targetArray[0] = this.measureTypeFieldIndex;
            targetArray[1] = this.measureTypeField;
            targetArray[2] = this.measureFieldIndex;
            return targetArray;
        }

        @Override
        protected void updateValueArray(Object[] v) {
            this.measureTypeFieldIndex = this.getInteger(v, 0);
            this.measureTypeField = this.getString(v, 1);
            this.measureFieldIndex = this.getInteger(v, 2);
        }
    }

    public static class OlapServerDimemsionMetaInfo
    extends OlapServerBaseMetaInfo {
        private static final long serialVersionUID = -8587656821365432066L;
        @JSONField(serialize=false)
        protected String dimEntityName;
        @JSONField(serialize=false)
        protected String fieldMapped;
        @JSONField(serialize=false)
        protected Map<String, List<OlapServerDimMemberMetaInfo>> dimMembers = new LinkedHashMap<String, List<OlapServerDimMemberMetaInfo>>(10);
        @JSONField(serialize=false)
        private Set<String> limitedMembers;

        public OlapServerDimemsionMetaInfo() {
            this(null, null, null, null, null);
        }

        public OlapServerDimemsionMetaInfo(Long id, String number, String name, String dimEntityName, String fieldMapped, Collection<String> limitedMembers) {
            super(id, number, name);
            this.dimEntityName = dimEntityName;
            this.fieldMapped = fieldMapped;
            this.limitedMembers = new LinkedHashSet<String>(10);
            if (limitedMembers != null) {
                this.limitedMembers.addAll(limitedMembers);
            }
        }

        public OlapServerDimemsionMetaInfo(Long id, String number, String name, String dimEntityName, String fieldMapped) {
            this(id, number, name, dimEntityName, fieldMapped, null);
        }

        public String toString() {
            return "OlapServerDimemsionMetaInfo{id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", dimEntityName='" + this.dimEntityName + '\'' + ", fieldMapped='" + this.fieldMapped + '\'' + ", dimMembers=" + this.dimMembers + ", limitedMembers=" + this.limitedMembers + '}';
        }

        public List<OlapServerDimMemberMetaInfo> getDimMemberByNumber(String memberNumber) {
            return this.dimMembers.get(memberNumber);
        }

        @Override
        @JSONField(serialize=false)
        protected int getArraySize() {
            return super.getArraySize() + 4;
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            super.appendSerializedArray(targetArray);
            int index = super.getArraySize();
            targetArray[index++] = this.dimEntityName;
            targetArray[index++] = this.fieldMapped;
            targetArray[index++] = this.dimMembers;
            targetArray[index] = this.limitedMembers;
            return targetArray;
        }

        @Override
        protected void updateValueArray(Object[] v) {
            super.updateValueArray(v);
            int index = super.getArraySize();
            this.dimEntityName = this.getString(v, index++);
            this.fieldMapped = this.getString(v, index++);
            JSONObject jsonObject = JSON.parseObject((String)v[index++].toString());
            this.dimMembers = new HashMap<String, List<OlapServerDimMemberMetaInfo>>(10);
            this.parseMapValue(jsonObject, this.dimMembers, k -> k, (k, o) -> this.parseDimMemberMetaInfo((String)k, o));
            JSONArray jsonArray = JSON.parseArray((String)v[index].toString());
            if (jsonArray != null && !jsonArray.isEmpty()) {
                this.limitedMembers = new LinkedHashSet<String>(jsonArray.size());
                this.limitedMembers.addAll(jsonArray.toJavaList(String.class));
            }
        }

        protected List<OlapServerDimMemberMetaInfo> parseDimMemberMetaInfo(String key, Object srcObject) {
            JSONArray jsonArray = OlapServerDimemsionMetaInfo.toJSONArray(srcObject);
            List list = null;
            if (jsonArray != null) {
                list = JSONObject.parseArray((String)jsonArray.toJSONString(), OlapServerDimMemberMetaInfo.class);
            }
            return list == null ? Collections.emptyList() : list;
        }

        @JSONField(serialize=false)
        public String getDimEntityName() {
            return this.dimEntityName;
        }

        public void setDimEntityName(String dimEntityName) {
            this.dimEntityName = dimEntityName;
        }

        @JSONField(serialize=false)
        public String getFieldMapped() {
            return this.fieldMapped;
        }

        public void setFieldMapped(String fieldMapped) {
            this.fieldMapped = fieldMapped;
        }

        @JSONField(serialize=false)
        public Map<String, List<OlapServerDimMemberMetaInfo>> getDimMembers() {
            return this.dimMembers;
        }

        public void setDimMembers(Map<String, List<OlapServerDimMemberMetaInfo>> dimMembers) {
            this.dimMembers = dimMembers;
        }

        @JSONField(serialize=false)
        public Set<String> getLimitedMembers() {
            return this.limitedMembers;
        }

        public void setLimitedMembers(Set<String> limitedMembers) {
            this.limitedMembers = limitedMembers;
        }
    }

    public static class OlapServerDimMemberMetaInfoPeriod
    extends OlapServerDimMemberMetaInfo {
        private static final long serialVersionUID = 136776478513390286L;
        @JSONField(serialize=false)
        protected String date;

        @Override
        protected int getArraySize() {
            return super.getArraySize() + 1;
        }

        public OlapServerDimMemberMetaInfoPeriod() {
        }

        public OlapServerDimMemberMetaInfoPeriod(Long id, String number, String name, int level, boolean isLeaf, int seq, Long parent, String longNumber, String storagetype, String aggoprt) {
            super(id, number, name, level, isLeaf, seq, parent, longNumber, storagetype, aggoprt);
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            super.appendSerializedArray(targetArray);
            int index = super.getArraySize();
            targetArray[index++] = this.date;
            return targetArray;
        }

        @Override
        protected void updateValueArray(Object[] v) {
            super.updateValueArray(v);
            int index = super.getArraySize();
            this.date = this.getString(v, index++);
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }
    }

    public static class OlapServerDimMemberMetaInfoEntity
    extends OlapServerDimMemberMetaInfo {
        private static final long serialVersionUID = 136776478513390285L;
        @JSONField(serialize=false)
        protected String changeType;
        @JSONField(serialize=false)
        protected Date bizeffdate;

        @Override
        protected int getArraySize() {
            return super.getArraySize() + 2;
        }

        public OlapServerDimMemberMetaInfoEntity() {
        }

        public OlapServerDimMemberMetaInfoEntity(Long id, String number, String name, int level, boolean isLeaf, int seq, Long parent, String longNumber, String storagetype, String aggoprt) {
            super(id, number, name, level, isLeaf, seq, parent, longNumber, storagetype, aggoprt);
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            super.appendSerializedArray(targetArray);
            int index = super.getArraySize();
            targetArray[index++] = this.changeType;
            targetArray[index] = this.bizeffdate;
            return targetArray;
        }

        @Override
        protected void updateValueArray(Object[] v) {
            super.updateValueArray(v);
            int index = super.getArraySize();
            this.changeType = this.getString(v, index++);
            this.bizeffdate = this.getDate(v, index);
        }

        public String getChangeType() {
            return this.changeType;
        }

        public void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        public Date getBizeffdate() {
            return this.bizeffdate;
        }

        public void setBizeffdate(Date bizeffdate) {
            this.bizeffdate = bizeffdate;
        }
    }

    public static class OlapServerDimMemberMetaInfo
    extends OlapServerBaseMetaInfo {
        private static final long serialVersionUID = -7051884047846810665L;
        @JSONField(serialize=false)
        protected Long parent;
        @JSONField(serialize=false)
        protected String longNumber;
        @JSONField(serialize=false)
        protected int seq;
        @JSONField(serialize=false)
        protected int level;
        @JSONField(serialize=false)
        protected boolean isLeaf;
        @JSONField(serialize=false)
        protected String aggoprt;
        @JSONField(serialize=false)
        protected String storagetype;

        public OlapServerDimMemberMetaInfo() {
        }

        public OlapServerDimMemberMetaInfo(Long id, String number, String name, int level, boolean isLeaf) {
            super(id, number, name);
            this.level = level;
            this.isLeaf = isLeaf;
        }

        public OlapServerDimMemberMetaInfo(Long id, String number, String name, int level, boolean isLeaf, int seq, Long parent, String longNumber, String storagetype, String aggoprt) {
            super(id, number, name);
            this.parent = parent;
            this.longNumber = longNumber;
            this.seq = seq;
            this.level = level;
            this.isLeaf = isLeaf;
            this.storagetype = storagetype;
            this.aggoprt = aggoprt;
        }

        public String toString() {
            return "OlapServerDimMemberMetaInfo{id=" + this.id + ", number='" + this.number + '\'' + ", name='" + this.name + '\'' + ", level=" + this.level + ", isLeaf=" + this.isLeaf + ", storagetype=" + this.storagetype + ", aggopr=" + this.aggoprt + '}';
        }

        @Override
        @JSONField(serialize=false)
        protected int getArraySize() {
            return super.getArraySize() + 7;
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            super.appendSerializedArray(targetArray);
            int index = super.getArraySize();
            targetArray[index++] = this.parent;
            targetArray[index++] = this.longNumber;
            targetArray[index++] = this.seq;
            targetArray[index++] = this.level;
            targetArray[index++] = this.isLeaf;
            targetArray[index++] = this.storagetype;
            targetArray[index++] = this.aggoprt;
            return targetArray;
        }

        @Override
        protected void updateValueArray(Object[] v) {
            super.updateValueArray(v);
            int index = super.getArraySize();
            this.parent = this.getLong(v, index++);
            this.longNumber = this.getString(v, index++);
            this.seq = this.getInteger(v, index++);
            this.level = this.getInteger(v, index++);
            this.isLeaf = OlapServerDimMemberMetaInfo.getBoolean(v, index);
            this.storagetype = this.getString(v, index);
            this.aggoprt = this.getString(v, index);
        }

        @JSONField(serialize=false)
        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        @JSONField(serialize=false)
        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        @JSONField(serialize=false)
        public Long getParent() {
            return this.parent;
        }

        public void setParent(Long parent) {
            this.parent = parent;
        }

        @JSONField(serialize=false)
        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        @JSONField(serialize=false)
        public int getSeq() {
            return this.seq;
        }

        public void setSeq(int seq) {
            this.seq = seq;
        }
    }

    public static class OlapCslSchemeInfo
    extends OlapServerBaseMetaInfo {
        @JSONField(serialize=false)
        protected String longNumber;

        public OlapCslSchemeInfo(Long id, String number, String name, String longNumber) {
            super(id, number, name);
            this.longNumber = longNumber;
        }

        public OlapCslSchemeInfo() {
        }

        @Override
        @JSONField(serialize=false)
        protected int getArraySize() {
            return super.getArraySize() + 1;
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            super.appendSerializedArray(targetArray);
            int index = super.getArraySize();
            targetArray[index] = this.longNumber;
            return targetArray;
        }

        @Override
        protected void updateValueArray(Object[] v) {
            super.updateValueArray(v);
            int index = super.getArraySize();
            this.longNumber = this.getString(v, index);
        }
    }

    public static class OlapServerBaseMetaInfo
    extends BaseMServiceJsonModel {
        private static final long serialVersionUID = -6364793384513876839L;
        @JSONField(serialize=false)
        protected Long id;
        @JSONField(serialize=false)
        protected String number;
        @JSONField(serialize=false)
        protected String name;

        public OlapServerBaseMetaInfo() {
        }

        public OlapServerBaseMetaInfo(Long id, String number, String name) {
            this.id = id;
            this.number = number;
            this.name = name;
        }

        @Override
        @JSONField(serialize=false)
        protected int getArraySize() {
            return 3;
        }

        @Override
        protected Object[] appendSerializedArray(Object[] targetArray) {
            targetArray[0] = this.id;
            targetArray[1] = this.number;
            targetArray[2] = this.name;
            return targetArray;
        }

        @Override
        protected void updateValueArray(Object[] v) {
            this.id = this.getLong(v, 0);
            this.number = this.getString(v, 1);
            this.name = this.getString(v, 2);
        }

        @JSONField(serialize=false)
        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        @JSONField(serialize=false)
        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        @JSONField(serialize=false)
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static abstract class BaseMServiceJsonModel
    implements Serializable {
        private static final long serialVersionUID = -8165314269932568534L;

        @JSONField(serialize=false)
        protected abstract int getArraySize();

        public void initFromJsonString(String jsonString) {
            this.initFromJsonArray(BaseMServiceJsonModel.toJSONArray(jsonString));
        }

        public void initFromJsonArray(JSONArray jsonArray) {
            if (jsonArray != null) {
                this.updateValueArray(jsonArray.toArray());
            }
        }

        protected Object[] appendSerializedArray(Object[] targetArray) {
            return targetArray;
        }

        protected void updateValueArray(Object[] v) {
        }

        public Object[] getV() {
            return this.appendSerializedArray(new Object[this.getArraySize()]);
        }

        public void setV(Object[] v) {
            if (v == null) {
                return;
            }
            if (v.length > this.getArraySize()) {
                throw new IllegalArgumentException(String.format("Expect %s Array Size:%s, but acutal size=%s", this.getClass().getName(), this.getArraySize(), v.length));
            }
            this.updateValueArray(v);
        }

        protected <K, R> void parseMapValue(JSONObject jsonObject, Map<K, R> outputMap, Function<String, K> keyParseFun, BiFunction<K, Object, R> valueParseFun) {
            if (jsonObject != null && !jsonObject.isEmpty()) {
                for (Map.Entry en : jsonObject.entrySet()) {
                    K keyValue = keyParseFun.apply((String)en.getKey());
                    outputMap.put(keyValue, valueParseFun.apply(keyValue, en.getValue()));
                }
            }
        }

        protected <R> void parseCollectionValue(JSONObject jsonObject, Collection<R> outputCollection, BiFunction<String, Object, R> valueParseFun) {
            if (jsonObject != null && !jsonObject.isEmpty()) {
                for (Map.Entry en : jsonObject.entrySet()) {
                    R valueBuf = valueParseFun.apply((String)en.getKey(), en.getValue());
                    if (valueBuf == null) continue;
                    outputCollection.add(valueBuf);
                }
            }
        }

        protected void parseJsonValue(JSONObject jsonObject, BiConsumer<String, Object> valueConsumer) {
            if (jsonObject != null && !jsonObject.isEmpty()) {
                for (Map.Entry en : jsonObject.entrySet()) {
                    valueConsumer.accept((String)en.getKey(), en.getValue());
                }
            }
        }

        protected String getString(Object[] v, int index) {
            return this.getString(v[index]);
        }

        protected BigDecimal getBigDecimal(Object[] v, int index) {
            return BaseMServiceJsonModel.getBigDecimal(v[index]);
        }

        protected BigInteger getBigInteger(Object[] v, int index) {
            return new BigInteger(this.getString(v, index));
        }

        protected Date getDate(Object[] v, int index) {
            return BaseMServiceJsonModel.getDate(v[index]);
        }

        protected static Boolean getBoolean(Object[] v, int index) {
            return BaseMServiceJsonModel.getBoolean(v[index]);
        }

        protected static Date getDate(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Long) {
                return new Date((Long)value);
            }
            if (value instanceof Date) {
                return (Date)ObjectConverter.convert((Object)value, Date.class, (boolean)false);
            }
            if (value instanceof String) {
                return new Date(Long.parseLong((String)value));
            }
            return null;
        }

        protected Integer getInteger(Object[] v, int index) {
            return BaseMServiceJsonModel.getInteger(v[index]);
        }

        protected Short getShort(Object[] v, int index) {
            return BaseMServiceJsonModel.getShort(v[index]);
        }

        protected Long getLong(Object[] v, int index) {
            return BaseMServiceJsonModel.getLong(v[index]);
        }

        protected Double getDouble(Object[] v, int index) {
            return BaseMServiceJsonModel.getDouble(v[index]);
        }

        protected Float getFloat(Object[] v, int index) {
            return BaseMServiceJsonModel.getFloat(v[index]);
        }

        protected String getString(Object value) {
            return value != null ? String.valueOf(value) : null;
        }

        protected static Long getLong(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            return Long.valueOf(value.toString());
        }

        protected static Double getDouble(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            return Double.valueOf(value.toString());
        }

        protected static Boolean getBoolean(Object value) {
            if (value != null) {
                switch (value.toString().toLowerCase(Locale.ENGLISH)) {
                    case "1": 
                    case "y": 
                    case "yes": 
                    case "t": 
                    case "true": 
                    case "ok": {
                        return true;
                    }
                }
            }
            return false;
        }

        protected static BigDecimal getBigDecimal(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            return new BigDecimal(value.toString());
        }

        protected static Byte getByte(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Byte) {
                return (Byte)value;
            }
            return Byte.parseByte(value.toString());
        }

        protected static Float getFloat(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Float) {
                return (Float)value;
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }

        protected static Short getShort(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Short) {
                return (Short)value;
            }
            return Short.parseShort(value.toString());
        }

        protected static Integer getInteger(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Integer) {
                return (Integer)value;
            }
            return Integer.getInteger(value.toString());
        }

        public static JSONObject toJSONObject(Object source) {
            if (source == null) {
                return null;
            }
            if (source instanceof JSONObject) {
                return (JSONObject)source;
            }
            throw new KDBizException(String.format("Expect JSONObject, but accutal=%s", source.getClass().getName()));
        }

        protected static boolean isJSonFormat(String srcString, String ... checkContainString) {
            if (srcString == null) {
                return false;
            }
            String strBuf = srcString.trim();
            if (!strBuf.startsWith("{") || !strBuf.endsWith("}")) {
                return false;
            }
            if (checkContainString != null && checkContainString.length > 0) {
                for (String s : checkContainString) {
                    if (strBuf.contains(s)) continue;
                    return false;
                }
            }
            return true;
        }

        public static JSONArray toJSONArray(Object source) {
            if (source == null) {
                return null;
            }
            if (source instanceof String) {
                String jsonStr = source.toString();
                if (BaseMServiceJsonModel.isJSonFormat(jsonStr, new String[0])) {
                    return BaseMServiceJsonModel.toJSONArray(JSON.parseObject((String)jsonStr));
                }
            } else {
                if (source instanceof JSONArray) {
                    return (JSONArray)source;
                }
                if (source instanceof JSONObject) {
                    return ((JSONObject)source).getJSONArray("v");
                }
            }
            throw new KDBizException(String.format("Expect JSONObject or JSONArray, but accutal[Class=%s]=%s", source.getClass().getName(), source));
        }
    }

    public static class FilterUtil {
        public static List<Filter> changeListAndValidParam(int[] filterNumbers, Object[][] params, Class<?> aclass) {
            List list = Collections.emptyList();
            if (filterNumbers != null && params != null) {
                if (filterNumbers.length != params.length) {
                    throw new KDBizException("filters.length != params.length");
                }
                list = Arrays.stream(filterNumbers).mapToObj(p -> FilterEnum.getFilterEnum(p)).collect(Collectors.toList());
            } else if (filterNumbers != null && filterNumbers.length > 0 && params == null) {
                throw new KDBizException("filters.length != params.length");
            }
            boolean exist = list.stream().allMatch(p -> p.mustClass.isAssignableFrom(aclass));
            if (!exist) {
                throw new KDBizException(String.format("all filters need %s class", aclass.getName()));
            }
            return list.stream().map(p -> p.filter).collect(Collectors.toList());
        }

        public static boolean allMatchclazz(int[] filterNumbers, Class<?> clazz) {
            if (ArrayUtils.isEmpty((int[])filterNumbers)) {
                return true;
            }
            List list = Arrays.stream(filterNumbers).mapToObj(p -> FilterEnum.getFilterEnum(p)).collect(Collectors.toList());
            boolean exist = list.stream().map(p -> p.getMustClass()).allMatch(p -> p.isAssignableFrom(clazz));
            return exist;
        }
    }

    public static enum FilterEnum {
        PageDimMemberFilterImpl(1, new PageDimMemberFilterImpl(), Template.class),
        DistributionFilterImpl(2, new DistributionFilterImpl(), Template.class),
        PageDimExitDimFilterImpl(3, new PageDimExitDimFilterImpl(), Template.class),
        ColDimOrRowDimExitDimFilterImpl(4, new ColDimOrRowDimExitDimFilterImpl(), Template.class);

        int value;
        Filter filter;
        Class<?> mustClass;

        private FilterEnum(int value, Filter filter, Class<?> mustClass) {
            this.value = value;
            this.filter = filter;
            this.mustClass = mustClass;
        }

        public Class<?> getMustClass() {
            return this.mustClass;
        }

        public static FilterEnum getFilterEnum(int value) {
            switch (value) {
                case 1: {
                    return PageDimMemberFilterImpl;
                }
                case 2: {
                    return DistributionFilterImpl;
                }
                case 3: {
                    return PageDimExitDimFilterImpl;
                }
                case 4: {
                    return ColDimOrRowDimExitDimFilterImpl;
                }
            }
            throw new KDBizException(String.format("%s has not mapping FilterEnum", value));
        }
    }
}

