/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integrationnew.service.IntegrateDispatcher2;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.enums.HWModelTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.service.BatchEntryIntegrationMsService;

public class BatchEntryIntegrationMsServiceImpl
implements BatchEntryIntegrationMsService {
    private DynamicObject model;
    private Long modelId;
    private String scenarioNum;
    private String yearNum;
    private String periodNum;
    private String entityNum;
    private boolean isLG;

    public boolean execute(Map<String, Object> param) {
        this.validate(param);
        IntegrateEntity integrateEntity = new IntegrateEntity();
        this.buildIntegrateEntity(integrateEntity);
        this.setOrgAndScheme(integrateEntity);
        IntegrateDispatcher2.submitTask2((IntegrateEntity)integrateEntity, (boolean)true, (boolean)true, null);
        return true;
    }

    private void buildIntegrateEntity(IntegrateEntity integrateEntity) {
        integrateEntity.setModel(this.modelId, this.model.getString("number"));
        DynamicObject scenarioMember = this.getMember("Scenario", this.scenarioNum);
        integrateEntity.setScene(Long.valueOf(scenarioMember.getLong("id")), this.scenarioNum);
        DynamicObject yearMember = this.getMember("Year", this.yearNum);
        integrateEntity.setYear(Long.valueOf(yearMember.getLong("id")), this.yearNum);
        DynamicObject periodMember = this.getMember("Period", this.periodNum);
        integrateEntity.setPeriod(Long.valueOf(periodMember.getLong("id")), this.periodNum);
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        filter.and("number", "=", (Object)"EC");
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])new QFilter[]{filter});
        integrateEntity.setCurrency(Long.valueOf(currency.getLong("id")), currency.getString("number"));
    }

    private void setOrgAndScheme(IntegrateEntity integrateEntity) {
        DynamicObjectCollection orgs;
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        filter.and(QFilter.of((String)"scheme.enable = ?", (Object[])new Object[]{Boolean.TRUE}));
        filter.and(QFilter.of((String)"scheme.istarg.number = ?", (Object[])new Object[]{"NG"}));
        filter.and(QFilter.of((String)"scheme.issrc.number = ?", (Object[])new Object[]{"MIDLIB"}));
        String selectProperties = "scheme,entity,property,propertyvalue,range";
        DynamicObject[] schemeAssignEntitys = BusinessDataServiceHelper.load((String)"bcm_isschemeassignentity", (String)selectProperties, (QFilter[])new QFilter[]{filter});
        if (this.isLG) {
            QFilter orgFilter = new QFilter("model", "=", (Object)this.modelId);
            orgFilter.and("number", "=", (Object)this.entityNum);
            orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number,storagetype", (QFilter[])new QFilter[]{orgFilter});
            if (orgs == null || orgs.size() == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u7ec4\u7ec7\u7f16\u7801\u53c2\u6570\u3002", (String)"BatchEntryIntegrationMsServiceImpl_4", (String)"fi-bcm-mservice", (Object[])new Object[0]), this.entityNum));
            }
            if (((DynamicObject)orgs.get(0)).getString("storagetype").equals(StorageTypeEnum.SHARE.index)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u662f\u5171\u4eab\u5b58\u50a8\u7c7b\u578b\uff0c\u4e0d\u652f\u6301\u96c6\u6210\u3002", (String)"BatchEntryIntegrationMsServiceImpl_5", (String)"fi-bcm-mservice", (Object[])new Object[0]), this.entityNum));
            }
        } else {
            QFilter orgFilter1 = new QFilter("model", "=", (Object)this.modelId);
            orgFilter1.and("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
            orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])new QFilter[]{orgFilter1});
            if (orgs == null || orgs.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0b\u6ca1\u6709\u975e\u5171\u4eab\u5c5e\u6027\u7684\u7ec4\u7ec7\uff0c\u8bf7\u5148\u7ef4\u62a4\u3002", (String)"BatchEntryIntegrationMsServiceImpl_6", (String)"fi-bcm-mservice", (Object[])new Object[0]));
            }
        }
        for (DynamicObject org2 : orgs) {
            String archiveStatus = "";
            Object flowStatus = "";
            QFilter controlFilter = new QFilter("model", "=", (Object)this.modelId);
            controlFilter.and("org", "=", (Object)org2.getString("id"));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_mergecontrolentity", (String)"archivestatus,flowstatus", (QFilter[])new QFilter[]{controlFilter});
            if (dynamicObject != null) {
                archiveStatus = dynamicObject.getString("archivestatus");
                flowStatus = dynamicObject.getString("flowstatus");
            }
            if (archiveStatus.equals("D")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u4e0b\u8be5\u7ec4\u7ec7\u7684\u5f52\u6863\u72b6\u6001\u4e3a\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u8c03\u5ea6\u3002", (String)"BatchEntryIntegrationMsServiceImpl_8", (String)"fi-bcm-mservice", (Object[])new Object[0]));
            }
            if (((String)flowStatus).equals("C")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u4e0b\u8be5\u7ec4\u7ec7\u7684\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\uff0c\u4e0d\u5141\u8bb8\u8c03\u5ea6", (String)"BatchEntryIntegrationMsServiceImpl_9", (String)"fi-bcm-mservice", (Object[])new Object[0]));
            }
            if (!((String)flowStatus).equals("D")) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u667a\u80fd\u5408\u5e76\u4e0b\u8be5\u7ec4\u7ec7\u7684\u6d41\u7a0b\u72b6\u6001\u4e3a\u201c\u5df2\u5f52\u6863\u201d\uff0c\u4e0d\u5141\u8bb8\u8c03\u5ea6", (String)"BatchEntryIntegrationMsServiceImpl_10", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        HashMap orgRangeId = new HashMap(16);
        HashMap orgRangeNum = new HashMap(16);
        orgs.forEach(org -> {
            orgRangeId.put(org.getString("number"), org.getLong("id"));
            orgRangeNum.put(org.getLong("id"), org.getString("number"));
        });
        HashBasedTable schemeOrgIdMaps = HashBasedTable.create();
        for (DynamicObject schemeAssign : schemeAssignEntitys) {
            String mnumber;
            long mId;
            DynamicObject entity = schemeAssign.getDynamicObject("entity");
            boolean isCustom = false;
            if (entity == null) {
                isCustom = true;
                DynamicObject propertyvalue = schemeAssign.getDynamicObject("propertyvalue");
                if (ObjectUtils.isEmpty((Object)propertyvalue)) continue;
                mId = propertyvalue.getLong("id");
                mnumber = propertyvalue.getString("number");
            } else {
                mId = entity.getLong("id");
                mnumber = entity.getString("number");
            }
            MembRangeItem rangItem = new MembRangeItem("bcm_entitymembertree", Long.valueOf(mId), mnumber, RangeEnum.getRangeByVal((int)schemeAssign.getInt("range")), isCustom, (Object)this.modelId);
            rangItem.matchItems(arg_0 -> BatchEntryIntegrationMsServiceImpl.lambda$setOrgAndScheme$1(orgRangeId, schemeAssign, (Table)schemeOrgIdMaps, arg_0));
        }
        ArrayList schemeIds = new ArrayList(schemeOrgIdMaps.rowKeySet());
        IntegrationUtil.filterSchemeByScenarioAndDate((long)this.modelId, (String)this.scenarioNum, (String)this.periodNum, (String)this.yearNum, schemeIds);
        schemeOrgIdMaps.cellSet().removeIf(longLongDynamicObjectCell -> !schemeIds.contains(longLongDynamicObjectCell.getRowKey()));
        if (schemeOrgIdMaps.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u6267\u884c\u7684\u96c6\u6210\u65b9\u6848\u3002", (String)"BatchEntryIntegrationMsServiceImpl_7", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        for (Table.Cell cell : schemeOrgIdMaps.cellSet()) {
            Long orgId = (Long)cell.getColumnKey();
            Long schemeId = (Long)cell.getRowKey();
            DynamicObject scheme = (DynamicObject)cell.getValue();
            if (this.isLG) {
                if (!"PR".equalsIgnoreCase(scheme.getString("location"))) continue;
                integrateEntity.addOrgSchemePair(orgId, (String)orgRangeNum.get(orgId), schemeId, ((DynamicObject)cell.getValue()).getString("number"));
                continue;
            }
            integrateEntity.addOrgSchemePair(orgId, (String)orgRangeNum.get(orgId), schemeId, ((DynamicObject)cell.getValue()).getString("number"));
        }
    }

    private void validate(Map<String, Object> param) {
        this.scenarioNum = (String)param.get("Scenario");
        this.yearNum = (String)param.get("Year");
        this.periodNum = (String)param.get("Period");
        this.entityNum = (String)param.get("Entity");
        Object modelShowNum = param.get("model");
        QFilter modelFilter = new QFilter("shownumber", "=", modelShowNum);
        this.model = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id,number", (QFilter[])new QFilter[]{modelFilter});
        if (this.model == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u7684\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4f53\u7cfb\u7f16\u7801\u53c2\u6570\u3002", (String)"BatchEntryIntegrationMsServiceImpl_1", (String)"fi-bcm-mservice", (Object[])new Object[0]), modelShowNum));
        }
        this.modelId = this.model.getLong("id");
        QFilter configFilter = new QFilter("model", "=", (Object)this.modelId);
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_hwparam", (QFilter[])new QFilter[]{configFilter});
        if (model == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801%1$s\u7684\u4f53\u7cfb\u672a\u5728\u201c\u53c2\u6570\u8bbe\u7f6e-\u534e\u4e3a\u53c2\u6570\u8bbe\u7f6e\u201d\u4e2d\u914d\u7f6e\uff0c\u8bf7\u524d\u5f80\u914d\u7f6e\u540e\u91cd\u8bd5", (String)"BatchEntryIntegrationMsServiceImpl_2", (String)"fi-bcm-mservice", (Object[])new Object[0]), modelShowNum));
        }
        this.isLG = model.getString("type").equals(HWModelTypeEnum.LG.getNumber());
        if (this.isLG && this.entityNum == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f3a\u5c11\u201cEntity\u201d\u7ec4\u7ec7\u7f16\u7801\u53c2\u6570", (String)"BatchEntryIntegrationMsServiceImpl_11", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
    }

    private DynamicObject getMember(String dimensionNum, String memberNum) {
        SysDimensionEnum dimension = SysDimensionEnum.getEnumByNumber((String)dimensionNum);
        QFilter filter = new QFilter("model", "=", (Object)this.modelId);
        filter.and("number", "=", (Object)memberNum);
        DynamicObject member = BusinessDataServiceHelper.loadSingleFromCache((String)dimension.getMemberTreemodel(), (String)"id,number", (QFilter[])new QFilter[]{filter});
        if (member == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6210\u5458\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u201c%1$s\u201d\u3002", (String)"BatchEntryIntegrationMsServiceImpl_3", (String)"fi-bcm-mservice", (Object[])new Object[0]), memberNum, dimensionNum));
        }
        return member;
    }

    private static /* synthetic */ void lambda$setOrgAndScheme$1(Map orgRangeId, DynamicObject schemeAssign, Table schemeOrgIdMaps, SimpleItem c) {
        Long schemeId;
        DynamicObject scheme;
        if (orgRangeId.containsKey(c.number) && (scheme = schemeAssign.getDynamicObject("scheme")) != null && !schemeOrgIdMaps.containsRow((Object)(schemeId = Long.valueOf(scheme.getLong("id"))))) {
            schemeOrgIdMaps.put((Object)schemeId, orgRangeId.get(c.number), (Object)scheme);
        }
    }
}

