/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.integrationnew.service.IntegrateDispatcher2;
import kd.fi.bcm.business.integrationnew.service.IntegrateEntity;
import kd.fi.bcm.business.integrationnew.util.IntegrationUtil;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.service.BatchIntegrationMsService;

public class BatchIntegrationMsServiceImpl
implements BatchIntegrationMsService {
    private static final String MODEL = "model";
    private static final String BATCHNAME = "batchname";
    private static final String ALL = "*";
    private Long modelId;
    private String scenarioNum;
    private String yearNum;
    private String periodNum;

    public boolean execute(Object param) {
        if (!(param instanceof Map)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u65e0\u6cd5\u89e3\u6790\u3002", (String)"BatchIntegrationMsServiceImpl_0", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        Map input = (Map)param;
        IntegrateEntity integrateEntity = new IntegrateEntity();
        this.buildIntegrateEntity(input, integrateEntity);
        this.setOrgAndScheme(input, integrateEntity);
        IntegrateDispatcher2.submitTask2((IntegrateEntity)integrateEntity, (boolean)true, null);
        return true;
    }

    private void buildIntegrateEntity(Map<String, Object> param, IntegrateEntity integrateEntity) {
        QFBuilder builder = new QFBuilder("shownumber", "=", param.get(MODEL));
        DynamicObject model = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id,number", (QFilter[])builder.toArray());
        if (model == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u4f53\u7cfb\u3002", (String)"BatchIntegrationMsServiceImpl_1", (String)"fi-bcm-mservice", (Object[])new Object[0]), param.get(MODEL)));
        }
        this.modelId = model.getLong("id");
        integrateEntity.setModel(this.modelId, model.getString("number"));
        param.keySet().forEach(key -> {
            if (BATCHNAME.equals(key)) {
                integrateEntity.putCustomParam(BATCHNAME, param.get(BATCHNAME));
            } else if ("Scenario".equals(key) || "Year".equals(key) || "Period".equals(key)) {
                SysDimensionEnum dimension = SysDimensionEnum.getEnumByNumber((String)key);
                builder.clear();
                builder.add(MODEL, "=", (Object)this.modelId);
                builder.add("number", "=", param.get(key));
                DynamicObject member = BusinessDataServiceHelper.loadSingleFromCache((String)dimension.getMemberTreemodel(), (String)"id,number", (QFilter[])builder.toArray());
                if (member == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u7ef4\u5ea6\u201d\u4e0b\u4e0d\u5b58\u5728\u6210\u5458\u201c%2$s\u201d\u3002", (String)"BatchIntegrationMsServiceImpl_3", (String)"fi-bcm-mservice", (Object[])new Object[0]), key, param.get(key)));
                }
                switch (key) {
                    case "Scenario": {
                        this.scenarioNum = member.getString("number");
                        integrateEntity.setScene(Long.valueOf(member.getLong("id")), this.scenarioNum);
                        break;
                    }
                    case "Year": {
                        this.yearNum = member.getString("number");
                        integrateEntity.setYear(Long.valueOf(member.getLong("id")), this.yearNum);
                        break;
                    }
                    case "Period": {
                        this.periodNum = member.getString("number");
                        integrateEntity.setPeriod(Long.valueOf(member.getLong("id")), this.periodNum);
                    }
                }
            }
        });
        builder.clear();
        builder.add(MODEL, "=", (Object)this.modelId);
        builder.add("number", "=", (Object)"EC");
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_currencymembertree", (String)"id,number", (QFilter[])builder.toArray());
        integrateEntity.setCurrency(Long.valueOf(currency.getLong("id")), currency.getString("number"));
    }

    private void setOrgAndScheme(Map<String, Object> param, IntegrateEntity integrateEntity) {
        QFBuilder builder = new QFBuilder();
        builder.add(MODEL, "=", (Object)this.modelId);
        builder.add(QFilter.of((String)"scheme.enable = ?", (Object[])new Object[]{Boolean.TRUE}));
        builder.add(QFilter.of((String)"scheme.istarg.number = ?", (Object[])new Object[]{"NG"}));
        builder.add(QFilter.of((String)"scheme.issrc.number = ?", (Object[])new Object[]{"MIDLIB"}));
        String selectProperties = "scheme,entity,property,propertyvalue,range";
        DynamicObject[] schemeAssignEntitys = BusinessDataServiceHelper.load((String)"bcm_isschemeassignentity", (String)selectProperties, (QFilter[])builder.toArray());
        QFBuilder orgBuilder = new QFBuilder(MODEL, "=", (Object)this.modelId);
        orgBuilder.add("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,number", (QFilter[])orgBuilder.toArray());
        HashMap orgRangeId = new HashMap();
        HashMap orgRangeNum = new HashMap();
        orgs.forEach(org -> {
            orgRangeId.put(org.getString("number"), org.getLong("id"));
            orgRangeNum.put(org.getLong("id"), org.getString("number"));
        });
        HashBasedTable schemeOrgIdMaps = HashBasedTable.create();
        for (DynamicObject schemeAssign : schemeAssignEntitys) {
            String mnumber;
            long mId;
            DynamicObject entity = schemeAssign.getDynamicObject("entity");
            boolean isCustom = false;
            if (entity == null) {
                isCustom = true;
                DynamicObject propertyvalue = schemeAssign.getDynamicObject("propertyvalue");
                if (ObjectUtils.isEmpty((Object)propertyvalue)) continue;
                mId = propertyvalue.getLong("id");
                mnumber = propertyvalue.getString("number");
            } else {
                mId = entity.getLong("id");
                mnumber = entity.getString("number");
            }
            MembRangeItem rangItem = new MembRangeItem("bcm_entitymembertree", Long.valueOf(mId), mnumber, RangeEnum.getRangeByVal((int)schemeAssign.getInt("range")), isCustom, (Object)this.modelId);
            rangItem.matchItems(arg_0 -> BatchIntegrationMsServiceImpl.lambda$setOrgAndScheme$2(orgRangeId, schemeAssign, (Table)schemeOrgIdMaps, arg_0));
        }
        ArrayList<Long> schemeIds = new ArrayList<Long>(schemeOrgIdMaps.rowKeySet());
        IntegrationUtil.filterSchemeByScenarioAndDate((long)this.modelId, (String)this.scenarioNum, (String)this.periodNum, (String)this.yearNum, schemeIds);
        Long yearDimId = MemberReader.getDimensionIdByNum((long)this.modelId, (String)DimTypesEnum.YEAR.getNumber());
        Long periodDimId = MemberReader.getDimensionIdByNum((long)this.modelId, (String)DimTypesEnum.PERIOD.getNumber());
        Pair yearMemberPair = IntegrationUtil.filterSingleMapMems((Long)yearDimId, schemeIds, (List)new ArrayList<String>(){
            {
                this.add(BatchIntegrationMsServiceImpl.this.yearNum);
                this.add(BatchIntegrationMsServiceImpl.ALL);
            }
        });
        HashSet set = new HashSet();
        ((Map)yearMemberPair.p1).values().forEach(set::addAll);
        if (((Map)yearMemberPair.p2).get(this.yearNum) != null) {
            set.removeAll((Collection)((Map)yearMemberPair.p2).get(this.yearNum));
        }
        Pair periodMemberPair = IntegrationUtil.filterSingleMapMems((Long)periodDimId, set, (List)new ArrayList<String>(){
            {
                this.add(BatchIntegrationMsServiceImpl.this.periodNum);
                this.add(BatchIntegrationMsServiceImpl.ALL);
            }
        });
        HashSet set1 = new HashSet();
        ((Map)periodMemberPair.p1).values().forEach(set1::addAll);
        if (((Map)periodMemberPair.p2).get(this.periodNum) != null) {
            set1.removeAll((Collection)((Map)periodMemberPair.p2).get(this.periodNum));
        }
        schemeIds = new ArrayList(set1);
        Set<Long> sidSet = this.filterByScenario(schemeIds, this.scenarioNum);
        ArrayList needRemove = Lists.newArrayList();
        for (Table.Cell cell : schemeOrgIdMaps.cellSet()) {
            if (sidSet.contains(cell.getRowKey())) continue;
            needRemove.add(cell.getRowKey() + "_" + cell.getColumnKey());
        }
        for (String s : needRemove) {
            String[] idArray = s.split("_");
            schemeOrgIdMaps.remove((Object)Long.parseLong(idArray[0]), (Object)Long.parseLong(idArray[1]));
        }
        if (schemeOrgIdMaps.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u6267\u884c\u7684\u96c6\u6210\u65b9\u6848\u3002", (String)"BatchIntegrationMsServiceImpl_5", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        long trueOrgId = 0L;
        List rateOrgIdList = IntegrationUtil.getRateOrgIdList((Long)this.modelId);
        Object entity = param.get("Entity");
        if (entity != null) {
            trueOrgId = (Long)orgRangeId.get(entity);
        }
        String location = null;
        if (param.get("location") != null) {
            location = (String)param.get("location");
        }
        for (Table.Cell cell : schemeOrgIdMaps.cellSet()) {
            long orgId = (Long)cell.getColumnKey();
            long schemeId = (Long)cell.getRowKey();
            if (rateOrgIdList.contains(orgId)) {
                IntegrationUtil.saveRateSchemeCurrency2IntEntity((IntegrateEntity)integrateEntity, (long)schemeId, (String)((String)orgRangeNum.get(orgId)));
                List currency4Rate = integrateEntity.getCurrency4Rate();
                for (int i = 0; i < currency4Rate.size(); ++i) {
                    integrateEntity.addOrgSchemePair(Long.valueOf(orgId), (String)orgRangeNum.get(orgId), Long.valueOf(schemeId), ((DynamicObject)cell.getValue()).getString("number"));
                }
                continue;
            }
            if (trueOrgId != 0L && StringUtils.isNotEmpty((CharSequence)location)) {
                DynamicObject scheme = (DynamicObject)cell.getValue();
                if (orgId != trueOrgId || !StringUtils.equals((CharSequence)location, (CharSequence)scheme.getString("location"))) continue;
                integrateEntity.addOrgSchemePair(Long.valueOf(orgId), (String)orgRangeNum.get(orgId), Long.valueOf(schemeId), ((DynamicObject)cell.getValue()).getString("number"));
                continue;
            }
            integrateEntity.addOrgSchemePair(Long.valueOf(orgId), (String)orgRangeNum.get(orgId), Long.valueOf(schemeId), ((DynamicObject)cell.getValue()).getString("number"));
        }
    }

    private Set<Long> filterByScenario(List<Long> schemeIds, String scenarioNum) {
        HashSet<Long> result = new HashSet<Long>();
        QFBuilder qfb = new QFBuilder();
        qfb.add("schemeid", "in", schemeIds);
        qfb.add("targmembnumber", "in", (Object)scenarioNum);
        DynamicObject[] singMaps = BusinessDataServiceHelper.load((String)"bcm_issinglemap", (String)"schemeid.id", (QFilter[])qfb.toArray());
        Arrays.stream(singMaps).forEach(item -> result.add(item.getLong("schemeid.id")));
        qfb.clear();
        qfb.add("scheme", "in", schemeIds);
        qfb.add("isdimmaptargentry.isdimmaptargdefval.targetmemnum", "=", (Object)scenarioNum);
        DynamicObject[] dimMaps = BusinessDataServiceHelper.load((String)"bcm_isdimmap", (String)"id,scheme.id", (QFilter[])qfb.toArray());
        Arrays.stream(dimMaps).forEach(item -> result.add(item.getLong("scheme.id")));
        return result;
    }

    private static /* synthetic */ void lambda$setOrgAndScheme$2(Map orgRangeId, DynamicObject schemeAssign, Table schemeOrgIdMaps, SimpleItem c) {
        DynamicObject scheme;
        Long aLong = (Long)orgRangeId.get(c.number);
        if (aLong != null && (scheme = schemeAssign.getDynamicObject("scheme")) != null) {
            schemeOrgIdMaps.put((Object)scheme.getLong("id"), (Object)aLong, (Object)scheme);
        }
    }
}

