/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.bcm.business.util.HWModelParamUtil;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.BcmDimMapUtils;
import kd.fi.bcm.service.BuildIntegrationSchemeMsService;

public class BuildIntegrationSchemeMsServiceImpl
implements BuildIntegrationSchemeMsService {
    private WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());
    private static final String MODEL_SHOW_NUMBER = "modelShowNumber";
    private static final String LOCATION_NAME = "locationName";
    private static final String COMPANY_CODE = "companyCode";
    private static final String YEAR_NUMBER = "yearNum";
    private static final String PERIOD_NUMBE = "periodNum";
    private static List<String> locationList;
    private static List<String> companyCodeList;

    public void build(Object param) {
        if (!(param instanceof Map)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u65e0\u6cd5\u89e3\u6790", (String)"BuildIntegrationSchemeMsServiceImpl_8", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        Map input = (Map)param;
        this.buildParam(input);
        this.invokeMethod(input);
    }

    private void invokeMethod(Map<String, Object> input) {
        try {
            Class<?> clazz = Class.forName(input.get("instance").toString());
            Object instance = clazz.newInstance();
            Method method = clazz.getDeclaredMethod(input.get("method").toString(), Map.class);
            method.invoke(instance, input);
        }
        catch (Exception e) {
            this.log.error((Throwable)e);
        }
    }

    private void buildParam(Map<String, Object> input) {
        this.validateParam(input);
        this.addMethodParams(input);
    }

    private void addMethodParams(Map<String, Object> input) {
        String modelShowNumber = input.get(MODEL_SHOW_NUMBER).toString();
        Long modelID = this.getModelIDByModelShowNumber(modelShowNumber);
        String modelType = HWModelParamUtil.getModelType((long)modelID);
        if (modelType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u4f53\u7cfb\u7c7b\u578b\u201d\u53c2\u6570\u5931\u8d25\uff0c\u8bf7\u5728\u201c\u53c2\u6570\u7ba1\u7406-\u534e\u4e3a\u53c2\u6570\u8bbe\u7f6e\u201d\u4e2d\u914d\u7f6e\u76f8\u5173\u53c2\u6570\u4fe1\u606f\u540e\u91cd\u8bd5\u3002", (String)"BuildIntegrationSchemeMsServiceImpl_7", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        HWModelParamUtil.checkHWModelParam((Long)modelID);
        input.put("type", modelType);
        input.put("modelID", modelID);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"bcm_schemecatalog", (String)"id", (QFilter[])new QFilter("model.id", "=", (Object)modelID).and("number", "=", (Object)"root").toArray());
        if (dyn == null || dyn.get("id") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u4f53\u7cfb\u4e0b\u7684\u65b9\u6848\u7ec4", (String)"BuildIntegrationSchemeMsServiceImpl_9", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        input.put("catalogID", dyn.getLong("id"));
        input.put("uid", UserServiceHelper.getCurrentUserId());
        input.put("method", "mapping");
        input.put("instance", "kd.fi.bcm.business.integrationnew.bcmdimmap.SchemeAutoTask");
    }

    private Long getModelIDByModelShowNumber(String modelShowNumber) {
        return QueryServiceHelper.queryOne((String)"bcm_model", (String)"id", (QFilter[])new QFilter("showNumber", "=", (Object)modelShowNumber).toArray()).getLong("id");
    }

    private void validateParam(Map<String, Object> input) {
        Object modelID = input.get(MODEL_SHOW_NUMBER);
        Object locationName = input.get(LOCATION_NAME);
        Object companyCode = input.get(COMPANY_CODE);
        Object yearNum = input.get(YEAR_NUMBER);
        Object periodNum = input.get(PERIOD_NUMBE);
        if (modelID == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u4f53\u7cfb\u7f16\u7801", (String)"BuildIntegrationSchemeMsServiceImpl_0", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        if (locationName == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u6e90\u4f4d\u7f6e", (String)"BuildIntegrationSchemeMsServiceImpl_1", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        if (companyCode == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u516c\u53f8\u7f16\u7801", (String)"BuildIntegrationSchemeMsServiceImpl_2", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        if (!locationList.contains(locationName.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u6e90\u4f4d\u7f6e\u5e76\u672a\u7ef4\u62a4", (String)"BuildIntegrationSchemeMsServiceImpl_3", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        if (!companyCodeList.contains(companyCode.toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u516c\u53f8\u7f16\u7801\u5e76\u672a\u7ef4\u62a4", (String)"BuildIntegrationSchemeMsServiceImpl_4", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        if (yearNum == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u8d22\u5e74\u7f16\u7801", (String)"BuildIntegrationSchemeMsServiceImpl_5", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        if (periodNum == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165\u671f\u95f4\u7f16\u7801", (String)"BuildIntegrationSchemeMsServiceImpl_6", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
    }

    static {
        companyCodeList = BcmDimMapUtils.distinctDatas((String)"companycode");
        locationList = BcmDimMapUtils.distinctDatas((String)"locationname");
    }
}

