/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bcm.business.formula.calculate.CalculateService;
import kd.fi.bcm.business.formula.calculate.ctx.CalContext;
import kd.fi.bcm.business.formula.calculate.ctx.ICalContext;
import kd.fi.bcm.business.formula.express.ExpressStatus;
import kd.fi.bcm.business.formula.register.ExternalFormulaLoader;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.util.MapInitHelper;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.service.CalculateMsService;

public class CalculateMsServiceImpl
implements CalculateMsService {
    public String calculateFormulas(String formulaJson, String commonParam) {
        CalContext calContext;
        Objects.requireNonNull(formulaJson, ResManager.loadKDString((String)"\u516c\u5f0f\u5217\u8868\u4e3a\u7a7a", (String)"CalculateMsServiceImpl_0", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        if (commonParam != null) {
            Map argsMap = (Map)ObjectSerialUtil.parseObject((String)commonParam, Map.class);
            String modelNum = argsMap.computeIfPresent("model", (k, v) -> MemberReader.findModelNumberByShowNum((String)v));
            String fy = (String)argsMap.get("fy");
            String period = (String)argsMap.get("period");
            String org = (String)argsMap.get("org");
            String scenariod = (String)argsMap.get("scenario");
            String currency = (String)argsMap.get("currency");
            calContext = new CalContext(modelNum, org, fy, period, scenariod, currency);
        } else {
            calContext = new CalContext();
        }
        CalculateService calcService = new CalculateService((ICalContext)calContext);
        Map formulas = (Map)ObjectSerialUtil.parseObject((String)formulaJson, Map.class);
        HashMap exprMap = new HashMap();
        formulas.entrySet().forEach(f -> exprMap.put(f.getKey(), calcService.addCalculateExpress(f.getValue().toString())));
        formulas.clear();
        calcService.batchCalculate();
        exprMap.entrySet().forEach(e -> {
            Object v = calcService.evalExpress((ExpressStatus)e.getValue());
            if (v instanceof Exception) {
                formulas.put(e.getKey(), MapInitHelper.ofMap((Object)"v", (Object)ThrowableHelper.toString((Exception)((Exception)v)), (Object)"failed", (Object)Boolean.TRUE));
            } else {
                formulas.put(e.getKey(), MapInitHelper.ofMap((Object)"v", (Object)v));
            }
        });
        return ObjectSerialUtil.toJson((Object)formulas);
    }

    public String getFormulaConfig() {
        JSONArray formulaConfigs = new JSONArray();
        ExternalFormulaLoader.getInstance().loadExternalFormulaConfig().forEach(e -> formulaConfigs.add((Object)MapInitHelper.ofMap((Object)"catalogs", (Object)Lists.transform((List)e.getCatlogs(), c -> MapInitHelper.ofMap((Object)"name", (Object)c.getName(), (Object)"number", (Object)c.getNumber())), (Object)"formulaDef", (Object)e.getFormulas())));
        return formulaConfigs.toJSONString();
    }
}

