/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.integration.di.service.DIMemberMapImportImp;
import kd.fi.bcm.business.integration.model.MembMapImportDTO;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.service.DIMembMapImportMsService;

public class DIMembMapImportMsServiceImpl
implements DIMembMapImportMsService {
    private final WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());

    public Map<String, Object> importData(String paramJson) {
        MembMapImportDTO dto = null;
        this.log.startWatch();
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("successCount", 0);
        result.put("errors", new ArrayList(16));
        this.log.info(String.format("DIMembMapImportMsServiceImpl.importData request param: %s", paramJson));
        try {
            dto = (MembMapImportDTO)JSONUtils.cast((String)paramJson, MembMapImportDTO.class);
        }
        catch (Exception e) {
            ((ArrayList)result.get("errors")).add(String.format("convert Json [%s] to MembImportDTO error!", paramJson));
            this.log.error(String.format("DIMembMapImportMsServiceImpl.importData request error:%s", e));
            return result;
        }
        DIMemberMapImportImp service = new DIMemberMapImportImp();
        try {
            service.importData(dto);
        }
        catch (KDBizException e) {
            ((ArrayList)result.get("errors")).add(e.getMessage());
            this.log.error(String.format("DIMembMapImportMsServiceImpl.importData request error:%s", new Object[]{e}));
            return result;
        }
        result.put("successCount", service.getSuccessCount());
        result.put("errors", service.getErrorMsgs().stream().map(x -> x.toString()).collect(Collectors.toList()));
        return result;
    }
}

