/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.model.SimpleItem;
import kd.fi.bcm.business.util.TemplateDistributionOrgUtil;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.service.DataCollectMsService;
import kd.fi.bcm.spread.datacollect.DCContext;
import kd.fi.bcm.spread.datacollect.DataCollectService;

public class DataCollectMsServiceImpl
implements DataCollectMsService {
    public void dataCollect(String paramJson) {
        Map argsMap = (Map)ObjectSerialUtil.parseObject((String)paramJson, Map.class);
        String modelNum = argsMap.computeIfPresent("model", (k, v) -> MemberReader.findModelNumberByShowNum((String)v));
        long modelId = MemberReader.findModelIdByNum((String)modelNum);
        String fy = (String)argsMap.get("fy");
        String period = (String)argsMap.get("period");
        String scenario = (String)argsMap.get("scenario");
        IDNumberTreeNode fyNode = MemberReader.findFyMemberByNum((String)modelNum, (String)fy);
        IDNumberTreeNode periodNode = MemberReader.findPeriodMemberByNum((String)modelNum, (String)period);
        IDNumberTreeNode sceneNode = MemberReader.findScenaMemberByNum((String)modelNum, (String)scenario);
        Long fyId = fyNode.getId();
        Long periodId = periodNode.getId();
        String org = argsMap.get("org") == null ? "" : String.valueOf(argsMap.get("org"));
        String tmp = argsMap.get("template") == null ? "" : String.valueOf(argsMap.get("template"));
        List orgNums = (List)ObjectSerialUtil.parseObject((String)org, List.class);
        List tmpNums = (List)ObjectSerialUtil.parseObject((String)tmp, List.class);
        Map<Long, Long> rightTmp2VerIds = this.getTempDys(modelId, fyId, periodId, tmpNums);
        Set<Long> orgids = this.getOrgIds(orgNums, modelId);
        Map orgMap = TemplateDistributionOrgUtil.getTemplate2OrgMapOfDispense((Long)modelId, rightTmp2VerIds.values().stream().collect(Collectors.toSet()), new HashSet());
        HashMultimap organdtmp = HashMultimap.create();
        for (Map.Entry entry : orgMap.entrySet()) {
            long templateId = (Long)entry.getKey();
            Iterator iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                long orgId = (Long)iterator.next();
                if (!orgids.contains(orgId)) continue;
                organdtmp.put((Object)orgId, (Object)templateId);
            }
        }
        DCContext ctx = new DCContext(SimpleItem.newOne((Object)modelId, (String)modelNum), SimpleItem.newOne((Object)sceneNode.getId(), (String)scenario), SimpleItem.newOne((Object)fyId, (String)fy), SimpleItem.newOne((Object)periodId, (String)period), (Multimap)organdtmp);
        ctx.setSort(true);
        ctx.setReCollect(true);
        ctx.setRealSelectRow(null);
        new DataCollectService(ctx).excute();
    }

    private Map<Long, Long> getTempDys(long modelId, Long fyId, Long periodId, List<String> tmpNums) {
        Set<Object> templateids = new HashSet(16);
        if (tmpNums != null && !tmpNums.isEmpty()) {
            DynamicObjectCollection temps = TemplateUtil.getTempByNumber(tmpNums, (long)modelId, (String)"id");
            templateids = temps.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        } else {
            templateids = TemplateDistributionOrgUtil.getDispenseTemplateIds((Object)modelId);
        }
        return TemplateUtil.getRightTplIdByVersioned((Long)modelId, (Long)fyId, (Long)periodId, templateids);
    }

    private Set<Long> getOrgIds(List<String> orgNums, long modelId) {
        QFilter modelQF = new QFilter("model.id", "=", (Object)modelId);
        if (orgNums != null && !orgNums.isEmpty()) {
            QFilter orgFilter = new QFilter("number", "in", orgNums);
            modelQF.and(orgFilter);
        }
        QFilter typeQF = new QFilter("storagetype", "=", (Object)StorageTypeEnum.STORAGE.getOIndex());
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])new QFilter[]{modelQF, typeQF});
        HashSet<Long> orgids = new HashSet<Long>(16);
        for (DynamicObject dy : dys) {
            orgids.add(dy.getLong("id"));
        }
        return orgids;
    }
}

