/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.SaveDimMemberHelper;
import kd.fi.bcm.business.dimension.util.EntityVersioningUtil;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.tree.ITreeNode;
import kd.fi.bcm.business.tree.TreeBuilder;
import kd.fi.bcm.business.tree.dimension.DimensionTreeNode;
import kd.fi.bcm.business.util.HWModelParamUtil;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.AccountTypeEnum;
import kd.fi.bcm.common.enums.AggOprtEnum;
import kd.fi.bcm.common.enums.DataTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.DrCRDirectEnum;
import kd.fi.bcm.common.enums.ExchangeEnum;
import kd.fi.bcm.common.enums.HWModelTypeEnum;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.enums.dimension.DimMemTypeEnum;
import kd.fi.bcm.common.enums.log.DimMemberOperateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.service.DimenMemberSyncMsService;
import org.apache.commons.lang.CharUtils;

public class DimenMemberSyncMsServiceImpl
implements DimenMemberSyncMsService {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(DimenMemberSyncMsServiceImpl.class);
    private static final String MODEL = "model";
    private static final String DIMENSION = "dimension";
    private static final String ROOT = "root";
    private static final String ACCOUNT_DESCRIPTION = "description";
    private static final String ISCREATE = "create";
    private static final String ISUPDATE = "update";
    private static final String ACV06 = "acv06";
    private static final String Y = "Y";
    private static final String N = "N";
    private static final String ACCOUNTCATEGORY = "faccountcategory";
    private static final String DEFINEDDIMEN = "Custom1";
    private static final String ALL = "ALL";
    private static final String NONE = "NONE";
    private static final String REGEX = "^(?!_)[-a-zA-Z0-9_.]+$";
    private static final String ILLEGAL = "[^0-9a-zA-Z-_.]+";
    private static final String MULTIPOINT = "[.]+";
    private long modelId;
    private String modelNum;
    private boolean isLG;
    private long dimensionId;
    private String dimensionNum;
    private String entityNum;
    private static Map<String, String> dimEntityMap = new HashMap<String, String>(16){
        {
            this.put("bcm_accountmembertree", "bcm_accountmember");
            this.put("bcm_entitymembertree", "bcm_entitymember");
            this.put("bcm_currencymembertree", "bcm_currencymember");
            this.put("bcm_userdefinedmembertree", "bcm_userdefinedmember");
        }
    };
    private Map<String, DimensionTreeNode> noShareNodeMap;
    private Map<String, String> accountCategoryMap;

    public String syncEntityMember(Object map) {
        Map param = (Map)map;
        String modelNum = param.get(MODEL).toString();
        String dimenNum = param.get(DIMENSION).toString();
        DynamicObject model = this.getModel(modelNum);
        if (model == null) {
            return String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u4f53\u7cfb\u3002", (String)"DimenMemberSyncMsServiceImpl_21", (String)"fi-bcm-mservice", (Object[])new Object[0]), modelNum);
        }
        String modelNumber = (String)model.get("number");
        param.put("modelNumber", modelNumber);
        long modelId = model.getLong("id");
        DynamicObject dimension = QueryDimensionServiceHelper.getDimByNumber((String)dimenNum, (Long)modelId);
        if (dimension == null) {
            return String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u7ef4\u5ea6\u3002", (String)"DimenMemberSyncMsServiceImpl_22", (String)"fi-bcm-mservice", (Object[])new Object[0]), modelNum);
        }
        String entityNum = dimension.getString("membermodel");
        DynamicObject[] maindatas = this.getMidDatasByDim("bcm_dsentitymaindata");
        if (maindatas.length == 0) {
            return ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\uff0c\u8bf7\u5148\u7ef4\u62a4\u4e2d\u95f4\u8868\u3002", (String)"DimenMemberSyncMsServiceImpl_23", (String)"fi-bcm-mservice", (Object[])new Object[0]);
        }
        DynamicObject paramobject = this.getHwParam(modelId);
        if (paramobject == null || paramobject.get("entity") == null) {
            return ResManager.loadKDString((String)"\u83b7\u53d6\u7236\u7ea7\u79d1\u76ee\u6210\u5458\u5931\u8d25\uff0c\u8bf7\u5728\u201c\u53c2\u6570\u7ba1\u7406>\u534e\u4e3a\u53c2\u6570\u8bbe\u7f6e\u201d\u4e2d\u914d\u7f6e\u76f8\u5173\u53c2\u6570\u540e\u91cd\u8bd5\u3002", (String)"DimenMemberSyncMsServiceImpl_30", (String)"fi-bcm-mservice", (Object[])new Object[0]);
        }
        DynamicObject entity = (DynamicObject)paramobject.get("entity");
        QFBuilder builder = new QFBuilder(MODEL, "=", (Object)modelId);
        builder.and(new QFilter("storagetype", "!=", (Object)"3"));
        String selectProperties = "id,number,longnumber,level,dimension,model,isleaf,cslscheme";
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)entityNum, (String)selectProperties, (QFilter[])builder.toArray());
        builder = new QFBuilder(MODEL, "=", (Object)modelId);
        builder.and(new QFBuilder("id", "=", (Object)entity.getLong("id")));
        DynamicObject parentObject = BusinessDataServiceHelper.loadSingle((String)entityNum, (String)selectProperties, (QFilter[])builder.toArray());
        if (parentObject == null) {
            return String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u7ec4\u7ec7\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DimenMemberSyncMsServiceImpl_25", (String)"fi-bcm-mservice", (Object[])new Object[0]), entity.getString("number"));
        }
        Integer maxseq = 0;
        QFilter qFilter = new QFilter("parent", "=", (Object)parentObject.getString("id"));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityNum, (String)"dseq", (QFilter[])new QFilter[]{qFilter}, (String)"dseq desc", (int)1);
        if (!objects.isEmpty()) {
            maxseq = ((DynamicObject)objects.get(0)).getInt("dseq");
        }
        List<DynamicObject> needSaves = this.getneedSaves(parentObject, maindatas, datas);
        param.put("maxseq", maxseq);
        this.buildNeedSaves(param, parentObject, needSaves);
        return null;
    }

    public boolean createICMember(List<DynamicObject> dyTrees, boolean isIc, boolean isInner) {
        if (dyTrees != null && dyTrees.size() > 0) {
            DynamicObject object;
            DynamicObject tmpmodel;
            Long modelId;
            QFilter filterModel;
            ArrayList<DynamicObject> memberTrees = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> members = new ArrayList<DynamicObject>(10);
            QFilter filterNumber = new QFilter("number", "=", (Object)(isIc ? "InternalCompany" : "MyCompany"));
            QFilter[] filters = new QFilter[]{filterNumber, filterModel = new QFilter(MODEL, "=", (Object)(modelId = Long.valueOf((tmpmodel = (DynamicObject)(object = dyTrees.get(0)).get(MODEL)).getLong("id"))))};
            DynamicObject dyObj = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id,number", (QFilter[])filters);
            if (dyObj == null) {
                return false;
            }
            QFBuilder filterParent = new QFBuilder(MODEL, "=", (Object)modelId);
            String parentNum = isIc ? (isInner ? "ICEntity" : "ICOEntity") : "MyCompany";
            filterParent.add("number", "=", (Object)parentNum);
            DynamicObject parent = QueryServiceHelper.queryOne((String)(isIc ? "bcm_icmembertree" : "bcm_mycompanymembertree"), (String)"id", (QFilter[])filterParent.toArray());
            long parentId = parent.getLong("id");
            for (DynamicObject dyTree : dyTrees) {
                DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)(isIc ? "bcm_intercompanymember" : "bcm_mycompanymember"));
                DimensionServiceHelper.initDimensionDyObjectWithOrg((DynamicObject)member);
                member.set("number", dyTree.get("number"));
                member.set("name", dyTree.get("name"));
                DynamicObject dimension = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimension");
                String dimensionId = dyObj.getString("id");
                dimension.set("id", (Object)dimensionId);
                DynamicObject model = BusinessDataServiceHelper.newDynamicObject((String)"bcm_model");
                model.set("id", (Object)modelId);
                member.set(MODEL, (Object)model);
                member.set(DIMENSION, (Object)dimension);
                members.add(member);
                DynamicObject memberTree = BusinessDataServiceHelper.newDynamicObject((String)(isIc ? "bcm_icmembertree" : "bcm_mycompanymembertree"));
                DimensionServiceHelper.initDimensionDyObject((DynamicObject)memberTree);
                memberTree.set("member", (Object)member);
                memberTree.set("number", dyTree.get("number"));
                StringBuilder longnumber = new StringBuilder();
                if (isIc) {
                    longnumber.append("InternalCompany").append('!').append("ICTotal").append('!').append(isInner ? "ICEntity" : "ICOEntity").append('!').append(dyTree.getString("number"));
                } else {
                    longnumber.append("MyCompany").append('!').append(dyTree.getString("number"));
                }
                memberTree.set("longnumber", (Object)longnumber.toString());
                memberTree.set("name", dyTree.get("name"));
                memberTree.set("storagetype", (Object)4);
                memberTree.set("aggoprt", dyTree.get("aggoprt"));
                memberTree.set(ACCOUNT_DESCRIPTION, dyTree.get(ACCOUNT_DESCRIPTION));
                memberTree.set(MODEL, (Object)model);
                memberTree.set(DIMENSION, (Object)dimension);
                memberTree.set("issysmember", (Object)0);
                memberTree.set("isleaf", (Object)1);
                memberTree.set("level", (Object)(isIc ? 3 : 2));
                memberTree.set("parent", (Object)parentId);
                memberTree.set("dseq", (Object)this.getDSeq(parentId, isIc ? "bcm_icmembertree" : "bcm_mycompanymembertree"));
                memberTrees.add(memberTree);
            }
            SaveServiceHelper.save((DynamicObject[])members.toArray(new DynamicObject[0]));
            SaveServiceHelper.save((DynamicObject[])memberTrees.toArray(new DynamicObject[0]));
            if (isIc) {
                QFBuilder modelFilter = new QFBuilder(MODEL, "=", (Object)modelId);
                modelFilter.add("number", "=", (Object)"ICEntity");
                DynamicObject icDy = BusinessDataServiceHelper.loadSingle((String)"bcm_icmembertree", (String)"isleaf", (QFilter[])modelFilter.toArray());
                icDy.set("isleaf", (Object)0);
                BusinessDataWriter.save((IDataEntityType)icDy.getDynamicObjectType(), (Object[])new DynamicObject[]{icDy});
            }
        }
        return true;
    }

    public int getDSeq(long id, String entity) {
        QFilter filter = new QFilter("parent", "=", (Object)id);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)entity, (String)"dseq", (QFilter[])filters, (String)"dseq");
        if (dcs != null) {
            if (dcs.size() == 0) {
                return 1;
            }
            return ((DynamicObject)dcs.get(dcs.size() - 1)).getInt("dseq") + 1;
        }
        return 1;
    }

    public DynamicObject getHwParam(Long modelID) {
        QFBuilder builder = new QFBuilder(MODEL, "=", (Object)modelID);
        String selectProperties = "account,entity,model,definedid,definedmemid,definedmemprefix";
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"bcm_hwparam", (String)selectProperties, (QFilter[])builder.toArray());
        return object;
    }

    public List<DynamicObject> getneedSaves(DynamicObject parentObject, DynamicObject[] maindatas, DynamicObject[] datas) {
        ArrayList<DynamicObject> needSaves = new ArrayList<DynamicObject>(10);
        HashMap<String, DynamicObject> midMap = new HashMap<String, DynamicObject>();
        for (DynamicObject d : maindatas) {
            String number = d.getString("company_code");
            if (StringUtils.isEmpty((CharSequence)number) || midMap.get(number.toLowerCase(Locale.ENGLISH)) != null) continue;
            midMap.put(number.toLowerCase(Locale.ENGLISH), d);
        }
        Map<String, DynamicObject> existMap = Stream.of(datas).collect(Collectors.toMap(e -> e.getString("number").toLowerCase(Locale.ENGLISH), e -> e));
        midMap.keySet().forEach(e -> {
            if (existMap.keySet().stream().noneMatch(s -> s.equalsIgnoreCase((String)e))) {
                needSaves.add((DynamicObject)midMap.get(e));
            }
        });
        return needSaves;
    }

    public void buildNeedSaves(Map param, DynamicObject parentObject, List<DynamicObject> needSaves) {
        String modelNum = (String)param.get("modelNumber");
        String dimenNum = param.get(DIMENSION).toString();
        ArrayList<DynamicObject> newDatas = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> memDatas = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> entityparts = new ArrayList<DynamicObject>(10);
        QFBuilder builder = new QFBuilder("number", "=", (Object)"CNY");
        String selectProperties = "id";
        DynamicObject currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (String)selectProperties, (QFilter[])builder.toArray());
        DynamicObject model = (DynamicObject)parentObject.get(MODEL);
        DynamicObject dimension = (DynamicObject)parentObject.get(DIMENSION);
        String[] newNumbers = new String[needSaves.size()];
        String[] deriveNumbers = new String[needSaves.size()];
        ArrayList<Tuple> interNumbers = new ArrayList<Tuple>(needSaves.size());
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(10);
        int i = 0;
        Integer dseq = (Integer)param.get("maxseq");
        for (DynamicObject object : needSaves) {
            DynamicObject newObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
            newObject.set("number", (Object)object.getString("company_code"));
            newObject.set("name", (Object)object.getString("company_cn_name"));
            newObject.set("status", (Object)"C");
            newObject.set("shownumber", (Object)object.getString("company_code"));
            newObject.set("longnumber", (Object)(parentObject.getString("longnumber") + "!" + object.getString("company_code")));
            newObject.set("level", (Object)(parentObject.getInt("level") + 1));
            newObject.set("fullname", (Object)object.getString("company_cn_name"));
            newObject.set("isleaf", (Object)"1");
            newObject.set("parent", (Object)parentObject.getLong("id"));
            DynamicObject member = this.getDimensionMember("bcm_entitymember", model.getLong("id"), dimension.getLong("id"), object.getString("company_code"), object.getString("company_en_name"));
            newObject.set("member", (Object)member);
            newObject.set("storagetype", (Object)"2");
            newObject.set("aggoprt", (Object)"1");
            newObject.set(DIMENSION, (Object)dimension.getLong("id"));
            newObject.set(MODEL, (Object)model);
            newObject.set("isindependentorg", (Object)"1");
            newObject.set("isinnerorg", (Object)"1");
            newObject.set("isouterorg", (Object)"0");
            newObject.set("currency", (Object)currency.getInt("id"));
            newObject.set("cslscheme", (Object)parentObject.getLong("cslscheme.id"));
            newObject.set("enable", (Object)1);
            dseq = dseq + 1;
            newObject.set("dseq", (Object)dseq);
            DynamicObject entitypart = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymemberpart");
            entitypart.set("id", (Object)DBServiceHelper.genGlobalLongId());
            entitypart.set("isouterorg", newObject.get("isouterorg"));
            newObject.set("entitypart", (Object)entitypart);
            entityparts.add(entitypart);
            this.setUserAndTime(newObject);
            memDatas.add(member);
            newDatas.add(newObject);
            newNumbers[i] = object.getString("company_code");
            deriveNumbers[i] = parentObject.get("number") + "_" + object.getString("company_code");
            interNumbers.add(Tuple.create((Object)newObject.getString("number"), (Object)newObject.getInt("aggoprt"), (Object)"ICEntity"));
            this.saveModifyInfo(newObject, model.getLong("id"));
            this.buildAddMemberLog(model.getLong("id"), dimension.getLong("id"), object.getString("company_code"), object.getString("company_cn_name"), DimMemberOperateTypeEnum.INTEGRATION_NEW, logs);
            ++i;
        }
        try (TXHandle th = TX.requiresNew();){
            try {
                if (!needSaves.isEmpty()) {
                    parentObject.set("isleaf", (Object)0);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentObject});
                }
                SaveServiceHelper.save((DynamicObject[])memDatas.toArray(new DynamicObject[0]));
                this.createICMember(newDatas, true, true);
                SaveServiceHelper.save((DynamicObject[])entityparts.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])newDatas.toArray(new DynamicObject[0]));
                SaveDimMemberHelper.batchInsertDimMemberModifyLog(logs);
                OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)dimenNum, (String[])newNumbers);
                OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)dimenNum, (String[])deriveNumbers);
                DynamicComputingServiceHelper.repairModelByDim((String)modelNum, (String)dimenNum, (boolean)true);
                OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)DimTypesEnum.INTERCOMPANY.getNumber(), interNumbers);
            }
            catch (Exception e) {
                th.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private void saveModifyInfo(DynamicObject entityData, Long modelID) {
        DynamicObject modifier = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        modifier.set("id", (Object)RequestContext.get().getUserId());
        modifier.set("name", (Object)RequestContext.get().getUserName());
        Date nowDate = TimeServiceHelper.now();
        DynamicObjectCollection bizChangerds = entityData.getDynamicObjectCollection("bizchangerds");
        DynamicObject bizData = bizChangerds.addNew();
        bizData.set("bizeffdate", (Object)EntityVersioningUtil.getModelBeginDate((Object)modelID));
        bizData.set("bizexpdate", null);
        bizData.set("bizmodifier", (Object)modifier);
        bizData.set("bizmodifytime", (Object)nowDate);
        bizData.set("changetype", (Object)OrgBizChangeTypeEnum.initNewlyAdded.getValue());
        bizData.set("seq", (Object)"1");
        DynamicObjectCollection nameRecords = entityData.getDynamicObjectCollection("namechangerds");
        DynamicObject nameData = nameRecords.addNew();
        nameData.set("nameeffdate", (Object)EntityVersioningUtil.getModelBeginDate((Object)modelID));
        nameData.set("namerds", (Object)entityData.getString("name"));
        nameData.set("simplenamerds", (Object)entityData.getString("simplename"));
        nameData.set("namemodifier", (Object)modifier);
        nameData.set("namemodifytime", (Object)nowDate);
        nameData.set("seq", (Object)"1");
        DynamicObjectCollection currencyRecords = entityData.getDynamicObjectCollection("currencychangerds");
        DynamicObject currencyData = currencyRecords.addNew();
        currencyData.set("currencyeffdate", (Object)EntityVersioningUtil.getModelBeginDate((Object)modelID));
        currencyData.set("currencymodifier", (Object)modifier);
        currencyData.set("currencymodifytime", (Object)nowDate);
        currencyData.set("currencyrds", (Object)1);
        currencyData.set("seq", (Object)"1");
    }

    private void buildAddMemberLog(Long modelID, Long dimID, String memberNumber, String name, DimMemberOperateTypeEnum opType, List<DynamicObject> logs) {
        int clientType = 1;
        String clientAddress = "192.168.0.1";
        DynamicObject modifyLog = SaveDimMemberHelper.newMemberModifyLog((Long)modelID, (Long)dimID, null, (String)memberNumber, (String)name, (String)opType.getValue(), (String)opType.getName(), null, null, (long)Long.parseLong(RequestContext.get().getUserId()), (int)clientType, (String)clientAddress);
        logs.add(modifyLog);
    }

    private void setUserAndTime(DynamicObject object) {
        object.set("creator", (Object)RequestContext.get().getUserId());
        object.set("createtime", (Object)TimeServiceHelper.now());
        object.set("modifier", (Object)RequestContext.get().getUserId());
        object.set("modifytime", (Object)TimeServiceHelper.now());
    }

    public DynamicObject[] getMidDatasByDim(String midtablename) {
        String selectProperties = "company_code,company_cn_name,company_en_name";
        QFBuilder builder = new QFBuilder("1", "=", (Object)1);
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)midtablename, (String)selectProperties, (QFilter[])builder.toArray());
        if (datas != null && datas.length > 0) {
            Stream.of(datas).forEach(e -> {
                e.set("company_code", (Object)this.subString(this.removeIllegalConform(e.getString("company_code"))));
                e.set("company_code", (Object)e.getString("company_code").replace("_", ""));
            });
            List<DynamicObject> newdatas = Stream.of(datas).filter(e -> !e.getString("company_code").equalsIgnoreCase("all") && !e.getString("company_code").equalsIgnoreCase("none") && !StringUtils.isEmpty((CharSequence)e.getString("company_code")) && !StringUtils.isEmpty((CharSequence)e.getString("company_cn_name"))).collect(Collectors.toList());
            return newdatas.toArray(new DynamicObject[0]);
        }
        return datas;
    }

    public String createDimensionMember(Object param) {
        this.beforeSync(param);
        return this.syncDimensionMember(true, false);
    }

    public String updateDimensionMember(Object param) {
        this.beforeSync(param);
        return this.syncDimensionMember(false, true);
    }

    public String createAndUpdate(Object param) {
        this.beforeSync(param);
        return this.syncDimensionMember(true, true);
    }

    private void beforeSync(Object param) {
        DynamicObject dimension;
        if (param instanceof Map) {
            Map input = (Map)param;
            DynamicObject model = this.getModel(input.get(MODEL).toString());
            if (model == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u4f53\u7cfb\u3002", (String)"DimenMemberSyncMsServiceImpl_1", (String)"fi-bcm-mservice", (Object[])new Object[0]), input.get(MODEL)));
            }
            this.modelId = model.getLong("id");
            this.modelNum = model.getString("number");
            this.dimensionNum = input.get(DIMENSION).toString();
            dimension = QueryDimensionServiceHelper.getDimByNumber((String)this.dimensionNum, (Long)this.modelId);
            if (dimension == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u7ef4\u5ea6\u3002", (String)"DimenMemberSyncMsServiceImpl_2", (String)"fi-bcm-mservice", (Object[])new Object[0]), this.dimensionNum));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f93\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u65e0\u6cd5\u89e3\u6790\u3002", (String)"DimenMemberSyncMsServiceImpl_0", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        this.dimensionId = dimension.getLong("id");
        this.isLG = HWModelParamUtil.isLG((long)this.modelId);
        this.entityNum = dimension.getString("membermodel");
    }

    public String addAccountMember(Object param) {
        ConstructMap constructMap = new ConstructMap((Map)param).invoke("Account");
        long modelId = constructMap.getModelId();
        String modelNum = constructMap.getModelNum();
        String dimensionNum = constructMap.getDimensionNum();
        Long dimensionId = constructMap.getDimensionId();
        String entityNum = constructMap.getEntityNum();
        DynamicObject paramobject = this.getHwParam(modelId);
        if (null == paramobject) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7236\u7ea7\u79d1\u76ee\u6210\u5458\u5931\u8d25\uff0c\u8bf7\u5728\u201c\u53c2\u6570\u7ba1\u7406>\u534e\u4e3a\u53c2\u6570\u8bbe\u7f6e\u201d\u4e2d\u914d\u7f6e\u76f8\u5173\u53c2\u6570\u540e\u91cd\u8bd5\u3002", (String)"DimenMemberSyncMsServiceImpl_31", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        DynamicObject accountObject = paramobject.getDynamicObject("account");
        if (null == accountObject) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7236\u7ea7\u79d1\u76ee\u6210\u5458\u5931\u8d25\uff0c\u8bf7\u5728\u201c\u53c2\u6570\u7ba1\u7406>\u534e\u4e3a\u53c2\u6570\u8bbe\u7f6e\u201d\u4e2d\u914d\u7f6e\u76f8\u5173\u53c2\u6570\u540e\u91cd\u8bd5\u3002", (String)"DimenMemberSyncMsServiceImpl_31", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        Object id = accountObject.get("id");
        DynamicObject parentObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityNum, (String)"id,longnumber,isleaf,number,level");
        parentObject.set("isleaf", (Object)"0");
        Object parentFid = id;
        String parentNumber = parentObject.getString("number");
        String parentLongNumber = parentObject.getString("longnumber");
        int level = parentObject.getInt("level");
        QFBuilder builderExis = new QFBuilder(DIMENSION, "=", (Object)dimensionId);
        String selectExis = "number,dseq";
        DynamicObject[] exisList = BusinessDataServiceHelper.load((String)entityNum, (String)selectExis, (QFilter[])builderExis.toArray(), (String)"level");
        HashMap<String, DynamicObject> existMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject exi : exisList) {
            existMap.put(exi.getString("number").toLowerCase(Locale.ENGLISH), exi);
        }
        String select = "group_account_code,grp_account_code_cn_name";
        QFBuilder builder = new QFBuilder().add(new QFilter("group_account_code", "not in", Arrays.asList(ALL, "none")));
        DynamicObject[] mid = BusinessDataServiceHelper.load((String)"bcm_dsacctmaindata", (String)select, (QFilter[])builder.toArray());
        if (mid.length == 0) {
            return ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\uff0c\u8bf7\u5148\u7ef4\u62a4\u4e2d\u95f4\u8868\u3002", (String)"DimenMemberSyncMsServiceImpl_23", (String)"fi-bcm-mservice", (Object[])new Object[0]);
        }
        List midList = Stream.of(mid).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<DynamicObject>(Comparator.comparing(o -> o.getString("group_account_code").toLowerCase(Locale.ENGLISH)))), ArrayList::new));
        for (DynamicObject m : midList) {
            m.set("group_account_code", (Object)this.subString(this.removeIllegalConform(m.getString("group_account_code"))));
        }
        Map<String, DynamicObject> midMap = midList.stream().collect(Collectors.toMap(e -> e.getString("group_account_code"), e -> e));
        ArrayList midMenberList = new ArrayList();
        midMap.keySet().stream().filter(e -> {
            boolean flag = !existMap.containsKey(e.toLowerCase(Locale.ENGLISH));
            return flag;
        }).collect(Collectors.toList()).forEach(e -> midMenberList.add(midMap.get(e)));
        int seq = Stream.of(exisList).mapToInt(DynamicObject2 -> DynamicObject2.getInt("dseq")).max().getAsInt();
        ArrayList<DynamicObject> dyList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> dyDictList = new ArrayList<DynamicObject>(10);
        ArrayList<Tuple> newNumbers = new ArrayList<Tuple>(10);
        for (DynamicObject middleMenber : midMenberList) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_accountmembertree");
            String midNumber = middleMenber.getString("group_account_code");
            String name = middleMenber.getString("grp_account_code_cn_name");
            if (StringUtils.isEmpty((CharSequence)name)) continue;
            obj.set("number", (Object)midNumber);
            obj.set("name", (Object)name);
            obj.set("longnumber", (Object)(parentLongNumber + "!" + midNumber));
            obj.set("level", (Object)(level + 1));
            obj.set("dseq", (Object)(++seq));
            obj.set("accounttype", (Object)"1");
            obj.set("drcrdirect", (Object)"1");
            obj.set("entryrate", (Object)"1");
            obj.set("storagetype", (Object)"2");
            obj.set("issysmember", (Object)4);
            obj.set("share", (Object)0);
            obj.set("parent", parentFid);
            obj.set("aggoprt", (Object)"1");
            obj.set("isleaf", (Object)"1");
            obj.set("exchange", (Object)"0");
            obj.set(MODEL, (Object)modelId);
            obj.set(DIMENSION, (Object)dimensionId);
            obj.set("status", (Object)"C");
            obj.set("enable", (Object)1);
            obj.set("masterid", (Object)0);
            obj.set("datatype", (Object)DataTypeEnum.DEFAULT.index);
            DynamicObject member = this.getDimensionMember(dimEntityMap.get(entityNum), modelId, dimensionId, midNumber, name);
            obj.set("member", (Object)member);
            this.setSysField(obj);
            this.setAccountModifyRecord(obj, modelId);
            dyList.add(obj);
            dyDictList.add(member);
            newNumbers.add(Tuple.create((Object)obj.getString("number"), (Object)obj.getInt("aggoprt"), (Object)parentNumber));
        }
        try (TXHandle th = TX.requiresNew();){
            try {
                if (dyList.size() > 0) {
                    DynamicObject[] save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])dyList.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])dyDictList.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentObject});
                    this.constructLog(save);
                    OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)dimensionNum, newNumbers);
                }
            }
            catch (Exception e2) {
                th.markRollback();
                throw new KDBizException(e2.getMessage());
            }
        }
        return null;
    }

    private DynamicObject setAccountModifyRecord(DynamicObject obj, Long modelID) {
        DynamicObject modifier = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        modifier.set("id", (Object)RequestContext.get().getUserId());
        modifier.set("name", (Object)RequestContext.get().getUserName());
        Date nowDate = TimeServiceHelper.now();
        DynamicObjectCollection bizChangerds = obj.getDynamicObjectCollection("bizchangerds");
        DynamicObject bizData = bizChangerds.addNew();
        bizData.set("bizeffdate", (Object)EntityVersioningUtil.getModelBeginDate((Object)modelID));
        bizData.set("bizexpdate", null);
        bizData.set("bizmodifier", (Object)modifier);
        bizData.set("bizmodifytime", (Object)nowDate);
        return obj;
    }

    private String removeIllegalConform(String str) {
        if (null == str) {
            return null;
        }
        return str.replaceAll("[^A-Za-z0-9_-]", "");
    }

    private String subString(String str) {
        if (null != str && str.length() > 50) {
            return str.substring(0, 50);
        }
        return str;
    }

    public String addCurrencyMember(Map<String, Object> param) {
        String modelShowNumber = param.get(MODEL).toString();
        DynamicObject model = this.getModel(modelShowNumber);
        String modelNum = model.getString("number");
        Long modelId = model.getLong("id");
        DynamicObject[] middleMembers = BusinessDataServiceHelper.load((String)"bcm_dscurrmaindata", (String)"currency_code", null);
        if (null == middleMembers || middleMembers.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\uff0c\u8bf7\u5148\u7ef4\u62a4\u4e2d\u95f4\u8868\u3002", (String)"DimenMemberSyncMsServiceImpl_23", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        List<DynamicObject> middleMemberList = Arrays.asList(middleMembers);
        DynamicObject currency = this.getDimension(modelId, "Currency");
        List<DynamicObject> cMemberList = this.getFilteredMember(currency, middleMemberList);
        DynamicObject currencyParent = this.getParentMember(currency, "Currency");
        List<DynamicObject> currencyMembers = this.buildMember(cMemberList, currency, "bcm_currencymember");
        List<DynamicObject> currencyMemberTrees = this.buildMemberTree(currencyMembers, currencyParent);
        List<Tuple<String, Integer, String>> currencyMemberBatch = this.buildMemberBatch(cMemberList, currencyParent);
        DynamicObject process = this.getDimension(modelId, "Process");
        DynamicObject processParent = this.getParentMember(process, "TCF");
        List<DynamicObject> pMemberList = this.getFilteredMember(process, middleMemberList);
        List<DynamicObject> processMembers = this.buildMember(pMemberList, process, "bcm_processmember");
        List<DynamicObject> processMemberTrees = this.buildMemberTree(processMembers, processParent);
        List<Tuple<String, Integer, String>> processMemberBatch = this.buildMemberBatch(pMemberList, processParent);
        DynamicObject[] existComCurrencys = BusinessDataServiceHelper.load((String)"bd_currency", (String)"number", null);
        List<DynamicObject> existComCurrencyList = Stream.of(existComCurrencys).collect(Collectors.toList());
        List<DynamicObject> middleComCurrencyList = this.getDifferenceList(middleMemberList, existComCurrencyList, "currency_code");
        List<DynamicObject> comCurrencyList = this.buildCommonCurrency(middleComCurrencyList);
        DynamicObject paramObject = this.getHwParam(modelId);
        ArrayList<DynamicObject> customMembers = new ArrayList(10);
        List<Object> customMemberTrees = new ArrayList(10);
        List<Object> customMemberBatch = new ArrayList(10);
        if (paramObject != null && paramObject.get("definedid") != null && paramObject.get("definedmemid") != null) {
            DynamicObject dynamicObject = (DynamicObject)paramObject.get("definedid");
            String customNum = dynamicObject.getString("number");
            DynamicObject custom = this.getDimension(modelId, customNum);
            DynamicObject customMember = (DynamicObject)paramObject.get("definedmemid");
            String customMemberNum = customMember.getString("number");
            String definedMemPrefix = paramObject.getString("definedmemprefix");
            middleMemberList.stream().filter(e -> {
                String currencyCode = e.getString("currency_code");
                if (StringUtils.isBlank((CharSequence)currencyCode)) {
                    return false;
                }
                return !currencyCode.equalsIgnoreCase("all") && !currencyCode.equalsIgnoreCase("none");
            }).map(e -> {
                if (StringUtils.isNotEmpty((CharSequence)definedMemPrefix)) {
                    e.set("currency_code", (Object)(definedMemPrefix + "_" + e.getString("currency_code")));
                }
                return e;
            }).collect(Collectors.toList());
            List<DynamicObject> customMemberList = this.getFilteredMember(custom, middleMemberList);
            DynamicObject customParent = this.getParentMember(custom, customMemberNum);
            customMembers = this.buildMember(customMemberList, custom, "bcm_userdefinedmember");
            customMemberTrees = this.buildMemberTree(customMembers, customParent);
            customMemberBatch = this.buildMemberBatch(pMemberList, customParent);
        }
        try (TXHandle th = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])currencyMembers.toArray(new DynamicObject[0]));
                DynamicObject[] currencyResult = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])currencyMemberTrees.toArray(new DynamicObject[0]));
                this.constructLog(currencyResult);
                OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)"Currency", currencyMemberBatch);
                SaveServiceHelper.save((DynamicObject[])processMembers.toArray(new DynamicObject[0]));
                DynamicObject[] processResult = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])processMemberTrees.toArray(new DynamicObject[0]));
                this.constructLog(processResult);
                OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)"Process", processMemberBatch);
                SaveServiceHelper.save((DynamicObject[])customMembers.toArray(new DynamicObject[0]));
                DynamicObject[] customResult = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])customMemberTrees.toArray(new DynamicObject[0]));
                this.constructLog(customResult);
                if (paramObject != null && paramObject.get("definedid") != null && paramObject.get("definedmemid") != null) {
                    DynamicObject dynamicObject = (DynamicObject)paramObject.get("definedid");
                    String customNum = dynamicObject.getString("number");
                    OlapServiceHelper.batchCreateDimensionMembers((String)modelNum, (String)customNum, customMemberBatch);
                }
            }
            catch (Exception e2) {
                th.markRollback();
                throw new KDBizException(e2.getMessage());
            }
        }
        SaveServiceHelper.save((DynamicObject[])comCurrencyList.toArray(new DynamicObject[0]));
        return null;
    }

    private List<DynamicObject> buildCommonCurrency(List<DynamicObject> middleComCurrencyList) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (DynamicObject dynamicObject : middleComCurrencyList) {
            String number = dynamicObject.getString("currency_code");
            String name = dynamicObject.getString("currency_code");
            DynamicObject comCurrency = BusinessDataServiceHelper.newDynamicObject((String)"bd_currency");
            comCurrency.set("number", (Object)number);
            comCurrency.set("name", (Object)name);
            comCurrency.set("amtprecision", (Object)"2");
            comCurrency.set("priceprecision", (Object)"2");
            comCurrency.set(ACCOUNT_DESCRIPTION, (Object)ResManager.loadKDString((String)"\u901a\u8fc7\u6cd5\u5b9a\u5408\u5e76\u7684\u4e2d\u95f4\u8868t_bcm_dscurrmaindata\u96c6\u6210\u5f97\u5230\u3002", (String)"DimenMemberSyncMsServiceImpl_32", (String)"fi-bcm-mservice", (Object[])new Object[0]));
            comCurrency.set("status", (Object)"C");
            comCurrency.set("enable", (Object)1);
            comCurrency.set("issystem", (Object)"0");
            comCurrency.set("isshowsign", (Object)"0");
            this.setSysField(comCurrency);
            list.add(comCurrency);
        }
        return list;
    }

    private DynamicObject getParentMember(DynamicObject dimension, String nodeName) {
        Long dimensionId = dimension.getLong("id");
        String entityNum = dimension.getString("membermodel");
        QFilter qFilter = new QFilter(DIMENSION, "=", (Object)dimensionId);
        qFilter.and("number", "=", (Object)nodeName);
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((String)entityNum, (String)"id,longnumber,number,model,dimension", (QFilter[])new QFilter[]{qFilter});
        return parent;
    }

    private List<Tuple<String, Integer, String>> buildMemberBatch(List<DynamicObject> middleMemberList, DynamicObject parent) {
        String parentNumber = parent.getString("number");
        ArrayList<Tuple<String, Integer, String>> list = new ArrayList<Tuple<String, Integer, String>>(10);
        for (DynamicObject middleMember : middleMemberList) {
            String number = middleMember.getString("currency_code");
            list.add((Tuple<String, Integer, String>)Tuple.create((Object)number, (Object)5, (Object)parentNumber));
        }
        return list;
    }

    private List<DynamicObject> buildMember(List<DynamicObject> middleMemberList, DynamicObject dimension, String entityNum) {
        Long dimensionId = dimension.getLong("id");
        Long modelId = dimension.getLong("model.id");
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (DynamicObject middleMember : middleMemberList) {
            String number = middleMember.getString("currency_code");
            String name = middleMember.getString("currency_code");
            DynamicObject member = this.getDimensionMember(entityNum, modelId, dimensionId, number, name);
            list.add(member);
        }
        return list;
    }

    private List<DynamicObject> buildMemberTree(List<DynamicObject> memberList, DynamicObject parent) {
        String entityName = parent.getDynamicObjectType().getName();
        Integer seq = 0;
        QFilter qFilter = new QFilter("parent", "=", (Object)parent.getString("id"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityName, (String)"dseq", (QFilter[])new QFilter[]{qFilter}, (String)"dseq desc", (int)1);
        if (dynamicObjects != null && dynamicObjects.size() != 0) {
            seq = ((DynamicObject)dynamicObjects.get(0)).getInt("dseq");
        }
        List<Object> list = new ArrayList(10);
        if (entityName.equals("bcm_currencymembertree")) {
            list = this.getMemberTreeOfCurrency(memberList, parent, seq);
        } else if (entityName.equals("bcm_processmembertree")) {
            list = this.getMemberTreeOfProcess(memberList, parent, seq);
        } else if (entityName.equals("bcm_userdefinedmembertree")) {
            list = this.getMemberTreeOfCustom(memberList, parent, seq);
        }
        return list;
    }

    private List<DynamicObject> getMemberTreeOfCustom(List<DynamicObject> memberList, DynamicObject parent, Integer seq) {
        Long modelId = parent.getLong("model.id");
        Long dimensionId = parent.getLong("dimension.id");
        Long parentFid = parent.getLong("id");
        String parentLongNumber = parent.getString("longnumber");
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (DynamicObject member : memberList) {
            seq = seq + 1;
            String number = member.getString("number");
            String name = member.getString("name");
            DynamicObject memberTreeObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_userdefinedmembertree");
            memberTreeObject.set("longnumber", (Object)(parentLongNumber + "!" + number));
            memberTreeObject.set("member", (Object)member);
            memberTreeObject.set("parent", (Object)parentFid);
            memberTreeObject.set("isleaf", (Object)"1");
            memberTreeObject.set("level", (Object)"2");
            memberTreeObject.set("dseq", (Object)seq);
            memberTreeObject.set("storagetype", (Object)"4");
            memberTreeObject.set("aggoprt", (Object)"1");
            memberTreeObject.set("enable", (Object)1);
            memberTreeObject.set("status", (Object)"C");
            memberTreeObject.set("issysmember", (Object)DimMemTypeEnum.UNSYSMEM.getIndex());
            memberTreeObject.set("number", (Object)number);
            memberTreeObject.set("name", (Object)name);
            memberTreeObject.set(MODEL, (Object)modelId);
            memberTreeObject.set(DIMENSION, (Object)dimensionId);
            memberTreeObject.set("masterid", (Object)0);
            memberTreeObject.set("datatype", (Object)0);
            memberTreeObject.set(ACCOUNT_DESCRIPTION, (Object)ResManager.loadKDString((String)"\u901a\u8fc7\u4e2d\u95f4\u8868t_bcm_dscurrmaindata\u96c6\u6210\u5f97\u5230\u3002", (String)"DimenMemberSyncMsServiceImpl_33", (String)"fi-bcm-mservice", (Object[])new Object[0]));
            this.setSysField(memberTreeObject);
            list.add(memberTreeObject);
        }
        return list;
    }

    private List<DynamicObject> getMemberTreeOfProcess(List<DynamicObject> memberList, DynamicObject parent, Integer seq) {
        Long modelId = parent.getLong("model.id");
        Long dimensionId = parent.getLong("dimension.id");
        Long parentFid = parent.getLong("id");
        String parentLongNumber = parent.getString("longnumber");
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (DynamicObject member : memberList) {
            seq = seq + 1;
            String number = member.getString("number");
            String name = member.getString("name");
            DynamicObject memberTreeObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_processmembertree");
            memberTreeObject.set("longnumber", (Object)(parentLongNumber + "!" + number));
            memberTreeObject.set("member", (Object)member);
            memberTreeObject.set("parent", (Object)parentFid);
            memberTreeObject.set("isleaf", (Object)"1");
            memberTreeObject.set("level", (Object)"3");
            memberTreeObject.set("dseq", (Object)seq);
            memberTreeObject.set("storagetype", (Object)StorageTypeEnum.UNSHARE.index);
            memberTreeObject.set("aggoprt", (Object)"5");
            memberTreeObject.set("enable", (Object)1);
            memberTreeObject.set("status", (Object)"C");
            memberTreeObject.set("issysmember", (Object)DimMemTypeEnum.UNSYSMEM.getIndex());
            memberTreeObject.set("number", (Object)number);
            memberTreeObject.set("name", (Object)name);
            memberTreeObject.set(MODEL, (Object)modelId);
            memberTreeObject.set(DIMENSION, (Object)dimensionId);
            memberTreeObject.set("masterid", (Object)0);
            memberTreeObject.set(ACCOUNT_DESCRIPTION, (Object)ResManager.loadKDString((String)"\u901a\u8fc7\u4e2d\u95f4\u8868t_bcm_dscurrmaindata\u96c6\u6210\u5f97\u5230\u3002", (String)"DimenMemberSyncMsServiceImpl_33", (String)"fi-bcm-mservice", (Object[])new Object[0]));
            memberTreeObject.set("datasource", (Object)"1");
            this.setSysField(memberTreeObject);
            list.add(memberTreeObject);
        }
        return list;
    }

    private List<DynamicObject> getFilteredMember(DynamicObject dension, List<DynamicObject> middleMemberList) {
        Long dimensionId = dension.getLong("id");
        String entityNum = dension.getString("membermodel");
        List<DynamicObject> existMembers = Stream.of(this.getExistMembers(dimensionId, entityNum)).collect(Collectors.toList());
        List<DynamicObject> list = this.getDifferenceList(middleMemberList, existMembers, "currency_code");
        return list;
    }

    private void constructLog(DynamicObject[] obj) {
        if (obj != null && obj.length > 0) {
            ArrayList<DynamicObject> logList = new ArrayList<DynamicObject>(10);
            for (DynamicObject dynamicObject : obj) {
                DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"bcm_dimensionmodifylog");
                log.set(MODEL, dynamicObject.get(MODEL));
                log.set(DIMENSION, dynamicObject.get(DIMENSION));
                log.set("memberid", dynamicObject.getPkValue());
                log.set("membernumber", (Object)dynamicObject.getString("number"));
                log.set("membername", (Object)dynamicObject.getString("name"));
                log.set("operatenumber", (Object)"integration_new");
                log.set("operatename", (Object)ResManager.loadKDString((String)"\u96c6\u6210\u65b0\u589e", (String)"DimenMemberSyncMsServiceImpl_34", (String)"fi-bcm-mservice", (Object[])new Object[0]));
                log.set("createuserid", dynamicObject.get("modifier"));
                log.set("createtime", dynamicObject.get("modifytime"));
                logList.add(log);
            }
            SaveServiceHelper.save((DynamicObject[])logList.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject setSysField(DynamicObject obj) {
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        RequestContext tx = RequestContext.get();
        user.set("id", (Object)tx.getUserId());
        Date createTime = TimeServiceHelper.now();
        obj.set("modifytime", (Object)createTime);
        obj.set("createtime", (Object)createTime);
        obj.set("modifier", (Object)user);
        obj.set("creator", (Object)user);
        return obj;
    }

    private String syncDimensionMember(boolean isCreate, boolean isUpdate) {
        this.checkCanEdit(isCreate, isUpdate);
        List<kd.fi.bcm.spread.model.dao.Row> needSyncData = this.queryNeedSyncData();
        if (needSyncData.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\uff0c\u8bf7\u7ef4\u62a4\u4e2d\u95f4\u8868\u3002", (String)"DimenMemberSyncMsServiceImpl_4", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        StringBuilder errMsg = new StringBuilder();
        DynamicObjectCollection existTreeMembers = this.getExistTreeMemberCol();
        HashSet<String> existNumbers = new HashSet<String>(existTreeMembers.size());
        for (DynamicObject dot : existTreeMembers) {
            existNumbers.add(dot.getString("number"));
        }
        DimensionTreeNode root = new DimensionTreeNode(ROOT, ROOT);
        root = TreeBuilder.getDimensionTree4Sync((DynamicObjectCollection)existTreeMembers, (DimensionTreeNode)root, (String)((DynamicObject)existTreeMembers.get(0)).getString("parent"));
        this.buildNoShareNodeMap(root);
        this.buildAccountCategoryMap(needSyncData);
        if (isCreate) {
            this.createMembers(root, needSyncData, existNumbers, errMsg);
        }
        if (isUpdate) {
            this.updateMembers(needSyncData, root, errMsg);
        }
        HashMap<String, DynamicObject> allMember = new HashMap<String, DynamicObject>();
        ArrayList<DynamicObject> saveMembers = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> saveTreeMembers = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> saveParent = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> logMembers = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> newAccountPart = new ArrayList<DynamicObject>(10);
        HashSet<String> saveNumber2Olap = new HashSet<String>();
        HashMap<Long, DynamicObject> allTreeMember = new HashMap<Long, DynamicObject>(16);
        for (Object e : existTreeMembers) {
            allTreeMember.put(e.getLong("id"), (DynamicObject)e);
        }
        DynamicObjectCollection existMembers = this.getExistMemberCol();
        for (DynamicObject e : existMembers) {
            allMember.put(e.getString("number"), e);
        }
        ArrayList<DynamicObject> temp = new ArrayList<DynamicObject>();
        this.buildNeedSaveData(root, allTreeMember, existNumbers, allMember, saveMembers, saveTreeMembers, saveNumber2Olap, saveParent, logMembers, temp, newAccountPart);
        try (TXHandle th = TX.requiresNew();){
            try {
                if (!saveMembers.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)saveMembers.get(0)).getDynamicObjectType(), (Object[])saveMembers.toArray());
                }
                if (!saveTreeMembers.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)saveTreeMembers.get(0)).getDynamicObjectType(), (Object[])saveTreeMembers.toArray());
                }
                if (!temp.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)temp.get(0)).getDynamicObjectType(), (Object[])temp.toArray());
                }
                if (!saveParent.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)saveParent.get(0)).getDynamicObjectType(), (Object[])saveParent.toArray());
                }
                if (!newAccountPart.isEmpty()) {
                    BusinessDataWriter.save((IDataEntityType)((DynamicObject)newAccountPart.get(0)).getDynamicObjectType(), (Object[])newAccountPart.toArray());
                }
                if (!saveNumber2Olap.isEmpty()) {
                    OlapServiceHelper.batchCreateDimensionMembers((String)this.modelNum, (String)this.dimensionNum, (String[])saveNumber2Olap.toArray(new String[0]));
                    log.info("dimensionSync: olap " + saveNumber2Olap);
                }
            }
            catch (Exception e) {
                th.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        QFilter af = new QFilter("model.number", "=", (Object)this.modelNum).and(new QFilter("status", "!=", (Object)"A"));
        QFilter nb = new QFilter("longnumber", "like", (Object)(root.getLongnumber() + "%"));
        DynamicObjectCollection memCollection = QueryServiceHelper.query((String)this.entityNum, (String)"id, number, parent.id, aggoprt, isleaf, storagetype", (QFilter[])new QFilter[]{af, nb});
        DynamicComputingServiceHelper.repairModelByScope((String)this.modelNum, (String)this.dimensionNum, (boolean)true, (DynamicObjectCollection)memCollection);
        return errMsg.toString();
    }

    private void buildNeedSaveData(DimensionTreeNode root, Map<Long, DynamicObject> allTreeMember, Set<String> existNumbers, Map<String, DynamicObject> allMember, List<DynamicObject> saveMembers, List<DynamicObject> saveTreeMembers, Set<String> saveNumber2Olap, List<DynamicObject> saveParent, List<DynamicObject> logMembers, List<DynamicObject> temp, List<DynamicObject> newAccountPart) {
        Queue allNode = DimensionTreeNode.getQueue((DimensionTreeNode)root);
        while (!allNode.isEmpty()) {
            DimensionTreeNode node = (DimensionTreeNode)allNode.poll();
            if (!node.isNeadsave()) continue;
            if (node.getProperty(ISCREATE) != null) {
                this.packSaveData(node, allTreeMember, existNumbers, allMember, saveMembers, saveTreeMembers, saveNumber2Olap, newAccountPart, true);
                continue;
            }
            if (node.getProperty(ISUPDATE) != null && ((Boolean)node.getProperty(ISUPDATE)).booleanValue()) {
                this.packSaveData(node, allTreeMember, existNumbers, allMember, saveMembers, saveTreeMembers, saveNumber2Olap, newAccountPart, false);
                continue;
            }
            if (node.getProperty(ISUPDATE) != null && !((Boolean)node.getProperty(ISUPDATE)).booleanValue()) {
                this.modifyExistTreeMember(node, allTreeMember, temp, newAccountPart);
                continue;
            }
            DynamicObject treeMember = allTreeMember.get(Long.parseLong(node.getId()));
            treeMember.set("isleaf", (Object)Boolean.FALSE);
            if (ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"CM006")) {
                treeMember.set("storagetype", (Object)StorageTypeEnum.DYNAMIC.index);
            }
            saveParent.add(treeMember);
        }
    }

    private void checkCanEdit(boolean isCreate, boolean isUpdate) {
        boolean flag;
        if (this.isLG) {
            flag = isCreate && !isUpdate ? "Account".equals(this.dimensionNum) || DEFINEDDIMEN.equals(this.dimensionNum) || "Entity".equals(this.dimensionNum) || "Currency".equals(this.dimensionNum) : "Account".equals(this.dimensionNum) || DEFINEDDIMEN.equals(this.dimensionNum);
        } else {
            boolean trueDim = "Account".equals(this.dimensionNum) || "Entity".equals(this.dimensionNum) || "Currency".equals(this.dimensionNum);
            boolean bl = flag = isCreate && !isUpdate && trueDim;
        }
        if (!flag) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u4e0d\u652f\u6301\u8be5\u64cd\u4f5c\u3002", (String)"DimenMemberSyncMsServiceImpl_35", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
    }

    private List<DynamicObject> constrctIsaccountoffset(List<DynamicObject> midList, List<DynamicObject> saveTreeMembers) {
        ArrayList tpList = Lists.newArrayList();
        ArrayList midIsaccountoffsetList = Lists.newArrayList();
        for (DynamicObject saveTreeMember : saveTreeMembers) {
            Long tpId = 0L;
            String saveNumber = saveTreeMember.getString("number");
            for (DynamicObject midObject : midList) {
                String isaccountoffset;
                String midNumber = midObject.getString("accountnumber");
                if (!saveNumber.equals(midNumber) || !StringUtils.isNotEmpty((CharSequence)(isaccountoffset = midObject.getString("isaccountoffset")))) continue;
                midIsaccountoffsetList.add(isaccountoffset);
                DynamicObject part = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofaccountp");
                tpId = DBServiceHelper.genGlobalLongId();
                part.set("isaccountoffset", (Object)"1");
                part.set("id", (Object)tpId);
                tpList.add(part);
                break;
            }
            saveTreeMember.set("accountpart", (Object)tpId);
        }
        if (midIsaccountoffsetList.size() > 0) {
            block2: for (String midIsaccountoffset : midIsaccountoffsetList) {
                for (DynamicObject saveTreeMember : saveTreeMembers) {
                    String number = saveTreeMember.getString("number");
                    if (!midIsaccountoffset.equals(number)) continue;
                    DynamicObject part = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofaccountp");
                    Long tpId = DBServiceHelper.genGlobalLongId();
                    part.set("isaccountoffset", (Object)"1");
                    part.set("id", (Object)tpId);
                    tpList.add(part);
                    saveTreeMember.set("accountpart", (Object)tpId);
                    continue block2;
                }
            }
        }
        return tpList;
    }

    private void packSaveData(DimensionTreeNode node, Map<Long, DynamicObject> allTreeMember, Set<String> existNumbers, Map<String, DynamicObject> allMember, List<DynamicObject> saveMembers, List<DynamicObject> saveTreeMembers, Set<String> saveNumbers, List<DynamicObject> newAccountPart, boolean isCreate) {
        DynamicObject member;
        String number = node.getNumber();
        DynamicObject parent = allTreeMember.get(Long.parseLong(node.getParent().getId()));
        DynamicObject treeMember = BusinessDataServiceHelper.newDynamicObject((String)this.entityNum);
        this.getDimensionTreeMember(newAccountPart, treeMember, parent, node, true);
        DynamicObject obj = allMember.get(number);
        if (obj != null) {
            member = obj;
        } else {
            member = this.getDimensionMember(dimEntityMap.get(this.entityNum), this.modelId, this.dimensionId, number, node.getName());
            saveMembers.add(member);
            allMember.put(number, member);
        }
        treeMember.set("member", (Object)member);
        if (ConfigServiceHelper.getBoolParam((Long)this.modelId, (String)"CM006") && isCreate && !node.isLeaf()) {
            treeMember.set("storagetype", (Object)StorageTypeEnum.DYNAMIC.index);
        }
        allTreeMember.put(treeMember.getLong("id"), treeMember);
        saveTreeMembers.add(treeMember);
        if (!existNumbers.contains(number) && node.getCopyfrom().equals("0")) {
            saveNumbers.add(number);
        }
    }

    private void modifyExistTreeMember(DimensionTreeNode node, Map<Long, DynamicObject> allTreeMember, List<DynamicObject> saveTreeMembers, List<DynamicObject> newAccountPart) {
        DynamicObject dot = allTreeMember.get(Long.parseLong(node.getId()));
        if (dot == null) {
            log.info("dimensionSync: " + node.getId() + node.getLongnumber());
        } else {
            DynamicObject parent = allTreeMember.get(Long.parseLong(node.getParent().getId()));
            this.getDimensionTreeMember(newAccountPart, dot, parent, node, false);
            saveTreeMembers.add(dot);
        }
    }

    private void updateMembers(List<kd.fi.bcm.spread.model.dao.Row> needSync, DimensionTreeNode root, StringBuilder errMsg) {
        String entityName = this.getEntityName();
        String numberField = this.getNumberField(entityName, this.dimensionNum);
        String nameField = this.getNameField(entityName, this.dimensionNum);
        String parentField = this.getParentField(entityName, this.dimensionNum);
        for (kd.fi.bcm.spread.model.dao.Row dsmaindata : needSync) {
            String msg;
            String number = this.getValue(dsmaindata, numberField);
            String parentNumber = this.getValue(dsmaindata, parentField);
            if (number == null || number.length() == 0) {
                errMsg.append(ResManager.loadKDString((String)"\u6210\u5458\u7684\u7f16\u7801\u4e3a\u7a7a\u4e0d\u53ef\u66f4\u65b0\u3002", (String)"DimenMemberSyncMsServiceImpl_36", (String)"fi-bcm-mservice", (Object[])new Object[0]));
                continue;
            }
            number = this.getTrueNumber(number, errMsg);
            if (this.isLG && (number == null || number.length() == 0)) {
                String msg2 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u7236\u7ea7\u4e3a\u7a7a\uff0c\u4e0d\u53ef\u66f4\u65b0\u3002", (String)"DimenMemberSyncMsServiceImpl_37", (String)"fi-bcm-mservice", (Object[])new Object[0]), parentNumber);
                errMsg.append(msg2);
                continue;
            }
            parentNumber = ROOT.equals(parentNumber) ? root.getNumber() : parentNumber;
            parentNumber = this.getTrueNumber(parentNumber, errMsg);
            DimensionTreeNode node = this.searchNoShareNode(root, number);
            if (node == null) {
                String msg3 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5b58\u5728\u975e\u5171\u4eab\u6210\u5458\uff0c\u4e0d\u53ef\u66f4\u65b0\u3002", (String)"DimenMemberSyncMsServiceImpl_38", (String)"fi-bcm-mservice", (Object[])new Object[0]), number);
                errMsg.append(msg3);
                continue;
            }
            DimensionTreeNode parentNode = node.getParent();
            if (parentNode == null) {
                String msg4 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u7236\u8282\u70b9\u4e0d\u5b58\u5728\uff0c\u4e0d\u53ef\u66f4\u65b0\u3002", (String)"DimenMemberSyncMsServiceImpl_39", (String)"fi-bcm-mservice", (Object[])new Object[0]), number);
                errMsg.append(msg4);
                continue;
            }
            if (parentNumber != null && !parentNumber.equalsIgnoreCase(parentNode.getNumber())) {
                DimensionTreeNode newParentNode = this.searchNoShareNode(root, parentNumber);
                if (newParentNode == null) {
                    msg = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u975e\u5171\u4eab\u6210\u5458\uff0c\u65e0\u6cd5\u5728\u6b64\u6210\u5458\u4e0b\u66f4\u65b0\u201c%2$s\u201d\u3002", (String)"DimenMemberSyncMsServiceImpl_40", (String)"fi-bcm-mservice", (Object[])new Object[0]), parentNumber, number);
                    errMsg.append(msg);
                    continue;
                }
                if (this.numberEqual(number, newParentNode)) continue;
                DimensionTreeNode shareNode = new DimensionTreeNode(String.valueOf(DBServiceHelper.genGlobalLongId()), node.getName());
                this.copyShareNode(shareNode, node, newParentNode);
                this.setNodeProperty(this.entityNum, dsmaindata, shareNode, newParentNode, root);
                shareNode.setProperty(ISUPDATE, (Object)Boolean.TRUE);
                continue;
            }
            if (node.getProperty(ISCREATE) != null) continue;
            String name = this.getValue(dsmaindata, nameField);
            if (StringUtils.isEmpty((CharSequence)name)) {
                msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u540d\u79f0\u4e3a\u7a7a\uff0c\u4e0d\u53ef\u66f4\u65b0\u3002", (String)"DimenMemberSyncMsServiceImpl_41", (String)"fi-bcm-mservice", (Object[])new Object[0]), number);
                errMsg.append(msg);
                continue;
            }
            String storageType = this.getStorageType(dsmaindata, this.entityNum);
            if (StorageTypeEnum.SHARE.index.equals(storageType)) continue;
            node.setProperty(ISUPDATE, (Object)Boolean.FALSE);
            node.setName(name);
            this.setNodeProperty(this.entityNum, dsmaindata, node, parentNode, root);
        }
    }

    private boolean numberEqual(String number, DimensionTreeNode parentNode) {
        boolean flag = false;
        for (ITreeNode child : parentNode.getChildren()) {
            if (!number.equals(((DimensionTreeNode)child).getNumber())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void setNodeProperty(String entityNum, kd.fi.bcm.spread.model.dao.Row row, DimensionTreeNode node, DimensionTreeNode parentNode, DimensionTreeNode root) {
        if (StorageTypeEnum.SHARE.index.equals(node.getStoragetype())) {
            DimensionTreeNode srcNode = this.searchNoShareNode(root, node.getNumber());
            if (srcNode != null) {
                HashMap temp = new HashMap(srcNode.getProperties());
                node.setProperties(temp);
            }
        } else if ("bcm_accountmembertree".equals(entityNum)) {
            this.setAccountProperty(row, node, parentNode);
            this.setAccountOffset(node.getStoragetype(), node, row, root);
        }
        if ("bcm_accountmembertree".equals(entityNum)) {
            this.setAccountAggOprt(row, node, parentNode);
        } else if ("bcm_userdefinedmembertree".equals(entityNum)) {
            node.setProperty("aggoprt", (Object)AggOprtEnum.ADD.sign);
        }
        node.setNeadsave(true);
    }

    private void copyShareNode(DimensionTreeNode shareNode, DimensionTreeNode node, DimensionTreeNode newParentNode) {
        shareNode.setStoragetype(StorageTypeEnum.SHARE.index);
        shareNode.setIsleaf(node.isLeaf());
        shareNode.setNumber(node.getNumber());
        shareNode.setCopyfrom(node.getId());
        shareNode.setLongnumber(newParentNode.getLongnumber() + "!" + node.getNumber());
        shareNode.setLevel(newParentNode.getLevel() + 1);
        shareNode.setDseq(newParentNode.getChildren().size() + 1);
        newParentNode.addChild((ITreeNode)shareNode);
        node.getChildren().forEach(e -> shareNode.addChild((ITreeNode)((DimensionTreeNode)e).clone()));
        this.updateChildsLongnumberAndLevel(shareNode);
        if (newParentNode.isLeaf()) {
            newParentNode.setIsleaf(false);
            newParentNode.setNeadsave(true);
        }
    }

    private void updateChildsLongnumberAndLevel(DimensionTreeNode updateNode) {
        for (ITreeNode e : updateNode.getChildren()) {
            DimensionTreeNode child = (DimensionTreeNode)e;
            String longnumber = child.getNumber();
            DimensionTreeNode parent = child.getParent();
            longnumber = parent.getLongnumber() + '!' + longnumber;
            child.setLongnumber(longnumber);
            child.setLevel(parent.getLevel() + 1);
            child.setNeadsave(true);
            child.setStoragetype(StorageTypeEnum.SHARE.index);
            child.setProperty(ISUPDATE, (Object)Boolean.TRUE);
            child.setCopyfrom(child.getId());
            child.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
            this.updateChildsLongnumberAndLevel(child);
        }
    }

    private DynamicObject getModel(String showNumber) {
        QFBuilder modelBuilder = new QFBuilder("shownumber", "=", (Object)showNumber);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_model", (String)"id,number", (QFilter[])modelBuilder.toArray());
    }

    private String getTrueNumber(String number, StringBuilder errMsg) {
        if (number == null || number.length() == 0) {
            return null;
        }
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(number);
        boolean flag = true;
        if (!matcher.matches()) {
            flag = false;
        } else if (number.contains("..") || number.startsWith(".") || number.startsWith("-") || number.length() > 50) {
            flag = false;
        }
        if (flag) {
            return number;
        }
        String newNumber = null;
        for (int i = 0; i < number.length(); ++i) {
            if (!CharUtils.isAsciiAlphanumeric((char)number.charAt(i))) continue;
            newNumber = number.substring(i);
            break;
        }
        if (newNumber != null) {
            if ((newNumber = newNumber.replaceAll(ILLEGAL, "").replaceAll(MULTIPOINT, ".")).length() > 50) {
                newNumber = newNumber.substring(0, 50);
            }
            String msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u6539\u4e3a\u201c%2$s\u201d\u3002", (String)"DimenMemberSyncMsServiceImpl_13", (String)"fi-bcm-mservice", (Object[])new Object[0]), number, newNumber);
            errMsg.append(msg);
        } else {
            String msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%1$s\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u65e0\u6cd5\u5904\u7406", (String)"DimenMemberSyncMsServiceImpl_42", (String)"fi-bcm-mservice", (Object[])new Object[0]), number);
            errMsg.append(msg);
        }
        return newNumber;
    }

    private DynamicObject getDimensionMember(String memberModel, Long modelId, Long dimensionId, String number, String name) {
        DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)memberModel);
        Long id = DBServiceHelper.genGlobalLongId();
        member.set("id", (Object)id);
        member.set("number", (Object)number);
        member.set("name", (Object)name);
        member.set("masterid", (Object)0L);
        this.setUserAndTime(member);
        member.set("enable", (Object)1);
        member.set(MODEL, (Object)modelId);
        member.set(DIMENSION, (Object)dimensionId);
        member.set("org", (Object)RequestContext.get().getOrgId());
        member.set("status", (Object)"C");
        return member;
    }

    private List<DynamicObject> getMemberTreeOfCurrency(List<DynamicObject> memberList, DynamicObject parent, Integer seq) {
        Long modelId = parent.getLong("model.id");
        Long dimensionId = parent.getLong("dimension.id");
        Long parentFid = parent.getLong("id");
        String parentLongNumber = parent.getString("longnumber");
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (DynamicObject member : memberList) {
            seq = seq + 1;
            String number = member.getString("number");
            String name = member.getString("name");
            DynamicObject memberTreeObject = BusinessDataServiceHelper.newDynamicObject((String)"bcm_currencymembertree");
            memberTreeObject.set("number", (Object)number);
            memberTreeObject.set("name", (Object)name);
            memberTreeObject.set("longnumber", (Object)(parentLongNumber + "!" + number));
            memberTreeObject.set("level", (Object)"2");
            memberTreeObject.set("dseq", (Object)seq);
            memberTreeObject.set("parent", (Object)parentFid);
            memberTreeObject.set("isleaf", (Object)"1");
            memberTreeObject.set("storagetype", (Object)"4");
            memberTreeObject.set("aggoprt", (Object)"5");
            memberTreeObject.set("status", (Object)"C");
            memberTreeObject.set("enable", (Object)1);
            memberTreeObject.set("issysmember", (Object)DimMemTypeEnum.UNSYSMEM.getIndex());
            memberTreeObject.set(MODEL, (Object)modelId);
            memberTreeObject.set(DIMENSION, (Object)dimensionId);
            memberTreeObject.set("masterid", (Object)0);
            memberTreeObject.set(ACCOUNT_DESCRIPTION, (Object)ResManager.loadKDString((String)"\u901a\u8fc7\u4e2d\u95f4\u8868t_bcm_dscurrmaindata\u96c6\u6210\u5f97\u5230\u3002", (String)"DimenMemberSyncMsServiceImpl_33", (String)"fi-bcm-mservice", (Object[])new Object[0]));
            this.setSysField(memberTreeObject);
            memberTreeObject.set("member", (Object)member);
            list.add(memberTreeObject);
        }
        return list;
    }

    private void getDimensionTreeMember(List<DynamicObject> newAccountPart, DynamicObject obj, DynamicObject parent, DimensionTreeNode node, boolean isCreate) {
        String number = node.getNumber();
        obj.set("number", (Object)number);
        obj.set("name", (Object)node.getName());
        obj.set("longnumber", (Object)(parent.getString("longnumber") + "!" + number));
        obj.set("level", (Object)node.getLevel());
        obj.set("dseq", (Object)node.getDseq());
        obj.set("storagetype", (Object)node.getStoragetype());
        Date createTime = TimeServiceHelper.now();
        obj.set("modifytime", (Object)createTime);
        obj.set("createtime", (Object)createTime);
        DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        RequestContext tx = RequestContext.get();
        user.set("id", (Object)tx.getUserId());
        obj.set("modifier", (Object)user);
        obj.set("creator", (Object)user);
        obj.set("share", (Object)0);
        obj.set("parent", (Object)parent.getLong("id"));
        obj.set("isleaf", (Object)node.isLeaf());
        obj.set("copyfrom", (Object)node.getCopyfrom());
        if (isCreate) {
            obj.set("issysmember", (Object)4);
            obj.set(MODEL, (Object)this.modelId);
            obj.set(DIMENSION, (Object)this.dimensionId);
            obj.set("status", (Object)"C");
            obj.set("enable", (Object)1);
            obj.set("id", (Object)node.getId());
            obj.set("masterid", (Object)0);
            obj.set("datatype", (Object)DataTypeEnum.DEFAULT.index);
        }
        node.getProperties().keySet().forEach(key -> {
            if ("isaccountoffset".equals(key)) {
                DynamicObject part;
                if (obj.getDynamicObject("accountpart") == null) {
                    part = BusinessDataServiceHelper.newDynamicObject((String)"bcm_structofaccountp");
                    part.set("id", (Object)DBServiceHelper.genGlobalLongId());
                    obj.set("accountpart", part.get("id"));
                    newAccountPart.add(part);
                } else {
                    part = obj.getDynamicObject("accountpart");
                }
                part.set("isaccountoffset", (Object)Boolean.TRUE);
            } else if (!ISCREATE.equals(key) && !ISUPDATE.equals(key)) {
                obj.set(key, node.getProperty(key));
            }
        });
    }

    private DynamicObject[] getExistMembers(Long dimensionId, String entityName) {
        QFBuilder builder = new QFBuilder(DIMENSION, "=", (Object)dimensionId);
        String select = "id,name,number,parent,isleaf,storagetype,member.id,share,level,dseq,copyfrom,longnumber,aggoprt";
        if ("bcm_accountmembertree".equals(entityName)) {
            select = select + ",accounttype,exchange,drcrdirect";
        }
        return BusinessDataServiceHelper.load((String)entityName, (String)select, (QFilter[])builder.toArray(), (String)"level");
    }

    private DynamicObjectCollection getExistTreeMemberCol() {
        QFBuilder builder = new QFBuilder(DIMENSION, "=", (Object)this.dimensionId);
        DynamicObject[] col = BusinessDataServiceHelper.load((String)this.entityNum, (String)this.getSelectFields(), (QFilter[])builder.toArray(), (String)"level");
        DynamicObjectCollection result = new DynamicObjectCollection();
        Collections.addAll(result, col);
        return result;
    }

    private DynamicObjectCollection getExistMemberCol() {
        QFBuilder builder = new QFBuilder(DIMENSION, "=", (Object)this.dimensionId);
        DynamicObject[] col = BusinessDataServiceHelper.load((String)dimEntityMap.get(this.entityNum), (String)"id,number,name", (QFilter[])builder.toArray());
        DynamicObjectCollection result = new DynamicObjectCollection();
        Collections.addAll(result, col);
        return result;
    }

    private String getSelectFields() {
        String field = "id,name,number,parent,isleaf,storagetype,member.id,share,level,dseq,copyfrom,longnumber,aggoprt,creator,modifier,createtime,modifytime,description";
        switch (this.dimensionNum) {
            case "Account": {
                field = field + ",accounttype,exchange,drcrdirect,accountpart,isparticipmerge,isaccountoffset";
            }
        }
        return field;
    }

    private void createMembers(DimensionTreeNode root, List<kd.fi.bcm.spread.model.dao.Row> needSync, Set<String> existNumbers, StringBuilder errMsg) {
        String msg;
        Set allLowerNumbers = existNumbers.stream().map(String::toLowerCase).collect(Collectors.toSet());
        ArrayList<kd.fi.bcm.spread.model.dao.Row> noShareData = new ArrayList<kd.fi.bcm.spread.model.dao.Row>(10);
        ArrayList<kd.fi.bcm.spread.model.dao.Row> shareData = new ArrayList<kd.fi.bcm.spread.model.dao.Row>(10);
        String entityName = this.getEntityName();
        String numberField = this.getNumberField(entityName, this.dimensionNum);
        String nameField = this.getNameField(entityName, this.dimensionNum);
        String parentField = this.getParentField(entityName, this.dimensionNum);
        for (kd.fi.bcm.spread.model.dao.Row row : needSync) {
            String number = this.getValue(row, numberField).toLowerCase(Locale.ENGLISH);
            if (allLowerNumbers.contains(number)) continue;
            if (StorageTypeEnum.SHARE.index.equals(this.getStorageType(row, this.entityNum))) {
                shareData.add(row);
                continue;
            }
            noShareData.add(row);
        }
        HashSet<String> errorNumbers = new HashSet<String>(16);
        ArrayList syncThisTime = new ArrayList(noShareData);
        while (!syncThisTime.isEmpty()) {
            boolean addThisTime = false;
            Iterator it = syncThisTime.iterator();
            while (it.hasNext()) {
                kd.fi.bcm.spread.model.dao.Row member = (kd.fi.bcm.spread.model.dao.Row)it.next();
                String number = this.getValue(member, numberField);
                String name = this.getValue(member, nameField);
                if (StringUtils.isEmpty((CharSequence)number)) {
                    it.remove();
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)name)) {
                    it.remove();
                    msg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u6210\u5458\u540d\u79f0\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"DimenMemberSyncMsServiceImpl_43", (String)"fi-bcm-mservice", (Object[])new Object[0]), number);
                    errMsg.append(msg);
                    continue;
                }
                if ((number = this.getTrueNumber(number, errMsg)) != null && !allLowerNumbers.contains(number.toLowerCase(Locale.ENGLISH))) {
                    String parent = this.getValue(member, parentField);
                    if (this.isLG && StringUtils.isEmpty((CharSequence)parent)) {
                        it.remove();
                        String msg2 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u7236\u7ea7\u4e3a\u7a7a\uff0c\u4e0d\u53ef\u65b0\u589e\u3002", (String)"DimenMemberSyncMsServiceImpl_44", (String)"fi-bcm-mservice", (Object[])new Object[0]), number);
                        errMsg.append(msg2);
                        continue;
                    }
                    DimensionTreeNode parentNode = this.searchNoShareNode(root, parent = ROOT.equals(parent) ? root.getNumber() : this.getTrueNumber(parent, errMsg));
                    if (parentNode == null) {
                        errorNumbers.add(number.toLowerCase(Locale.ENGLISH));
                        continue;
                    }
                    this.addNode(this.entityNum, member, number, name, parentNode, "0", root);
                    addThisTime = true;
                    it.remove();
                    allLowerNumbers.add(number.toLowerCase(Locale.ENGLISH));
                    continue;
                }
                it.remove();
            }
            if (addThisTime) continue;
            break;
        }
        errorNumbers.removeAll(allLowerNumbers);
        errorNumbers.forEach(e -> {
            String msg = String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u201c%1$s\u201d\u7684\u7236\u7ea7\u6210\u5458\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"DimenMemberSyncMsServiceImpl_45", (String)"fi-bcm-mservice", (Object[])new Object[0]), e);
            errMsg.append(msg);
        });
        for (kd.fi.bcm.spread.model.dao.Row member : shareData) {
            String number = this.getValue(member, numberField);
            if (StringUtils.isEmpty((CharSequence)number)) continue;
            if ((number = this.getTrueNumber(number, errMsg)) != null && allLowerNumbers.contains(number.toLowerCase(Locale.ENGLISH))) {
                String parent = this.getValue(member, parentField);
                if (this.isLG && StringUtils.isEmpty((CharSequence)parent)) {
                    String msg3 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u7236\u7ea7\u4e3a\u7a7a\uff0c\u4e0d\u53ef\u65b0\u589e\u3002", (String)"DimenMemberSyncMsServiceImpl_44", (String)"fi-bcm-mservice", (Object[])new Object[0]), number);
                    errMsg.append(msg3);
                    continue;
                }
                parent = ROOT.equals(parent) ? root.getNumber() : parent;
                DimensionTreeNode parentNode = this.searchNoShareNode(root, parent = this.getTrueNumber(parent, errMsg));
                if (parentNode == null) {
                    msg = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u975e\u5171\u4eab\u6210\u5458\uff0c\u65e0\u6cd5\u5728\u6b64\u6210\u5458\u4e0b\u65b0\u589e\u3002", (String)"DimenMemberSyncMsServiceImpl_46", (String)"fi-bcm-mservice", (Object[])new Object[0]), parent, number);
                    errMsg.append(msg);
                    continue;
                }
                HashSet child = new HashSet(16);
                parentNode.getChildren().forEach(e -> child.add(((DimensionTreeNode)e).getNumber()));
                if (child.contains(number)) continue;
                DimensionTreeNode src = this.searchNoShareNode(root, number);
                if (src == null) {
                    String msg4 = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u975e\u5171\u4eab\u6210\u5458\uff0c\u65e0\u6cd5\u65b0\u589e\u5171\u4eab\u6210\u5458\u3002", (String)"DimenMemberSyncMsServiceImpl_47", (String)"fi-bcm-mservice", (Object[])new Object[0]), number);
                    errMsg.append(msg4);
                    continue;
                }
                this.addNode(this.entityNum, member, number, src.getName(), parentNode, src.getId(), root);
                continue;
            }
            String msg5 = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u975e\u5171\u4eab\u6210\u5458\uff0c\u65e0\u6cd5\u65b0\u589e\u5171\u4eab\u6210\u5458\u3002", (String)"DimenMemberSyncMsServiceImpl_47", (String)"fi-bcm-mservice", (Object[])new Object[0]), number);
            errMsg.append(msg5);
        }
    }

    private void addNode(String entityNum, kd.fi.bcm.spread.model.dao.Row member, String number, String name, DimensionTreeNode parentNode, String copyfrom, DimensionTreeNode root) {
        String id = String.valueOf(DBServiceHelper.genGlobalLongId());
        String storageType = this.getStorageType(member, entityNum);
        DimensionTreeNode newNode = new DimensionTreeNode(id, name);
        newNode.setNumber(number);
        newNode.setStoragetype(storageType);
        newNode.setCopyfrom(copyfrom);
        newNode.setShare(0);
        newNode.setLevel(parentNode.getLevel() + 1);
        newNode.setDseq(parentNode.getChildren().size() + 1);
        newNode.setIsleaf(true);
        newNode.setLongnumber(parentNode.getLongnumber() + "!" + newNode.getNumber());
        if (parentNode.isLeaf()) {
            parentNode.setIsleaf(false);
            parentNode.setNeadsave(true);
        }
        newNode.setProperty(ISCREATE, (Object)Boolean.TRUE);
        parentNode.addChild((ITreeNode)newNode);
        this.setNodeProperty(entityNum, member, newNode, parentNode, root);
        if (!StorageTypeEnum.SHARE.index.equals(storageType)) {
            this.noShareNodeMap.put(number.toLowerCase(Locale.ENGLISH), newNode);
        }
    }

    private void setAccountOffset(String storageType, DimensionTreeNode newNode, kd.fi.bcm.spread.model.dao.Row member, DimensionTreeNode root) {
        String otherNumber;
        if (!StorageTypeEnum.SHARE.index.equals(storageType) && StringUtils.isNotEmpty((CharSequence)(otherNumber = this.getValue(member, "fisaccountoffset")))) {
            newNode.setProperty("isaccountoffset", (Object)Boolean.TRUE);
            DimensionTreeNode node = this.searchNoShareNode(root, otherNumber);
            if (node != null) {
                node.setProperty("isaccountoffset", (Object)Boolean.TRUE);
                node.setNeadsave(true);
                node.setProperty(ISUPDATE, (Object)Boolean.FALSE);
            }
        }
    }

    private String getStorageType(DynamicObject member, String entityNum) {
        if (!this.isLG || "bcm_entitymembertree".equals(entityNum) || "bcm_currencymembertree".equals(entityNum)) {
            return StorageTypeEnum.STORAGE.index;
        }
        if ("bcm_accountmembertree".equals(entityNum)) {
            String noShare = member.getString("accountnoshare");
            String accountCategory = member.getString("accountcategory");
            if (ACV06.equals(accountCategory) && Y.equals(noShare)) {
                return StorageTypeEnum.LABEL.index;
            }
            if (!ACV06.equals(accountCategory) && Y.equals(noShare)) {
                return StorageTypeEnum.STORAGE.index;
            }
            return StorageTypeEnum.SHARE.index;
        }
        String noShare = member.getString("defined1noshare");
        if (N.equals(noShare)) {
            return StorageTypeEnum.SHARE.index;
        }
        return StorageTypeEnum.STORAGE.index;
    }

    private String getStorageType(kd.fi.bcm.spread.model.dao.Row member, String entityNum) {
        if (!this.isLG || "bcm_entitymembertree".equals(entityNum) || "bcm_currencymembertree".equals(entityNum)) {
            return StorageTypeEnum.STORAGE.index;
        }
        if ("bcm_accountmembertree".equals(entityNum)) {
            String noShare = this.getValue(member, "fnoshare");
            String accountCategory = this.getValue(member, ACCOUNTCATEGORY);
            if (ACV06.equals(accountCategory) && Y.equals(noShare)) {
                return StorageTypeEnum.LABEL.index;
            }
            if (!ACV06.equals(accountCategory) && Y.equals(noShare)) {
                return StorageTypeEnum.STORAGE.index;
            }
            return StorageTypeEnum.SHARE.index;
        }
        String noShare = this.getValue(member, "fdefined1noshare");
        if (N.equals(noShare)) {
            return StorageTypeEnum.SHARE.index;
        }
        return StorageTypeEnum.STORAGE.index;
    }

    private void setAccountProperty(kd.fi.bcm.spread.model.dao.Row member, DimensionTreeNode node, DimensionTreeNode parent) {
        String description;
        String accountCategory = this.getValue(member, ACCOUNTCATEGORY);
        if (accountCategory != null && accountCategory.length() > 0) {
            switch (accountCategory.toLowerCase(Locale.ENGLISH)) {
                case "acv01": {
                    node.setProperty("accounttype", (Object)AccountTypeEnum.ASSET.index);
                    node.setProperty("exchange", (Object)ExchangeEnum.TERMINAL.index);
                    node.setProperty("drcrdirect", (Object)DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.index);
                    break;
                }
                case "acv02": {
                    node.setProperty("accounttype", (Object)AccountTypeEnum.DEBT.index);
                    node.setProperty("exchange", (Object)ExchangeEnum.TERMINAL.index);
                    node.setProperty("drcrdirect", (Object)DrCRDirectEnum.BORROW_MINUS_lOAN_PLUS.index);
                    break;
                }
                case "acv08": {
                    node.setProperty("accounttype", (Object)AccountTypeEnum.CASHFLOW.index);
                    node.setProperty("exchange", (Object)ExchangeEnum.AVERAGE.index);
                    node.setProperty("drcrdirect", (Object)DrCRDirectEnum.BORROW_MINUS_lOAN_PLUS.index);
                    break;
                }
                case "acv03": {
                    node.setProperty("accounttype", (Object)AccountTypeEnum.LOSS.index);
                    node.setProperty("exchange", (Object)ExchangeEnum.AVERAGE.index);
                    node.setProperty("drcrdirect", (Object)DrCRDirectEnum.BORROW_MINUS_lOAN_PLUS.index);
                    break;
                }
                case "acv04": {
                    node.setProperty("accounttype", (Object)AccountTypeEnum.LOSS.index);
                    node.setProperty("exchange", (Object)ExchangeEnum.AVERAGE.index);
                    node.setProperty("drcrdirect", (Object)DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.index);
                    break;
                }
                case "acv05": {
                    if (parent.getLevel() == 1) {
                        node.setProperty("accounttype", (Object)AccountTypeEnum.ASSET.index);
                        node.setProperty("exchange", (Object)ExchangeEnum.TERMINAL.index);
                        node.setProperty("drcrdirect", (Object)DrCRDirectEnum.BORROW_PLUS_lOAN_MINUS.index);
                        break;
                    }
                    node.setProperty("accounttype", parent.getProperty("accounttype"));
                    node.setProperty("exchange", parent.getProperty("exchange"));
                    node.setProperty("drcrdirect", parent.getProperty("drcrdirect"));
                    break;
                }
                case "acv06": 
                case "acv07": {
                    node.setProperty("accounttype", (Object)AccountTypeEnum.OTHERS.index);
                    node.setProperty("exchange", (Object)ExchangeEnum.NONE.index);
                    node.setProperty("drcrdirect", (Object)DrCRDirectEnum.NONE.index);
                    break;
                }
                case "currencyrate": {
                    node.setProperty("accounttype", (Object)AccountTypeEnum.EXCHANGERATE.index);
                    node.setProperty("exchange", (Object)ExchangeEnum.NONE.index);
                    node.setProperty("drcrdirect", (Object)DrCRDirectEnum.NONE.index);
                }
            }
            if ("currencyrate".equals(accountCategory)) {
                node.setProperty("isparticipmerge", (Object)Boolean.FALSE);
            } else {
                node.setProperty("isparticipmerge", (Object)Boolean.TRUE);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(description = this.getValue(member, "fdescription")))) {
            node.setProperty(ACCOUNT_DESCRIPTION, (Object)description);
        }
    }

    private void setAccountAggOprt(kd.fi.bcm.spread.model.dao.Row member, DimensionTreeNode node, DimensionTreeNode parent) {
        String category = this.getValue(member, ACCOUNTCATEGORY);
        if (category == null) {
            return;
        }
        category = category.toLowerCase(Locale.ENGLISH);
        if (parent.getLevel() == 1) {
            switch (category) {
                case "acv06": 
                case "acv07": {
                    node.setProperty("aggoprt", (Object)AggOprtEnum.SKIP.sign);
                    break;
                }
                default: {
                    node.setProperty("aggoprt", (Object)AggOprtEnum.ADD.sign);
                    break;
                }
            }
        } else {
            String parentCategory = this.accountCategoryMap.get(parent.getNumber().toLowerCase(Locale.ENGLISH));
            if (parentCategory == null) {
                node.setProperty("aggoprt", (Object)AggOprtEnum.ADD.sign);
            } else {
                boolean isSub = false;
                switch (category) {
                    case "acv01": 
                    case "acv04": {
                        isSub = parentCategory.equals("acv02") || parentCategory.equals("acv03");
                        break;
                    }
                    case "acv02": 
                    case "acv03": {
                        isSub = parentCategory.equals("acv01") || parentCategory.equals("acv04");
                    }
                }
                node.setProperty("aggoprt", (Object)(isSub ? AggOprtEnum.SUBSTRACT.sign : AggOprtEnum.ADD.sign));
            }
        }
    }

    private List<kd.fi.bcm.spread.model.dao.Row> queryNeedSyncData() {
        String sql = this.getSql(this.getEntityName());
        ArrayList<kd.fi.bcm.spread.model.dao.Row> result = new ArrayList<kd.fi.bcm.spread.model.dao.Row>();
        try (DataSet dataset = DB.queryDataSet((String)"DimenMemberSyncMsServiceImpl.getNeedSyncData", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);){
            if (dataset != null) {
                while (dataset.hasNext()) {
                    Row row = dataset.next();
                    kd.fi.bcm.spread.model.dao.Row temp = new kd.fi.bcm.spread.model.dao.Row();
                    boolean notEmpty = true;
                    for (String key : dataset.getRowMeta().getFieldNames()) {
                        String value = (String)row.get(key);
                        if (!key.equals("fisaccountoffset") && StringUtils.isEmpty((CharSequence)value)) {
                            notEmpty = false;
                            break;
                        }
                        temp.addColumn(key, (Object)value);
                    }
                    if (!notEmpty) continue;
                    result.add(temp);
                }
            }
        }
        return result;
    }

    public String getEntityName() {
        switch (this.dimensionNum) {
            case "Entity": {
                return "bcm_dsentitymaindata";
            }
            case "Currency": {
                return "bcm_dscurrmaindata";
            }
            case "Account": {
                return this.isLG ? "bcm_dsmaindata" : "bcm_dsacctmaindata";
            }
        }
        return "bcm_dsmaindata";
    }

    private String getNumberField(String entityName, String dimensionNum) {
        switch (entityName) {
            case "bcm_dsentitymaindata": {
                return "company_code";
            }
            case "bcm_dscurrmaindata": {
                return "currency_code";
            }
            case "bcm_dsacctmaindata": {
                return "group_account_code";
            }
        }
        return "Account".equals(dimensionNum) ? "fnumber" : "fdefined1number";
    }

    private String getNameField(String entityName, String dimensionNum) {
        switch (entityName) {
            case "bcm_dsentitymaindata": {
                return "company_cn_name";
            }
            case "bcm_dscurrmaindata": {
                return "currency_code";
            }
            case "bcm_dsacctmaindata": {
                return "grp_account_code_cn_name";
            }
        }
        return "Account".equals(dimensionNum) ? "fname" : "fdefined1name";
    }

    private String getParentField(String entityName, String dimensionNum) {
        switch (entityName) {
            case "bcm_dsentitymaindata": {
                return "company_cn_name";
            }
            case "bcm_dscurrmaindata": {
                return "currency_code";
            }
            case "bcm_dsacctmaindata": {
                return "grp_account_code_cn_name";
            }
        }
        return "Account".equals(dimensionNum) ? "fparent" : "fdefined1parent";
    }

    private String getSelectFields(String entityName, String dimensionNum) {
        switch (entityName) {
            case "bcm_dsentitymaindata": {
                return "company_code,company_cn_name,company_en_name";
            }
            case "bcm_dscurrmaindata": {
                return "currency_code";
            }
            case "bcm_dsacctmaindata": {
                return "group_account_code,grp_account_code_cn_name,grp_account_code_en_name";
            }
        }
        if ("Account".equals(dimensionNum)) {
            return "id,accountnumber,accountname,description,accountparent,accountcategory,accountnoshare,isaccountoffset,changeagg";
        }
        return "id,defined1number,defined1name,defined1parent,defined1noshare";
    }

    private String getSql(String entityName) {
        StringBuilder result = new StringBuilder();
        switch (entityName) {
            case "bcm_dsentitymaindata": {
                return "";
            }
            case "bcm_dscurrmaindata": {
                return "";
            }
            case "bcm_dsacctmaindata": {
                return "";
            }
        }
        if ("Account".equals(this.dimensionNum)) {
            result.append("select distinct a.fnumber,b.fname,a.fparent,a.faccountcategory,a.fnoshare,a.fisaccountoffset ");
        } else {
            result.append("select distinct a.fdefined1number,b.fdefined1name,a.fdefined1parent,a.fdefined1noshare ");
        }
        result.append("from t_bcm_dsmaindata as a,t_bcm_dsmaindata_l as b where a.FID = b.FID");
        return result.toString();
    }

    public DynamicObject getDimension(Long modelId, String dimensionNum) {
        QFBuilder modelBuilder = new QFBuilder(MODEL, "=", (Object)modelId).add("number", "=", (Object)dimensionNum);
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension,fieldmapped,dseq,model";
        DynamicObject dimension = BusinessDataServiceHelper.loadSingle((String)"bcm_dimension", (String)selectFields, (QFilter[])modelBuilder.toArray());
        return dimension;
    }

    public List<DynamicObject> getDifferenceList(List<DynamicObject> list, List<DynamicObject> excludeList, String campareProperty) {
        List nameList = excludeList.stream().map(dynamicObject -> dynamicObject.getString("number").toLowerCase(Locale.ENGLISH)).distinct().collect(Collectors.toList());
        List<DynamicObject> diff = list.stream().map(dynamicObject -> {
            dynamicObject.set(campareProperty, (Object)this.subString(this.removeIllegalConform(dynamicObject.getString(campareProperty))));
            return dynamicObject;
        }).filter(dynamicObject -> {
            String currencyCode = dynamicObject.getString(campareProperty);
            if (StringUtils.isBlank((CharSequence)currencyCode)) {
                return false;
            }
            if (currencyCode.equalsIgnoreCase("all") || currencyCode.equalsIgnoreCase("none")) {
                return false;
            }
            boolean flag = !nameList.contains(currencyCode.toLowerCase(Locale.ENGLISH));
            nameList.add(dynamicObject.getString(campareProperty).toLowerCase(Locale.ENGLISH));
            return flag;
        }).collect(Collectors.toList());
        return diff;
    }

    public String syncDimensionMembers(Map<String, Object> param) {
        String result;
        this.validateParam(param);
        String modelShowNum = (String)param.get(MODEL);
        String dimensionNum = (String)param.get(DIMENSION);
        DynamicObject model = this.getModel(modelShowNum);
        if (model == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u4f53\u7cfb\u3002", (String)"DimenMemberSyncMsServiceImpl_21", (String)"fi-bcm-mservice", (Object[])new Object[0]), modelShowNum));
        }
        String modelType = HWModelParamUtil.getModelType((long)model.getLong("id"));
        boolean isLG = modelType.equals(HWModelTypeEnum.LG.getNumber());
        boolean isFin = modelType.equals(HWModelTypeEnum.FIN.getNumber());
        if (!isLG && !isFin) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4f53\u7cfb\u7c7b\u578b\u4e0d\u652f\u6301\u540c\u6b65\u7ef4\u5ea6\u6210\u5458\u64cd\u4f5c\u3002", (String)"DimenMemberSyncMsServiceImpl_29", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        if (dimensionNum.equals("Entity")) {
            result = this.syncEntityMember(param);
        } else if (dimensionNum.equals("Currency")) {
            result = this.addCurrencyMember(param);
        } else if (isFin && dimensionNum.equals("Account")) {
            result = this.addAccountMember(param);
        } else if (isLG && Arrays.asList("Account", DEFINEDDIMEN).contains(dimensionNum)) {
            result = this.createDimensionMember(param);
            result = result + this.updateDimensionMember(param);
        } else {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u201c%1$s\u201d\u4e0d\u652f\u6301\u540c\u6b65\u6210\u5458\u64cd\u4f5c\u3002", (String)"DimenMemberSyncMsServiceImpl_28", (String)"fi-bcm-mservice", (Object[])new Object[0]), dimensionNum));
        }
        return result;
    }

    private void validateParam(Map<String, Object> param) {
        String modelShowNum = (String)param.get(MODEL);
        String dimensionNum = (String)param.get(DIMENSION);
        if (StringUtils.isBlank((CharSequence)modelShowNum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimenMemberSyncMsServiceImpl_26", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)dimensionNum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DimenMemberSyncMsServiceImpl_27", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
    }

    private DimensionTreeNode searchNoShareNode(DimensionTreeNode root, String number) {
        if (number == null) {
            return null;
        }
        String lowercase = number.toLowerCase(Locale.ENGLISH);
        if (this.noShareNodeMap.get(lowercase) == null) {
            DimensionTreeNode node = DimensionTreeNode.searchNoShareNode((DimensionTreeNode)root, (String)lowercase);
            if (node != null) {
                this.noShareNodeMap.put(lowercase, node);
            }
            return node;
        }
        return this.noShareNodeMap.get(lowercase);
    }

    private String getValue(kd.fi.bcm.spread.model.dao.Row row, String key) {
        if (row.getColValue(key) == null) {
            return null;
        }
        return row.getColValue(key).toString();
    }

    private void buildNoShareNodeMap(DimensionTreeNode root) {
        this.noShareNodeMap = new HashMap<String, DimensionTreeNode>();
        Queue queue = DimensionTreeNode.getQueue((DimensionTreeNode)root);
        while (!queue.isEmpty()) {
            DimensionTreeNode node = (DimensionTreeNode)queue.poll();
            if (node.getStoragetype().equals(StorageTypeEnum.SHARE.index)) continue;
            this.noShareNodeMap.put(node.getNumber().toLowerCase(Locale.ENGLISH), node);
        }
    }

    private void buildAccountCategoryMap(List<kd.fi.bcm.spread.model.dao.Row> needSyncData) {
        if ("Account".equals(this.dimensionNum)) {
            String entityName = this.getEntityName();
            String numberField = this.getNumberField(entityName, this.dimensionNum);
            this.accountCategoryMap = new HashMap<String, String>();
            for (kd.fi.bcm.spread.model.dao.Row row : needSyncData) {
                String number;
                if (StorageTypeEnum.SHARE.index.equals(this.getStorageType(row, this.entityNum)) || (number = this.getValue(row, numberField)) == null) continue;
                number = number.toLowerCase(Locale.ENGLISH);
                this.accountCategoryMap.computeIfAbsent(number, e -> this.getValue(row, ACCOUNTCATEGORY).toLowerCase(Locale.ENGLISH));
            }
        }
    }

    private class ConstructMap {
        private Map<String, Object> param;
        private long modelId;
        private Long dimensionId;
        private String entityNum;
        private String modelNum;
        private String dimensionNum;

        public ConstructMap(Map<String, Object> param) {
            this.param = param;
        }

        public long getModelId() {
            return this.modelId;
        }

        public Long getDimensionId() {
            return this.dimensionId;
        }

        public String getEntityNum() {
            return this.entityNum;
        }

        public String getModelNum() {
            return this.modelNum;
        }

        public String getDimensionNum() {
            return this.dimensionNum;
        }

        public ConstructMap invoke(String number) {
            String showNumber = this.param.get(DimenMemberSyncMsServiceImpl.MODEL).toString();
            this.dimensionNum = number;
            DynamicObject model = DimenMemberSyncMsServiceImpl.this.getModel(showNumber);
            this.modelNum = model.getString("number");
            this.modelId = model.getLong("id");
            DynamicObject object = DimenMemberSyncMsServiceImpl.this.getDimension(this.modelId, this.dimensionNum);
            this.dimensionId = object.getLong("id");
            this.entityNum = object.getString("membermodel");
            return this;
        }
    }
}

