/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.fi.bcm.business.dimension.api.CreateEntityDTO;
import kd.fi.bcm.business.dimension.api.UpdateEntityDTO;
import kd.fi.bcm.business.dimension.helper.MemberServiceHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.service.AbstractMsService;
import kd.fi.bcm.service.EntityMemberMsService;

public class EntityMemberMsServiceImpl
extends AbstractMsService
implements EntityMemberMsService {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(EntityMemberMsServiceImpl.class);

    public Map<String, Object> batchUpdateEntity(String modelNum, String paramJson) {
        Map<Object, Object> result;
        block6: {
            List params;
            log.startWatch();
            result = new HashMap<String, Object>(16);
            result.put("success", true);
            try {
                params = (List)JSON.parseObject((String)paramJson, (TypeReference)new TypeReference<List<UpdateEntityDTO>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception ex) {
                log.error("parse object fail." + ThrowableHelper.toString((Exception)ex));
                result.put("success", false);
                result.put("errorMsg", "paramJson parse fail." + ThrowableHelper.toString((Exception)ex));
                return result;
            }
            try {
                Long userId = ((UpdateEntityDTO)params.get(0)).getApplicantId();
                if (userId != null && userId != 0L) {
                    this.resetCurrentUser(userId);
                }
                if ((result = this.validParam(modelNum)).get("errorMsg") != null) {
                    return result;
                }
                MemberServiceHelper.batchUpdateEntity((String)modelNum, (List)params);
            }
            catch (Exception ex) {
                log.error("batch create entity fail." + ex.getMessage());
                if ("ROLLBACK".equals(ex.getMessage())) break block6;
                result.put("errorMsg", ex.getMessage());
                result.put("success", false);
            }
        }
        log.infoEnd("batch create entity end.");
        return result;
    }

    public Map<String, Object> batchCreateEntity(String modelNum, String paramJson) {
        Map<Object, Object> result;
        block6: {
            List params;
            log.startWatch();
            result = new HashMap<String, Object>(16);
            result.put("success", true);
            try {
                params = (List)JSON.parseObject((String)paramJson, (TypeReference)new TypeReference<List<CreateEntityDTO>>(){}, (Feature[])new Feature[0]);
            }
            catch (Exception ex) {
                log.error("parse object fail." + ThrowableHelper.toString((Exception)ex));
                result.put("success", false);
                result.put("errorMsg", "paramJson parse fail." + ThrowableHelper.toString((Exception)ex));
                return result;
            }
            try {
                Long userId = ((CreateEntityDTO)params.get(0)).getApplicantId();
                if (userId != null && userId != 0L) {
                    this.resetCurrentUser(userId);
                }
                if ((result = this.validParam(modelNum)).get("errorMsg") != null) {
                    return result;
                }
                MemberServiceHelper.batchCreateEntity((String)modelNum, (List)params);
            }
            catch (Exception ex) {
                log.error("batch create entity fail." + ex.getMessage());
                if ("ROLLBACK".equals(ex.getMessage())) break block6;
                result.put("errorMsg", ex.getMessage());
                result.put("success", false);
            }
        }
        log.infoEnd("batch create entity end.");
        return result;
    }

    private Map<String, Object> validParam(String modelNum) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        Optional<String> perm = this.validModelPerm(modelNum);
        if (perm.isPresent()) {
            result.put("errorMsg", perm.get());
            result.put("success", false);
        } else {
            result.put("success", true);
        }
        return result;
    }
}

