/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.disclosure.BCMMemberHelper;
import kd.fi.bcm.business.disclosure.model.BCMMemberTreeNode;
import kd.fi.bcm.business.disclosure.util.DmCurrencyUtil;
import kd.fi.bcm.business.extdata.ExtDataServiceHelper;
import kd.fi.bcm.business.extdata.sql.EDColumn;
import kd.fi.bcm.business.extdata.sql.EDResultSet;
import kd.fi.bcm.business.extdata.sql.EdQueryComInfo;
import kd.fi.bcm.business.permission.cache.MembRangeItem;
import kd.fi.bcm.business.permission.perm.PermPackage;
import kd.fi.bcm.business.permission.perm.PermPackageList;
import kd.fi.bcm.business.permission.perm.PermissionService;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.business.permission.permclass.PermClassEntityHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.sql.MDResultSet;
import kd.fi.bcm.business.sql.MDResultSetMetaData;
import kd.fi.bcm.business.sql.Row;
import kd.fi.bcm.business.sql.SQLBuilder;
import kd.fi.bcm.business.template.model.AreaRangeEntry;
import kd.fi.bcm.business.template.model.Dimension;
import kd.fi.bcm.business.template.model.Member;
import kd.fi.bcm.business.template.model.PageDimensionEntry;
import kd.fi.bcm.business.template.model.TemplateModel;
import kd.fi.bcm.business.template.model.ViewPointDimensionEntry;
import kd.fi.bcm.business.util.TemplateUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.Permission.DataTypeEnum;
import kd.fi.bcm.common.enums.RangeEnum;
import kd.fi.bcm.common.enums.TemplateTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.reportenum.ReportAreaEnum;
import kd.fi.bcm.common.util.ExcelUtils;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.Point;
import kd.fi.bcm.formplugin.report.querydata.ReportDataQueryService;
import kd.fi.bcm.formplugin.report.querydata.ReportQueryRowResult;
import kd.fi.bcm.formplugin.report.querydata.ReportRowDataQueryParam;
import kd.fi.bcm.service.FIDMMsService;
import kd.fi.bcm.spread.domain.view.JsonSerializerUtil;
import kd.fi.bcm.spread.domain.view.SpreadManager;
import kd.fi.bcm.spread.domain.view.builder.PositionInfo;
import kd.fi.bcm.spread.domain.view.builder.extend.ExtendInfo;
import kd.fi.bcm.spread.model.DimMember;
import org.apache.commons.collections4.map.MultiKeyMap;

public class FIDMMsServiceImpl
implements FIDMMsService {
    private final WatchLogger logger = BcmLogFactory.getWatchLogInstance(this.getClass());

    public Map<String, Object> execute(Map<String, String> param) {
        if (param == null) {
            return this.fail(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u65e0\u6cd5\u89e3\u6790", (String)"FIDMMsServiceImpl_1", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)param.get("action"))) {
            return this.fail(ResManager.loadKDString((String)"\u53c2\u6570\u6267\u884c\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"FIDMMsServiceImpl_2", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        String action = param.get("action");
        String input = param.get("input");
        try {
            if ("OLAPQUERYDATA".equalsIgnoreCase(action)) {
                return this.olapQueryData(input);
            }
            if ("EXTENDSQUERYDATA".equalsIgnoreCase(action)) {
                return this.extendsQueryData(input);
            }
            if ("REPORTDIMRESULTQUERYDATA".equalsIgnoreCase(action)) {
                return this.reportDimResultQueryData(input);
            }
            if ("REPORTSECTIONCHECKAREA".equalsIgnoreCase(action)) {
                return this.reportsectionCheckArea(input);
            }
            if ("FINDMEMBERBYNUMBER".equalsIgnoreCase(action)) {
                return this.findMemberByNumber(input);
            }
            if ("FINDMEMBERBYID".equalsIgnoreCase(action)) {
                return this.findMemberById(input);
            }
            if ("BATCHGETMEMBERS".equalsIgnoreCase(action)) {
                return this.batchGetMembers(input);
            }
            if ("BATCHGETMEMBERSBYIDS".equalsIgnoreCase(action)) {
                return this.batchGetMembersByIds(input);
            }
            if ("GETMEMBERPERM".equalsIgnoreCase(action)) {
                return this.getMemberPerm(input);
            }
            if ("FILTERHASPERMMEMBER".equalsIgnoreCase(action)) {
                return this.filterHasPermMember(input);
            }
            if ("GETEXCELDATABYREPORTSECTION".equalsIgnoreCase(action)) {
                return this.getExcelDataByReportsection(input);
            }
            if ("GETTEMPLATEEXCELBYREPORTSECTION".equalsIgnoreCase(action)) {
                return this.getTemplateExcelByReportsection(input);
            }
            if ("GETTEMPLATE".equalsIgnoreCase(action)) {
                return this.getTemplate(input);
            }
            if ("GETAREABYTEMPLATEID".equalsIgnoreCase(action)) {
                return this.getAreaByTemplateId(input);
            }
            if ("GETTEMPLATEDATA".equalsIgnoreCase(action)) {
                return this.getTemplateData(input);
            }
            if ("MEMBERREADERFINDMEMBERBYNUMBER".equalsIgnoreCase(action)) {
                return this.memberReaderfindMemberByNumber(input);
            }
            if ("HANDLEECDC".equalsIgnoreCase(action)) {
                return this.handleECDC(input);
            }
            return this.fail(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u7f16\u7801\u4e3a[%1$s]\u7684\u5fae\u670d\u52a1\u8c03\u7528\u4e0d\u652f\u6301\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"FIDMMsServiceImpl_0", (String)"fi-bcm-mservice", (Object[])new Object[0]), action));
        }
        catch (KDBizException kdBizException) {
            return this.fail(kdBizException.getMessage());
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService erorr", (Throwable)ex);
            return this.fail(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u7f16\u7801\u4e3a[%1$s]\u7684\u5408\u5e76\u5fae\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01", (String)"FIDMMsServiceImpl_5", (String)"fi-bcm-mservice", (Object[])new Object[0]), action));
        }
    }

    private Map<String, Object> getTemplateData(String input) {
        try {
            HashMap map = Maps.newHashMapWithExpectedSize((int)1);
            ReportDataQueryService controller = new ReportDataQueryService();
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            Long templateId = LongUtil.toLong(params.get("templateId"));
            TemplateModel template = TemplateUtil.getTemplateModel((Object)templateId);
            ReportRowDataQueryParam param = FIDMMsServiceImpl.buildParam(params, template);
            map.put("data", FIDMMsServiceImpl.resultHanler(controller.getReportRowData(param), params, template.getModelId()));
            return this.success(map);
        }
        catch (Exception e) {
            this.logger.error("dm getTemplateData fail", (Throwable)e);
            return null;
        }
    }

    private static void exResultHandler(ReportQueryRowResult.PositionRowDataInfo areaInfo, LinkedHashMap<String, Object> baseMap, Long modelId, String extendNumber, List<LinkedHashMap<String, Object>> result) {
        if (StringUtils.isEmpty((String)extendNumber) || !Objects.equals(areaInfo.getExtModel(), extendNumber)) {
            return;
        }
        Map dimDyoByModelId = MemberReader.getDimDyoByModelId((long)modelId);
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        FIDMMsServiceImpl.columnsHandler(dimDyoByModelId.keySet(), areaInfo.getDataColFields(), map);
        block0: for (List allData : areaInfo.getAllDatas()) {
            if (CollectionUtils.isEmpty((Collection)allData)) continue;
            LinkedHashMap<String, Object> dimMap = new LinkedHashMap<String, Object>(baseMap);
            for (int i = 0; i < allData.size(); ++i) {
                Object value = allData.get(i);
                Pair pair = (Pair)map.get(i);
                if (Objects.isNull(pair)) continue block0;
                if (((Boolean)pair.p1).booleanValue()) {
                    if (Objects.isNull(value)) continue block0;
                    dimMap.put((String)pair.p2, value.toString().split("\\|")[0]);
                    continue;
                }
                dimMap.put((String)pair.p2, value);
                if (i != allData.size() - 1) continue;
                LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(dimMap);
                result.add(resultMap);
            }
        }
    }

    private static void dimResultHandler(ReportQueryRowResult.PositionRowDataInfo areaInfo, LinkedHashMap<String, Object> baseMap, List<LinkedHashMap<String, Object>> result) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        FIDMMsServiceImpl.columnsHandler(areaInfo.getRowDims(), areaInfo.getColDims(), areaInfo.getDataColFields(), map);
        block0: for (List allData : areaInfo.getAllDatas()) {
            if (CollectionUtils.isEmpty((Collection)allData)) continue;
            LinkedHashMap<String, Object> dimMap = new LinkedHashMap<String, Object>(baseMap);
            for (int i = 0; i < allData.size(); ++i) {
                Object value = allData.get(i);
                Pair pair = (Pair)map.get(i);
                if (Objects.isNull(pair)) continue block0;
                if (((Boolean)pair.p1).booleanValue()) {
                    if (Objects.isNull(value)) continue block0;
                    dimMap.put((String)((Pair)((List)pair.p2).get((int)0)).p1, value.toString().split("\\|")[0]);
                    continue;
                }
                if (!Objects.nonNull(value)) continue;
                LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>(dimMap);
                for (Pair dimPair : (List)pair.p2) {
                    resultMap.put((String)dimPair.p1, dimPair.p2);
                }
                resultMap.put("FMONEY", value);
                result.add(resultMap);
            }
        }
    }

    private static Object resultHanler(List<ReportQueryRowResult> results, Map<String, Object> params, Long modelId) {
        String extendNumber = "";
        boolean isDim = true;
        if (Objects.nonNull(params.get("extendNumber"))) {
            extendNumber = params.get("extendNumber").toString();
            isDim = false;
        }
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        for (ReportQueryRowResult row : results) {
            LinkedHashMap baseMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
            baseMap.putAll(row.getPageDims());
            baseMap.putAll(row.getViewDims());
            for (ReportQueryRowResult.PositionRowDataInfo areaInfo : row.getAreaInfos()) {
                if (isDim && !Objects.equals(ReportAreaEnum.EXTEND.getNumber(), areaInfo.getAreaType())) {
                    FIDMMsServiceImpl.dimResultHandler(areaInfo, baseMap, result);
                }
                if (isDim || !Objects.equals(ReportAreaEnum.EXTEND.getNumber(), areaInfo.getAreaType())) continue;
                FIDMMsServiceImpl.exResultHandler(areaInfo, baseMap, modelId, extendNumber, result);
            }
        }
        return result;
    }

    private static void columnsHandler(Set<String> keySet, List<List<Object>> dataColFields, Map<Integer, Pair<Boolean, String>> map) {
        List<Object> objects;
        for (int i = 0; i < dataColFields.size() && !CollectionUtils.isEmpty(objects = dataColFields.get(i)); ++i) {
            String s = objects.get(0).toString();
            map.put(i, (Pair<Boolean, String>)new Pair((Object)keySet.contains(s), (Object)s));
        }
    }

    private static void columnsHandler(List<String> rowDims, List<String> colDims, List<List<Object>> dataColFields, Map<Integer, Pair<Boolean, List<Pair<String, String>>>> map) {
        for (int i = 0; i < dataColFields.size(); ++i) {
            if (i < rowDims.size()) {
                map.put(i, (Pair<Boolean, List<Pair<String, String>>>)new Pair((Object)true, (Object)Lists.newArrayList((Object[])new Pair[]{new Pair((Object)rowDims.get(i), (Object)"")})));
                continue;
            }
            List<Object> objects = dataColFields.get(i);
            ArrayList dimPair = Lists.newArrayListWithExpectedSize((int)colDims.size());
            for (int j = 0; j < objects.size(); ++j) {
                dimPair.add(new Pair((Object)colDims.get(j), (Object)objects.get(j).toString()));
            }
            map.put(i, (Pair<Boolean, List<Pair<String, String>>>)new Pair((Object)false, (Object)dimPair));
        }
    }

    private static ReportRowDataQueryParam buildParam(Map<String, Object> params, TemplateModel template) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bcm_model", (String)"shownumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)template.getModelId())});
        String modelNum = dynamicObject.getString("shownumber");
        ReportRowDataQueryParam param = new ReportRowDataQueryParam();
        param.setModelNum(modelNum);
        Map dimMap = (Map)SerializationUtils.fromJsonString((String)params.get("dimMap").toString(), Map.class);
        param.setSceneNum((String)dimMap.get(DimTypesEnum.SCENARIO.getNumber()));
        param.setYear((String)dimMap.get(DimTypesEnum.YEAR.getNumber()));
        param.setPeriod((String)dimMap.get(DimTypesEnum.PERIOD.getNumber()));
        param.setCurrency((String)dimMap.get(DimTypesEnum.CURRENCY.getNumber()));
        dimMap.remove(DimTypesEnum.SCENARIO.getNumber());
        dimMap.remove(DimTypesEnum.YEAR.getNumber());
        dimMap.remove(DimTypesEnum.PERIOD.getNumber());
        dimMap.remove(DimTypesEnum.CURRENCY.getNumber());
        List orgs = (List)SerializationUtils.fromJsonString((String)params.get(DimTypesEnum.ENTITY.getNumber()).toString(), List.class);
        param.setOrgs(orgs);
        param.setTmps((List)Lists.newArrayList((Object[])new String[]{template.getNumber()}));
        param.setDim2Mems(dimMap);
        return param;
    }

    private Map<String, Object> getTemplate(String input) {
        try {
            ArrayListMultimap permissionMap;
            List list;
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            Long modelId = LongUtil.toLong(params.get("modelId"));
            QFilter filter = new QFilter("model", "=", (Object)modelId);
            filter.and("status", "=", (Object)"1");
            filter.and("templatetype", "in", (Object)TemplateTypeEnum.getCommonTemplateType());
            filter.and("issavebydim", "=", (Object)"1");
            if (!PermissionServiceImpl.getInstance((Long)modelId).isAdmin() && !CollectionUtils.isEmpty((Collection)(list = (permissionMap = PermClassEntityHelper.getPermissionMap((String)"bcm_templateentity", (String)params.get("modelId").toString(), (String)RequestContext.get().getUserId())).get((Object)DataTypeEnum.NO.getIndex())))) {
                filter.and(new QFilter("id", "not in", (Object)list));
            }
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id,name", (QFilter[])filter.toArray());
            Map<Long, String> result = query.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name")));
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
            returnMap.put("result", result);
            return this.success(returnMap);
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService getTemplate erorr", (Throwable)ex);
            throw ex;
        }
    }

    private Map<String, Object> getAreaByTemplateId(String input) {
        try {
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            Long templateId = LongUtil.toLong(params.get("templateId"));
            TemplateModel template = TemplateUtil.getTemplateModel((Object)templateId);
            SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)template.getRptData());
            Set postionInfoSet = sm.getAreaManager().getPostionInfoSet();
            boolean hasExtend = false;
            boolean hasDim = false;
            HashMap extendsMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap dimensionMap = Maps.newHashMapWithExpectedSize((int)16);
            String extendNumber = "";
            for (PositionInfo positionInfo : postionInfoSet) {
                ExtendInfo extendInfo = positionInfo.getExtendInfo();
                if (Objects.nonNull(extendInfo)) {
                    hasExtend = true;
                    extendNumber = extendInfo.getExtModelNumber();
                    Set extendsField = extendInfo.getCols().stream().filter(t -> !positionInfo.getExtendInfo().getFloatDimNums().contains(t)).collect(Collectors.toSet());
                    if (extendsMap.containsKey(extendNumber)) {
                        ((Set)extendsMap.get(extendNumber)).addAll(extendsField);
                        continue;
                    }
                    extendsMap.put(extendNumber, extendsField);
                    continue;
                }
                hasDim = true;
                AreaRangeEntry areaRangeEntry = template.findAreaByArea(positionInfo.getAreaRange());
                List colEntry = areaRangeEntry.getColDimEntries();
                List rowEntry = areaRangeEntry.getRowDimEntries();
                if (!colEntry.isEmpty()) {
                    dimensionMap.put("col", colEntry.stream().map(entry -> JSON.toJSON((Object)entry.getDimension())).collect(Collectors.toSet()));
                }
                if (rowEntry.isEmpty()) continue;
                dimensionMap.put("row", rowEntry.stream().map(entry -> JSON.toJSON((Object)entry.getDimension())).collect(Collectors.toSet()));
            }
            List<Map<String, Object>> hideDim = FIDMMsServiceImpl.getHidDim(template);
            Map<String, List<Map<String, Object>>> pageDim = FIDMMsServiceImpl.getPageDim(template);
            HashMap result = Maps.newHashMapWithExpectedSize((int)16);
            result.put("hasExtend", hasExtend);
            result.put("hasDim", hasDim);
            result.put("extendsMap", extendsMap);
            result.put("dimensionMap", dimensionMap);
            result.put("hideDim", hideDim);
            result.put("pageDim", pageDim);
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
            returnMap.put("result", result);
            return this.success(returnMap);
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService getTemplate erorr", (Throwable)ex);
            throw ex;
        }
    }

    private static List<Map<String, Object>> getHidDim(TemplateModel template) {
        ArrayList hideDim = Lists.newArrayListWithExpectedSize((int)16);
        if (Objects.nonNull(template.getViewPointDimensionEntries())) {
            for (ViewPointDimensionEntry view : template.getViewPointDimensionEntries()) {
                Member member = view.getMember();
                if (Objects.isNull(member)) continue;
                HashMap map = Maps.newHashMapWithExpectedSize((int)16);
                map.put("id", member.getId());
                map.put("name", member.getName());
                map.put("number", member.getNumber());
                Dimension dimension = member.getDimension();
                map.put("dimension", dimension.getMemberEntityNumber());
                map.put("dimNumber", dimension.getNumber());
                map.put("shortNumber", dimension.getShortNumber());
                map.put("dimId", dimension.getId());
                hideDim.add(map);
            }
        }
        return hideDim;
    }

    private static Map<String, List<Map<String, Object>>> getPageDim(TemplateModel template) {
        HashMap pageDim = Maps.newHashMapWithExpectedSize((int)16);
        if (Objects.nonNull(template.getPageDimensionEntries())) {
            for (PageDimensionEntry view : template.getPageDimensionEntries()) {
                ArrayList memberlist = Lists.newArrayListWithExpectedSize((int)16);
                Dimension dimension = view.getDimension();
                pageDim.put(dimension.getNumber(), memberlist);
                List members = view.getMembers();
                if (CollectionUtils.isEmpty((Collection)members)) continue;
                for (Member member : members) {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)16);
                    map.put("id", member.getId());
                    map.put("name", member.getName());
                    map.put("number", member.getNumber());
                    map.put("range", member.getScope());
                    map.put("dimension", dimension.getMemberEntityNumber());
                    map.put("dimNumber", dimension.getNumber());
                    map.put("shortNumber", dimension.getShortNumber());
                    map.put("dimId", dimension.getId());
                    memberlist.add(map);
                }
            }
        }
        return pageDim;
    }

    private Map<String, Object> filterHasPermMember(String input) {
        try {
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            String modelNum = params.get("modelNum").toString();
            String dimNum = params.get("dimNum").toString();
            Long modelId = MemberReader.findModelIdByNum((String)modelNum);
            PermissionService instance = PermissionServiceImpl.getInstance((Long)modelId);
            JSONArray members = (JSONArray)params.get("members");
            HashSet returnSets = Sets.newHashSetWithExpectedSize((int)members.size());
            for (Object memberNumber : members) {
                IDNumberTreeNode member = MemberReader.findMemberByNumber((String)modelNum, (String)dimNum, (String)memberNumber.toString());
                if (Objects.equals(IDNumberTreeNode.NotFoundTreeNode, member)) {
                    return this.fail(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230 %s \u7ef4\u5ea6\u6210\u5458\u3002", (String)"FIDMMsServiceImpl_3", (String)"fi-bcm-mservice", (Object[])new Object[0]), memberNumber));
                }
                if (!instance.hasWriteOrReadPerm(member.getDimId(), member.getId())) continue;
                returnSets.add(memberNumber.toString());
            }
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
            returnMap.put("result", returnSets);
            return this.success(returnMap);
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService filterHasPermMember erorr", (Throwable)ex);
            throw ex;
        }
    }

    private Map<String, Object> getMemberPerm(String input) {
        try {
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            Long modelId = LongUtil.toLong(params.get("modelId"));
            Long dimId = LongUtil.toLong(params.get("dimId"));
            PermissionService instance = PermissionServiceImpl.getInstance((Long)modelId);
            PermPackageList dimPermSet = instance.getDimPermSet(dimId);
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
            returnMap.put("defaultPerm", dimPermSet.getDefaultPerm().getValue());
            for (PermPackage permPackage : dimPermSet.getList()) {
                returnMap.put(String.valueOf(permPackage.getPerm().getValue()), permPackage.getPermSet());
            }
            return this.success(returnMap);
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService getMemberPerm erorr", (Throwable)ex);
            throw ex;
        }
    }

    private Map<String, Object> batchGetMembers(String input) {
        try {
            HashSet result = Sets.newHashSetWithExpectedSize((int)16);
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            IDNumberTreeNode member = MemberReader.findMemberByNumber((String)params.get("modelNum").toString(), (String)params.get("dimNum").toString(), (String)params.get("number").toString());
            if (Objects.equals(IDNumberTreeNode.NotFoundTreeNode, member)) {
                return this.fail(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230 %s \u7ef4\u5ea6\u6210\u5458\u3002", (String)"FIDMMsServiceImpl_3", (String)"fi-bcm-mservice", (Object[])new Object[0]), params.get("number")));
            }
            DynamicObject dimension = MemberReader.getDimensionDynById((long)member.getDimId());
            if (Objects.isNull(dimension)) {
                return this.fail(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230 %s \u7ef4\u5ea6\u3002", (String)"FIDMMsServiceImpl_4", (String)"fi-bcm-mservice", (Object[])new Object[0]), params.get("dimNum")));
            }
            String entityName = dimension.getString("membermodel");
            Long modelId = MemberReader.findModelIdByNum((String)params.get("modelNum").toString());
            new MembRangeItem(entityName, member.getId(), member.getNumber(), RangeEnum.getRangeByNumberOrName((String)params.get("range").toString()), false, (Object)modelId).matchItems(c -> result.add(c.number));
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
            returnMap.put("result", result);
            return this.success(returnMap);
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService batchGetMembers erorr", (Throwable)ex);
            throw ex;
        }
    }

    private Map<String, Object> batchGetMembersByIds(String input) {
        try {
            ArrayList result = Lists.newArrayListWithCapacity((int)100);
            JSONObject params = JSON.parseObject((String)input);
            Long modelId = params.getLong("modelId");
            String entityName = params.getString("entityName");
            for (Object memberObject : params.getJSONArray("members")) {
                JSONObject memberInput = (JSONObject)memberObject;
                Long memeberId = memberInput.getLong("id");
                int memeberRange = memberInput.getInteger("range");
                IDNumberTreeNode member = MemberReader.findMemberById((long)modelId, (String)entityName, (Long)memeberId);
                if (Objects.equals(IDNumberTreeNode.NotFoundTreeNode, member)) {
                    return this.fail(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230 %s \u7ef4\u5ea6\u6210\u5458\u3002", (String)"FIDMMsServiceImpl_3", (String)"fi-bcm-mservice", (Object[])new Object[0]), params.get((Object)"number")));
                }
                new MembRangeItem(entityName, member.getId(), member.getNumber(), RangeEnum.getRangeByVal((int)memeberRange), false, (Object)modelId).matchItems(c -> {
                    LinkedHashMap<String, Object> memberItem = new LinkedHashMap<String, Object>(3);
                    memberItem.put("id", c.getId().toString());
                    memberItem.put("name", c.getNumber());
                    memberItem.put("number", c.getNumber());
                    memberItem.put("inputMemberId", memeberId.toString());
                    memberItem.put("inputMemeberRange", memeberRange);
                    result.add(memberItem);
                });
            }
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
            returnMap.put("result", result);
            return this.success(returnMap);
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService batchGetMembers erorr", (Throwable)ex);
            throw ex;
        }
    }

    private Map<String, Object> findMemberById(String input) {
        try {
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            IDNumberTreeNode member = MemberReader.findMemberById((long)LongUtil.toLong(params.get("modelId")), (String)params.get("entityNumber").toString(), (Long)LongUtil.toLong(params.get("memberId")));
            if (Objects.equals(IDNumberTreeNode.NotFoundTreeNode, member)) {
                return this.fail(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230 %s \u7ef4\u5ea6\u6210\u5458\u3002", (String)"FIDMMsServiceImpl_3", (String)"fi-bcm-mservice", (Object[])new Object[0]), params.get("memberId")));
            }
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
            returnMap.put("memberId", member.getId());
            returnMap.put("number", member.getNumber());
            returnMap.put("name", member.getName());
            returnMap.put("copyFromId", member.getCopyfromId());
            returnMap.put("dimId", member.getDimId());
            returnMap.put("isLeaf", member.isLeaf());
            return this.success(returnMap);
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService findMemberById erorr", (Throwable)ex);
            throw ex;
        }
    }

    private Map<String, Object> findMemberByNumber(String input) {
        try {
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            IDNumberTreeNode member = MemberReader.findMemberByNumber((String)params.get("modelNum").toString(), (String)params.get("dimNum").toString(), (String)params.get("number").toString());
            if (Objects.equals(IDNumberTreeNode.NotFoundTreeNode, member)) {
                return this.fail(String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230 %s \u7ef4\u5ea6\u6210\u5458\u3002", (String)"FIDMMsServiceImpl_3", (String)"fi-bcm-mservice", (Object[])new Object[0]), params.get("number")));
            }
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)16);
            returnMap.put("memberId", member.getId());
            returnMap.put("number", member.getNumber());
            returnMap.put("name", member.getName());
            returnMap.put("copyFromId", member.getCopyfromId());
            returnMap.put("dimId", member.getDimId());
            returnMap.put("isLeaf", member.isLeaf());
            return this.success(returnMap);
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService findMemberByNumber erorr", (Throwable)ex);
            throw ex;
        }
    }

    private Map<String, Object> olapQueryData(String input) {
        try {
            JSONObject inputObject = JSON.parseObject((String)input);
            String cubecatalog = inputObject.getString("cubecatalog");
            SQLBuilder querySQL = new SQLBuilder(cubecatalog);
            if (inputObject.get((Object)"top") != null && inputObject.getInteger("top") > 0) {
                querySQL.setTop(inputObject.getInteger("top").intValue());
            }
            if (inputObject.get((Object)"measures") != null) {
                for (Object obj : inputObject.getJSONArray("measures")) {
                    querySQL.addMeasures(new String[]{obj.toString()});
                }
            }
            if (inputObject.get((Object)"selectField") != null) {
                for (Object obj : inputObject.getJSONArray("selectField")) {
                    querySQL.addSelectField(new String[]{obj.toString()});
                }
            }
            if (inputObject.get((Object)"filters") != null) {
                for (Object obj : inputObject.getJSONArray("filters")) {
                    JSONObject filter = (JSONObject)obj;
                    String p1 = filter.getString("p1");
                    ArrayList<String> p2 = new ArrayList<String>(2);
                    if (filter.get((Object)"p2") != null) {
                        for (Object p2Obj : filter.getJSONArray("p2")) {
                            p2.add(p2Obj.toString());
                        }
                    }
                    querySQL.addFilter(p1, p2.toArray(new String[0]));
                }
            }
            if (inputObject.get((Object)"excludeNullData") != null) {
                querySQL.setExcludeNullData(inputObject.getBoolean("excludeNullData").booleanValue());
            }
            if (inputObject.get((Object)"excludeDynaData") != null) {
                querySQL.setExcludeDynaData(inputObject.getBoolean("excludeDynaData").booleanValue());
            }
            MDResultSet rs = OlapServiceHelper.queryData((SQLBuilder)querySQL);
            List<Map<String, Object>> items = this.getMDResults(rs, Arrays.asList(querySQL.getMeasures()));
            HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(2);
            result.put("rows", items);
            return this.success(result);
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService olapQueryData erorr", (Throwable)ex);
            throw ex;
        }
    }

    private List<Map<String, Object>> getMDResults(MDResultSet rs, List<String> measures) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(100);
        if (rs.getRows() == null || rs.getRows().length == 0) {
            return items;
        }
        MDResultSetMetaData metaData = rs.getMetaData();
        ArrayList keys = new ArrayList(metaData.getMetaDatas().size());
        for (Row row : rs.getRows()) {
            keys.clear();
            metaData.getMetaDatas().forEach(m -> {
                if (!measures.contains(m.getMdName())) {
                    keys.add(row.getString(m.getMdName()));
                }
            });
            ArrayList values = new ArrayList(16);
            measures.forEach(m -> values.add(row.getOriginalValue(m)));
            HashMap<String, Object> item = new HashMap<String, Object>(2);
            item.put("key", String.join((CharSequence)"|", keys));
            for (String measure : measures) {
                item.put(measure, row.getOriginalValue(measure));
            }
            items.add(item);
        }
        return items;
    }

    private Map<String, Object> extendsQueryData(String input) {
        try {
            JSONObject inputObject = JSON.parseObject((String)input);
            EdQueryComInfo edQueryComInfo = new EdQueryComInfo(inputObject.getString("showNumber"), inputObject.getString("extGroup"), inputObject.getString("datamodel"));
            edQueryComInfo.setNeedSum(inputObject.getBoolean("needSum").booleanValue());
            edQueryComInfo.setMultiOrg(inputObject.getBoolean("multiOrg").booleanValue());
            edQueryComInfo.setExternal(true);
            edQueryComInfo.setMulOrgNumMap((Map)inputObject.getObject("mulOrgNumMap", Map.class));
            if (inputObject.get((Object)"extselects") != null) {
                ArrayList<String> extselects = new ArrayList<String>(2);
                for (Object obj : inputObject.getJSONArray("extselects")) {
                    extselects.add(obj.toString());
                }
                edQueryComInfo.setExtselects(extselects.toArray(new String[0]));
            }
            if (inputObject.get((Object)"dimselects") != null) {
                ArrayList dimselects = new ArrayList(2);
                for (Object obj : inputObject.getJSONArray("dimselects")) {
                    dimselects.add(obj.toString());
                }
                edQueryComInfo.setDimselects(dimselects.toArray(new String[0]));
            }
            if (inputObject.get((Object)"dimFilter") != null) {
                for (Map.Entry item : inputObject.getJSONObject("dimFilter").entrySet()) {
                    ArrayList<String> dfList = new ArrayList<String>(2);
                    if (item.getValue() != null) {
                        for (Object valObj : (JSONArray)item.getValue()) {
                            dfList.add(valObj.toString());
                        }
                    }
                    edQueryComInfo.addDimFilter((String)item.getKey(), dfList.toArray(new String[0]));
                }
            }
            if (StringUtils.isNotEmpty((String)inputObject.getString("customFilter"))) {
                edQueryComInfo.setCustomFilter(QFilter.fromSerializedString((String)inputObject.getString("customFilter")));
            }
            EDResultSet edResultSet = ExtDataServiceHelper.queryData((EdQueryComInfo)edQueryComInfo);
            ArrayList rows = Lists.newArrayListWithCapacity((int)edResultSet.getRows().length);
            edResultSet.iteratorRows(row -> {
                LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)row.getMetaData().getColMetaDatas().size());
                List colMetaDatas = row.getMetaData().getColMetaDatas();
                for (EDColumn column : colMetaDatas) {
                    String mdName = column.getMdName();
                    map.put(mdName, row.getString(mdName));
                }
                rows.add(map);
            });
            HashMap<String, ArrayList> result = new HashMap<String, ArrayList>(2);
            result.put("rows", rows);
            return this.success(result);
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService extendsQueryData erorr", (Throwable)ex);
            throw ex;
        }
    }

    private Map<String, Object> reportDimResultQueryData(String input) {
        try {
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            DynamicObject component = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_component_info", (String)"selectedarea,rptdata,pagedim", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong(params.get("componentId")))});
            SpreadManager spread = JsonSerializerUtil.toSpreadManager((String)component.getString("rptdata"));
            String area = component.getString("selectedarea");
            String[] split = area.split(":");
            Point pointX = ExcelUtils.pos2Point((String)split[0]);
            Point pointY = ExcelUtils.pos2Point((String)split[1]);
            LinkedHashSet dimKeys = Sets.newLinkedHashSetWithExpectedSize((int)16);
            ArrayList dimValues = Lists.newArrayListWithCapacity((int)16);
            spread.getBook().getSheet(0).iteratorRangeCells(pointX.y, pointY.y, pointX.x, pointY.x, c -> {
                Object userObject = c.getUserObject("KEY_DIM_FLAG");
                if (userObject instanceof List) {
                    List dimMemberList = (List)userObject;
                    StringBuilder sb = new StringBuilder();
                    for (DimMember dimMember : dimMemberList) {
                        dimKeys.add(dimMember.getDimension().getNumber());
                        sb.append(dimMember.getNumber()).append("#");
                    }
                    dimValues.add(sb.toString());
                }
            });
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            result.put("dimValues", dimValues);
            result.put("dimKeys", dimKeys);
            result.put("pageDim", component.getString("pagedim"));
            return this.success(result);
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService reportDimResultQueryData erorr", (Throwable)ex);
            throw ex;
        }
    }

    private Map<String, Object> reportsectionCheckArea(String input) {
        try {
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            DynamicObject component = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_component_info", (String)"selectedarea,rptdata", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)LongUtil.toLong(params.get("componentId")))});
            SpreadManager spread = JsonSerializerUtil.toSpreadManager((String)component.getString("rptdata"));
            boolean isFloat = false;
            for (PositionInfo next : spread.getAreaManager().getPostionInfoSet()) {
                String areaRange = next.getAreaRange();
                if (!next.isFloatPosition()) continue;
                List basePoints = next.getBasePoints();
                Set<String> dynaRanges = basePoints.stream().map(o -> o.getDynaRange()).collect(Collectors.toSet());
                if (!this.isAreaCross(component.getString("selectedarea"), areaRange, dynaRanges)) continue;
                isFloat = true;
                break;
            }
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(2);
            result.put("isFloat", isFloat);
            return this.success(result);
        }
        catch (Exception ex) {
            this.logger.error("FIDMMsService reportsectionCheckArea erorr", (Throwable)ex);
            throw ex;
        }
    }

    private boolean isAreaCross(String area, String areaRange, Set<String> dynaRanges) {
        if (this.isAreaCross(area, areaRange)) {
            return true;
        }
        for (String dynaRange : dynaRanges) {
            if (!this.isAreaCross(area, dynaRange)) continue;
            return true;
        }
        return false;
    }

    private boolean isAreaCross(String area1, String area2) {
        String[] split = area1.split(":");
        Point startPoint = ExcelUtils.pos2Point((String)split[0]);
        Point endPoint = ExcelUtils.pos2Point((String)split[1]);
        String position = ExcelUtils.xy2Pos((int)startPoint.x, (int)startPoint.y);
        String position1 = ExcelUtils.xy2Pos((int)startPoint.x, (int)endPoint.y);
        String position2 = ExcelUtils.xy2Pos((int)endPoint.x, (int)startPoint.y);
        String position3 = ExcelUtils.xy2Pos((int)endPoint.x, (int)endPoint.y);
        return ExcelUtils.isWithInScope((String)area2, (String)position) || ExcelUtils.isWithInScope((String)area2, (String)position1) || ExcelUtils.isWithInScope((String)area2, (String)position2) || ExcelUtils.isWithInScope((String)area2, (String)position3);
    }

    private Map<String, Object> getExcelDataByReportsection(String input) {
        Map excelMap = null;
        try {
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            Class<?> clazz = Class.forName("kd.fi.bcm.formplugin.disclosure.calculate.reportSection.ReportSectionExportService");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("getExcelDataByInvoke", Map.class);
            excelMap = (Map)method.invoke(obj, params);
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception e) {
            if (e.getCause() instanceof KDBizException) {
                throw (KDBizException)e.getCause();
            }
            this.logger.error("FIDMMsService  invokeMethod--error: ", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u62a5\u544a\u5207\u7247\u8ba1\u7b97\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01", (String)"FIDMMsServiceImpl_6", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        return this.success(excelMap);
    }

    private Map<String, Object> getTemplateExcelByReportsection(String input) {
        Map excelMap = null;
        try {
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            Class<?> clazz = Class.forName("kd.fi.bcm.formplugin.disclosure.calculate.reportSection.ReportSectionExportService");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("getTemplateExcelByInvoke", Map.class);
            excelMap = (Map)method.invoke(obj, params);
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception e) {
            if (e.getCause() instanceof KDBizException) {
                throw (KDBizException)e.getCause();
            }
            this.logger.error("FIDMMsService  invokeMethod--error: ", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u62a5\u544a\u5207\u7247\u8ba1\u7b97\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01", (String)"FIDMMsServiceImpl_6", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        return this.success(excelMap);
    }

    private Map<String, Object> memberReaderfindMemberByNumber(String input) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        try {
            Map params = (Map)JSON.parseObject((String)input, Map.class);
            String modelNum = params.get("modelNum").toString();
            String dimNum = params.get("dimNum").toString();
            String number = params.get("number").toString();
            BCMMemberTreeNode bcmMemberTreeNode = BCMMemberHelper.findMemberByNumber((String)modelNum, (String)dimNum, (String)number);
            result.put("member", bcmMemberTreeNode == null ? null : JSON.toJSONString((Object)bcmMemberTreeNode));
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception e) {
            this.logger.error("FIDMMsService  invokeMethod--error: ", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u7ef4\u5ea6\u6210\u5458\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01", (String)"FIDMMsServiceImpl_7", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        return this.success(result);
    }

    private Map<String, Object> handleECDC(String input) {
        List dtoList = new ArrayList(1);
        try {
            JSONObject params = JSON.parseObject((String)input);
            String cubeNumber = params.getString("cubeNumber");
            List<String> entitys = this.getJSONListString(params.getJSONArray("entitys"));
            List<String> currencys = this.getJSONListString(params.getJSONArray("currencys"));
            List<String> processs = this.getJSONListString(params.getJSONArray("processs"));
            Boolean bpall = params.getBoolean("bpall");
            MultiKeyMap currencyresult = DmCurrencyUtil.handleECDC((String)cubeNumber, entitys, currencys, processs, (Boolean)bpall);
            dtoList = DmCurrencyUtil.convertTo((MultiKeyMap)currencyresult);
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception e) {
            this.logger.error("FIDMMsService  invokeMethod--error: ", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u7ec4\u7ec7\u8fc7\u7a0b\u5e01\u522b\u67e5\u8be2\u63a5\u53e3\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\uff01", (String)"FIDMMsServiceImpl_8", (String)"fi-bcm-mservice", (Object[])new Object[0]));
        }
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("result", JSONObject.toJSONString(dtoList));
        return this.success(result);
    }

    private List<String> getJSONListString(JSONArray array) {
        ArrayList<String> items = new ArrayList<String>(2);
        for (Object obj : array) {
            if (obj == null) continue;
            items.add(obj.toString());
        }
        return items;
    }

    private Map<String, Object> success(Object data) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("success", true);
        result.put("data", data);
        return result;
    }

    private Map<String, Object> fail(String failMsg) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("success", false);
        result.put("message", failMsg);
        return result;
    }
}

