/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.integration.IntegrationServiceHelper;
import kd.fi.bcm.business.integration.di.servicehelper.DIIntegrateServiceHelper;
import kd.fi.bcm.business.integration.di.util.DIIntegrationUtil;
import kd.fi.bcm.business.integrationnew.bcmdimmap.SchemeUtil;
import kd.fi.bcm.business.integrationnew.service.IntegrateDispatcher2;
import kd.fi.bcm.business.integrationnew.servicehelper.IntegrateServiceHelper;
import kd.fi.bcm.business.permission.perm.PermissionServiceImpl;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.integration.AdapterEnum;
import kd.fi.bcm.common.enums.integration.CollectStatusEnum;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.CollectionUtil;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ObjectSerialUtil;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.common.util.ToStringHelper;
import kd.fi.bcm.fel.common.StringUtils;
import kd.fi.bcm.service.IntegrationMsService;
import kd.fi.bcm.spread.common.util.StringUtil;
import kd.fi.bcm.task.IntelligentScheduleHelper;
import kd.fi.bcm.task.IntelligentSchedulePlan;
import kd.fi.bcm.task.common.OperatorHelper;

public class IntegrationMsServiceImpl
implements IntegrationMsService {
    private final WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());
    private static final String ALL = "*";
    private static final String CODE = "code";
    private static final String MESSAGE = "message";
    private static final String ISSUCCESS = "isSuccess";
    private static final String TIPS = "tips";
    private static final String DATA = "data";
    private static final String CLASSS_PATH = "kd.fi.bcm.formplugin.intergration.pusheasrpt.PushRpt2EasMsServiceHelper";
    private static final String METHOD_NAME = "query";
    private static final String CLASSS_PATH_DI = "kd.fi.bcm.formplugin.intergration.di.pusheasrpt.DIPushRpt2EasMsServiceHelper";
    private static final String METHOD_NAME_DI = "query";

    public String execute(Map<String, Object> param) {
        String json = "";
        Object result = null;
        if (param == null) {
            param = new HashMap<String, Object>();
        }
        try {
            param.put("isMsCall", Boolean.TRUE);
            result = IntegrationServiceHelper.execute(param);
            json = result != null ? "" : JSONUtils.toString((Object)result);
        }
        catch (IOException e1) {
            throw new RuntimeException(String.format("convert Objct [%s] to json error!", ToStringHelper.deepToString((Object)result)), e1);
        }
        return json;
    }

    public void writeLog(Map<String, Object> param) {
        IntegrationServiceHelper.writeLog(param);
    }

    public String executeScheme(Map<String, Object> param) {
        String json = "";
        String result = null;
        if (param == null) {
            param = new HashMap<String, Object>();
        }
        try {
            param.put("isMsCall", Boolean.TRUE);
            result = IntegrateDispatcher2.submitTaskByExecute(param);
            json = result != null ? "" : JSONUtils.toString((Object)result);
        }
        catch (IOException e1) {
            throw new RuntimeException(String.format("convert Objct [%s] to json error!", ToStringHelper.deepToString((Object)result)), e1);
        }
        return json;
    }

    public String integrateCQ2EAS(Map<String, Object> param) {
        this.log.startWatch();
        this.log.debug("QC2EAS-Param:" + ObjectSerialUtil.toJson(param));
        HashMap<String, Object> filter = new HashMap<String, Object>();
        filter.putAll(param);
        filter.put("adapter", AdapterEnum.IERP2EASCSL);
        List table = (List)IntegrationServiceHelper.execute(filter);
        return ObjectSerialUtil.toJson((Object)table);
    }

    public String executePush2EAS(Map<String, Object> param) {
        List table;
        this.log.startWatch();
        this.log.info("executePush2EAS-Param:" + ObjectSerialUtil.toJson(param));
        try {
            Class<?> clazz = Class.forName(CLASSS_PATH);
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("query", Map.class);
            table = (List)method.invoke(obj, param);
        }
        catch (Exception e) {
            this.log.error("executePush2EAS--error: ", (Throwable)e);
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)50));
        }
        this.log.info("executePush2EAS-table:" + ObjectSerialUtil.toJson((Object)table));
        return ObjectSerialUtil.toJson((Object)table);
    }

    public String executeDIPush2EAS(Map<String, Object> param) {
        List table;
        this.log.startWatch();
        this.log.info("executeDIPush2EAS-Param:" + ObjectSerialUtil.toJson(param));
        try {
            Class<?> clazz = Class.forName(CLASSS_PATH_DI);
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("query", Map.class);
            table = (List)method.invoke(obj, param);
        }
        catch (Exception e) {
            this.log.error("executeDIPush2EAS--error: ", (Throwable)e);
            throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)50));
        }
        this.log.info("executeDIPush2EAS-table:" + ObjectSerialUtil.toJson((Object)table));
        return ObjectSerialUtil.toJson((Object)table);
    }

    public Map<String, Object> executeIntegrate(String param) {
        try {
            Map paramMap = (Map)JSONObject.parseObject((String)param, Map.class);
            String modelNum = (String)paramMap.get("modelNum");
            String sceneNum = (String)paramMap.get("sceneNum");
            String yearNum = (String)paramMap.get("yearNum");
            String periodNum = (String)paramMap.get("periodNum");
            List orgNums = (List)paramMap.get("orgNums");
            List schemeNums = (List)paramMap.get("schemeNums");
            boolean isMustIn = IntegrationMsServiceImpl.checkMustIn(modelNum, sceneNum, yearNum, periodNum);
            if (!isMustIn) {
                return IntegrationMsServiceImpl.buildResMap(false, "1001", ResManager.loadKDString((String)"\u9700\u8981\u586b\u5199\u4f53\u7cfb\uff0c\u60c5\u666f\uff0c\u8d22\u5e74\uff0c\u671f\u95f4\u3002", (String)"IntegrateServiceHelper_1", (String)"fi-bcm-business", (Object[])new Object[0]), null, null);
            }
            Long modelId = MemberReader.findModelIdByShowNum((String)modelNum);
            boolean isHasOpPermission = DIIntegrateServiceHelper.checkOpPermission((long)modelId, (String)"bcm_isschemecollectlist2", (String)"1T8/1A25NK8=");
            if (!isHasOpPermission) {
                return IntegrationMsServiceImpl.buildResMap(false, "1002", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\uff01", (String)"MemberPermHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]), null, null);
            }
            String modelOlapNum = MemberReader.findModelNumberById((Object)modelId);
            IDNumberTreeNode scenario = MemberReader.findScenaMemberByNum((String)modelOlapNum, (String)sceneNum);
            IDNumberTreeNode year = MemberReader.findFyMemberByNum((String)modelOlapNum, (String)yearNum);
            IDNumberTreeNode period = MemberReader.findPeriodMemberByNum((String)modelOlapNum, (String)periodNum);
            Set orgSet = null;
            String dataMsg = "";
            if (CollectionUtil.isEmpty((Collection)orgNums)) {
                orgSet = this.getRightOrgs(modelId, scenario.getId(), year.getId(), period.getId());
            } else {
                Pair<Set<Long>, String> orgSetPair = this.getRightOrgs(modelId, scenario.getId(), year.getId(), period.getId(), orgNums);
                orgSet = (Set)orgSetPair.p1;
                dataMsg = dataMsg + (String)orgSetPair.p2;
            }
            if (CollectionUtil.isEmpty(orgSet)) {
                return IntegrationMsServiceImpl.buildResMap(false, "1003", ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7ec4\u7ec7\u3002", (String)"IntegrateServiceHelper_2", (String)"fi-bcm-business", (Object[])new Object[0]), dataMsg, null);
            }
            List schemeList = null;
            if (CollectionUtil.isEmpty((Collection)schemeNums)) {
                schemeList = this.getRightSchemes(modelId);
            } else {
                Pair<List<Long>, String> schemeListPair = this.getRightSchemes(modelId, schemeNums);
                schemeList = (List)schemeListPair.p1;
                dataMsg = dataMsg + (String)schemeListPair.p2;
            }
            if (CollectionUtil.isEmpty(schemeList)) {
                return IntegrationMsServiceImpl.buildResMap(false, "1004", ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u65b9\u6848\u3002", (String)"DIIntegrationNewServiceHelper_18", (String)"fi-bcm-business", (Object[])new Object[0]), dataMsg, null);
            }
            Long mark = GlobalIdUtil.genGlobalLongId();
            Set<String> tarCollectStatus = this.getTarCollectStatus();
            Set<Long> baseOrgSet = this.getBaeEntIds(modelOlapNum, orgSet);
            boolean isDoExcute = IntegrateServiceHelper.doCollect((boolean)false, (Long)mark, (Long)modelId, new ArrayList<Long>(baseOrgSet), (Long)scenario.getId(), (Long)year.getId(), (Long)period.getId(), (List)schemeList, tarCollectStatus);
            if (!isDoExcute) {
                return IntegrationMsServiceImpl.buildResMap(false, "1005", ResManager.loadKDString((String)"\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u7ec4\u7ec7\u548c\u65b9\u6848\u3002", (String)"DIIntegrationNewServiceHelper_24", (String)"fi-bcm-business", (Object[])new Object[0]), dataMsg, null);
            }
            return IntegrationMsServiceImpl.buildResMap(true, "1000", ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"AbstractExecuteService_0", (String)"fi-bcm-business", (Object[])new Object[0]), dataMsg, mark);
        }
        catch (Throwable e) {
            this.log.error("executeIntegrate is error", e);
            return IntegrationMsServiceImpl.buildResMap(true, "999", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"AbstractExecuteService_1", (String)"fi-bcm-business", (Object[])new Object[0]), null, null);
        }
    }

    private Set<Long> getBaeEntIds(String modelOlapNum, Set<Long> orgSet) {
        HashSet<Long> baseOrgSet = new HashSet<Long>(16);
        for (Long id : orgSet) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberById((String)modelOlapNum, (Long)id);
            baseOrgSet.add(entity.getBaseTreeNode().getId());
        }
        return baseOrgSet;
    }

    public Map<String, Object> executeStatus(String param) {
        try {
            Map paramMap = (Map)JSONObject.parseObject((String)param, Map.class);
            Long mark = (Long)paramMap.get("mark");
            if (mark == null) {
                return IntegrationMsServiceImpl.buildResMap(false, "1001", String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustConvertService_12", (String)"fi-bcm-business", (Object[])new Object[0]), "mark"), null, null);
            }
            QFilter markFilter = new QFilter("schedulelog", "=", (Object)mark);
            QFilter statusFilter = new QFilter("status", "in", (Object)new String[]{"2", "8"});
            boolean exists = QueryServiceHelper.exists((String)"bcm_schedule_statuslog", (QFilter[])new QFilter[]{markFilter, statusFilter});
            if (exists) {
                return IntegrationMsServiceImpl.buildResMap(true, "1005", ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"AbstractUpgradeService_0", (String)"fi-bcm-business", (Object[])new Object[0]), null, null);
            }
            QFilter failFilter = new QFilter("status", "=", (Object)"4");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_schedule_statuslog", (String)"integrateexeclog.org.number, integrateexeclog.scheme.number", (QFilter[])new QFilter[]{markFilter, failFilter});
            if (CollectionUtil.isEmpty((Collection)query)) {
                return IntegrationMsServiceImpl.buildResMap(true, "1000", ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"AbstractExecuteService_0", (String)"fi-bcm-business", (Object[])new Object[0]), null, null);
            }
            ArrayList logList = new ArrayList(16);
            query.forEach(e -> logList.add(e.getString("integrateexeclog.org.number") + ";" + e.getString("integrateexeclog.scheme.number")));
            return IntegrationMsServiceImpl.buildResMap(true, "1000", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\uff0c\u5b58\u5728\u5931\u8d25\u7684\u6267\u884c\u8bb0\u5f55\u3002", (String)"DIIntegrationNewServiceHelper_19", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)",", logList), null);
        }
        catch (Throwable e2) {
            this.log.error("executeStatus is error", e2);
            return IntegrationMsServiceImpl.buildResMap(true, "999", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"AbstractExecuteService_1", (String)"fi-bcm-business", (Object[])new Object[0]), null, null);
        }
    }

    public Map<String, Object> executePlan(String param) {
        try {
            QFilter enableFilter;
            QFilter numberFilter;
            QFilter modelFilter;
            DynamicObject query;
            Map paramMap = (Map)JSONObject.parseObject((String)param, Map.class);
            String modelNum = (String)paramMap.get("modelNum");
            String planNum = (String)paramMap.get("planNum");
            if (StringUtils.isEmpty((CharSequence)planNum) || StringUtils.isEmpty((CharSequence)modelNum)) {
                return IntegrationMsServiceImpl.buildResMap(false, "1001", String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AdjustConvertService_12", (String)"fi-bcm-business", (Object[])new Object[0]), "modelNum, planNum"), null, null);
            }
            Long modelId = MemberReader.findModelIdByShowNum((String)modelNum);
            boolean isHasOpPermission = DIIntegrateServiceHelper.checkOpPermission((long)modelId, (String)"bcm_intelschedulelist", (String)"4730fc9f000019ae");
            if (!isHasOpPermission) {
                return IntegrationMsServiceImpl.buildResMap(false, "1002", ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6b64\u64cd\u4f5c\u6743\u9650\uff01", (String)"MemberPermHelper_0", (String)"fi-bcm-business", (Object[])new Object[0]), null, null);
            }
            String appId = (String)paramMap.get("appId");
            if (appId == null) {
                appId = ApplicationTypeEnum.CM.appnum;
            }
            if ((query = QueryServiceHelper.queryOne((String)"bcm_intelschedule", (String)"id", (QFilter[])new QFilter[]{modelFilter = new QFilter("model", "=", (Object)modelId), numberFilter = new QFilter("number", "=", (Object)planNum), enableFilter = new QFilter("isenable", "=", (Object)"1")})) == null) {
                return IntegrationMsServiceImpl.buildResMap(false, "1004", ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u65b9\u6848\u3002", (String)"DIIntegrationNewServiceHelper_18", (String)"fi-bcm-business", (Object[])new Object[0]), null, null);
            }
            Long planId = query.getLong("id");
            String exeType = (String)paramMap.get("exeType");
            if ("2".equals(exeType)) {
                this.execPlan(planId, appId);
            } else {
                IntelligentScheduleHelper.execPlan((Long)planId, (String)appId);
            }
            return IntegrationMsServiceImpl.buildResMap(true, "1000", ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"AbstractExecuteService_0", (String)"fi-bcm-business", (Object[])new Object[0]), null, null);
        }
        catch (Throwable e) {
            this.log.error("executePlan is error", e);
            return IntegrationMsServiceImpl.buildResMap(true, "999", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"AbstractExecuteService_1", (String)"fi-bcm-business", (Object[])new Object[0]), null, null);
        }
    }

    private void execPlan(Long planId, String appId) {
        Lang lang = RequestContext.get().getLang();
        HashMap<String, String> param = new HashMap<String, String>(8);
        param.put("appId", appId);
        new IntelligentSchedulePlan().process(planId, true, lang, param);
    }

    private Set<String> getTarCollectStatus() {
        HashSet<String> tarCollectStatus = new HashSet<String>(16);
        tarCollectStatus.add(CollectStatusEnum.READY.getValue() + "");
        tarCollectStatus.add(CollectStatusEnum.SUCCESS.getValue() + "");
        tarCollectStatus.add(CollectStatusEnum.FAIL.getValue() + "");
        tarCollectStatus.add(CollectStatusEnum.COMPLETE.getValue() + "");
        return tarCollectStatus;
    }

    private Pair<List<Long>, String> getRightSchemes(Long modelId, List<String> schemeNums) {
        List schemeList = new ArrayList(16);
        String errorMsg = "";
        Pair<List<Long>, String> schemePair = this.getSchemes(modelId, schemeNums);
        if (CollectionUtil.isEmpty((Collection)((Collection)schemePair.p1))) {
            return Pair.onePair(schemeList, (Object)schemePair.p2);
        }
        schemeList = (List)schemePair.p1;
        errorMsg = errorMsg + (String)schemePair.p2;
        List noPermList = DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)modelId, (Long)RequestContext.get().getCurrUserId());
        HashSet<Long> inNoPermIds = new HashSet<Long>(schemeList.size());
        for (Long schemeId : schemeList) {
            if (!noPermList.contains(schemeId)) continue;
            inNoPermIds.add(schemeId);
        }
        if (!inNoPermIds.isEmpty()) {
            schemeList.removeAll(inNoPermIds);
            QFilter filter = new QFilter("id", "in", inNoPermIds);
            DynamicObjectCollection names = QueryServiceHelper.query((String)"bcm_isscheme", (String)"number", (QFilter[])filter.toArray());
            List listNames = names.stream().map(f -> f.getString("number")).collect(Collectors.toList());
            String result = String.join((CharSequence)" ", listNames);
            errorMsg = errorMsg + String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6267\u884c\u7528\u6237\u65e0\u7f16\u7801\u4e3a%s\u7684\u96c6\u6210\u65b9\u6848\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u914d\u3002", (String)"IntegrateServiceHelper_4", (String)"fi-bcm-business", (Object[])new Object[0]), result);
        }
        return Pair.onePair(schemeList, (Object)errorMsg);
    }

    private List<Long> getRightSchemes(Long modelId) {
        List<Long> schemeList = new ArrayList<Long>(16);
        Pair<List<Long>, String> schemePair = this.getSchemes(modelId, null);
        if (CollectionUtil.isEmpty((Collection)((Collection)schemePair.p1))) {
            return schemeList;
        }
        schemeList = (List)schemePair.p1;
        List noPermList = DIIntegrationUtil.getCurrentUserNoPermDIScheme((Long)modelId, (Long)RequestContext.get().getCurrUserId());
        schemeList.removeAll(noPermList);
        return schemeList;
    }

    private Pair<List<Long>, String> getSchemes(Long modelId, List<String> schemeNums) {
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter enableFilter = new QFilter("status", "=", (Object)"1");
        QFilter catalogFilter = new QFilter("templatecatalog.type", "=", (Object)"1");
        QFilter issrcFilter = new QFilter("issrc.number", "not in", (Object)SchemeUtil.getDIProduct());
        issrcFilter.and("issrc.number", "not in", (Object)new String[]{IntegrateProductEnum.EXCELIMPORTProduct.getNumber(), IntegrateProductEnum.JQONLINEProduct.getNumber(), IntegrateProductEnum.JQProduct.getNumber()});
        if (schemeNums != null) {
            issrcFilter.and("number", "in", schemeNums);
        }
        DynamicObjectCollection schemeObj = QueryServiceHelper.query((String)"bcm_isscheme", (String)"id,number", (QFilter[])new QFilter[]{modelFilter, catalogFilter, enableFilter, issrcFilter});
        ArrayList schemeIdList = new ArrayList(16);
        ArrayList schemeNumberList = new ArrayList(16);
        schemeObj.forEach(e -> {
            schemeIdList.add(e.getLong("id"));
            schemeNumberList.add(e.getString("number"));
        });
        String errorMsg = "";
        if (schemeNums != null && schemeNumberList.size() != schemeNums.size()) {
            schemeNums.removeAll(schemeNumberList);
            if (schemeNums.size() > 0) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u7981\u7528\u6216\u5220\u9664\u7684\u65b9\u6848:%s\u3002", (String)"IntegrateServiceHelper_3", (String)"fi-bcm-business", (Object[])new Object[0]), String.join((CharSequence)" ", schemeNums));
            }
        }
        return Pair.onePair(schemeIdList, (Object)errorMsg);
    }

    private Pair<Set<Long>, String> getRightOrgs(Long modelId, Long scenarioId, Long yearId, Long periodId, List<String> orgNums) {
        IDNumberTreeNode entity;
        Set<Long> orgIds = new HashSet<Long>(16);
        String errorMsg = "";
        String modelOlapNum = MemberReader.findModelNumberById((Object)modelId);
        Pair<Pair<Boolean, String>, Pair<List<String>, List<String>>> orgPair = this.getOrgNums(orgNums);
        if (!((Boolean)((Pair)orgPair.p1).p1).booleanValue()) {
            return Pair.onePair(orgIds, (Object)((Pair)orgPair.p1).p2);
        }
        for (String orgNumber : (List)((Pair)orgPair.p2).p1) {
            entity = MemberReader.findEntityMemberByNum((String)modelOlapNum, (String)orgNumber);
            orgIds.add(entity.getBaseTreeNode().getId());
        }
        for (String orgNumber : (List)((Pair)orgPair.p2).p2) {
            entity = MemberReader.findMemberByLongNumber((String)modelOlapNum, (String)DimTypesEnum.ENTITY.getNumber(), (String)orgNumber);
            orgIds.add(entity.getId());
        }
        Pair setStringPair = OperatorHelper.dealNoPermOrgWithMsg((long)modelId, orgIds);
        orgIds = (Set)setStringPair.p1;
        errorMsg = errorMsg + (setStringPair.p2 == null ? "" : (String)setStringPair.p2);
        if (CollectionUtil.isEmpty(orgIds)) {
            return Pair.onePair(orgIds, (Object)errorMsg);
        }
        Pair effectiveFilterResult = OperatorHelper.getEffectiveEntityWithMsg((long)modelId, (long)scenarioId, (long)yearId, (long)periodId, orgIds);
        orgIds = (Set)effectiveFilterResult.p1;
        errorMsg = errorMsg + (effectiveFilterResult.p2 == null ? "" : (String)effectiveFilterResult.p2);
        if (CollectionUtil.isEmpty(orgIds)) {
            return Pair.onePair(orgIds, (Object)errorMsg);
        }
        String resMsg = OperatorHelper.checkPeriodStatusWithMsg((long)modelId, (long)scenarioId, (long)yearId, (long)periodId, orgIds);
        errorMsg = errorMsg + (resMsg == null ? "" : resMsg);
        return Pair.onePair(orgIds, (Object)errorMsg);
    }

    private Pair<Pair<Boolean, String>, Pair<List<String>, List<String>>> getOrgNums(List<String> orgNums) {
        ArrayList<String> numOrgs = new ArrayList<String>(16);
        ArrayList<String> longNumOrgs = new ArrayList<String>(16);
        HashSet<String> numSets = new HashSet<String>(16);
        HashSet<String> longNumSets = new HashSet<String>(16);
        for (String org : orgNums) {
            if (org.contains("!")) {
                longNumOrgs.add(org);
                String[] split = org.split("!");
                if (longNumSets.add(split[split.length - 1])) continue;
                return Pair.onePair((Object)Pair.onePair((Object)false, (Object)String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u7ec4\u7ec7\uff1a%1$s\u3002", (String)"IntegrateServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), split[split.length - 1])), null);
            }
            numOrgs.add(org);
            numSets.add(org);
        }
        numSets.retainAll(longNumSets);
        if (numSets.size() > 0) {
            return Pair.onePair((Object)Pair.onePair((Object)false, (Object)String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u7ec4\u7ec7\uff1a%1$s\u3002", (String)"IntegrateServiceHelper_5", (String)"fi-bcm-business", (Object[])new Object[0]), numSets)), null);
        }
        return Pair.onePair((Object)Pair.onePair((Object)true, (Object)""), (Object)Pair.onePair(numOrgs, longNumOrgs));
    }

    private Set<Long> getRightOrgs(Long modelId, Long scenarioId, Long yearId, Long periodId) {
        Set<Long> orgIds = new HashSet<Long>(16);
        Long dimensionId = MemberReader.getDimensionIdByNum((long)modelId, (String)"Entity");
        QFilter idQf = PermissionServiceImpl.getInstance((Long)modelId).getWritePermFilter(dimensionId, "bcm_entitymembertree", "id");
        idQf.and("model", "=", (Object)modelId);
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id", (QFilter[])idQf.toArray());
        for (DynamicObject val : ids) {
            IDNumberTreeNode entity = MemberReader.findEntityMemberById((Long)modelId, (Long)val.getLong("id"));
            orgIds.add(entity.getBaseTreeNode().getId());
        }
        if (CollectionUtil.isEmpty(orgIds)) {
            return orgIds;
        }
        Pair effectiveFilterResult = OperatorHelper.getEffectiveEntityWithMsg((long)modelId, (long)scenarioId, (long)yearId, (long)periodId, orgIds);
        orgIds = (Set)effectiveFilterResult.p1;
        if (CollectionUtil.isEmpty(orgIds)) {
            return orgIds;
        }
        OperatorHelper.checkPeriodStatusWithMsg((long)modelId, (long)scenarioId, (long)yearId, (long)periodId, orgIds);
        return orgIds;
    }

    private static boolean checkMustIn(String modelNum, String sceneNum, String yearNum, String periodNum) {
        return !StringUtil.isEmptyString((String)modelNum) && !StringUtil.isEmptyString((String)sceneNum) && !StringUtil.isEmptyString((String)yearNum) && !StringUtil.isEmptyString((String)periodNum);
    }

    private static Map<String, Object> buildResMap(boolean isSuccess, String code, String message, String tips, Object data) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        resMap.put(CODE, code);
        resMap.put(ISSUCCESS, isSuccess);
        resMap.put(MESSAGE, message);
        resMap.put(TIPS, tips);
        resMap.put(DATA, data);
        return resMap;
    }
}

