/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.adjust.AdjustmentServiceHelper;
import kd.fi.bcm.business.allinone.model.McStatus;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.api.dto.InvCopyRatioRelationDTO;
import kd.fi.bcm.business.invest.api.dto.InvGenerateInvestDTO;
import kd.fi.bcm.business.invest.api.dto.InvMsResult;
import kd.fi.bcm.business.invest.api.dto.InvRecalculateRatioRelationDTO;
import kd.fi.bcm.business.invest.api.dto.InvResultDTO;
import kd.fi.bcm.business.invest.api.dto.InvShareRelaDTO;
import kd.fi.bcm.business.invest.api.helper.InvRelationSearchHelper;
import kd.fi.bcm.business.invest.api.helper.InvShareRelaHelper;
import kd.fi.bcm.business.invest.invratio.InvRelationSearchService;
import kd.fi.bcm.business.invest.invratio.model.InvRelationRadioDTO;
import kd.fi.bcm.business.invest.sheet.InvElimSpreadGenerateService;
import kd.fi.bcm.business.invest.sheet.InvPaperGenerateService;
import kd.fi.bcm.business.mergecontrol.MergeControlHelper;
import kd.fi.bcm.business.mergecontrol.MergeStatusHelper;
import kd.fi.bcm.business.period.PeriodSettingHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.invest.SheetStatusEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.service.InvestMsService;
import org.apache.commons.collections.CollectionUtils;

public class InvestMsServiceImpl
implements InvestMsService {
    private final WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());

    public String addInvShareRela(String paramJson) {
        this.log.startWatch();
        List dto = null;
        InvResultDTO result = InvResultDTO.success((Object)"");
        try {
            this.log.info(String.format("InvestMsServiceImpl.addInvShareRela request param: %s", paramJson));
            dto = (List)JSONUtils.cast((String)paramJson, List.class, (Class[])new Class[]{InvShareRelaDTO.class});
            result = InvShareRelaHelper.save((List)dto);
        }
        catch (Exception e) {
            result = InvResultDTO.fail((String)String.format("convert Json [%s] to List<InvShareRelaDTO> error!", paramJson));
            this.log.error(String.format("InvestMsServiceImpl.addInvShareRela request error:%s", e));
        }
        String res = result.toString();
        this.log.infoEnd(String.format("InvestMsServiceImpl.addInvShareRela request finish:%s", res));
        return res;
    }

    public Map<String, Object> createInvestPaperEntry(Map<String, Object> properTies) {
        long modelId = LongUtil.toLong((Object)properTies.get("model"));
        long sceneId = LongUtil.toLong((Object)properTies.get("scenario"));
        long yearId = LongUtil.toLong((Object)properTies.get("year"));
        long periodId = LongUtil.toLong((Object)properTies.get("period"));
        long orgId = LongUtil.toLong((Object)properTies.get("org"));
        Set investPaperPks = (Set)properTies.get("investPaperPks");
        HashMap<String, Object> returnMap = new HashMap<String, Object>(4);
        try {
            AdjustmentServiceHelper.checkPermission((long)modelId, (String)"bcm_rptadjust_list", (String)"13X65LZQ=RM/");
            IDNumberTreeNode selectedOrgNode = MemberReader.findEntityMemberById((Long)modelId, (Long)orgId);
            if (ConfigServiceHelper.getBoolParam((Long)modelId, (String)"CM012") && !PeriodSettingHelper.checkPeriodStatus((long)modelId, (String)selectedOrgNode.getNumber(), (long)sceneId, (long)yearId, (long)periodId, (String)"datastatus")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvestServiceHelper_6", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            if (MergeControlHelper.isQuoteLocked((Long)modelId, (Long)sceneId, (Long)yearId, (Long)periodId, (Long)orgId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u5f00\u542f\u7248\u672c\u5316\u3002", (String)"InvestServiceHelper_7", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            McStatus mcStatus = MergeStatusHelper.getMcStatus((Long)modelId, (Long)sceneId, (Long)yearId, (Long)periodId, (Long)orgId);
            if (mcStatus.getFlow().isSubmit()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u9ed8\u8ba4\u5e01\u62a5\u8868\u72b6\u6001\u4e3a\u201c\u5df2\u63d0\u4ea4\u201d\u6216\u8005\u201c\u5df2\u5f52\u6863\u201d\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvestServiceHelper_8", (String)"fi-bcm-business", (Object[])new Object[0]));
            }
            ArrayList<Object> sheetList = new ArrayList(investPaperPks.size());
            sheetList.addAll((Collection<Object>)QueryServiceHelper.query((String)"bcm_invlimsheetentity", (String)"template.id,data", (QFilter[])new QFBuilder("id", "in", (Object)investPaperPks).toArray()));
            InvElimSpreadGenerateService elimCreateService = new InvElimSpreadGenerateService(modelId, sceneId, yearId, periodId, orgId, sheetList);
            Tuple result = elimCreateService.generate();
            String errMsg = (String)result.p3;
            if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
                returnMap.put("successCount", 0);
                returnMap.put("billCount", investPaperPks.size());
                returnMap.put("errorMsg", errMsg);
                returnMap.put("detailMsg", errMsg);
            } else {
                Set successIds = (Set)result.p2;
                sheetList = new ArrayList<DynamicObject>(Arrays.asList(BusinessDataServiceHelper.load((Object[])successIds.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"bcm_invlimsheetentity").getDynamicObjectType())));
                sheetList.stream().filter(sheet -> successIds.contains(sheet.getLong("template.id")) && SheetStatusEnum.STORAGE.status().equals(sheet.getString("from"))).forEach(e -> e.set("from", (Object)SheetStatusEnum.HAND.status()));
                SaveServiceHelper.save((DynamicObject[])sheetList.toArray(new DynamicObject[0]));
                returnMap.put("successCount", successIds.size());
                returnMap.put("billCount", investPaperPks.size());
                returnMap.put("errorMsg", null);
                returnMap.put("detailMsg", String.format(ResManager.loadKDString((String)"\u751f\u6210%s\u4e2a\u62b5\u9500\u5206\u5f55,\u8bf7\u8fdb\u5165\u8c03\u6574\u62b5\u9500\u5206\u5f55\u754c\u9762\u67e5\u770b\u3002", (String)"InvestMsServiceImpl_1", (String)"fi-bcm-mservice", (Object[])new Object[0]), Math.max((Integer)result.p1, 0)));
                HashSet temppks = new HashSet();
                elimCreateService.getCtx().getSheets().forEach(template -> temppks.add(template.getLong("template.id")));
                returnMap.put("InvSheetPaperResult", InvestServiceHelper.queryInvSheetPaperResult((Long)modelId, (Long)sceneId, (Long)yearId, (Long)periodId, Collections.singleton(selectedOrgNode.getNumber()), temppks));
            }
        }
        catch (Throwable t) {
            returnMap.put("successCount", 0);
            returnMap.put("billCount", investPaperPks.size());
            returnMap.put("errorMsg", AdjustmentServiceHelper.toString_Adj((Throwable)t));
            returnMap.put("detailMsg", AdjustmentServiceHelper.toString_Adj((Throwable)t));
        }
        return returnMap;
    }

    public String copyFromAnotherPeriod(String paramJson) {
        InvMsResult invMsResult;
        this.log.startWatch();
        try {
            this.log.info(String.format("InvestMsServiceImpl.copyFromAnotherPeriod request param: %s", paramJson));
            InvCopyRatioRelationDTO dto = (InvCopyRatioRelationDTO)JSONUtils.cast((String)paramJson, InvCopyRatioRelationDTO.class);
            invMsResult = InvRelationSearchHelper.copyFromAnotherPeriod((InvCopyRatioRelationDTO)dto);
        }
        catch (Exception e) {
            this.log.error(String.format("InvestMsServiceImpl.copyFromAnotherPeriod request error:%s", e.getMessage()), (Throwable)e);
            invMsResult = InvMsResult.fail((InvMsResult.ResultEnum)InvMsResult.ResultEnum.PARAM_ERROR).setData((Object)String.format("convert Json [%s] to InvCopyRatioRelationDTO error!", paramJson));
        }
        String res = invMsResult.toString();
        this.log.infoEnd(String.format("InvestMsServiceImpl.copyFromAnotherPeriod request finish:%s", res));
        return res;
    }

    public String recalculateRatioRelation(String paramJson) {
        InvMsResult invMsResult;
        this.log.startWatch();
        try {
            this.log.info(String.format("InvestMsServiceImpl.recalculateRatioRelation request param: %s", paramJson));
            InvRecalculateRatioRelationDTO dto = (InvRecalculateRatioRelationDTO)JSONUtils.cast((String)paramJson, InvRecalculateRatioRelationDTO.class);
            invMsResult = InvRelationSearchHelper.recalculateRatioRelation((InvRecalculateRatioRelationDTO)dto);
        }
        catch (Exception e) {
            this.log.error(String.format("InvestMsServiceImpl.recalculateRatioRelation request error:%s", e.getMessage()), (Throwable)e);
            invMsResult = InvMsResult.fail((InvMsResult.ResultEnum)InvMsResult.ResultEnum.PARAM_ERROR).setData((Object)String.format("convert Json [%s] to InvCopyRatioRelationDTO error!", paramJson));
        }
        String res = invMsResult.toString();
        this.log.infoEnd(String.format("InvestMsServiceImpl.recalculateRatioRelation request finish:%s", res));
        return res;
    }

    public String generateInvestPaper(String paramJson) {
        this.log.startWatch();
        InvMsResult result = InvMsResult.success();
        try {
            this.log.info(String.format("InvestMsServiceImpl.generateInvestPaper request param: %s", paramJson));
            InvGenerateInvestDTO dto = (InvGenerateInvestDTO)JSONUtils.cast((String)paramJson, InvGenerateInvestDTO.class);
            Long modelId = dto.getModelId();
            Long sceneId = dto.getScenarioId();
            Long yearId = dto.getYearId();
            Long periodId = dto.getPeriodId();
            Set orgNodes = dto.getOrgNodes();
            Set templationSet = dto.getTemplationSet();
            if (Objects.isNull(modelId) || Objects.isNull(sceneId) || Objects.isNull(yearId) || Objects.isNull(periodId) || CollectionUtils.isEmpty((Collection)orgNodes)) {
                String msg = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"InvestMsServiceImpl_2", (String)"fi-bcm-mservice", (Object[])new Object[0]);
                result = InvMsResult.fail((InvMsResult.ResultEnum)InvMsResult.ResultEnum.PARAM_ERROR).setMessage(msg);
            } else {
                Sets.SetView periodDifference;
                HashSet allOrgNodes = Sets.newHashSet((Iterable)orgNodes);
                Set hasPermOrg = InvRelationSearchService.dealNoPermOrg((Set)orgNodes, (long)modelId);
                Set periodOpenOrg = InvRelationSearchService.dealPeriodOpen((long)modelId, (Set)orgNodes, (Long)sceneId, (Long)yearId, (Long)periodId);
                InvPaperGenerateService invPaperGenerateService = new InvPaperGenerateService(modelId, sceneId, yearId, periodId);
                if (CollectionUtils.isNotEmpty((Collection)templationSet)) {
                    invPaperGenerateService.setInvestGenWay(Boolean.valueOf(false));
                }
                List resultMsg = invPaperGenerateService.generatePaper(orgNodes, templationSet);
                String msg = ResManager.loadKDString((String)"\u5408\u5e76\u8282\u70b9\u3010%s\u3011\u65e0\u6743\u6216\u53ea\u8bfb\u4e0d\u80fd\u751f\u6210\u5e95\u7a3f", (String)"InvelimSheetListPlugin_40", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
                String periodMsg = ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u6570\u636e\u671f\u95f4\u5df2\u5173\u95ed\u6216\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"InvRelationSearchHelper_16", (String)"fi-bcm-business", (Object[])new Object[0]);
                Sets.SetView difference = Sets.difference((Set)allOrgNodes, (Set)hasPermOrg);
                if (CollectionUtils.isNotEmpty((Collection)difference)) {
                    difference.forEach(t -> {
                        IDNumberTreeNode member = MemberReader.findEntityMemberById((Long)modelId, (Long)LongUtil.toLong((Object)t));
                        resultMsg.add(String.format(msg, member.getNumber()));
                    });
                }
                if (CollectionUtils.isNotEmpty((Collection)(periodDifference = Sets.difference((Set)allOrgNodes, (Set)periodOpenOrg)))) {
                    periodDifference.forEach(t -> {
                        IDNumberTreeNode member = MemberReader.findEntityMemberById((Long)modelId, (Long)LongUtil.toLong((Object)t));
                        resultMsg.add(String.format(periodMsg, member.getNumber()));
                    });
                }
                result.setData((Object)String.join((CharSequence)"\n", resultMsg));
            }
        }
        catch (Exception e) {
            result = InvMsResult.fail((InvMsResult.ResultEnum)InvMsResult.ResultEnum.BUSINESS_EXCEPTION);
            result.setMessage(e.getMessage());
            this.log.error(String.format("InvestMsServiceImpl.generateInvestPaper request error:%s", e));
        }
        String res = result.toString();
        this.log.infoEnd(String.format("InvestMsServiceImpl.generateInvestPaper request finish:%s", res));
        return res;
    }

    public String addInvRelation(String paramJson) {
        this.log.startWatch();
        InvMsResult result = InvMsResult.success();
        try {
            this.log.info(String.format("InvestMsServiceImpl.addInvRelation request param: %s", paramJson));
            InvRelationRadioDTO dto = (InvRelationRadioDTO)JSONUtils.cast((String)paramJson, InvRelationRadioDTO.class);
            result = InvRelationSearchHelper.addInvRelation((InvRelationRadioDTO)dto);
        }
        catch (Exception e) {
            result = InvMsResult.fail((InvMsResult.ResultEnum)InvMsResult.ResultEnum.BUSINESS_EXCEPTION);
            result.setMessage(e.getMessage());
            this.log.error(String.format("InvestMsServiceImpl.addInvRelation request error:%s", e));
        }
        String res = result.toString();
        this.log.infoEnd(String.format("InvestMsServiceImpl.addInvRelation request finish:%s", res));
        return res;
    }
}

