/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.exception.KDBizException;
import kd.bos.util.JSONUtils;
import kd.fi.bcm.business.dimension.api.QueryMemberDTO;
import kd.fi.bcm.business.dimension.helper.QueryDimensionServiceHelper;
import kd.fi.bcm.business.serviceHelper.MemberPermHelper;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.service.AbstractMsService;
import kd.fi.bcm.service.MemberQueryMsService;
import org.apache.commons.lang3.StringUtils;

public class MemberQueryMsServiceImpl
extends AbstractMsService
implements MemberQueryMsService {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(MemberQueryMsServiceImpl.class);

    public String queryMemberTree(String paramJson) {
        QueryMemberDTO param = this.valid(paramJson);
        Map result = QueryDimensionServiceHelper.queryMemberTree((QueryMemberDTO)param);
        if (result != null && !result.isEmpty()) {
            try {
                return JSONUtils.toString((Object)result);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public Set<Long> queryMembers(String paramJson) {
        QueryMemberDTO param = this.valid(paramJson);
        long modelId = MemberReader.findModelIdByNum((String)param.getModelNum());
        if (MemberPermHelper.isModelAdmin((Long)modelId)) {
            log.info("model admin return null.");
            return null;
        }
        return QueryDimensionServiceHelper.queryMembers((QueryMemberDTO)param);
    }

    private QueryMemberDTO valid(String paramJson) {
        Optional<String> msg;
        QueryMemberDTO param;
        try {
            param = (QueryMemberDTO)JSONUtils.cast((String)paramJson, QueryMemberDTO.class);
        }
        catch (Exception ex) {
            log.error("parse object fail." + ThrowableHelper.toString((Exception)ex));
            throw new KDBizException("parse object fail." + ThrowableHelper.toString((Exception)ex));
        }
        if (param.getUserId() != null) {
            this.resetCurrentUser(param.getUserId());
        }
        if ((msg = this.validModelPerm(param.getModelNum())).isPresent()) {
            throw new KDBizException(msg.get());
        }
        msg = this.validParam(param);
        if (msg.isPresent()) {
            throw new KDBizException(msg.get());
        }
        return param;
    }

    private Optional<String> validParam(QueryMemberDTO param) {
        if (StringUtils.isEmpty((CharSequence)param.getDimNum())) {
            return Optional.of("dimNum is required.");
        }
        if ("Entity".equals(param.getDimNum()) && StringUtils.isEmpty((CharSequence)param.getSchemeNum())) {
            return Optional.of("schemeNum is required.");
        }
        return Optional.empty();
    }
}

