/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Map;
import java.util.Optional;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.dimension.api.ApiResultDTO;
import kd.fi.bcm.business.dimension.api.QueryOlapDataDTO;
import kd.fi.bcm.business.olap.OlapDataQueryHelper;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.ThrowableHelper;
import kd.fi.bcm.service.AbstractMsService;
import kd.fi.bcm.service.OlapDataQueryMsService;

public class OlapDataQueryMsServiceImpl
extends AbstractMsService
implements OlapDataQueryMsService {
    private static WatchLogger log = BcmLogFactory.getWatchLogInstance(OlapDataQueryMsServiceImpl.class);

    public Map<String, Object> queryData(String modelNum, String jsonParam) {
        ApiResultDTO result;
        QueryOlapDataDTO dto;
        log.startWatch();
        Optional<String> errorMsg = this.validModelPerm(modelNum);
        if (errorMsg.isPresent()) {
            return ApiResultDTO.failToMap((String)errorMsg.get());
        }
        try {
            dto = (QueryOlapDataDTO)JSON.parseObject((String)jsonParam, (TypeReference)new TypeReference<QueryOlapDataDTO>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception ex) {
            log.error("parse object fail." + ThrowableHelper.toString((Exception)ex));
            throw new KDBizException(ex.getMessage());
        }
        if (dto == null) {
            return ApiResultDTO.failToMap((String)"param is invalid.");
        }
        try {
            result = OlapDataQueryHelper.queryData((String)modelNum, (QueryOlapDataDTO)dto);
        }
        catch (Exception ex) {
            log.error("query olap data fail." + ThrowableHelper.toString((Exception)ex));
            throw new KDBizException(ex.getMessage());
        }
        log.infoEnd("query olap data api end.");
        return result.toMap();
    }
}

